/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.frontend.fir.handlers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.FirLazyDeclarationResolver;
import org.jetbrains.kotlin.test.frontend.fir.handlers.FirLazyResolveContractViolationException;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\b\u001a\u00020\t2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010\f\u001a\u00020\u0004H\u0002J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u0004H\u0016J\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0010J\u001c\u0010\u0011\u001a\u00020\t2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010\u0012\u001a\u00020\u0004H\u0016J\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u0004H\u0016R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/test/frontend/fir/handlers/FirCompilerLazyDeclarationResolverWithPhaseChecking;", "Lorg/jetbrains/kotlin/fir/symbols/FirLazyDeclarationResolver;", "()V", "currentTransformerPhase", "Lorg/jetbrains/kotlin/fir/declarations/FirResolvePhase;", "exceptions", "", "Lorg/jetbrains/kotlin/test/frontend/fir/handlers/FirLazyResolveContractViolationException;", "checkIfCanLazyResolveToPhase", "", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "requestedPhase", "finishResolvingPhase", "phase", "getContractViolationExceptions", "", "lazyResolveToPhase", "toPhase", "startResolvingPhase", "tests-common-new_test"})
public final class FirCompilerLazyDeclarationResolverWithPhaseChecking
extends FirLazyDeclarationResolver {
    @Nullable
    private FirResolvePhase currentTransformerPhase;
    @NotNull
    private final List<FirLazyResolveContractViolationException> exceptions = new ArrayList();

    @NotNull
    public final List<FirLazyResolveContractViolationException> getContractViolationExceptions() {
        return this.exceptions;
    }

    public void lazyResolveToPhase(@NotNull FirBasedSymbol<?> symbol2, @NotNull FirResolvePhase toPhase) {
        Intrinsics.checkNotNullParameter(symbol2, (String)"symbol");
        Intrinsics.checkNotNullParameter((Object)toPhase, (String)"toPhase");
        this.checkIfCanLazyResolveToPhase(symbol2, toPhase);
    }

    public void startResolvingPhase(@NotNull FirResolvePhase phase) {
        Intrinsics.checkNotNullParameter((Object)phase, (String)"phase");
        if (!(this.currentTransformerPhase == null)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        this.currentTransformerPhase = phase;
    }

    public void finishResolvingPhase(@NotNull FirResolvePhase phase) {
        Intrinsics.checkNotNullParameter((Object)phase, (String)"phase");
        if (!(this.currentTransformerPhase == phase)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        this.currentTransformerPhase = null;
    }

    private final void checkIfCanLazyResolveToPhase(FirBasedSymbol<?> symbol2, FirResolvePhase requestedPhase) {
        if (!this.getLazyResolveContractChecksEnabled()) {
            return;
        }
        FirResolvePhase firResolvePhase = this.currentTransformerPhase;
        if (firResolvePhase == null) {
            throw new IllegalStateException(("Current phase is not set, please call " + "startResolvingPhase" + " before starting transforming the file").toString());
        }
        FirResolvePhase currentPhase = firResolvePhase;
        if (requestedPhase.compareTo((Enum)currentPhase) >= 0) {
            ((Collection)this.exceptions).add(new FirLazyResolveContractViolationException(StringsKt.trimIndent((String)("`lazyResolveToPhase(" + requestedPhase + ")` cannot be called from a transformer with a phase " + currentPhase + ".\n                    lazyResolveToPhase was called on a " + symbol2 + ".\n                    `lazyResolveToPhase` can be called only from a transformer with a phase which is strictly greater than a requested phase;\n                     i.e., `lazyResolveToPhase(A)` may be only called from a lazy transformer with a phase B, where A < B. This is a contract of lazy resolve"))));
        }
    }
}

