/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.frontend.fir.handlers;

import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.FirControlFlowGraphRenderVisitor;
import org.jetbrains.kotlin.fir.visitors.FirVisitorVoid;
import org.jetbrains.kotlin.test.Assertions;
import org.jetbrains.kotlin.test.directives.FirDiagnosticsDirectives;
import org.jetbrains.kotlin.test.directives.model.DirectivesContainer;
import org.jetbrains.kotlin.test.frontend.fir.FirOutputArtifact;
import org.jetbrains.kotlin.test.frontend.fir.handlers.FirAnalysisHandler;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.TestModuleStructureKt;
import org.jetbrains.kotlin.test.services.TestServices;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0006H\u0016J\u0018\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00060\bj\u0002`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/test/frontend/fir/handlers/FirCfgDumpHandler;", "Lorg/jetbrains/kotlin/test/frontend/fir/handlers/FirAnalysisHandler;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "alreadyDumped", "", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "directiveContainers", "", "Lorg/jetbrains/kotlin/test/directives/model/DirectivesContainer;", "getDirectiveContainers", "()Ljava/util/List;", "processAfterAllModules", "", "someAssertionWasFailed", "processModule", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "info", "Lorg/jetbrains/kotlin/test/frontend/fir/FirOutputArtifact;", "tests-common-new_test"})
public final class FirCfgDumpHandler
extends FirAnalysisHandler {
    @NotNull
    private final StringBuilder builder;
    private boolean alreadyDumped;

    public FirCfgDumpHandler(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        super(testServices, false, false, 6, null);
        this.builder = new StringBuilder();
    }

    @Override
    @NotNull
    public List<DirectivesContainer> getDirectiveContainers() {
        return CollectionsKt.listOf((Object)FirDiagnosticsDirectives.INSTANCE);
    }

    @Override
    public void processModule(@NotNull TestModule module, @NotNull FirOutputArtifact info) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        if (this.alreadyDumped || !module.getDirectives().contains(FirDiagnosticsDirectives.INSTANCE.getDUMP_CFG())) {
            return;
        }
        FirFile file = (FirFile)CollectionsKt.first((Iterable)info.getMainFirFiles().values());
        boolean renderLevels = module.getDirectives().contains(FirDiagnosticsDirectives.INSTANCE.getRENDERER_CFG_LEVELS());
        file.accept((FirVisitorVoid)new FirControlFlowGraphRenderVisitor(this.builder, renderLevels));
        this.alreadyDumped = true;
    }

    @Override
    public void processAfterAllModules(boolean someAssertionWasFailed) {
        if (!this.alreadyDumped) {
            return;
        }
        File testDataFile = (File)CollectionsKt.first(TestModuleStructureKt.getModuleStructure(this.getTestServices()).getOriginalTestDataFiles());
        File file = testDataFile.getParentFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"testDataFile.parentFile");
        File expectedFile = FilesKt.resolve((File)file, (String)(this.getNameWithoutFirExtension(testDataFile) + ".dot"));
        Assertions assertions = this.getAssertions();
        String string = this.builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.toString()");
        Assertions.assertEqualsToFile$default(assertions, expectedFile, string, null, 4, null);
    }
}

