/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.frontend.fir;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.ir.backend.js.JsLibraryResolverKt;
import org.jetbrains.kotlin.ir.backend.js.KlibKt;
import org.jetbrains.kotlin.js.config.JSConfigurationKeys;
import org.jetbrains.kotlin.library.metadata.resolver.KotlinLibraryResolveResult;
import org.jetbrains.kotlin.library.metadata.resolver.KotlinResolvedLibrary;
import org.jetbrains.kotlin.test.model.DependencyRelation;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.services.configuration.JsEnvironmentConfigurator;
import org.jetbrains.kotlin.util.Logger;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001c\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a:\u0010\u0007\u001a&\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u00010\b2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a$\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u000e"}, d2={"getAllJsDependenciesPaths", "", "", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "getJsDependencies", "Lkotlin/Triple;", "Ljava/io/File;", "resolveJsLibraries", "Lorg/jetbrains/kotlin/library/metadata/resolver/KotlinResolvedLibrary;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "tests-common-new_test"})
@SourceDebugExtension(value={"SMAP\nTestFirJsSessionFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TestFirJsSessionFactory.kt\norg/jetbrains/kotlin/test/frontend/fir/TestFirJsSessionFactoryKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,94:1\n1549#2:95\n1620#2,3:96\n*S KotlinDebug\n*F\n+ 1 TestFirJsSessionFactory.kt\norg/jetbrains/kotlin/test/frontend/fir/TestFirJsSessionFactoryKt\n*L\n85#1:95\n85#1:96,3\n*E\n"})
public final class TestFirJsSessionFactoryKt {
    @NotNull
    public static final List<KotlinResolvedLibrary> resolveJsLibraries(@NotNull TestModule module, @NotNull TestServices testServices, @NotNull CompilerConfiguration configuration2) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        List<String> paths = TestFirJsSessionFactoryKt.getAllJsDependenciesPaths(module, testServices);
        Collection collection = (Collection)configuration2.get(JSConfigurationKeys.REPOSITORIES);
        if (collection == null) {
            collection = CollectionsKt.emptyList();
        }
        Collection repositories = collection;
        Logger logger = KlibKt.getResolverLogger((CompilerConfiguration)configuration2);
        return KotlinLibraryResolveResult.getFullResolvedList$default((KotlinLibraryResolveResult)JsLibraryResolverKt.jsResolveLibraries((Collection)paths, (Collection)repositories, (Logger)logger), null, (int)1, null);
    }

    @NotNull
    public static final List<String> getAllJsDependenciesPaths(@NotNull TestModule module, @NotNull TestServices testServices) {
        File it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        Triple<List<String>, List<File>, List<File>> triple = TestFirJsSessionFactoryKt.getJsDependencies(module, testServices);
        List runtimeKlibsPaths = (List)triple.component1();
        List transitiveLibraries = (List)triple.component2();
        List friendLibraries = (List)triple.component3();
        Iterable iterable = transitiveLibraries;
        Collection collection2 = runtimeKlibsPaths;
        boolean $i$f$map = false;
        void var8_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            File file = (File)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getPath());
        }
        $this$map$iv = friendLibraries;
        collection2 = CollectionsKt.plus((Collection)collection2, (Iterable)((List)destination$iv$iv));
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (File)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getPath());
        }
        return CollectionsKt.plus((Collection)collection2, (Iterable)((List)destination$iv$iv));
    }

    @NotNull
    public static final Triple<List<String>, List<File>, List<File>> getJsDependencies(@NotNull TestModule module, @NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        List<String> runtimeKlibsPaths = JsEnvironmentConfigurator.Companion.getRuntimePathsForModule(module, testServices);
        List<File> transitiveLibraries = JsEnvironmentConfigurator.Companion.getKlibDependencies(module, testServices, DependencyRelation.RegularDependency);
        List<File> friendLibraries = JsEnvironmentConfigurator.Companion.getKlibDependencies(module, testServices, DependencyRelation.FriendDependency);
        return new Triple(runtimeKlibsPaths, transitiveLibraries, friendLibraries);
    }
}

