/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.ZipUtil;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.lang.ref.SoftReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import java.util.zip.ZipOutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.reflect.KClass;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.CLICompiler;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.js.K2JSCompiler;
import org.jetbrains.kotlin.cli.jvm.K2JVMCompiler;
import org.jetbrains.kotlin.preloading.ClassPreloadingUtils;
import org.jetbrains.kotlin.test.Assertions;
import org.jetbrains.kotlin.test.JvmCompilationUtils;
import org.jetbrains.kotlin.test.KtAssert;
import org.jetbrains.kotlin.test.MockLibraryUtil;
import org.jetbrains.kotlin.test.MockLibraryUtilKt;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.jetbrains.kotlin.utils.PathUtil;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002Jd\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\b\b\u0002\u0010\u0011\u001a\u00020\u00122\u000e\b\u0002\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00142\u000e\b\u0002\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00142\u000e\b\u0002\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00142\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u0019\u001a\u00020\u0012H\u0007J0\u0010\u001a\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u000e\b\u0002\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0014H\u0007Jn\u0010\u001b\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\b\b\u0002\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u001c\u001a\u00020\u00122\u000e\b\u0002\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00142\u000e\b\u0002\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00142\u000e\b\u0002\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00142\b\b\u0002\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0018H\u0007JA\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020\r2\u000e\b\u0002\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00142\u0012\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0 \"\u00020\u000fH\u0007\u00a2\u0006\u0002\u0010!J&\u0010\"\u001a\u00020\u001e2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020\r2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0014H\u0002J\u000e\u0010$\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020\u000fJv\u0010&\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000f2\b\b\u0002\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u001c\u001a\u00020\u00122\u000e\b\u0002\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00142\u000e\b\u0002\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00142\u000e\b\u0002\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00142\b\b\u0002\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0018H\u0007J\b\u0010(\u001a\u00020\u000bH\u0002J,\u0010)\u001a\u00020\r2\u0006\u0010'\u001a\u00020\r2\u0006\u0010*\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000f2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0007J \u0010+\u001a\u0006\u0012\u0002\b\u00030\u00042\u0012\u0010,\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030.0-H\u0002J\"\u0010/\u001a\u00020\u001e2\n\u0010,\u001a\u0006\u0012\u0002\b\u00030\u00042\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0014H\u0002J\u0016\u00101\u001a\u00020\u001e2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0014H\u0002J\u0014\u00102\u001a\u00020\u001e2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0014R\u0018\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0018\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lorg/jetbrains/kotlin/test/MockLibraryUtil;", "", "()V", "compiler2JSClass", "Ljava/lang/Class;", "getCompiler2JSClass", "()Ljava/lang/Class;", "compiler2JVMClass", "getCompiler2JVMClass", "compilerClassLoader", "Ljava/lang/ref/SoftReference;", "Ljava/lang/ClassLoader;", "compileJavaFilesLibraryToJar", "Ljava/io/File;", "sourcesPath", "", "jarName", "addSources", "", "extraOptions", "", "extraClasspath", "extraModulepath", "assertions", "Lorg/jetbrains/kotlin/test/Assertions;", "useJava11", "compileJsLibraryToJar", "compileJvmLibraryToJar", "allowKotlinSources", "compileKotlin", "", "outDir", "", "(Ljava/lang/String;Ljava/io/File;Ljava/util/List;[Ljava/lang/String;)V", "compileKotlin2JS", "outputFile", "compileKotlinModule", "buildFilePath", "compileLibraryToJar", "contentDir", "createCompilerClassLoader", "createJarFile", "dirToAdd", "loadCompilerClass", "compilerClass", "Lkotlin/reflect/KClass;", "Lorg/jetbrains/kotlin/cli/common/CLICompiler;", "runCompiler", "args", "runJsCompiler", "runJvmCompiler", "tests-compiler-utils_test"})
@SourceDebugExtension(value={"SMAP\nMockLibraryUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MockLibraryUtil.kt\norg/jetbrains/kotlin/test/MockLibraryUtil\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,242:1\n37#2,2:243\n37#2,2:246\n37#2,2:248\n1#3:245\n*S KotlinDebug\n*F\n+ 1 MockLibraryUtil.kt\norg/jetbrains/kotlin/test/MockLibraryUtil\n*L\n106#1:243,2\n185#1:246,2\n213#1:248,2\n*E\n"})
public final class MockLibraryUtil {
    @NotNull
    public static final MockLibraryUtil INSTANCE = new MockLibraryUtil();
    @NotNull
    private static SoftReference<ClassLoader> compilerClassLoader = new SoftReference<Object>(null);

    private MockLibraryUtil() {
    }

    @JvmStatic
    @NotNull
    public static final File compileJvmLibraryToJar(@NotNull String sourcesPath, @NotNull String jarName, boolean addSources, boolean allowKotlinSources, @NotNull List<String> extraOptions, @NotNull List<String> extraClasspath, @NotNull List<String> extraModulepath, boolean useJava11, @NotNull Assertions assertions) {
        Intrinsics.checkNotNullParameter((Object)sourcesPath, (String)"sourcesPath");
        Intrinsics.checkNotNullParameter((Object)jarName, (String)"jarName");
        Intrinsics.checkNotNullParameter(extraOptions, (String)"extraOptions");
        Intrinsics.checkNotNullParameter(extraClasspath, (String)"extraClasspath");
        Intrinsics.checkNotNullParameter(extraModulepath, (String)"extraModulepath");
        Intrinsics.checkNotNullParameter((Object)assertions, (String)"assertions");
        File file = KtTestUtil.tmpDirForReusableFolder("testLibrary-" + jarName);
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"tmpDirForReusableFolder(\"testLibrary-$jarName\")");
        return MockLibraryUtil.compileLibraryToJar(sourcesPath, file, jarName, addSources, allowKotlinSources, extraOptions, extraClasspath, extraModulepath, useJava11, assertions);
    }

    public static /* synthetic */ File compileJvmLibraryToJar$default(String string, String string2, boolean bl, boolean bl2, List list, List list2, List list3, boolean bl3, Assertions assertions, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            bl2 = true;
        }
        if ((n & 0x10) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 0x20) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n & 0x40) != 0) {
            list3 = CollectionsKt.emptyList();
        }
        if ((n & 0x80) != 0) {
            bl3 = false;
        }
        return MockLibraryUtil.compileJvmLibraryToJar(string, string2, bl, bl2, list, list2, list3, bl3, assertions);
    }

    @JvmStatic
    @NotNull
    public static final File compileJavaFilesLibraryToJar(@NotNull String sourcesPath, @NotNull String jarName, boolean addSources, @NotNull List<String> extraOptions, @NotNull List<String> extraClasspath, @NotNull List<String> extraModulepath, @NotNull Assertions assertions, boolean useJava11) {
        Intrinsics.checkNotNullParameter((Object)sourcesPath, (String)"sourcesPath");
        Intrinsics.checkNotNullParameter((Object)jarName, (String)"jarName");
        Intrinsics.checkNotNullParameter(extraOptions, (String)"extraOptions");
        Intrinsics.checkNotNullParameter(extraClasspath, (String)"extraClasspath");
        Intrinsics.checkNotNullParameter(extraModulepath, (String)"extraModulepath");
        Intrinsics.checkNotNullParameter((Object)assertions, (String)"assertions");
        return MockLibraryUtil.compileJvmLibraryToJar(sourcesPath, jarName, addSources, false, extraOptions, extraClasspath, extraModulepath, useJava11, assertions);
    }

    public static /* synthetic */ File compileJavaFilesLibraryToJar$default(String string, String string2, boolean bl, List list, List list2, List list3, Assertions assertions, boolean bl2, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 0x10) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n & 0x20) != 0) {
            list3 = CollectionsKt.emptyList();
        }
        if ((n & 0x80) != 0) {
            bl2 = false;
        }
        return MockLibraryUtil.compileJavaFilesLibraryToJar(string, string2, bl, list, list2, list3, assertions, bl2);
    }

    @JvmStatic
    @NotNull
    public static final File compileLibraryToJar(@NotNull String sourcesPath, @NotNull File contentDir, @NotNull String jarName, boolean addSources, boolean allowKotlinSources, @NotNull List<String> extraOptions, @NotNull List<String> extraClasspath, @NotNull List<String> extraModulepath, boolean useJava11, @NotNull Assertions assertions) {
        String string;
        Collection thisCollection$iv;
        Intrinsics.checkNotNullParameter((Object)sourcesPath, (String)"sourcesPath");
        Intrinsics.checkNotNullParameter((Object)contentDir, (String)"contentDir");
        Intrinsics.checkNotNullParameter((Object)jarName, (String)"jarName");
        Intrinsics.checkNotNullParameter(extraOptions, (String)"extraOptions");
        Intrinsics.checkNotNullParameter(extraClasspath, (String)"extraClasspath");
        Intrinsics.checkNotNullParameter(extraModulepath, (String)"extraModulepath");
        Intrinsics.checkNotNullParameter((Object)assertions, (String)"assertions");
        KtAssert.assertTrue("Module path can be used only for compilation using javac 9 and higher", useJava11 || extraModulepath.isEmpty());
        File classesDir = new File(contentDir, "classes");
        File srcFile = new File(sourcesPath);
        List list = FileUtil.findFilesByMask((Pattern)Pattern.compile(".*\\.kt"), (File)srcFile);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"findFilesByMask(Pattern.\u2026pile(\".*\\\\.kt\"), srcFile)");
        List kotlinFiles = list;
        if (srcFile.isFile() || !((Collection)kotlinFiles).isEmpty()) {
            KtAssert.assertTrue("Only java files are expected", allowKotlinSources);
            Collection $this$toTypedArray$iv = extraClasspath;
            boolean $i$f$toTypedArray = false;
            thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            MockLibraryUtil.compileKotlin(sourcesPath, classesDir, extraOptions, Arrays.copyOf(stringArray, stringArray.length));
        }
        List list2 = FileUtil.findFilesByMask((Pattern)Pattern.compile(".*\\.java"), (File)srcFile);
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"findFilesByMask(Pattern.\u2026le(\".*\\\\.java\"), srcFile)");
        List javaFiles = list2;
        if (!((Collection)javaFiles).isEmpty()) {
            List classpath = new ArrayList();
            ((Collection)classpath).add(MockLibraryUtilKt.getKotlinPathsForDistDirectoryForTests(PathUtil.INSTANCE).getStdlibPath().getPath());
            CollectionsKt.addAll((Collection)classpath, (Iterable)extraClasspath);
            if (classesDir.exists()) {
                ((Collection)classpath).add(classesDir.getPath());
            } else {
                FileUtil.createDirectory((File)classesDir);
            }
            Collection $this$compileLibraryToJar_u24lambda_u240 = thisCollection$iv = CollectionsKt.createListBuilder();
            boolean bl = false;
            $this$compileLibraryToJar_u24lambda_u240.add("-classpath");
            Iterable iterable = classpath;
            String string2 = File.pathSeparator;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"pathSeparator");
            $this$compileLibraryToJar_u24lambda_u240.add(CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string2, null, null, (int)0, null, null, (int)62, null));
            $this$compileLibraryToJar_u24lambda_u240.add("-d");
            $this$compileLibraryToJar_u24lambda_u240.add(classesDir.getPath());
            if (useJava11 && !((Collection)extraModulepath).isEmpty()) {
                $this$compileLibraryToJar_u24lambda_u240.add("--module-path");
                Iterable iterable2 = extraModulepath;
                String string3 = File.pathSeparator;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"pathSeparator");
                $this$compileLibraryToJar_u24lambda_u240.add(CollectionsKt.joinToString$default((Iterable)iterable2, (CharSequence)string3, null, null, (int)0, null, null, (int)62, null));
            }
            List options = CollectionsKt.build((List)thisCollection$iv);
            Function2 compile2 = useJava11 ? (Function2)compileLibraryToJar.compile.1.INSTANCE : (Function2)new Function2<Collection<? extends File>, List<? extends String>, Boolean>(assertions){
                final /* synthetic */ Assertions $assertions;
                {
                    this.$assertions = $assertions;
                    super(2);
                }

                @NotNull
                public final Boolean invoke(@NotNull Collection<? extends File> files, @NotNull List<String> opts) {
                    Intrinsics.checkNotNullParameter(files, (String)"files");
                    Intrinsics.checkNotNullParameter(opts, (String)"opts");
                    return JvmCompilationUtils.compileJavaFiles$default(files, opts, null, this.$assertions, false, 20, null);
                }
            };
            boolean success = (Boolean)compile2.invoke((Object)javaFiles, (Object)options);
            if (!success) {
                throw new AssertionError((Object)"Java files are not compiled successfully");
            }
        }
        String options = string = sourcesPath;
        String string4 = jarName;
        File file = classesDir;
        File file2 = contentDir;
        boolean bl = false;
        boolean bl2 = addSources;
        return MockLibraryUtil.createJarFile(file2, file, string4, bl2 ? string : null);
    }

    public static /* synthetic */ File compileLibraryToJar$default(String string, File file, String string2, boolean bl, boolean bl2, List list, List list2, List list3, boolean bl3, Assertions assertions, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            bl2 = true;
        }
        if ((n & 0x20) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 0x40) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n & 0x80) != 0) {
            list3 = CollectionsKt.emptyList();
        }
        if ((n & 0x100) != 0) {
            bl3 = false;
        }
        return MockLibraryUtil.compileLibraryToJar(string, file, string2, bl, bl2, list, list2, list3, bl3, assertions);
    }

    @JvmStatic
    @NotNull
    public static final File compileJsLibraryToJar(@NotNull String sourcesPath, @NotNull String jarName, boolean addSources, @NotNull List<String> extraOptions) {
        String string;
        Intrinsics.checkNotNullParameter((Object)sourcesPath, (String)"sourcesPath");
        Intrinsics.checkNotNullParameter((Object)jarName, (String)"jarName");
        Intrinsics.checkNotNullParameter(extraOptions, (String)"extraOptions");
        File file = KtTestUtil.tmpDirForReusableFolder("testLibrary-" + jarName);
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"tmpDirForReusableFolder(\"testLibrary-$jarName\")");
        File contentDir = file;
        File outDir = new File(contentDir, "out");
        File outputFile = new File(outDir, jarName + ".js");
        INSTANCE.compileKotlin2JS(sourcesPath, outputFile, extraOptions);
        String string2 = string = sourcesPath;
        String string3 = jarName;
        File file2 = outDir;
        File file3 = contentDir;
        boolean bl = false;
        boolean bl2 = addSources;
        return MockLibraryUtil.createJarFile(file3, file2, string3, bl2 ? string : null);
    }

    public static /* synthetic */ File compileJsLibraryToJar$default(String string, String string2, boolean bl, List list, int n, Object object) {
        if ((n & 8) != 0) {
            list = CollectionsKt.emptyList();
        }
        return MockLibraryUtil.compileJsLibraryToJar(string, string2, bl, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @NotNull
    public static final File createJarFile(@NotNull File contentDir, @NotNull File dirToAdd, @NotNull String jarName, @Nullable String sourcesPath) {
        Intrinsics.checkNotNullParameter((Object)contentDir, (String)"contentDir");
        Intrinsics.checkNotNullParameter((Object)dirToAdd, (String)"dirToAdd");
        Intrinsics.checkNotNullParameter((Object)jarName, (String)"jarName");
        File jarFile = new File(contentDir, jarName + ".jar");
        Closeable closeable = new ZipOutputStream(new FileOutputStream(jarFile));
        Throwable throwable = null;
        try {
            ZipOutputStream zip = (ZipOutputStream)closeable;
            boolean bl = false;
            ZipUtil.addDirToZipRecursively((ZipOutputStream)zip, (File)jarFile, (File)dirToAdd, (String)"", null, null);
            if (sourcesPath != null) {
                ZipUtil.addDirToZipRecursively((ZipOutputStream)zip, (File)jarFile, (File)new File(sourcesPath), (String)"src", null, null);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return jarFile;
    }

    public static /* synthetic */ File createJarFile$default(File file, File file2, String string, String string2, int n, Object object) {
        if ((n & 8) != 0) {
            string2 = null;
        }
        return MockLibraryUtil.createJarFile(file, file2, string, string2);
    }

    public final void runJvmCompiler(@NotNull List<String> args) {
        Intrinsics.checkNotNullParameter(args, (String)"args");
        this.runCompiler(this.getCompiler2JVMClass(), args);
    }

    private final void runJsCompiler(List<String> args) {
        this.runCompiler(this.getCompiler2JSClass(), args);
    }

    private final void runCompiler(Class<?> compilerClass, List<String> args) {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        Object compiler = compilerClass.newInstance();
        Class[] classArray = new Class[]{PrintStream.class, String[].class};
        Method execMethod = compilerClass.getMethod("exec", classArray);
        Object[] objectArray = new Object[2];
        objectArray[0] = new PrintStream(outStream);
        Collection $this$toTypedArray$iv = args;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        objectArray[1] = thisCollection$iv.toArray(new String[0]);
        Object object = execMethod.invoke(compiler, objectArray);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Enum<*>");
        Enum invocationResult = (Enum)object;
        byte[] byArray = outStream.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"outStream.toByteArray()");
        byte[] byArray2 = byArray;
        KtAssert.assertEquals(new String(byArray2, Charsets.UTF_8), ExitCode.OK.name(), invocationResult.name());
    }

    @JvmStatic
    @JvmOverloads
    public static final void compileKotlin(@NotNull String sourcesPath, @NotNull File outDir, @NotNull List<String> extraOptions, String ... extraClasspath) {
        Intrinsics.checkNotNullParameter((Object)sourcesPath, (String)"sourcesPath");
        Intrinsics.checkNotNullParameter((Object)outDir, (String)"outDir");
        Intrinsics.checkNotNullParameter(extraOptions, (String)"extraOptions");
        Intrinsics.checkNotNullParameter((Object)extraClasspath, (String)"extraClasspath");
        List classpath = new ArrayList();
        if (new File(sourcesPath).isDirectory()) {
            ((Collection)classpath).add(sourcesPath);
        }
        CollectionsKt.addAll((Collection)classpath, (Object[])extraClasspath);
        Object[] objectArray = new String[5];
        objectArray[0] = sourcesPath;
        objectArray[1] = "-d";
        objectArray[2] = outDir.getAbsolutePath();
        objectArray[3] = "-classpath";
        Iterable iterable = classpath;
        String string = File.pathSeparator;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pathSeparator");
        objectArray[4] = CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string, null, null, (int)0, null, null, (int)62, null);
        List args = CollectionsKt.plus((Collection)CollectionsKt.mutableListOf((Object[])objectArray), (Iterable)extraOptions);
        INSTANCE.runJvmCompiler(args);
    }

    public static /* synthetic */ void compileKotlin$default(String string, File file, List list, String[] stringArray, int n, Object object) {
        if ((n & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        MockLibraryUtil.compileKotlin(string, file, list, stringArray);
    }

    private final void compileKotlin2JS(String sourcesPath, File outputFile, List<String> extraOptions) {
        SpreadBuilder spreadBuilder = new SpreadBuilder(5);
        spreadBuilder.add((Object)"-meta-info");
        spreadBuilder.add((Object)"-output");
        spreadBuilder.add((Object)outputFile.getAbsolutePath());
        spreadBuilder.add((Object)sourcesPath);
        Collection $this$toTypedArray$iv = extraOptions;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        spreadBuilder.addSpread((Object)thisCollection$iv.toArray(new String[0]));
        this.runJsCompiler(CollectionsKt.listOf((Object[])spreadBuilder.toArray((Object[])new String[spreadBuilder.size()])));
    }

    public final void compileKotlinModule(@NotNull String buildFilePath) {
        Intrinsics.checkNotNullParameter((Object)buildFilePath, (String)"buildFilePath");
        Object[] objectArray = new String[]{"-no-stdlib", "-Xbuild-file", buildFilePath};
        this.runJvmCompiler(CollectionsKt.listOf((Object[])objectArray));
    }

    private final synchronized Class<?> getCompiler2JVMClass() {
        return this.loadCompilerClass(Reflection.getOrCreateKotlinClass(K2JVMCompiler.class));
    }

    private final synchronized Class<?> getCompiler2JSClass() {
        return this.loadCompilerClass(Reflection.getOrCreateKotlinClass(K2JSCompiler.class));
    }

    private final synchronized Class<?> loadCompilerClass(KClass<? extends CLICompiler<?>> compilerClass) {
        ClassLoader classLoader = compilerClassLoader.get();
        if (classLoader == null) {
            ClassLoader classLoader2;
            ClassLoader classLoader3 = classLoader2 = this.createCompilerClassLoader();
            boolean bl = false;
            compilerClassLoader = new SoftReference<ClassLoader>(classLoader3);
            classLoader = classLoader2;
        }
        Intrinsics.checkNotNullExpressionValue((Object)classLoader, (String)"compilerClassLoader.get(\u2026r>(classLoader)\n        }");
        ClassLoader classLoader4 = classLoader;
        Class<?> clazz = classLoader4.loadClass(JvmClassMappingKt.getJavaClass(compilerClass).getName());
        Intrinsics.checkNotNullExpressionValue(clazz, (String)"classLoader.loadClass(compilerClass.java.name)");
        return clazz;
    }

    private final synchronized ClassLoader createCompilerClassLoader() {
        ClassLoader classLoader = ClassPreloadingUtils.preloadClasses((Collection)CollectionsKt.listOf((Object)MockLibraryUtilKt.getKotlinPathsForDistDirectoryForTests(PathUtil.INSTANCE).getCompilerPath()), (int)4096, null, null);
        Intrinsics.checkNotNullExpressionValue((Object)classLoader, (String)"preloadClasses(\n        \u2026ATE, null, null\n        )");
        return classLoader;
    }

    @JvmStatic
    @JvmOverloads
    public static final void compileKotlin(@NotNull String sourcesPath, @NotNull File outDir, String ... extraClasspath) {
        Intrinsics.checkNotNullParameter((Object)sourcesPath, (String)"sourcesPath");
        Intrinsics.checkNotNullParameter((Object)outDir, (String)"outDir");
        Intrinsics.checkNotNullParameter((Object)extraClasspath, (String)"extraClasspath");
        MockLibraryUtil.compileKotlin$default(sourcesPath, outDir, null, extraClasspath, 4, null);
    }
}

