/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.references.FirControlFlowGraphReference;
import org.jetbrains.kotlin.fir.resolve.dfa.FirControlFlowGraphReferenceImpl;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.CFGNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraph;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.GraphEnterNodeMarker;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.GraphExitNodeMarker;
import org.jetbrains.kotlin.fir.visitors.FirVisitorVoid;
import org.jetbrains.kotlin.test.Assertions;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/fir/FirCfgConsistencyChecker;", "Lorg/jetbrains/kotlin/fir/visitors/FirVisitorVoid;", "assertions", "Lorg/jetbrains/kotlin/test/Assertions;", "(Lorg/jetbrains/kotlin/test/Assertions;)V", "checkConsistency", "", "graph", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraph;", "checkOrder", "visitControlFlowGraphReference", "controlFlowGraphReference", "Lorg/jetbrains/kotlin/fir/references/FirControlFlowGraphReference;", "visitElement", "element", "Lorg/jetbrains/kotlin/fir/FirElement;", "tests-compiler-utils_test"})
@SourceDebugExtension(value={"SMAP\nFirCfgConsistencyChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirCfgConsistencyChecker.kt\norg/jetbrains/kotlin/fir/FirCfgConsistencyChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,60:1\n618#2,12:61\n618#2,12:73\n*S KotlinDebug\n*F\n+ 1 FirCfgConsistencyChecker.kt\norg/jetbrains/kotlin/fir/FirCfgConsistencyChecker\n*L\n24#1:61,12\n25#1:73,12\n*E\n"})
public final class FirCfgConsistencyChecker
extends FirVisitorVoid {
    @NotNull
    private final Assertions assertions;

    public FirCfgConsistencyChecker(@NotNull Assertions assertions) {
        Intrinsics.checkNotNullParameter((Object)assertions, (String)"assertions");
        this.assertions = assertions;
    }

    public void visitElement(@NotNull FirElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        element.acceptChildren((FirVisitorVoid)this);
    }

    public void visitControlFlowGraphReference(@NotNull FirControlFlowGraphReference controlFlowGraphReference) {
        CFGNode it;
        Iterable $this$single$iv;
        Intrinsics.checkNotNullParameter((Object)controlFlowGraphReference, (String)"controlFlowGraphReference");
        FirControlFlowGraphReferenceImpl firControlFlowGraphReferenceImpl = controlFlowGraphReference instanceof FirControlFlowGraphReferenceImpl ? (FirControlFlowGraphReferenceImpl)controlFlowGraphReference : null;
        if (firControlFlowGraphReferenceImpl == null || (firControlFlowGraphReferenceImpl = firControlFlowGraphReferenceImpl.getControlFlowGraph()) == null) {
            return;
        }
        FirControlFlowGraphReferenceImpl graph = firControlFlowGraphReferenceImpl;
        Iterable iterable = graph.getNodes();
        Assertions assertions = this.assertions;
        boolean $i$f$single = false;
        Object single$iv = null;
        boolean found$iv = false;
        for (Object element$iv : $this$single$iv) {
            it = (CFGNode)element$iv;
            boolean bl = false;
            if (!(it instanceof GraphEnterNodeMarker)) continue;
            if (found$iv) {
                throw new IllegalArgumentException("Collection contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        Assertions.assertEquals$default(assertions, single$iv, graph.getEnterNode(), null, 4, null);
        $this$single$iv = graph.getNodes();
        assertions = this.assertions;
        $i$f$single = false;
        single$iv = null;
        found$iv = false;
        for (Object element$iv : $this$single$iv) {
            it = (CFGNode)element$iv;
            boolean bl = false;
            if (!(it instanceof GraphExitNodeMarker)) continue;
            if (found$iv) {
                throw new IllegalArgumentException("Collection contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        Assertions.assertEquals$default(assertions, single$iv, graph.getExitNode(), null, 4, null);
        this.checkConsistency((ControlFlowGraph)graph);
        this.checkOrder((ControlFlowGraph)graph);
    }

    private final void checkConsistency(ControlFlowGraph graph) {
        for (CFGNode node : graph.getNodes()) {
            CFGNode[] cFGNodeArray;
            this.assertions.assertEquals(node.getFollowingNodes().size(), CollectionsKt.toSet((Iterable)node.getFollowingNodes()).size(), (Function0<String>)((Function0)new Function0<String>(node){
                final /* synthetic */ CFGNode<?> $node;
                {
                    this.$node = $node;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "followingNodes has repeats: " + this.$node;
                }
            }));
            this.assertions.assertEquals(node.getPreviousNodes().size(), CollectionsKt.toSet((Iterable)node.getPreviousNodes()).size(), (Function0<String>)((Function0)new Function0<String>(node){
                final /* synthetic */ CFGNode<?> $node;
                {
                    this.$node = $node;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "previousNodes has repeats: " + this.$node;
                }
            }));
            for (CFGNode to : node.getFollowingNodes()) {
                cFGNodeArray = new CFGNode[]{node};
                this.assertions.assertContainsElements((Collection)to.getPreviousNodes(), cFGNodeArray);
                this.assertions.assertFalse(node.isDead() && to.isDead() && to.edgeFrom(node).getKind().getUsedInDfa(), (Function0<String>)((Function0)new Function0<String>(node, to){
                    final /* synthetic */ CFGNode<?> $node;
                    final /* synthetic */ CFGNode<?> $to;
                    {
                        this.$node = $node;
                        this.$to = $to;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "data flow between dead nodes: " + this.$node + " -> " + this.$to;
                    }
                }));
            }
            for (CFGNode from : node.getPreviousNodes()) {
                cFGNodeArray = new CFGNode[]{node};
                this.assertions.assertContainsElements((Collection)from.getFollowingNodes(), cFGNodeArray);
            }
            this.assertions.assertFalse(node.getFollowingNodes().isEmpty() && node.getPreviousNodes().isEmpty(), (Function0<String>)((Function0)new Function0<String>(node){
                final /* synthetic */ CFGNode<?> $node;
                {
                    this.$node = $node;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Unconnected CFG node: " + this.$node;
                }
            }));
        }
    }

    private final void checkOrder(ControlFlowGraph graph) {
        Set visited = new LinkedHashSet();
        for (CFGNode node : graph.getNodes()) {
            for (CFGNode previousNode : node.getPreviousNodes()) {
                if (!Intrinsics.areEqual((Object)previousNode.getOwner(), (Object)graph) || node.edgeFrom(previousNode).getKind().isBack()) continue;
                Assertions.assertTrue$default(this.assertions, visited.contains(previousNode), null, 2, null);
            }
            ((Collection)visited).add(node);
        }
    }
}

