/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.runners;

import com.intellij.testFramework.TestDataPath;
import java.io.File;
import java.util.regex.Pattern;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.jetbrains.kotlin.test.runners.AbstractDiagnosticsTestWithJvmIrBackend;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

@TestMetadata(value="compiler/testData/diagnostics/testsWithJvmBackend")
@TestDataPath(value="$PROJECT_ROOT")
public class DiagnosticsTestWithJvmIrBackendGenerated
extends AbstractDiagnosticsTestWithJvmIrBackend {
    @Test
    public void testAllFilesPresentInTestsWithJvmBackend() throws Exception {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/testsWithJvmBackend"), Pattern.compile("^(.+)\\.kts?$"), Pattern.compile("^(.+)\\.(fir|ll)\\.kts?$"), TargetBackend.JVM_IR, true, new String[0]);
    }

    @Test
    @TestMetadata(value="indirectInlineCycle_ir.kt")
    public void testIndirectInlineCycle_ir() throws Exception {
        this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/indirectInlineCycle_ir.kt");
    }

    @Test
    @TestMetadata(value="inlineCycle_ir.kt")
    public void testInlineCycle_ir() throws Exception {
        this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/inlineCycle_ir.kt");
    }

    @Test
    @TestMetadata(value="multipleBigArityFunsImplemented_ir.kt")
    public void testMultipleBigArityFunsImplemented_ir() throws Exception {
        this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/multipleBigArityFunsImplemented_ir.kt");
    }

    @Test
    @TestMetadata(value="noWarningInLV1_5.kt")
    public void testNoWarningInLV1_5() throws Exception {
        this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/noWarningInLV1_5.kt");
    }

    @Test
    @TestMetadata(value="propertyInlineCycle.kt")
    public void testPropertyInlineCycle() throws Exception {
        this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/propertyInlineCycle.kt");
    }

    @Test
    @TestMetadata(value="suspendInlineCycle_ir.kt")
    public void testSuspendInlineCycle_ir() throws Exception {
        this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/suspendInlineCycle_ir.kt");
    }

    @Nested
    @TestMetadata(value="compiler/testData/diagnostics/testsWithJvmBackend/valueClasses")
    @TestDataPath(value="$PROJECT_ROOT")
    public class ValueClasses {
        @Test
        public void testAllFilesPresentInValueClasses() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/testsWithJvmBackend/valueClasses"), Pattern.compile("^(.+)\\.kts?$"), Pattern.compile("^(.+)\\.(fir|ll)\\.kts?$"), TargetBackend.JVM_IR, true, new String[0]);
        }

        @Test
        @TestMetadata(value="cloneable.kt")
        public void testCloneable() throws Exception {
            DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/valueClasses/cloneable.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/diagnostics/testsWithJvmBackend/typeOf")
    @TestDataPath(value="$PROJECT_ROOT")
    public class TypeOf {
        @Test
        public void testAllFilesPresentInTypeOf() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/testsWithJvmBackend/typeOf"), Pattern.compile("^(.+)\\.kts?$"), Pattern.compile("^(.+)\\.(fir|ll)\\.kts?$"), TargetBackend.JVM_IR, true, new String[0]);
        }

        @Test
        @TestMetadata(value="nonReifiedTypeParameterWithRecursiveBound.kt")
        public void testNonReifiedTypeParameterWithRecursiveBound() throws Exception {
            DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/typeOf/nonReifiedTypeParameterWithRecursiveBound.kt");
        }

        @Test
        @TestMetadata(value="suspendType.kt")
        public void testSuspendType() throws Exception {
            DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/typeOf/suspendType.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/diagnostics/testsWithJvmBackend/scripts")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Scripts {
        @Test
        public void testAllFilesPresentInScripts() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/testsWithJvmBackend/scripts"), Pattern.compile("^(.+)\\.kts?$"), Pattern.compile("^(.+)\\.(fir|ll)\\.kts?$"), TargetBackend.JVM_IR, true, new String[0]);
        }

        @Test
        @TestMetadata(value="enumCapturesProperty.kts")
        public void testEnumCapturesProperty() throws Exception {
            DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/scripts/enumCapturesProperty.kts");
        }

        @Test
        @TestMetadata(value="enumEntryCapturesProperty.kts")
        public void testEnumEntryCapturesProperty() throws Exception {
            DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/scripts/enumEntryCapturesProperty.kts");
        }

        @Test
        @TestMetadata(value="interfaceCapturesProperty.kts")
        public void testInterfaceCapturesProperty() throws Exception {
            DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/scripts/interfaceCapturesProperty.kts");
        }

        @Test
        @TestMetadata(value="nestedAndOuterClassesCaptureProperty.kts")
        public void testNestedAndOuterClassesCaptureProperty() throws Exception {
            DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/scripts/nestedAndOuterClassesCaptureProperty.kts");
        }

        @Test
        @TestMetadata(value="nestedClassCapturesProperty.kts")
        public void testNestedClassCapturesProperty() throws Exception {
            DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/scripts/nestedClassCapturesProperty.kts");
        }

        @Test
        @TestMetadata(value="nestedToObjectClassCapturesProperty.kts")
        public void testNestedToObjectClassCapturesProperty() throws Exception {
            DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/scripts/nestedToObjectClassCapturesProperty.kts");
        }

        @Test
        @TestMetadata(value="objectCapturesProperty.kts")
        public void testObjectCapturesProperty() throws Exception {
            DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/scripts/objectCapturesProperty.kts");
        }

        @Test
        @TestMetadata(value="objectCapturesPropertyIndirect.kts")
        public void testObjectCapturesPropertyIndirect() throws Exception {
            DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/scripts/objectCapturesPropertyIndirect.kts");
        }

        @Test
        @TestMetadata(value="objectCapturesPropertyViaExtension1.kts")
        public void testObjectCapturesPropertyViaExtension1() throws Exception {
            DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/scripts/objectCapturesPropertyViaExtension1.kts");
        }

        @Test
        @TestMetadata(value="objectCapturesPropertyViaExtension2.kts")
        public void testObjectCapturesPropertyViaExtension2() throws Exception {
            DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/scripts/objectCapturesPropertyViaExtension2.kts");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/diagnostics/testsWithJvmBackend/multifileClasses")
    @TestDataPath(value="$PROJECT_ROOT")
    public class MultifileClasses {
        @Test
        public void testAllFilesPresentInMultifileClasses() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/testsWithJvmBackend/multifileClasses"), Pattern.compile("^(.+)\\.kts?$"), Pattern.compile("^(.+)\\.(fir|ll)\\.kts?$"), TargetBackend.JVM_IR, true, new String[0]);
        }

        @Test
        @TestMetadata(value="jvmSynthetic.kt")
        public void testJvmSynthetic() throws Exception {
            DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/multifileClasses/jvmSynthetic.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature")
    @TestDataPath(value="$PROJECT_ROOT")
    public class DuplicateJvmSignature {
        @Test
        public void testAllFilesPresentInDuplicateJvmSignature() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature"), Pattern.compile("^(.+)\\.kts?$"), Pattern.compile("^(.+)\\.(fir|ll)\\.kts?$"), TargetBackend.JVM_IR, true, new String[0]);
        }

        @Test
        @TestMetadata(value="caseInProperties.kt")
        public void testCaseInProperties() throws Exception {
            DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/caseInProperties.kt");
        }

        @Test
        @TestMetadata(value="changingNullabilityOfOrdinaryClassIsBinaryCompatibleChange.kt")
        public void testChangingNullabilityOfOrdinaryClassIsBinaryCompatibleChange() throws Exception {
            DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/changingNullabilityOfOrdinaryClassIsBinaryCompatibleChange.kt");
        }

        @Test
        @TestMetadata(value="vararg.kt")
        public void testVararg() throws Exception {
            DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/vararg.kt");
        }

        @Nested
        @TestMetadata(value="compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/traitImpl")
        @TestDataPath(value="$PROJECT_ROOT")
        public class TraitImpl {
            @Test
            public void testAllFilesPresentInTraitImpl() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/traitImpl"), Pattern.compile("^(.+)\\.kts?$"), Pattern.compile("^(.+)\\.(fir|ll)\\.kts?$"), TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="defaultVsNonDefault_ir.kt")
            public void testDefaultVsNonDefault_ir() throws Exception {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/traitImpl/defaultVsNonDefault_ir.kt");
            }

            @Test
            @TestMetadata(value="kt43611.kt")
            public void testKt43611() throws Exception {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/traitImpl/kt43611.kt");
            }

            @Test
            @TestMetadata(value="oneTrait_ir.kt")
            public void testOneTrait_ir() throws Exception {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/traitImpl/oneTrait_ir.kt");
            }

            @Test
            @TestMetadata(value="traitFunctionOverriddenByPropertyInTrait_ir.kt")
            public void testTraitFunctionOverriddenByPropertyInTrait_ir() throws Exception {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/traitImpl/traitFunctionOverriddenByPropertyInTrait_ir.kt");
            }

            @Test
            @TestMetadata(value="traitPropertyOverriddenByFunctionInTrait_ir.kt")
            public void testTraitPropertyOverriddenByFunctionInTrait_ir() throws Exception {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/traitImpl/traitPropertyOverriddenByFunctionInTrait_ir.kt");
            }

            @Test
            @TestMetadata(value="twoTraits_ir.kt")
            public void testTwoTraits_ir() throws Exception {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/traitImpl/twoTraits_ir.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/synthesized")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Synthesized {
            @Test
            public void testAllFilesPresentInSynthesized() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/synthesized"), Pattern.compile("^(.+)\\.kts?$"), Pattern.compile("^(.+)\\.(fir|ll)\\.kts?$"), TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="enumValuesValueOf.kt")
            public void testEnumValuesValueOf() throws Exception {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/synthesized/enumValuesValueOf.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/statics")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Statics {
            @Test
            public void testAllFilesPresentInStatics() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/statics"), Pattern.compile("^(.+)\\.kts?$"), Pattern.compile("^(.+)\\.(fir|ll)\\.kts?$"), TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="jkjk.kt")
            public void testJkjk() throws Exception {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/statics/jkjk.kt");
            }

            @Test
            @TestMetadata(value="kotlinClassExtendsJavaClass.kt")
            public void testKotlinClassExtendsJavaClass() throws Exception {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/statics/kotlinClassExtendsJavaClass.kt");
            }

            @Test
            @TestMetadata(value="kotlinClassExtendsJavaClassExtendsJavaClass.kt")
            public void testKotlinClassExtendsJavaClassExtendsJavaClass() throws Exception {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/statics/kotlinClassExtendsJavaClassExtendsJavaClass.kt");
            }

            @Test
            @TestMetadata(value="kotlinClassImplementsJavaInterface.kt")
            public void testKotlinClassImplementsJavaInterface() throws Exception {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/statics/kotlinClassImplementsJavaInterface.kt");
            }

            @Test
            @TestMetadata(value="kotlinClassImplementsJavaInterfaceExtendsJavaInteface.kt")
            public void testKotlinClassImplementsJavaInterfaceExtendsJavaInteface() throws Exception {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/statics/kotlinClassImplementsJavaInterfaceExtendsJavaInteface.kt");
            }

            @Test
            @TestMetadata(value="kotlinMembersVsJavaNonVisibleStatics.kt")
            public void testKotlinMembersVsJavaNonVisibleStatics() throws Exception {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/statics/kotlinMembersVsJavaNonVisibleStatics.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/specialNames")
        @TestDataPath(value="$PROJECT_ROOT")
        public class SpecialNames {
            @Test
            public void testAllFilesPresentInSpecialNames() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/specialNames"), Pattern.compile("^(.+)\\.kts?$"), Pattern.compile("^(.+)\\.(fir|ll)\\.kts?$"), TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="classObjectCopiedField.kt")
            public void testClassObjectCopiedField() throws Exception {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/specialNames/classObjectCopiedField.kt");
            }

            @Test
            @TestMetadata(value="classObjectCopiedFieldObject_ir.kt")
            public void testClassObjectCopiedFieldObject_ir() throws Exception {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/specialNames/classObjectCopiedFieldObject_ir.kt");
            }

            @Test
            @TestMetadata(value="classObject_ir.kt")
            public void testClassObject_ir() throws Exception {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/specialNames/classObject_ir.kt");
            }

            @Test
            @TestMetadata(value="dataClassCopy.kt")
            public void testDataClassCopy() throws Exception {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/specialNames/dataClassCopy.kt");
            }

            @Test
            @TestMetadata(value="defaults_ir.kt")
            public void testDefaults_ir() throws Exception {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/specialNames/defaults_ir.kt");
            }

            @Test
            @TestMetadata(value="delegationBy_ir.kt")
            public void testDelegationBy_ir() throws Exception {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/specialNames/delegationBy_ir.kt");
            }

            @Test
            @TestMetadata(value="enum.kt")
            public void testEnum() throws Exception {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/specialNames/enum.kt");
            }

            @Test
            @TestMetadata(value="innerClassField_ir.kt")
            public void testInnerClassField_ir() throws Exception {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/specialNames/innerClassField_ir.kt");
            }

            @Test
            @TestMetadata(value="instance_ir.kt")
            public void testInstance_ir() throws Exception {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/specialNames/instance_ir.kt");
            }

            @Test
            @TestMetadata(value="propertyMetadataCache_ir.kt")
            public void testPropertyMetadataCache_ir() throws Exception {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/specialNames/propertyMetadataCache_ir.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/functionAndProperty")
        @TestDataPath(value="$PROJECT_ROOT")
        public class FunctionAndProperty {
            @Test
            public void testAllFilesPresentInFunctionAndProperty() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/functionAndProperty"), Pattern.compile("^(.+)\\.kts?$"), Pattern.compile("^(.+)\\.(fir|ll)\\.kts?$"), TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="class.kt")
            public void testClass() throws Exception {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/functionAndProperty/class.kt");
            }

            @Test
            @TestMetadata(value="classObject.kt")
            public void testClassObject() throws Exception {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/functionAndProperty/classObject.kt");
            }

            @Test
            @TestMetadata(value="classPropertyInConstructor.kt")
            public void testClassPropertyInConstructor() throws Exception {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/functionAndProperty/classPropertyInConstructor.kt");
            }

            @Test
            @TestMetadata(value="extensionFunctionAndNormalFunction.kt")
            public void testExtensionFunctionAndNormalFunction() throws Exception {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/functionAndProperty/extensionFunctionAndNormalFunction.kt");
            }

            @Test
            @TestMetadata(value="extensionPropertyAndFunction.kt")
            public void testExtensionPropertyAndFunction() throws Exception {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/functionAndProperty/extensionPropertyAndFunction.kt");
            }

            @Test
            @TestMetadata(value="functionAndSetter.kt")
            public void testFunctionAndSetter() throws Exception {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/functionAndProperty/functionAndSetter.kt");
            }

            @Test
            @TestMetadata(value="functionAndVar.kt")
            public void testFunctionAndVar() throws Exception {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/functionAndProperty/functionAndVar.kt");
            }

            @Test
            @TestMetadata(value="localClass.kt")
            public void testLocalClass() throws Exception {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/functionAndProperty/localClass.kt");
            }

            @Test
            @TestMetadata(value="localClassInClass.kt")
            public void testLocalClassInClass() throws Exception {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/functionAndProperty/localClassInClass.kt");
            }

            @Test
            @TestMetadata(value="nestedClass.kt")
            public void testNestedClass() throws Exception {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/functionAndProperty/nestedClass.kt");
            }

            @Test
            @TestMetadata(value="object.kt")
            public void testObject() throws Exception {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/functionAndProperty/object.kt");
            }

            @Test
            @TestMetadata(value="objectExpression.kt")
            public void testObjectExpression() throws Exception {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/functionAndProperty/objectExpression.kt");
            }

            @Test
            @TestMetadata(value="objectExpressionInConstructor.kt")
            public void testObjectExpressionInConstructor() throws Exception {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/functionAndProperty/objectExpressionInConstructor.kt");
            }

            @Test
            @TestMetadata(value="privateClassPropertyNoClash.kt")
            public void testPrivateClassPropertyNoClash() throws Exception {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/functionAndProperty/privateClassPropertyNoClash.kt");
            }

            @Test
            @TestMetadata(value="topLevel.kt")
            public void testTopLevel() throws Exception {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/functionAndProperty/topLevel.kt");
            }

            @Test
            @TestMetadata(value="topLevelDifferentFiles.kt")
            public void testTopLevelDifferentFiles() throws Exception {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/functionAndProperty/topLevelDifferentFiles.kt");
            }

            @Test
            @TestMetadata(value="topLevelGetter.kt")
            public void testTopLevelGetter() throws Exception {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/functionAndProperty/topLevelGetter.kt");
            }

            @Test
            @TestMetadata(value="trait_ir.kt")
            public void testTrait_ir() throws Exception {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/functionAndProperty/trait_ir.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/finalMembersFromBuiltIns")
        @TestDataPath(value="$PROJECT_ROOT")
        public class FinalMembersFromBuiltIns {
            @Test
            public void testAllFilesPresentInFinalMembersFromBuiltIns() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/finalMembersFromBuiltIns"), Pattern.compile("^(.+)\\.kts?$"), Pattern.compile("^(.+)\\.(fir|ll)\\.kts?$"), TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="enumMembers.kt")
            public void testEnumMembers() throws Exception {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/finalMembersFromBuiltIns/enumMembers.kt");
            }

            @Test
            @TestMetadata(value="waitNotifyGetClass_ir.kt")
            public void testWaitNotifyGetClass_ir() throws Exception {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/finalMembersFromBuiltIns/waitNotifyGetClass_ir.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/erasure")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Erasure {
            @Test
            public void testAllFilesPresentInErasure() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/erasure"), Pattern.compile("^(.+)\\.kts?$"), Pattern.compile("^(.+)\\.(fir|ll)\\.kts?$"), TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="clashFromInterfaceAndSuperClass_ir.kt")
            public void testClashFromInterfaceAndSuperClass_ir() throws Exception {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/erasure/clashFromInterfaceAndSuperClass_ir.kt");
            }

            @Test
            @TestMetadata(value="collections.kt")
            public void testCollections() throws Exception {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/erasure/collections.kt");
            }

            @Test
            @TestMetadata(value="delegateToTwoTraits.kt")
            public void testDelegateToTwoTraits() throws Exception {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/erasure/delegateToTwoTraits.kt");
            }

            @Test
            @TestMetadata(value="delegationAndOwnMethod.kt")
            public void testDelegationAndOwnMethod() throws Exception {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/erasure/delegationAndOwnMethod.kt");
            }

            @Test
            @TestMetadata(value="delegationToTraitImplAndOwnMethod.kt")
            public void testDelegationToTraitImplAndOwnMethod() throws Exception {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/erasure/delegationToTraitImplAndOwnMethod.kt");
            }

            @Test
            @TestMetadata(value="extensionProperties.kt")
            public void testExtensionProperties() throws Exception {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/erasure/extensionProperties.kt");
            }

            @Test
            @TestMetadata(value="genericType.kt")
            public void testGenericType() throws Exception {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/erasure/genericType.kt");
            }

            @Test
            @TestMetadata(value="inheritFromTwoTraits_ir.kt")
            public void testInheritFromTwoTraits_ir() throws Exception {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/erasure/inheritFromTwoTraits_ir.kt");
            }

            @Test
            @TestMetadata(value="kotlinAndJavaCollections.kt")
            public void testKotlinAndJavaCollections() throws Exception {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/erasure/kotlinAndJavaCollections.kt");
            }

            @Test
            @TestMetadata(value="nullableType.kt")
            public void testNullableType() throws Exception {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/erasure/nullableType.kt");
            }

            @Test
            @TestMetadata(value="superTraitAndDelegationToTraitImpl_ir.kt")
            public void testSuperTraitAndDelegationToTraitImpl_ir() throws Exception {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/erasure/superTraitAndDelegationToTraitImpl_ir.kt");
            }

            @Test
            @TestMetadata(value="twoTraitsAndOwnFunction_ir.kt")
            public void testTwoTraitsAndOwnFunction_ir() throws Exception {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/erasure/twoTraitsAndOwnFunction_ir.kt");
            }

            @Test
            @TestMetadata(value="typeMappedToJava.kt")
            public void testTypeMappedToJava() throws Exception {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/erasure/typeMappedToJava.kt");
            }

            @Test
            @TestMetadata(value="typeParameter.kt")
            public void testTypeParameter() throws Exception {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/erasure/typeParameter.kt");
            }

            @Test
            @TestMetadata(value="typeParameterWithBound.kt")
            public void testTypeParameterWithBound() throws Exception {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/erasure/typeParameterWithBound.kt");
            }

            @Test
            @TestMetadata(value="typeParameterWithTwoBounds.kt")
            public void testTypeParameterWithTwoBounds() throws Exception {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/erasure/typeParameterWithTwoBounds.kt");
            }

            @Test
            @TestMetadata(value="typeParameterWithTwoBoundsInWhere.kt")
            public void testTypeParameterWithTwoBoundsInWhere() throws Exception {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/erasure/typeParameterWithTwoBoundsInWhere.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/bridges")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Bridges {
            @Test
            public void testAllFilesPresentInBridges() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/bridges"), Pattern.compile("^(.+)\\.kts?$"), Pattern.compile("^(.+)\\.(fir|ll)\\.kts?$"), TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="class_ir.kt")
            public void testClass_ir() throws Exception {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/bridges/class_ir.kt");
            }

            @Test
            @TestMetadata(value="fakeOverrideTrait_ir.kt")
            public void testFakeOverrideTrait_ir() throws Exception {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/bridges/fakeOverrideTrait_ir.kt");
            }

            @Test
            @TestMetadata(value="trait_ir.kt")
            public void testTrait_ir() throws Exception {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/bridges/trait_ir.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/accidentalOverrides")
        @TestDataPath(value="$PROJECT_ROOT")
        public class AccidentalOverrides {
            @Test
            @TestMetadata(value="accidentalOverrideFromGrandparent.kt")
            public void testAccidentalOverrideFromGrandparent() throws Exception {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/accidentalOverrides/accidentalOverrideFromGrandparent.kt");
            }

            @Test
            public void testAllFilesPresentInAccidentalOverrides() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/accidentalOverrides"), Pattern.compile("^(.+)\\.kts?$"), Pattern.compile("^(.+)\\.(fir|ll)\\.kts?$"), TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="classFunctionOverriddenByProperty.kt")
            public void testClassFunctionOverriddenByProperty() throws Exception {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/accidentalOverrides/classFunctionOverriddenByProperty.kt");
            }

            @Test
            @TestMetadata(value="classFunctionOverriddenByPropertyInConstructor.kt")
            public void testClassFunctionOverriddenByPropertyInConstructor() throws Exception {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/accidentalOverrides/classFunctionOverriddenByPropertyInConstructor.kt");
            }

            @Test
            @TestMetadata(value="classFunctionOverriddenByPropertyNoGetter.kt")
            public void testClassFunctionOverriddenByPropertyNoGetter() throws Exception {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/accidentalOverrides/classFunctionOverriddenByPropertyNoGetter.kt");
            }

            @Test
            @TestMetadata(value="classPropertyOverriddenByFunction.kt")
            public void testClassPropertyOverriddenByFunction() throws Exception {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/accidentalOverrides/classPropertyOverriddenByFunction.kt");
            }

            @Test
            @TestMetadata(value="defaultFunction_ir.kt")
            public void testDefaultFunction_ir() throws Exception {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/accidentalOverrides/defaultFunction_ir.kt");
            }

            @Test
            @TestMetadata(value="delegatedFunctionOverriddenByProperty_ir.kt")
            public void testDelegatedFunctionOverriddenByProperty_ir() throws Exception {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/accidentalOverrides/delegatedFunctionOverriddenByProperty_ir.kt");
            }

            @Test
            @TestMetadata(value="genericClassFunction.kt")
            public void testGenericClassFunction() throws Exception {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/accidentalOverrides/genericClassFunction.kt");
            }

            @Test
            @TestMetadata(value="overridesNothing_ir.kt")
            public void testOverridesNothing_ir() throws Exception {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/accidentalOverrides/overridesNothing_ir.kt");
            }

            @Test
            @TestMetadata(value="privateClassFunctionOverriddenByProperty.kt")
            public void testPrivateClassFunctionOverriddenByProperty() throws Exception {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/accidentalOverrides/privateClassFunctionOverriddenByProperty.kt");
            }

            @Test
            @TestMetadata(value="traitFunctionOverriddenByPropertyNoImpl.kt")
            public void testTraitFunctionOverriddenByPropertyNoImpl() throws Exception {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/accidentalOverrides/traitFunctionOverriddenByPropertyNoImpl.kt");
            }

            @Test
            @TestMetadata(value="traitFunctionOverriddenByProperty_ir.kt")
            public void testTraitFunctionOverriddenByProperty_ir() throws Exception {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/accidentalOverrides/traitFunctionOverriddenByProperty_ir.kt");
            }

            @Test
            @TestMetadata(value="traitPropertyOverriddenByFunctionNoImpl.kt")
            public void testTraitPropertyOverriddenByFunctionNoImpl() throws Exception {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/accidentalOverrides/traitPropertyOverriddenByFunctionNoImpl.kt");
            }

            @Test
            @TestMetadata(value="traitPropertyOverriddenByFunction_ir.kt")
            public void testTraitPropertyOverriddenByFunction_ir() throws Exception {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/accidentalOverrides/traitPropertyOverriddenByFunction_ir.kt");
            }
        }
    }
}

