/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.frontend.fir.handlers;

import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.test.frontend.fir.handlers.AbstractFirIdenticalChecker;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.utils.CustomTestDataUtilsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/test/frontend/fir/handlers/FirIdenticalChecker;", "Lorg/jetbrains/kotlin/test/frontend/fir/handlers/AbstractFirIdenticalChecker;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "checkTestDataFile", "", "testDataFile", "Ljava/io/File;", "removeFirFileIfExist", "tests-common-new_test"})
public final class FirIdenticalChecker
extends AbstractFirIdenticalChecker {
    public FirIdenticalChecker(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        super(testServices);
    }

    @Override
    protected void checkTestDataFile(@NotNull File testDataFile) {
        Intrinsics.checkNotNullParameter((Object)testDataFile, (String)"testDataFile");
        if (CustomTestDataUtilsKt.isLLFirTestData(testDataFile)) {
            return;
        }
        if (CustomTestDataUtilsKt.isFirTestData(testDataFile)) {
            File classicFile = this.getHelper().getClassicFileToCompare(testDataFile);
            if (this.getHelper().contentsAreEquals(classicFile, testDataFile, true)) {
                this.getHelper().deleteFirFile(testDataFile);
                this.getHelper().addDirectiveToClassicFileAndAssert(classicFile);
            }
        } else {
            this.removeFirFileIfExist(testDataFile);
        }
    }

    private final void removeFirFileIfExist(File testDataFile) {
        File firFile = this.getHelper().getFirFileToCompare(testDataFile);
        firFile.delete();
    }
}

