/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.frontend.fir.handlers;

import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.test.WrappedException;
import org.jetbrains.kotlin.test.model.AfterAnalysisChecker;
import org.jetbrains.kotlin.test.services.TestModuleStructureKt;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.utils.CustomTestDataUtilsKt;
import org.jetbrains.kotlin.test.utils.FirIdenticalCheckerHelper;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001:\u0001\u0011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fJ\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H$R\u0018\u0010\u0005\u001a\u00060\u0006R\u00020\u0000X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/test/frontend/fir/handlers/AbstractFirIdenticalChecker;", "Lorg/jetbrains/kotlin/test/model/AfterAnalysisChecker;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "helper", "Lorg/jetbrains/kotlin/test/frontend/fir/handlers/AbstractFirIdenticalChecker$SpecificHelper;", "getHelper", "()Lorg/jetbrains/kotlin/test/frontend/fir/handlers/AbstractFirIdenticalChecker$SpecificHelper;", "check", "", "failedAssertions", "", "Lorg/jetbrains/kotlin/test/WrappedException;", "checkTestDataFile", "testDataFile", "Ljava/io/File;", "SpecificHelper", "tests-common-new_test"})
public abstract class AbstractFirIdenticalChecker
extends AfterAnalysisChecker {
    @NotNull
    private final SpecificHelper helper;

    public AbstractFirIdenticalChecker(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        super(testServices);
        this.helper = new SpecificHelper();
    }

    @NotNull
    protected final SpecificHelper getHelper() {
        return this.helper;
    }

    protected abstract void checkTestDataFile(@NotNull File var1);

    @Override
    public final void check(@NotNull List<? extends WrappedException> failedAssertions) {
        Intrinsics.checkNotNullParameter(failedAssertions, (String)"failedAssertions");
        if (!((Collection)failedAssertions).isEmpty()) {
            return;
        }
        File testDataFile = (File)CollectionsKt.first(TestModuleStructureKt.getModuleStructure(this.getTestServices()).getOriginalTestDataFiles());
        this.checkTestDataFile(testDataFile);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0084\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016J\u0010\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/test/frontend/fir/handlers/AbstractFirIdenticalChecker$SpecificHelper;", "Lorg/jetbrains/kotlin/test/utils/FirIdenticalCheckerHelper;", "(Lorg/jetbrains/kotlin/test/frontend/fir/handlers/AbstractFirIdenticalChecker;)V", "getClassicFileToCompare", "Ljava/io/File;", "testDataFile", "getFirFileToCompare", "tests-common-new_test"})
    protected final class SpecificHelper
    extends FirIdenticalCheckerHelper {
        public SpecificHelper() {
            super(AbstractFirIdenticalChecker.this.getTestServices());
        }

        @Override
        @NotNull
        public File getClassicFileToCompare(@NotNull File testDataFile) {
            Intrinsics.checkNotNullParameter((Object)testDataFile, (String)"testDataFile");
            return CustomTestDataUtilsKt.getOriginalTestDataFile(testDataFile);
        }

        @Override
        @NotNull
        public File getFirFileToCompare(@NotNull File testDataFile) {
            Intrinsics.checkNotNullParameter((Object)testDataFile, (String)"testDataFile");
            return CustomTestDataUtilsKt.getFirTestDataFile(testDataFile);
        }
    }
}

