/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.backend.handlers;

import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.BytecodeListingTextCollectingVisitor;
import org.jetbrains.kotlin.test.Assertions;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.backend.handlers.JvmBinaryArtifactHandler;
import org.jetbrains.kotlin.test.directives.CodegenTestDirectives;
import org.jetbrains.kotlin.test.directives.model.DirectivesContainer;
import org.jetbrains.kotlin.test.model.BinaryArtifacts;
import org.jetbrains.kotlin.test.model.FrontendKinds;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.DefaultsProviderKt;
import org.jetbrains.kotlin.test.services.TestModuleStructureKt;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.utils.FileUtilsKt;
import org.jetbrains.kotlin.test.utils.MultiModuleInfoDumper;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/test/backend/handlers/BytecodeListingHandler;", "Lorg/jetbrains/kotlin/test/backend/handlers/JvmBinaryArtifactHandler;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "directiveContainers", "", "Lorg/jetbrains/kotlin/test/directives/model/DirectivesContainer;", "getDirectiveContainers", "()Ljava/util/List;", "multiModuleInfoDumper", "Lorg/jetbrains/kotlin/test/utils/MultiModuleInfoDumper;", "processAfterAllModules", "", "someAssertionWasFailed", "", "processModule", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "info", "Lorg/jetbrains/kotlin/test/model/BinaryArtifacts$Jvm;", "tests-common-new_test"})
@SourceDebugExtension(value={"SMAP\nBytecodeListingHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BytecodeListingHandler.kt\norg/jetbrains/kotlin/test/backend/handlers/BytecodeListingHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,76:1\n1#2:77\n*E\n"})
public final class BytecodeListingHandler
extends JvmBinaryArtifactHandler {
    @NotNull
    private final MultiModuleInfoDumper multiModuleInfoDumper;

    public BytecodeListingHandler(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        super(testServices, false, 2, null);
        this.multiModuleInfoDumper = new MultiModuleInfoDumper(null, 1, null);
    }

    @Override
    @NotNull
    public List<DirectivesContainer> getDirectiveContainers() {
        return CollectionsKt.listOf((Object)CodegenTestDirectives.INSTANCE);
    }

    @Override
    public void processModule(@NotNull TestModule module, @NotNull BinaryArtifacts.Jvm info) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        if (!module.getDirectives().contains(CodegenTestDirectives.INSTANCE.getCHECK_BYTECODE_LISTING())) {
            return;
        }
        String dump = BytecodeListingTextCollectingVisitor.Companion.getText(info.getClassFileFactory(), BytecodeListingTextCollectingVisitor.Filter.ForCodegenTests.INSTANCE, module.getDirectives().contains(CodegenTestDirectives.INSTANCE.getWITH_SIGNATURES()), !module.getDirectives().contains(CodegenTestDirectives.INSTANCE.getIGNORE_ANNOTATIONS()), !module.getDirectives().contains(CodegenTestDirectives.INSTANCE.getDONT_SORT_DECLARATIONS()));
        this.multiModuleInfoDumper.builderForModule(module).append(dump);
    }

    @Override
    public void processAfterAllModules(boolean someAssertionWasFailed) {
        File file;
        File file2;
        File it;
        File file3;
        if (this.multiModuleInfoDumper.isEmpty()) {
            return;
        }
        File sourceFile = (File)CollectionsKt.first(TestModuleStructureKt.getModuleStructure(this.getTestServices()).getOriginalTestDataFiles());
        File defaultTxtFile = FileUtilsKt.withExtension(sourceFile, ".txt");
        File irTxtFile = FileUtilsKt.withExtension(sourceFile, ".ir.txt");
        File firTxtFile = FileUtilsKt.withExtension(sourceFile, ".fir.txt");
        boolean isFir = Intrinsics.areEqual(DefaultsProviderKt.getDefaultsProvider(this.getTestServices()).getDefaultFrontend(), (Object)FrontendKinds.FIR.INSTANCE);
        TargetBackend targetBackend = DefaultsProviderKt.getDefaultsProvider(this.getTestServices()).getDefaultTargetBackend();
        boolean isIr = targetBackend != null ? targetBackend.isIR() : false;
        if (isFir) {
            it = file3 = firTxtFile;
            boolean bl = false;
            file2 = it.exists() ? file3 : null;
            if (file2 == null) {
                File it2 = it = irTxtFile;
                boolean bl2 = false;
                file2 = it2.exists() ? it : null;
                if (file2 == null) {
                    file2 = defaultTxtFile;
                }
            }
        } else if (isIr) {
            it = file3 = irTxtFile;
            boolean bl = false;
            file2 = it.exists() ? file3 : null;
            if (file2 == null) {
                file2 = defaultTxtFile;
            }
        } else {
            file2 = defaultTxtFile;
        }
        File actualFile = file2;
        if (isFir) {
            File file4;
            File it3 = file4 = irTxtFile;
            boolean bl = false;
            file = it3.exists() ? file4 : null;
            if (file == null) {
                file = defaultTxtFile;
            }
        } else {
            file = defaultTxtFile;
        }
        File goldenFile = file;
        Assertions.assertEqualsToFile$default(this.getAssertions(), actualFile, this.multiModuleInfoDumper.generateResultingDump(), null, 4, null);
        if (!Intrinsics.areEqual((Object)actualFile, (Object)goldenFile) && Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)FilesKt.readText$default((File)actualFile, null, (int)1, null))).toString(), (Object)((Object)StringsKt.trim((CharSequence)FilesKt.readText$default((File)goldenFile, null, (int)1, null))).toString())) {
            this.getAssertions().fail((Function0<String>)((Function0)new Function0<String>(actualFile){
                final /* synthetic */ File $actualFile;
                {
                    this.$actualFile = $actualFile;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "JVM and JVM_IR golden files are identical. Remove " + this.$actualFile + '.';
                }
            }));
            throw null;
        }
    }
}

