/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.utils;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.test.model.TestModule;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u000b\u001a\u00060\bj\u0002`\t2\u0006\u0010\f\u001a\u00020\u0007J\u0006\u0010\r\u001a\u00020\u0003J\u0006\u0010\u000e\u001a\u00020\u000fR2\u0010\u0005\u001a&\u0012\u0004\u0012\u00020\u0007\u0012\b\u0012\u00060\bj\u0002`\t0\u0006j\u0012\u0012\u0004\u0012\u00020\u0007\u0012\b\u0012\u00060\bj\u0002`\t`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/test/utils/MultiModuleInfoDumper;", "", "moduleHeaderTemplate", "", "(Ljava/lang/String;)V", "builderByModule", "Ljava/util/LinkedHashMap;", "Lorg/jetbrains/kotlin/test/model/TestModule;", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "Lkotlin/collections/LinkedHashMap;", "builderForModule", "module", "generateResultingDump", "isEmpty", "", "tests-common-new"})
public final class MultiModuleInfoDumper {
    @Nullable
    private final String moduleHeaderTemplate;
    @NotNull
    private final LinkedHashMap<TestModule, StringBuilder> builderByModule;

    public MultiModuleInfoDumper(@Nullable String moduleHeaderTemplate) {
        this.moduleHeaderTemplate = moduleHeaderTemplate;
        this.builderByModule = new LinkedHashMap();
    }

    public /* synthetic */ MultiModuleInfoDumper(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "Module: %s";
        }
        this(string);
    }

    @NotNull
    public final StringBuilder builderForModule(@NotNull TestModule module) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Map $this$getOrPut$iv = this.builderByModule;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(module);
        if (value$iv == null) {
            boolean bl = false;
            StringBuilder answer$iv = new StringBuilder();
            $this$getOrPut$iv.put(module, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (StringBuilder)object;
    }

    @NotNull
    public final String generateResultingDump() {
        Collection<StringBuilder> collection = this.builderByModule.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"builderByModule.values");
        StringBuilder stringBuilder = (StringBuilder)CollectionsKt.singleOrNull((Iterable)collection);
        if (stringBuilder != null) {
            StringBuilder it = stringBuilder;
            boolean bl = false;
            String string = it.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.toString()");
            return string;
        }
        StringBuilder $this$generateResultingDump_u24lambda_u242 = stringBuilder = new StringBuilder();
        boolean bl = false;
        for (Map.Entry entry : ((Map)this.builderByModule).entrySet()) {
            StringBuilder stringBuilder2;
            TestModule module = (TestModule)entry.getKey();
            StringBuilder builder = (StringBuilder)entry.getValue();
            if (this.moduleHeaderTemplate != null) {
                String string;
                String it;
                boolean bl2 = false;
                StringBuilder stringBuilder3 = $this$generateResultingDump_u24lambda_u242;
                Object[] objectArray = new Object[]{module.getName()};
                Intrinsics.checkNotNullExpressionValue((Object)String.format(it, Arrays.copyOf(objectArray, objectArray.length)), (String)"format(format, *args)");
                StringBuilder stringBuilder4 = stringBuilder3.append(string);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(value)");
                StringBuilder stringBuilder5 = stringBuilder4.append('\n');
                stringBuilder2 = stringBuilder5;
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append('\\n')");
            } else {
                stringBuilder2 = null;
            }
            $this$generateResultingDump_u24lambda_u242.append((CharSequence)builder);
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    public final boolean isEmpty() {
        return this.builderByModule.isEmpty();
    }

    public MultiModuleInfoDumper() {
        this(null, 1, null);
    }
}

