/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.services;

import com.intellij.openapi.project.Project;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.compiler.plugin.CompilerPluginRegistrar;
import org.jetbrains.kotlin.config.AnalysisFlag;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.test.directives.model.RegisteredDirectives;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.AbstractEnvironmentConfigurator;
import org.jetbrains.kotlin.test.services.DirectiveToConfigurationKeyExtractor;
import org.jetbrains.kotlin.test.services.TestModuleStructure;
import org.jetbrains.kotlin.test.services.TestModuleStructureKt;
import org.jetbrains.kotlin.test.services.TestServices;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0018\u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J \u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0016J*\u0010\u0015\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0017\u0012\u0006\u0012\u0004\u0018\u00010\u00180\u00162\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\f\u0010\u001d\u001a\u00020\f*\u00020\u001eH\u0016J\u001c\u0010\u001f\u001a\u00020\f*\u00020 2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0014\u0010\u0005\u001a\u00020\u00068DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/test/services/EnvironmentConfigurator;", "Lorg/jetbrains/kotlin/test/services/AbstractEnvironmentConfigurator;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "moduleStructure", "Lorg/jetbrains/kotlin/test/services/TestModuleStructure;", "getModuleStructure", "()Lorg/jetbrains/kotlin/test/services/TestModuleStructure;", "getTestServices", "()Lorg/jetbrains/kotlin/test/services/TestServices;", "configureCompileConfigurationWithAdditionalConfigurationKeys", "", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "configureCompilerConfiguration", "legacyRegisterCompilerExtensions", "project", "Lcom/intellij/openapi/project/Project;", "provideAdditionalAnalysisFlags", "", "Lorg/jetbrains/kotlin/config/AnalysisFlag;", "", "directives", "Lorg/jetbrains/kotlin/test/directives/model/RegisteredDirectives;", "languageVersion", "Lorg/jetbrains/kotlin/config/LanguageVersion;", "provideConfigurationKeys", "Lorg/jetbrains/kotlin/test/services/DirectiveToConfigurationKeyExtractor;", "registerCompilerExtensions", "Lorg/jetbrains/kotlin/compiler/plugin/CompilerPluginRegistrar$ExtensionStorage;", "test-infrastructure"})
public abstract class EnvironmentConfigurator
extends AbstractEnvironmentConfigurator {
    @NotNull
    private final TestServices testServices;

    public EnvironmentConfigurator(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        this.testServices = testServices;
    }

    @NotNull
    protected final TestServices getTestServices() {
        return this.testServices;
    }

    @NotNull
    protected final TestModuleStructure getModuleStructure() {
        return TestModuleStructureKt.getModuleStructure(this.testServices);
    }

    protected void configureCompilerConfiguration(@NotNull CompilerConfiguration configuration2, @NotNull TestModule module) {
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
    }

    @Override
    public final void configureCompileConfigurationWithAdditionalConfigurationKeys(@NotNull CompilerConfiguration configuration2, @NotNull TestModule module) {
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        DirectiveToConfigurationKeyExtractor extractor = new DirectiveToConfigurationKeyExtractor();
        this.provideConfigurationKeys(extractor);
        extractor.configure(configuration2, module.getDirectives());
        this.configureCompilerConfiguration(configuration2, module);
    }

    public void provideConfigurationKeys(@NotNull DirectiveToConfigurationKeyExtractor $this$provideConfigurationKeys) {
        Intrinsics.checkNotNullParameter((Object)$this$provideConfigurationKeys, (String)"<this>");
    }

    @Override
    @NotNull
    public Map<AnalysisFlag<?>, Object> provideAdditionalAnalysisFlags(@NotNull RegisteredDirectives directives2, @NotNull LanguageVersion languageVersion) {
        Intrinsics.checkNotNullParameter((Object)directives2, (String)"directives");
        Intrinsics.checkNotNullParameter((Object)languageVersion, (String)"languageVersion");
        return MapsKt.emptyMap();
    }

    @Override
    public void legacyRegisterCompilerExtensions(@NotNull Project project, @NotNull TestModule module, @NotNull CompilerConfiguration configuration2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
    }

    @Override
    public void registerCompilerExtensions(@NotNull CompilerPluginRegistrar.ExtensionStorage $this$registerCompilerExtensions, @NotNull TestModule module, @NotNull CompilerConfiguration configuration2) {
        Intrinsics.checkNotNullParameter((Object)$this$registerCompilerExtensions, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
    }
}

