/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.frontend.fir.handlers;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.renderer.FirRenderer;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderKt;
import org.jetbrains.kotlin.fir.scopes.FirKotlinScopeProviderKt;
import org.jetbrains.kotlin.fir.scopes.FirScope;
import org.jetbrains.kotlin.fir.scopes.FirScopeKt;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.scopes.ProcessorAction;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.test.Assertions;
import org.jetbrains.kotlin.test.directives.FirDiagnosticsDirectives;
import org.jetbrains.kotlin.test.directives.model.DirectivesContainer;
import org.jetbrains.kotlin.test.frontend.fir.FirOutputArtifact;
import org.jetbrains.kotlin.test.frontend.fir.handlers.FirAnalysisHandler;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.TestModuleStructureKt;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.utils.FileUtilsKt;
import org.jetbrains.kotlin.test.utils.MultiModuleInfoDumper;
import org.jetbrains.kotlin.util.SmartPrinter;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u00011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\u00060\r2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J$\u0010\u0019\u001a\u00020\u0011*\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J:\u0010!\u001a\u00020\u0011*\u00020\u001a2\u0006\u0010\"\u001a\u00020\u000e2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00062\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J$\u0010(\u001a\u00020\u0011*\u00020\u001a2\u0006\u0010)\u001a\u00020*2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u001c\u0010+\u001a\u00020\u0011*\u00020\u001a2\u0006\u0010,\u001a\u00020-2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u001c\u0010.\u001a\u00020\u0011*\u00020\u001a2\u0006\u0010,\u001a\u00020-2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J(\u0010/\u001a\u00020\u0011*\u00020\u001a2\n\u0010)\u001a\u0006\u0012\u0002\b\u0003002\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lorg/jetbrains/kotlin/test/frontend/fir/handlers/FirScopeDumpHandler;", "Lorg/jetbrains/kotlin/test/frontend/fir/handlers/FirAnalysisHandler;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "directiveContainers", "", "Lorg/jetbrains/kotlin/test/directives/model/DirectivesContainer;", "getDirectiveContainers", "()Ljava/util/List;", "dumper", "Lorg/jetbrains/kotlin/test/utils/MultiModuleInfoDumper;", "extractFqNameAndMemberNames", "Lkotlin/Pair;", "", "fqNameWithNames", "processAfterAllModules", "", "someAssertionWasFailed", "", "processModule", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "info", "Lorg/jetbrains/kotlin/test/frontend/fir/FirOutputArtifact;", "printInfo", "Lorg/jetbrains/kotlin/util/SmartPrinter;", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "scope", "Lorg/jetbrains/kotlin/fir/scopes/FirTypeScope;", "counter", "Lorg/jetbrains/kotlin/test/frontend/fir/handlers/FirScopeDumpHandler$SymbolCounter;", "processClass", "fqName", "namesFromDirective", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "processFunction", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "processFunctions", "name", "Lorg/jetbrains/kotlin/name/Name;", "processProperties", "processProperty", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirVariableSymbol;", "SymbolCounter", "tests-common-new"})
public final class FirScopeDumpHandler
extends FirAnalysisHandler {
    @NotNull
    private final MultiModuleInfoDumper dumper;

    public FirScopeDumpHandler(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        super(testServices, false, false, 6, null);
        this.dumper = new MultiModuleInfoDumper(null, 1, null);
    }

    @Override
    @NotNull
    public List<DirectivesContainer> getDirectiveContainers() {
        return CollectionsKt.listOf((Object)FirDiagnosticsDirectives.INSTANCE);
    }

    @Override
    public void processModule(@NotNull TestModule module, @NotNull FirOutputArtifact info) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        List<String> fqNamesWithNames = module.getDirectives().get(FirDiagnosticsDirectives.INSTANCE.getSCOPE_DUMP());
        if (fqNamesWithNames.isEmpty()) {
            return;
        }
        SmartPrinter printer = new SmartPrinter((Appendable)this.dumper.builderForModule(module), "  ");
        for (String fqNameWithNames : fqNamesWithNames) {
            Pair<String, List<String>> pair = this.extractFqNameAndMemberNames(fqNameWithNames);
            String fqName = (String)pair.component1();
            List names = (List)pair.component2();
            this.processClass(printer, fqName, names, info.getSession(), info.getFirAnalyzerFacade().getScopeSession(), module);
        }
    }

    private final Pair<String, List<String>> extractFqNameAndMemberNames(String fqNameWithNames) {
        Object object = new String[]{":"};
        Object it = object = StringsKt.split$default((CharSequence)fqNameWithNames, (String[])object, (boolean)false, (int)0, (int)6, null);
        boolean bl = false;
        Object object2 = it.size() > 1 ? object : null;
        if (object2 == null) {
            return TuplesKt.to((Object)fqNameWithNames, (Object)CollectionsKt.emptyList());
        }
        Object object3 = object2;
        String fqName = (String)object3.get(0);
        String namesString = (String)object3.get(1);
        String[] stringArray = new String[]{";"};
        return TuplesKt.to((Object)fqName, (Object)StringsKt.split$default((CharSequence)namesString, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
    }

    /*
     * WARNING - void declaration
     */
    private final void processClass(SmartPrinter $this$processClass, String fqName, List<String> namesFromDirective, FirSession session, ScopeSession scopeSession, TestModule module) {
        Collection collection;
        String className;
        String[] stringArray = new String[]{"."};
        List it = StringsKt.split$default((CharSequence)fqName, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean bl = false;
        FqName fqName2 = FqName.fromSegments((List)CollectionsKt.dropLast((List)it, (int)1));
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"fromSegments(it.dropLast(1))");
        FqName packageName = fqName2;
        Pair pair = TuplesKt.to((Object)packageName, (Object)CollectionsKt.last((List)it));
        FqName packageFqName = (FqName)pair.component1();
        String it2 = className = (String)pair.component2();
        boolean $i$a$-let-FirScopeDumpHandler$processClass$classId$22 = false;
        String[] stringArray2 = new String[]{"$"};
        List names = StringsKt.split$default((CharSequence)it2, (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
        ClassId classId = new ClassId(packageFqName, Name.identifier((String)((String)CollectionsKt.first((List)names))));
        Object object = CollectionsKt.drop((Iterable)names, (int)1).iterator();
        while (object.hasNext()) {
            String name2 = (String)object.next();
            Intrinsics.checkNotNullExpressionValue((Object)classId.createNestedClassId(Name.identifier((String)name2)), (String)"classId.createNestedClassId(Name.identifier(name))");
        }
        ClassId classId2 = classId;
        FirClassLikeSymbol firClassLikeSymbol = FirSymbolProviderKt.getSymbolProvider((FirSession)session).getClassLikeSymbolByClassId(classId2);
        if (firClassLikeSymbol == null) {
            this.getAssertions().fail((Function0<String>)((Function0)new Function0<String>(fqName, module){
                final /* synthetic */ String $fqName;
                final /* synthetic */ TestModule $module;
                {
                    this.$fqName = $fqName;
                    this.$module = $module;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Class " + this.$fqName + " not found in module " + this.$module.getName();
                }
            }));
            throw null;
        }
        FirClassLikeSymbol symbol2 = firClassLikeSymbol;
        classId = symbol2.getFir();
        FirRegularClass firRegularClass = classId instanceof FirRegularClass ? (FirRegularClass)classId : null;
        if (firRegularClass == null) {
            this.getAssertions().fail((Function0<String>)((Function0)new Function0<String>(fqName, symbol2){
                final /* synthetic */ String $fqName;
                final /* synthetic */ FirClassLikeSymbol<?> $symbol;
                {
                    this.$fqName = $fqName;
                    this.$symbol = $symbol;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return this.$fqName + " is not a class but " + UtilsKt.render((FirElement)((FirElement)this.$symbol.getFir()));
                }
            }));
            throw null;
        }
        FirRegularClass firClass2 = firRegularClass;
        Object[] $i$a$-let-FirScopeDumpHandler$processClass$classId$22 = new Object[]{fqName + ": "};
        $this$processClass.println($i$a$-let-FirScopeDumpHandler$processClass$classId$22);
        FirTypeScope scope = FirKotlinScopeProviderKt.unsubstitutedScope((FirClass)((FirClass)firClass2), (FirSession)session, (ScopeSession)scopeSession, (boolean)true);
        Object it3 = object = namesFromDirective;
        boolean bl2 = false;
        Object object2 = !((Collection)it3).isEmpty() ? object : null;
        if (object2 != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)object2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it4;
                String string = (String)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl3 = false;
                collection2.add(Name.identifier((String)it4));
            }
            collection = (List)destination$iv$iv;
        } else {
            collection = scope.getCallableNames();
        }
        Collection names2 = collection;
        SmartPrinter $this$withIndent$iv = $this$processClass;
        boolean $i$f$withIndent = false;
        $this$withIndent$iv.pushIndent();
        boolean bl4 = false;
        for (Name name3 : names2) {
            this.processFunctions($this$processClass, name3, scope);
            this.processProperties($this$processClass, name3, scope);
        }
        $this$withIndent$iv.popIndent();
        $this$processClass.println(new Object[0]);
    }

    private final void processFunctions(SmartPrinter $this$processFunctions, Name name2, FirTypeScope scope) {
        List functions = FirScopeKt.getFunctions((FirScope)((FirScope)scope), (Name)name2);
        for (FirNamedFunctionSymbol function : functions) {
            this.processFunction($this$processFunctions, function, scope, new SymbolCounter());
        }
    }

    private final void processFunction(SmartPrinter $this$processFunction, FirNamedFunctionSymbol symbol2, FirTypeScope scope, SymbolCounter counter) {
        this.printInfo($this$processFunction, (FirCallableDeclaration)symbol2.getFir(), scope, counter);
        scope.processDirectOverriddenFunctionsWithBaseScope(symbol2, (Function2)new Function2<FirNamedFunctionSymbol, FirTypeScope, ProcessorAction>($this$processFunction, this, counter){
            final /* synthetic */ SmartPrinter $this_processFunction;
            final /* synthetic */ FirScopeDumpHandler this$0;
            final /* synthetic */ SymbolCounter $counter;
            {
                this.$this_processFunction = $receiver;
                this.this$0 = $receiver2;
                this.$counter = $counter;
                super(2);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final ProcessorAction invoke(@NotNull FirNamedFunctionSymbol overridden, @NotNull FirTypeScope baseScope) {
                void $this$withIndent$iv;
                Intrinsics.checkNotNullParameter((Object)overridden, (String)"overridden");
                Intrinsics.checkNotNullParameter((Object)baseScope, (String)"baseScope");
                SmartPrinter smartPrinter = this.$this_processFunction;
                FirScopeDumpHandler firScopeDumpHandler = this.this$0;
                SmartPrinter smartPrinter2 = this.$this_processFunction;
                SymbolCounter symbolCounter = this.$counter;
                boolean $i$f$withIndent = false;
                $this$withIndent$iv.pushIndent();
                boolean bl = false;
                FirScopeDumpHandler.access$processFunction(firScopeDumpHandler, smartPrinter2, overridden, baseScope, symbolCounter);
                $this$withIndent$iv.popIndent();
                return ProcessorAction.NEXT;
            }
        });
    }

    private final void processProperties(SmartPrinter $this$processProperties, Name name2, FirTypeScope scope) {
        List properties = FirScopeKt.getProperties((FirScope)((FirScope)scope), (Name)name2);
        for (FirVariableSymbol property : properties) {
            this.processProperty($this$processProperties, property, scope, new SymbolCounter());
        }
    }

    private final void processProperty(SmartPrinter $this$processProperty, FirVariableSymbol<?> symbol2, FirTypeScope scope, SymbolCounter counter) {
        this.printInfo($this$processProperty, (FirCallableDeclaration)symbol2.getFir(), scope, counter);
        if (!(symbol2 instanceof FirPropertySymbol)) {
            return;
        }
        SmartPrinter $this$withIndent$iv = $this$processProperty;
        boolean $i$f$withIndent = false;
        $this$withIndent$iv.pushIndent();
        boolean bl = false;
        scope.processDirectOverriddenPropertiesWithBaseScope((FirPropertySymbol)symbol2, (Function2)new Function2<FirPropertySymbol, FirTypeScope, ProcessorAction>(this, $this$processProperty, counter){
            final /* synthetic */ FirScopeDumpHandler this$0;
            final /* synthetic */ SmartPrinter $this_processProperty;
            final /* synthetic */ SymbolCounter $counter;
            {
                this.this$0 = $receiver;
                this.$this_processProperty = $receiver2;
                this.$counter = $counter;
                super(2);
            }

            @NotNull
            public final ProcessorAction invoke(@NotNull FirPropertySymbol overriden, @NotNull FirTypeScope baseScope) {
                Intrinsics.checkNotNullParameter((Object)overriden, (String)"overriden");
                Intrinsics.checkNotNullParameter((Object)baseScope, (String)"baseScope");
                FirScopeDumpHandler.access$processProperty(this.this$0, this.$this_processProperty, (FirVariableSymbol)overriden, baseScope, this.$counter);
                return ProcessorAction.NEXT;
            }
        });
        $this$withIndent$iv.popIndent();
    }

    private final void printInfo(SmartPrinter $this$printInfo, FirCallableDeclaration declaration, FirTypeScope scope, SymbolCounter counter) {
        Object[] objectArray = new Object[]{"" + '[' + declaration.getOrigin() + "]: "};
        $this$printInfo.print(objectArray);
        String renderedDeclaration = ((Object)StringsKt.trim((CharSequence)FirRenderer.Companion.noAnnotationBodiesAccessorAndArguments().renderElementAsString((FirElement)declaration))).toString();
        Object[] objectArray2 = new Object[]{renderedDeclaration};
        $this$printInfo.print(objectArray2);
        objectArray2 = new Object[]{" from " + scope};
        $this$printInfo.print(objectArray2);
        objectArray2 = new Object[]{" [id: " + counter.getIndex((FirBasedSymbol)declaration.getSymbol()) + ']'};
        $this$printInfo.println(objectArray2);
    }

    @Override
    public void processAfterAllModules(boolean someAssertionWasFailed) {
        if (this.dumper.isEmpty()) {
            return;
        }
        File expectedFile = FileUtilsKt.withExtension((File)CollectionsKt.first(TestModuleStructureKt.getModuleStructure(this.getTestServices()).getOriginalTestDataFiles()), ".overrides.txt");
        String actualDump = this.dumper.generateResultingDump();
        Assertions.assertEqualsToFile$default(this.getAssertions(), expectedFile, actualDump, null, 4, null);
    }

    public static final /* synthetic */ void access$processFunction(FirScopeDumpHandler $this, SmartPrinter $receiver, FirNamedFunctionSymbol symbol2, FirTypeScope scope, SymbolCounter counter) {
        $this.processFunction($receiver, symbol2, scope, counter);
    }

    public static final /* synthetic */ void access$processProperty(FirScopeDumpHandler $this, SmartPrinter $receiver, FirVariableSymbol symbol2, FirTypeScope scope, SymbolCounter counter) {
        $this.processProperty($receiver, symbol2, scope, counter);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\b\u001a\u00020\u00042\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0005\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/test/frontend/fir/handlers/FirScopeDumpHandler$SymbolCounter;", "", "()V", "counter", "", "map", "", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "getIndex", "symbol", "tests-common-new"})
    private static final class SymbolCounter {
        @NotNull
        private final Map<FirBasedSymbol<?>, Integer> map = new LinkedHashMap();
        private int counter;

        public final int getIndex(@NotNull FirBasedSymbol<?> symbol2) {
            Intrinsics.checkNotNullParameter(symbol2, (String)"symbol");
            Integer n = this.map.computeIfAbsent(symbol2, arg_0 -> SymbolCounter.getIndex$lambda$0((Function1)new Function1<FirBasedSymbol<?>, Integer>(this){
                final /* synthetic */ SymbolCounter this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Integer invoke(@NotNull FirBasedSymbol<?> it) {
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    SymbolCounter symbolCounter = this.this$0;
                    int n = SymbolCounter.access$getCounter$p(symbolCounter);
                    SymbolCounter.access$setCounter$p(symbolCounter, n + 1);
                    return n;
                }
            }, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)n, (String)"fun getIndex(symbol: Fir\u2026) { counter++ }\n        }");
            return ((Number)n).intValue();
        }

        private static final Integer getIndex$lambda$0(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Integer)$tmp0.invoke(p0);
        }

        public static final /* synthetic */ int access$getCounter$p(SymbolCounter $this) {
            return $this.counter;
        }

        public static final /* synthetic */ void access$setCounter$p(SymbolCounter $this, int n) {
            $this.counter = n;
        }
    }
}

