/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.frontend.fir;

import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.psi.PsiElementFinder;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.finder.JavaElementFinder;
import org.jetbrains.kotlin.backend.common.extensions.IrGenerationExtension;
import org.jetbrains.kotlin.cli.jvm.compiler.JvmPackagePartProvider;
import org.jetbrains.kotlin.cli.jvm.compiler.PsiBasedProjectFileSearchScope;
import org.jetbrains.kotlin.cli.jvm.compiler.TopDownAnalyzerFacadeForJVM;
import org.jetbrains.kotlin.cli.jvm.compiler.VfsBasedProjectEnvironment;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.fir.DependencyListForCliModule;
import org.jetbrains.kotlin.fir.FirAnalyzerFacade;
import org.jetbrains.kotlin.fir.FirModuleData;
import org.jetbrains.kotlin.fir.FirModuleDataImpl;
import org.jetbrains.kotlin.fir.FirModuleDataKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.checkers.CheckersContainersKt;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.extensions.FirExtensionRegistrar;
import org.jetbrains.kotlin.fir.java.FirProjectSessionProvider;
import org.jetbrains.kotlin.fir.session.FirSessionConfigurator;
import org.jetbrains.kotlin.fir.session.FirSessionFactory;
import org.jetbrains.kotlin.fir.session.environment.AbstractProjectEnvironment;
import org.jetbrains.kotlin.fir.session.environment.AbstractProjectFileSearchScope;
import org.jetbrains.kotlin.load.kotlin.PackagePartProvider;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.TargetPlatformKt;
import org.jetbrains.kotlin.platform.js.JsPlatformKt;
import org.jetbrains.kotlin.platform.jvm.JvmPlatformKt;
import org.jetbrains.kotlin.platform.konan.NativePlatformKt;
import org.jetbrains.kotlin.resolve.PlatformDependentAnalyzerServices;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.directives.FirDiagnosticsDirectives;
import org.jetbrains.kotlin.test.directives.model.DirectivesContainer;
import org.jetbrains.kotlin.test.frontend.fir.FirFrontendFacade;
import org.jetbrains.kotlin.test.frontend.fir.FirFrontendFacadeKt;
import org.jetbrains.kotlin.test.frontend.fir.FirJsSessionFactory;
import org.jetbrains.kotlin.test.frontend.fir.FirModuleInfoProvider;
import org.jetbrains.kotlin.test.frontend.fir.FirModuleInfoProviderKt;
import org.jetbrains.kotlin.test.frontend.fir.FirNativeSessionFactory;
import org.jetbrains.kotlin.test.frontend.fir.FirOutputArtifact;
import org.jetbrains.kotlin.test.frontend.fir.FirOutputArtifactImpl;
import org.jetbrains.kotlin.test.model.FrontendFacade;
import org.jetbrains.kotlin.test.model.FrontendKinds;
import org.jetbrains.kotlin.test.model.TestFile;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.CompilerConfigurationProvider;
import org.jetbrains.kotlin.test.services.CompilerConfigurationProviderKt;
import org.jetbrains.kotlin.test.services.ServiceRegistrationData;
import org.jetbrains.kotlin.test.services.SourceFileProviderKt;
import org.jetbrains.kotlin.test.services.TestService;
import org.jetbrains.kotlin.test.services.TestServices;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0014B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\r\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/test/frontend/fir/FirFrontendFacade;", "Lorg/jetbrains/kotlin/test/model/FrontendFacade;", "Lorg/jetbrains/kotlin/test/frontend/fir/FirOutputArtifact;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "additionalSessionConfiguration", "Lorg/jetbrains/kotlin/test/frontend/fir/FirFrontendFacade$SessionConfiguration;", "(Lorg/jetbrains/kotlin/test/services/TestServices;Lorg/jetbrains/kotlin/test/frontend/fir/FirFrontendFacade$SessionConfiguration;)V", "additionalServices", "", "Lorg/jetbrains/kotlin/test/services/ServiceRegistrationData;", "getAdditionalServices", "()Ljava/util/List;", "directiveContainers", "Lorg/jetbrains/kotlin/test/directives/model/DirectivesContainer;", "getDirectiveContainers", "analyze", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "SessionConfiguration", "tests-common-new"})
public final class FirFrontendFacade
extends FrontendFacade<FirOutputArtifact> {
    @Nullable
    private final SessionConfiguration additionalSessionConfiguration;

    public FirFrontendFacade(@NotNull TestServices testServices, @Nullable SessionConfiguration additionalSessionConfiguration) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        super(testServices, FrontendKinds.FIR.INSTANCE);
        this.additionalSessionConfiguration = additionalSessionConfiguration;
    }

    public FirFrontendFacade(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        this(testServices, (SessionConfiguration)null);
    }

    @Override
    @NotNull
    public List<ServiceRegistrationData> getAdditionalServices() {
        Function1 serviceConstructor$iv = additionalServices.1.INSTANCE;
        boolean $i$f$service = false;
        return CollectionsKt.listOf((Object)new ServiceRegistrationData((KClass<? extends TestService>)Reflection.getOrCreateKotlinClass(FirModuleInfoProvider.class), (Function1<? super TestServices, ? extends TestService>)serviceConstructor$iv));
    }

    @Override
    @NotNull
    public List<DirectivesContainer> getDirectiveContainers() {
        return CollectionsKt.listOf((Object)FirDiagnosticsDirectives.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public FirOutputArtifact analyze(@NotNull TestModule module) {
        void $this$mapNotNullTo$iv$iv;
        FirSession firSession;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        FirModuleInfoProvider moduleInfoProvider = FirModuleInfoProviderKt.getFirModuleInfoProvider(this.getTestServices());
        CompilerConfigurationProvider compilerConfigurationProvider = CompilerConfigurationProviderKt.getCompilerConfigurationProvider(this.getTestServices());
        Project project = compilerConfigurationProvider.getProject(module);
        PsiElementFinder.EP.getPoint((AreaInstance)project).unregisterExtension(JavaElementFinder.class);
        boolean lightTreeEnabled = module.getDirectives().contains(FirDiagnosticsDirectives.INSTANCE.getUSE_LIGHT_TREE());
        Pair pair = lightTreeEnabled ? TuplesKt.to((Object)CollectionsKt.emptyList(), SourceFileProviderKt.getLightTreeFilesForSourceFiles(SourceFileProviderKt.getSourceFileProvider(this.getTestServices()), (Collection<TestFile>)module.getFiles()).values()) : TuplesKt.to(SourceFileProviderKt.getKtFilesForSourceFiles$default(SourceFileProviderKt.getSourceFileProvider(this.getTestServices()), module.getFiles(), project, false, 4, null).values(), (Object)CollectionsKt.emptyList());
        Collection ktFiles = (Collection)pair.component1();
        Collection lightTreeFiles = (Collection)pair.component2();
        Name name2 = Name.identifier((String)module.getName());
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(module.name)");
        Name moduleName = name2;
        LanguageVersionSettings languageVersionSettings = module.getLanguageVersionSettings();
        PlatformDependentAnalyzerServices analyzerServices = FirFrontendFacadeKt.getAnalyzerServices(module.getTargetPlatform());
        CompilerConfiguration configuration2 = compilerConfigurationProvider.getCompilerConfiguration(module);
        List extensionRegistrars = FirExtensionRegistrar.Companion.getInstances(project);
        Function1 sessionConfigurator2 = (Function1)new Function1<FirSessionConfigurator, Unit>(module, this){
            final /* synthetic */ TestModule $module;
            final /* synthetic */ FirFrontendFacade this$0;
            {
                this.$module = $module;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull FirSessionConfigurator $this$null) {
                block1: {
                    Intrinsics.checkNotNullParameter((Object)$this$null, (String)"$this$null");
                    if (this.$module.getDirectives().contains(FirDiagnosticsDirectives.INSTANCE.getWITH_EXTENDED_CHECKERS())) {
                        CheckersContainersKt.registerExtendedCommonCheckers((FirSessionConfigurator)$this$null);
                    }
                    SessionConfiguration sessionConfiguration = FirFrontendFacade.access$getAdditionalSessionConfiguration$p(this.this$0);
                    if (sessionConfiguration == null) break block1;
                    sessionConfiguration.invoke($this$null);
                }
            }
        };
        boolean isCommonOrJvm = JvmPlatformKt.isJvm((TargetPlatform)module.getTargetPlatform()) || TargetPlatformKt.isCommon((TargetPlatform)module.getTargetPlatform());
        DependencyListForCliModule dependencyList2 = FirFrontendFacadeKt.access$buildDependencyList(module, moduleName, moduleInfoProvider, analyzerServices, (Function1)new Function1<DependencyListForCliModule.Builder, Unit>(isCommonOrJvm, module, configuration2, this){
            final /* synthetic */ boolean $isCommonOrJvm;
            final /* synthetic */ TestModule $module;
            final /* synthetic */ CompilerConfiguration $configuration;
            final /* synthetic */ FirFrontendFacade this$0;
            {
                this.$isCommonOrJvm = $isCommonOrJvm;
                this.$module = $module;
                this.$configuration = $configuration;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull DependencyListForCliModule.Builder $this$buildDependencyList) {
                Intrinsics.checkNotNullParameter((Object)$this$buildDependencyList, (String)"$this$buildDependencyList");
                if (this.$isCommonOrJvm || NativePlatformKt.isNative((TargetPlatform)this.$module.getTargetPlatform())) {
                    FirFrontendFacadeKt.access$configureJvmDependencies($this$buildDependencyList, this.$configuration);
                } else {
                    FirFrontendFacadeKt.access$configureJsDependencies($this$buildDependencyList, this.$module, this.this$0.getTestServices());
                }
            }
        });
        VfsBasedProjectEnvironment projectEnvironment = null;
        if (isCommonOrJvm) {
            Function1<GlobalSearchScope, JvmPackagePartProvider> packagePartProviderFactory = compilerConfigurationProvider.getPackagePartProviderFactory(module);
            VirtualFileSystem virtualFileSystem = VirtualFileManager.getInstance().getFileSystem("file");
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileSystem, (String)"getInstance().getFileSys\u2026ileSystems.FILE_PROTOCOL)");
            projectEnvironment = new VfsBasedProjectEnvironment(project, virtualFileSystem, (Function1)new Function1<GlobalSearchScope, PackagePartProvider>(packagePartProviderFactory){
                final /* synthetic */ Function1<GlobalSearchScope, JvmPackagePartProvider> $packagePartProviderFactory;
                {
                    this.$packagePartProviderFactory = $packagePartProviderFactory;
                    super(1);
                }

                @NotNull
                public final PackagePartProvider invoke(@NotNull GlobalSearchScope it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return (PackagePartProvider)this.$packagePartProviderFactory.invoke((Object)it);
                }
            });
            GlobalSearchScope globalSearchScope = ProjectScope.getLibrariesScope((Project)project);
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"getLibrariesScope(project)");
            PsiBasedProjectFileSearchScope projectFileSearchScope = new PsiBasedProjectFileSearchScope(globalSearchScope);
            PackagePartProvider packagePartProvider = projectEnvironment.getPackagePartProvider((AbstractProjectFileSearchScope)projectFileSearchScope);
            FirSessionFactory.INSTANCE.createLibrarySession(moduleName, moduleInfoProvider.getFirSessionProvider(), dependencyList2, (AbstractProjectEnvironment)projectEnvironment, (AbstractProjectFileSearchScope)projectFileSearchScope, packagePartProvider, languageVersionSettings);
        } else if (JsPlatformKt.isJs((TargetPlatform)module.getTargetPlatform())) {
            projectEnvironment = null;
            FirJsSessionFactory.INSTANCE.createLibrarySession(moduleName, moduleInfoProvider.getFirSessionProvider(), dependencyList2, module, this.getTestServices(), configuration2, languageVersionSettings);
        } else if (NativePlatformKt.isNative((TargetPlatform)module.getTargetPlatform())) {
            projectEnvironment = null;
            FirNativeSessionFactory.INSTANCE.createLibrarySession(moduleName, moduleInfoProvider.getFirSessionProvider(), dependencyList2, languageVersionSettings);
        } else {
            throw new IllegalStateException("Unsupported".toString());
        }
        FirModuleDataImpl mainModuleData = new FirModuleDataImpl(moduleName, dependencyList2.getRegularDependencies(), dependencyList2.getDependsOnDependencies(), dependencyList2.getFriendsDependencies(), dependencyList2.getPlatform(), dependencyList2.getAnalyzerServices());
        if (isCommonOrJvm) {
            FirModuleData firModuleData = (FirModuleData)mainModuleData;
            FirProjectSessionProvider firProjectSessionProvider = moduleInfoProvider.getFirSessionProvider();
            AbstractProjectFileSearchScope abstractProjectFileSearchScope = (AbstractProjectFileSearchScope)new PsiBasedProjectFileSearchScope(TopDownAnalyzerFacadeForJVM.INSTANCE.newModuleSearchScope(project, ktFiles));
            VfsBasedProjectEnvironment vfsBasedProjectEnvironment = projectEnvironment;
            Intrinsics.checkNotNull((Object)vfsBasedProjectEnvironment);
            firSession = FirSessionFactory.INSTANCE.createModuleBasedSession(firModuleData, firProjectSessionProvider, abstractProjectFileSearchScope, (AbstractProjectEnvironment)vfsBasedProjectEnvironment, null, extensionRegistrars, languageVersionSettings, null, null, true, sessionConfigurator2);
        } else if (JsPlatformKt.isJs((TargetPlatform)module.getTargetPlatform())) {
            firSession = FirJsSessionFactory.INSTANCE.createModuleBasedSession((FirModuleData)mainModuleData, moduleInfoProvider.getFirSessionProvider(), extensionRegistrars, languageVersionSettings, null, (Function1<? super FirSessionConfigurator, Unit>)sessionConfigurator2);
        } else if (NativePlatformKt.isNative((TargetPlatform)module.getTargetPlatform())) {
            firSession = FirNativeSessionFactory.INSTANCE.createModuleBasedSession((FirModuleData)mainModuleData, moduleInfoProvider.getFirSessionProvider(), extensionRegistrars, languageVersionSettings, (Function1<? super FirSessionConfigurator, Unit>)sessionConfigurator2);
        } else {
            throw new IllegalStateException("Unsupported".toString());
        }
        FirSession session = firSession;
        moduleInfoProvider.registerModuleData(module, FirModuleDataKt.getModuleData((FirSession)session));
        boolean enablePluginPhases = module.getDirectives().contains(FirDiagnosticsDirectives.INSTANCE.getENABLE_PLUGIN_PHASES());
        FirAnalyzerFacade firAnalyzerFacade = new FirAnalyzerFacade(session, languageVersionSettings, ktFiles, lightTreeFiles, IrGenerationExtension.Companion.getInstances(project), lightTreeEnabled, enablePluginPhases, module.getTargetBackend() == TargetBackend.JVM_IR_SERIALIZE);
        List<FirFile> firFiles2 = firAnalyzerFacade.runResolution();
        Iterable $this$mapNotNull$iv = firFiles2;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair it$iv$iv;
            TestFile testFile;
            Object v8;
            FirFile firFile;
            block14: {
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                firFile = (FirFile)element$iv$iv;
                boolean bl2 = false;
                Iterable $this$firstOrNull$iv = module.getFiles();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    TestFile it = (TestFile)element$iv;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)firFile.getName())) continue;
                    v8 = element$iv;
                    break block14;
                }
                v8 = null;
            }
            if (((TestFile)v8 == null ? null : TuplesKt.to((Object)testFile, (Object)firFile)) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Map filesMap = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        return new FirOutputArtifactImpl(session, filesMap, firAnalyzerFacade);
    }

    public static final /* synthetic */ SessionConfiguration access$getAdditionalSessionConfiguration$p(FirFrontendFacade $this) {
        return $this.additionalSessionConfiguration;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0004\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/kotlin/test/frontend/fir/FirFrontendFacade$SessionConfiguration;", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/fir/session/FirSessionConfigurator;", "", "tests-common-new"})
    public static interface SessionConfiguration
    extends Function1<FirSessionConfigurator, Unit> {
    }
}

