/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.builders;

import com.intellij.openapi.Disposable;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.PrivateForInline;
import org.jetbrains.kotlin.test.FacadeStepBuilder;
import org.jetbrains.kotlin.test.HandlersStepBuilder;
import org.jetbrains.kotlin.test.TestConfiguration;
import org.jetbrains.kotlin.test.TestInfrastructureInternals;
import org.jetbrains.kotlin.test.TestStepBuilder;
import org.jetbrains.kotlin.test.builders.DefaultsProviderBuilder;
import org.jetbrains.kotlin.test.builders.RegisteredDirectivesBuilder;
import org.jetbrains.kotlin.test.directives.model.DirectivesContainer;
import org.jetbrains.kotlin.test.impl.TestConfigurationImpl;
import org.jetbrains.kotlin.test.model.AbstractTestFacade;
import org.jetbrains.kotlin.test.model.AfterAnalysisChecker;
import org.jetbrains.kotlin.test.model.ResultingArtifact;
import org.jetbrains.kotlin.test.model.TestArtifactKind;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.AbstractEnvironmentConfigurator;
import org.jetbrains.kotlin.test.services.AdditionalMetaInfoProcessor;
import org.jetbrains.kotlin.test.services.AdditionalSourceProvider;
import org.jetbrains.kotlin.test.services.AssertionsService;
import org.jetbrains.kotlin.test.services.CompilerConfigurationProvider;
import org.jetbrains.kotlin.test.services.DefaultsDsl;
import org.jetbrains.kotlin.test.services.KotlinTestInfo;
import org.jetbrains.kotlin.test.services.MetaTestConfigurator;
import org.jetbrains.kotlin.test.services.ModuleStructureTransformer;
import org.jetbrains.kotlin.test.services.PreAnalysisHandler;
import org.jetbrains.kotlin.test.services.RuntimeClasspathProvider;
import org.jetbrains.kotlin.test.services.ServiceRegistrationData;
import org.jetbrains.kotlin.test.services.SourceFilePreprocessor;
import org.jetbrains.kotlin.test.services.TestService;
import org.jetbrains.kotlin.test.services.TestServices;

@DefaultsDsl
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00fc\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u001e\b\u0007\u0018\u00002\u00020\u0001:\u0002\u008f\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010R\u001a\u00020S2\u0006\u0010T\u001a\u000206JQ\u0010U\u001a\u00020\u001e\"\u000e\b\u0000\u0010V*\b\u0012\u0004\u0012\u0002HV0C2\u0006\u0010W\u001a\u0002062\f\u0010X\u001a\b\u0012\u0004\u0012\u0002HV0Y2\u001d\u0010Z\u001a\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u0002HV0[\u0012\u0004\u0012\u00020\u001e0\u0005\u00a2\u0006\u0002\b\u001fH\u0086\b\u00f8\u0001\u0000J\u001f\u0010\\\u001a\u00020\u001e2\u0017\u0010Z\u001a\u0013\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\u001e0\u0005\u00a2\u0006\u0002\b\u001fJ\u0006\u0010]\u001a\u00020\u001eJh\u0010^\u001a\u000e\u0012\u0004\u0012\u0002HV\u0012\u0004\u0012\u0002H`0_\"\u000e\b\u0000\u0010V*\b\u0012\u0004\u0012\u0002HV0C\"\u000e\b\u0001\u0010`*\b\u0012\u0004\u0012\u0002H`0C24\u0010a\u001a0\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002HV\u0012\u0004\u0012\u0002H`0b0\u0005j\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002HV\u0012\u0004\u0012\u0002H`0b`\bJ'\u0010c\u001a\u00020\u001e2\u0006\u0010d\u001a\u0002062\u0017\u0010e\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u001e0\u0005\u00a2\u0006\u0002\b\u001fJ'\u0010c\u001a\u00020\u001e2\u0006\u0010d\u001a\u00020\u001d2\u0017\u0010e\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u001e0\u0005\u00a2\u0006\u0002\b\u001fJ'\u0010f\u001a\u00020\u001e2\u0006\u0010d\u001a\u0002062\u0017\u0010e\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u001e0\u0005\u00a2\u0006\u0002\b\u001fJ'\u0010f\u001a\u00020\u001e2\u0006\u0010d\u001a\u00020\u001d2\u0017\u0010e\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u001e0\u0005\u00a2\u0006\u0002\b\u001fJ\u001f\u0010g\u001a\u00020\u001e2\u0017\u0010Z\u001a\u0013\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020\u001e0\u0005\u00a2\u0006\u0002\b\u001fJO\u0010h\u001a\b\u0012\u0004\u0012\u0002HV0[\"\u000e\b\u0000\u0010V*\b\u0012\u0004\u0012\u0002HV0C2\f\u0010X\u001a\b\u0012\u0004\u0012\u0002HV0Y2\u001d\u0010Z\u001a\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u0002HV0[\u0012\u0004\u0012\u00020\u001e0\u0005\u00a2\u0006\u0002\b\u001fH\u0086\b\u00f8\u0001\u0000JW\u0010i\u001a\b\u0012\u0004\u0012\u0002HV0[\"\u000e\b\u0000\u0010V*\b\u0012\u0004\u0012\u0002HV0C2\u0006\u0010W\u001a\u0002062\f\u0010X\u001a\b\u0012\u0004\u0012\u0002HV0Y2\u001d\u0010Z\u001a\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u0002HV0[\u0012\u0004\u0012\u00020\u001e0\u0005\u00a2\u0006\u0002\b\u001fH\u0086\b\u00f8\u0001\u0000J&\u0010j\u001a\n\u0012\u0004\u0012\u0002HV\u0018\u00010[\"\u000e\b\u0000\u0010V*\b\u0012\u0004\u0012\u0002HV0C2\u0006\u0010W\u001a\u000206J\b\u0010k\u001a\u00020\u001eH\u0007J.\u0010l\u001a\u00020\u001e\"\n\b\u0000\u0010m\u0018\u0001*\u00020n2\u0014\b\b\u0010o\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u0002Hm0\u0005H\u0086\b\u00f8\u0001\u0000J\u001f\u0010p\u001a\u00020\u001e2\u0012\u0010q\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0r\"\u00020\n\u00a2\u0006\u0002\u0010sJK\u0010t\u001a\u00020\u001e2>\u0010u\u001a \u0012\u001c\b\u0001\u0012\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\f0\u0005j\b\u0012\u0004\u0012\u00020\f`\b0r\"\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\f0\u0005j\b\u0012\u0004\u0012\u00020\f`\b\u00a2\u0006\u0002\u0010vJK\u0010w\u001a\u00020\u001e2>\u0010x\u001a \u0012\u001c\b\u0001\u0012\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000e0\u0005j\b\u0012\u0004\u0012\u00020\u000e`\b0r\"\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000e0\u0005j\b\u0012\u0004\u0012\u00020\u000e`\b\u00a2\u0006\u0002\u0010vJK\u0010y\u001a\u00020\u001e2>\u0010,\u001a \u0012\u001c\b\u0001\u0012\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00190\u0005j\b\u0012\u0004\u0012\u00020\u0019`\b0r\"\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00190\u0005j\b\u0012\u0004\u0012\u00020\u0019`\b\u00a2\u0006\u0002\u0010vJ.\u0010z\u001a\u00020\u001e2$\u0010{\u001a \u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0017\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u0018\u0012\u0004\u0012\u00020\u001a0\u0016H\u0007JK\u0010|\u001a\u00020\u001e2>\u0010{\u001a \u0012\u001c\b\u0001\u0012\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020>0\u0005j\b\u0012\u0004\u0012\u00020>`\b0r\"\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020>0\u0005j\b\u0012\u0004\u0012\u00020>`\b\u00a2\u0006\u0002\u0010vJ\u001f\u0010}\u001a\u00020\u001e2\u0012\u0010*\u001a\n\u0012\u0006\b\u0001\u0012\u00020+0r\"\u00020+\u00a2\u0006\u0002\u0010~JL\u0010\u007f\u001a\u00020\u001e2?\u0010\u0080\u0001\u001a \u0012\u001c\b\u0001\u0012\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\b\u0012\u0004\u0012\u00020\u0007`\b0r\"\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\b\u0012\u0004\u0012\u00020\u0007`\b\u00a2\u0006\u0002\u0010vJM\u0010\u0081\u0001\u001a\u00020\u001e2?\u0010\u0082\u0001\u001a \u0012\u001c\b\u0001\u0012\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u0002010\u0005j\b\u0012\u0004\u0012\u000201`\b0r\"\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u0002010\u0005j\b\u0012\u0004\u0012\u000201`\b\u00a2\u0006\u0002\u0010vJ$\u0010\u0083\u0001\u001a\u00020\u001e2\u0013\u0010\u0084\u0001\u001a\n\u0012\u0006\b\u0001\u0012\u0002030r\"\u000203H\u0007\u00a2\u0006\u0003\u0010\u0085\u0001JM\u0010\u0086\u0001\u001a\u00020\u001e2?\u0010\u0087\u0001\u001a \u0012\u001c\b\u0001\u0012\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020<0\u0005j\b\u0012\u0004\u0012\u00020<`\b0r\"\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020<0\u0005j\b\u0012\u0004\u0012\u00020<`\b\u00a2\u0006\u0002\u0010vJY\u0010\u0088\u0001\u001a\u00020\u001e2?\u0010\u0089\u0001\u001a \u0012\u001c\b\u0001\u0012\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020@0\u0005j\b\u0012\u0004\u0012\u00020@`\b0r\"\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020@0\u0005j\b\u0012\u0004\u0012\u00020@`\b2\t\b\u0002\u0010\u008a\u0001\u001a\u00020/\u00a2\u0006\u0003\u0010\u008b\u0001J\u0017\u0010\u008c\u0001\u001a\u000206*\u0002062\u0007\u0010\u008d\u0001\u001a\u000206H\u0086\u0004J\r\u0010\u008e\u0001\u001a\u000206*\u000206H\u0002R*\u0010\u0003\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\b\u0012\u0004\u0012\u00020\u0007`\b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u000b\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\f0\u0005j\b\u0012\u0004\u0012\u00020\f`\b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\r\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000e0\u0005j\b\u0012\u0004\u0012\u00020\u000e`\b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\u0010X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R.\u0010\u0015\u001a\"\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0017\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u0018\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R1\u0010\u001b\u001a%\u0012!\u0012\u001f\u0012\u0004\u0012\u00020\u001d\u0012\u0015\u0012\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u001e0\u0005\u00a2\u0006\u0002\b\u001f0\u001c0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R1\u0010 \u001a%\u0012!\u0012\u001f\u0012\u0004\u0012\u00020\u001d\u0012\u0015\u0012\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u001e0\u0005\u00a2\u0006\u0002\b\u001f0\u001c0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R%\u0010!\u001a\u0019\u0012\u0015\u0012\u0013\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\u001e0\u0005\u00a2\u0006\u0002\b\u001f0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010#\u001a\u00020\"\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0011\u0010&\u001a\u00020'\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0014\u0010*\u001a\b\u0012\u0004\u0012\u00020+0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010,\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00190\u0005j\b\u0012\u0004\u0012\u00020\u0019`\b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R%\u0010-\u001a\u0019\u0012\u0015\u0012\u0013\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020\u001e0\u0005\u00a2\u0006\u0002\b\u001f0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020/X\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u00100\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u0002010\u0005j\b\u0012\u0004\u0012\u000201`\b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00102\u001a\b\u0012\u0004\u0012\u0002030\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R0\u00104\u001a\u0016\u0012\u0004\u0012\u000206\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u000307058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b8\u0010\u0002\u001a\u0004\b9\u0010:R*\u0010;\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020<0\u0005j\b\u0012\u0004\u0012\u00020<`\b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010=\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020>0\u0005j\b\u0012\u0004\u0012\u00020>`\b0\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010?\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020@0\u0005j\b\u0012\u0004\u0012\u00020@`\b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010A\u001a\u0012\u0012\u0004\u0012\u00020B\u0012\b\u0012\u0006\u0012\u0002\b\u00030C0\u0005X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bD\u0010E\"\u0004\bF\u0010GR*\u0010H\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u0003070\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\bI\u0010\u0002\u001a\u0004\bJ\u0010KR\u001a\u0010L\u001a\u00020MX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bN\u0010O\"\u0004\bP\u0010Q\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0090\u0001"}, d2={"Lorg/jetbrains/kotlin/test/builders/TestConfigurationBuilder;", "", "()V", "additionalMetaInfoProcessors", "", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/test/services/TestServices;", "Lorg/jetbrains/kotlin/test/services/AdditionalMetaInfoProcessor;", "Lorg/jetbrains/kotlin/test/Constructor;", "additionalServices", "Lorg/jetbrains/kotlin/test/services/ServiceRegistrationData;", "additionalSourceProviders", "Lorg/jetbrains/kotlin/test/services/AdditionalSourceProvider;", "afterAnalysisCheckers", "Lorg/jetbrains/kotlin/test/model/AfterAnalysisChecker;", "assertions", "Lorg/jetbrains/kotlin/test/services/AssertionsService;", "getAssertions", "()Lorg/jetbrains/kotlin/test/services/AssertionsService;", "setAssertions", "(Lorg/jetbrains/kotlin/test/services/AssertionsService;)V", "compilerConfigurationProvider", "Lkotlin/Function3;", "Lcom/intellij/openapi/Disposable;", "", "Lorg/jetbrains/kotlin/test/services/AbstractEnvironmentConfigurator;", "Lorg/jetbrains/kotlin/test/services/CompilerConfigurationProvider;", "configurationsByNegativeTestDataCondition", "Lkotlin/Pair;", "Lkotlin/text/Regex;", "", "Lkotlin/ExtensionFunctionType;", "configurationsByPositiveTestDataCondition", "defaultDirectiveConfigurators", "Lorg/jetbrains/kotlin/test/builders/RegisteredDirectivesBuilder;", "defaultRegisteredDirectivesBuilder", "getDefaultRegisteredDirectivesBuilder", "()Lorg/jetbrains/kotlin/test/builders/RegisteredDirectivesBuilder;", "defaultsProviderBuilder", "Lorg/jetbrains/kotlin/test/builders/DefaultsProviderBuilder;", "getDefaultsProviderBuilder", "()Lorg/jetbrains/kotlin/test/builders/DefaultsProviderBuilder;", "directives", "Lorg/jetbrains/kotlin/test/directives/model/DirectivesContainer;", "environmentConfigurators", "globalDefaultsConfigurators", "metaInfoHandlerEnabled", "", "metaTestConfigurators", "Lorg/jetbrains/kotlin/test/services/MetaTestConfigurator;", "moduleStructureTransformers", "Lorg/jetbrains/kotlin/test/services/ModuleStructureTransformer;", "namedSteps", "", "", "Lorg/jetbrains/kotlin/test/TestStepBuilder;", "getNamedSteps$annotations", "getNamedSteps", "()Ljava/util/Map;", "preAnalysisHandlers", "Lorg/jetbrains/kotlin/test/services/PreAnalysisHandler;", "runtimeClasspathProviders", "Lorg/jetbrains/kotlin/test/services/RuntimeClasspathProvider;", "sourcePreprocessors", "Lorg/jetbrains/kotlin/test/services/SourceFilePreprocessor;", "startingArtifactFactory", "Lorg/jetbrains/kotlin/test/model/TestModule;", "Lorg/jetbrains/kotlin/test/model/ResultingArtifact;", "getStartingArtifactFactory", "()Lkotlin/jvm/functions/Function1;", "setStartingArtifactFactory", "(Lkotlin/jvm/functions/Function1;)V", "steps", "getSteps$annotations", "getSteps", "()Ljava/util/List;", "testInfo", "Lorg/jetbrains/kotlin/test/services/KotlinTestInfo;", "getTestInfo", "()Lorg/jetbrains/kotlin/test/services/KotlinTestInfo;", "setTestInfo", "(Lorg/jetbrains/kotlin/test/services/KotlinTestInfo;)V", "build", "Lorg/jetbrains/kotlin/test/TestConfiguration;", "testDataPath", "configureNamedHandlersStep", "I", "name", "artifactKind", "Lorg/jetbrains/kotlin/test/model/TestArtifactKind;", "init", "Lorg/jetbrains/kotlin/test/HandlersStepBuilder;", "defaultDirectives", "enableMetaInfoHandler", "facadeStep", "Lorg/jetbrains/kotlin/test/FacadeStepBuilder;", "O", "facade", "Lorg/jetbrains/kotlin/test/model/AbstractTestFacade;", "forTestsMatching", "pattern", "configuration", "forTestsNotMatching", "globalDefaults", "handlersStep", "namedHandlersStep", "namedStepOfType", "resetModuleStructureTransformers", "useAdditionalService", "T", "Lorg/jetbrains/kotlin/test/services/TestService;", "serviceConstructor", "useAdditionalServices", "serviceRegistrationData", "", "([Lorg/jetbrains/kotlin/test/services/ServiceRegistrationData;)V", "useAdditionalSourceProviders", "providers", "([Lkotlin/jvm/functions/Function1;)V", "useAfterAnalysisCheckers", "checkers", "useConfigurators", "useCustomCompilerConfigurationProvider", "provider", "useCustomRuntimeClasspathProviders", "useDirectives", "([Lorg/jetbrains/kotlin/test/directives/model/DirectivesContainer;)V", "useMetaInfoProcessors", "updaters", "useMetaTestConfigurators", "configurators", "useModuleStructureTransformers", "transformers", "([Lorg/jetbrains/kotlin/test/services/ModuleStructureTransformer;)V", "usePreAnalysisHandlers", "handlers", "useSourcePreprocessor", "preprocessors", "needToPrepend", "([Lkotlin/jvm/functions/Function1;Z)V", "or", "other", "toMatchingRegexString", "ReadOnlyBuilder", "tests-common-new"})
public final class TestConfigurationBuilder {
    @NotNull
    private final DefaultsProviderBuilder defaultsProviderBuilder = new DefaultsProviderBuilder();
    public AssertionsService assertions;
    @NotNull
    private final List<TestStepBuilder<?, ?>> steps = new ArrayList();
    @NotNull
    private final Map<String, TestStepBuilder<?, ?>> namedSteps = new LinkedHashMap();
    @NotNull
    private final List<Function1<TestServices, SourceFilePreprocessor>> sourcePreprocessors = new ArrayList();
    @NotNull
    private final List<Function1<TestServices, AdditionalMetaInfoProcessor>> additionalMetaInfoProcessors = new ArrayList();
    @NotNull
    private final List<Function1<TestServices, AbstractEnvironmentConfigurator>> environmentConfigurators = new ArrayList();
    @NotNull
    private final List<Function1<TestServices, PreAnalysisHandler>> preAnalysisHandlers = new ArrayList();
    @NotNull
    private final List<Function1<TestServices, AdditionalSourceProvider>> additionalSourceProviders = new ArrayList();
    @NotNull
    private final List<ModuleStructureTransformer> moduleStructureTransformers = new ArrayList();
    @NotNull
    private final List<Function1<TestServices, MetaTestConfigurator>> metaTestConfigurators = new ArrayList();
    @NotNull
    private final List<Function1<TestServices, AfterAnalysisChecker>> afterAnalysisCheckers = new ArrayList();
    private boolean metaInfoHandlerEnabled;
    @NotNull
    private final List<DirectivesContainer> directives = new ArrayList();
    @NotNull
    private final RegisteredDirectivesBuilder defaultRegisteredDirectivesBuilder = new RegisteredDirectivesBuilder();
    @NotNull
    private final List<Pair<Regex, Function1<TestConfigurationBuilder, Unit>>> configurationsByPositiveTestDataCondition = new ArrayList();
    @NotNull
    private final List<Pair<Regex, Function1<TestConfigurationBuilder, Unit>>> configurationsByNegativeTestDataCondition = new ArrayList();
    @NotNull
    private final List<ServiceRegistrationData> additionalServices = new ArrayList();
    @Nullable
    private Function3<? super TestServices, ? super Disposable, ? super List<? extends AbstractEnvironmentConfigurator>, ? extends CompilerConfigurationProvider> compilerConfigurationProvider;
    @NotNull
    private List<Function1<TestServices, RuntimeClasspathProvider>> runtimeClasspathProviders = new ArrayList();
    public KotlinTestInfo testInfo;
    public Function1<? super TestModule, ? extends ResultingArtifact<?>> startingArtifactFactory;
    @NotNull
    private final List<Function1<DefaultsProviderBuilder, Unit>> globalDefaultsConfigurators = new ArrayList();
    @NotNull
    private final List<Function1<RegisteredDirectivesBuilder, Unit>> defaultDirectiveConfigurators = new ArrayList();

    @NotNull
    public final DefaultsProviderBuilder getDefaultsProviderBuilder() {
        return this.defaultsProviderBuilder;
    }

    @NotNull
    public final AssertionsService getAssertions() {
        AssertionsService assertionsService = this.assertions;
        if (assertionsService != null) {
            return assertionsService;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"assertions");
        return null;
    }

    public final void setAssertions(@NotNull AssertionsService assertionsService) {
        Intrinsics.checkNotNullParameter((Object)assertionsService, (String)"<set-?>");
        this.assertions = assertionsService;
    }

    @NotNull
    public final List<TestStepBuilder<?, ?>> getSteps() {
        return this.steps;
    }

    @PrivateForInline
    public static /* synthetic */ void getSteps$annotations() {
    }

    @NotNull
    public final Map<String, TestStepBuilder<?, ?>> getNamedSteps() {
        return this.namedSteps;
    }

    @PrivateForInline
    public static /* synthetic */ void getNamedSteps$annotations() {
    }

    @NotNull
    public final RegisteredDirectivesBuilder getDefaultRegisteredDirectivesBuilder() {
        return this.defaultRegisteredDirectivesBuilder;
    }

    @NotNull
    public final KotlinTestInfo getTestInfo() {
        KotlinTestInfo kotlinTestInfo = this.testInfo;
        if (kotlinTestInfo != null) {
            return kotlinTestInfo;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"testInfo");
        return null;
    }

    public final void setTestInfo(@NotNull KotlinTestInfo kotlinTestInfo) {
        Intrinsics.checkNotNullParameter((Object)kotlinTestInfo, (String)"<set-?>");
        this.testInfo = kotlinTestInfo;
    }

    @NotNull
    public final Function1<TestModule, ResultingArtifact<?>> getStartingArtifactFactory() {
        Function1<? super TestModule, ? extends ResultingArtifact<?>> function1 = this.startingArtifactFactory;
        if (function1 != null) {
            return function1;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"startingArtifactFactory");
        return null;
    }

    public final void setStartingArtifactFactory(@NotNull Function1<? super TestModule, ? extends ResultingArtifact<?>> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
        this.startingArtifactFactory = function1;
    }

    public final /* synthetic */ <T extends TestService> void useAdditionalService(Function1<? super TestServices, ? extends T> serviceConstructor) {
        Intrinsics.checkNotNullParameter(serviceConstructor, (String)"serviceConstructor");
        boolean $i$f$useAdditionalService = false;
        ServiceRegistrationData[] serviceRegistrationDataArray = new ServiceRegistrationData[1];
        boolean $i$f$service = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        serviceRegistrationDataArray[0] = new ServiceRegistrationData((KClass<? extends TestService>)Reflection.getOrCreateKotlinClass(TestService.class), serviceConstructor);
        this.useAdditionalServices(serviceRegistrationDataArray);
    }

    public final void useAdditionalServices(ServiceRegistrationData ... serviceRegistrationData) {
        Intrinsics.checkNotNullParameter((Object)serviceRegistrationData, (String)"serviceRegistrationData");
        CollectionsKt.addAll((Collection)this.additionalServices, (Object[])serviceRegistrationData);
    }

    public final void forTestsMatching(@NotNull String pattern, @NotNull Function1<? super TestConfigurationBuilder, Unit> configuration2) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter(configuration2, (String)"configuration");
        Regex regex = new Regex(this.toMatchingRegexString(pattern));
        this.forTestsMatching(regex, configuration2);
    }

    public final void forTestsNotMatching(@NotNull String pattern, @NotNull Function1<? super TestConfigurationBuilder, Unit> configuration2) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter(configuration2, (String)"configuration");
        Regex regex = new Regex(this.toMatchingRegexString(pattern));
        this.forTestsNotMatching(regex, configuration2);
    }

    @NotNull
    public final String or(@NotNull String $this$or, @NotNull String other) {
        Intrinsics.checkNotNullParameter((Object)$this$or, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return $this$or + '|' + other;
    }

    private final String toMatchingRegexString(String $this$toMatchingRegexString) {
        return Intrinsics.areEqual((Object)$this$toMatchingRegexString, (Object)"*") ? ".*" : "^.*/(" + StringsKt.replace$default((String)$this$toMatchingRegexString, (String)"*", (String)".*", (boolean)false, (int)4, null) + ")$";
    }

    public final void forTestsMatching(@NotNull Regex pattern, @NotNull Function1<? super TestConfigurationBuilder, Unit> configuration2) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter(configuration2, (String)"configuration");
        ((Collection)this.configurationsByPositiveTestDataCondition).add(TuplesKt.to((Object)pattern, configuration2));
    }

    public final void forTestsNotMatching(@NotNull Regex pattern, @NotNull Function1<? super TestConfigurationBuilder, Unit> configuration2) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter(configuration2, (String)"configuration");
        ((Collection)this.configurationsByNegativeTestDataCondition).add(TuplesKt.to((Object)pattern, configuration2));
    }

    public final void globalDefaults(@NotNull Function1<? super DefaultsProviderBuilder, Unit> init) {
        Intrinsics.checkNotNullParameter(init, (String)"init");
        ((Collection)this.globalDefaultsConfigurators).add(init);
        DefaultsProviderBuilder defaultsProviderBuilder = this.defaultsProviderBuilder;
        init.invoke((Object)defaultsProviderBuilder);
    }

    @NotNull
    public final <I extends ResultingArtifact<I>, O extends ResultingArtifact<O>> FacadeStepBuilder<I, O> facadeStep(@NotNull Function1<? super TestServices, ? extends AbstractTestFacade<I, O>> facade) {
        FacadeStepBuilder facadeStepBuilder;
        Intrinsics.checkNotNullParameter(facade, (String)"facade");
        FacadeStepBuilder it = facadeStepBuilder = new FacadeStepBuilder(facade);
        boolean bl = false;
        ((Collection)this.steps).add(it);
        return facadeStepBuilder;
    }

    @NotNull
    public final <I extends ResultingArtifact<I>> HandlersStepBuilder<I> handlersStep(@NotNull TestArtifactKind<I> artifactKind, @NotNull Function1<? super HandlersStepBuilder<I>, Unit> init) {
        HandlersStepBuilder<I> handlersStepBuilder;
        Intrinsics.checkNotNullParameter(artifactKind, (String)"artifactKind");
        Intrinsics.checkNotNullParameter(init, (String)"init");
        boolean $i$f$handlersStep = false;
        HandlersStepBuilder<I> it = handlersStepBuilder = new HandlersStepBuilder<I>(artifactKind);
        boolean bl = false;
        init.invoke(it);
        ((Collection)this.getSteps()).add(it);
        return handlersStepBuilder;
    }

    @NotNull
    public final <I extends ResultingArtifact<I>> HandlersStepBuilder<I> namedHandlersStep(@NotNull String name2, @NotNull TestArtifactKind<I> artifactKind, @NotNull Function1<? super HandlersStepBuilder<I>, Unit> init) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter(artifactKind, (String)"artifactKind");
        Intrinsics.checkNotNullParameter(init, (String)"init");
        boolean $i$f$namedHandlersStep = false;
        HandlersStepBuilder<I> previouslyContainedStep = this.namedStepOfType(name2);
        if (previouslyContainedStep == null) {
            HandlersStepBuilder<I> handlersStepBuilder;
            TestConfigurationBuilder this_$iv = this;
            boolean $i$f$handlersStep = false;
            HandlersStepBuilder<I> it$iv = handlersStepBuilder = new HandlersStepBuilder<I>(artifactKind);
            boolean bl = false;
            init.invoke(it$iv);
            ((Collection)this_$iv.getSteps()).add(it$iv);
            HandlersStepBuilder<I> step2 = handlersStepBuilder;
            this.getNamedSteps().put(name2, step2);
            return step2;
        }
        TestConfigurationBuilder this_$iv = this;
        boolean $i$f$configureNamedHandlersStep = false;
        HandlersStepBuilder<I> handlersStepBuilder = this_$iv.namedStepOfType(name2);
        if (handlersStepBuilder == null) {
            throw new IllegalStateException(new Function0<String>(name2){
                final /* synthetic */ String $name;
                {
                    this.$name = $name;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Step \"" + this.$name + "\" not found";
                }
            }.toString());
        }
        HandlersStepBuilder<I> step$iv = handlersStepBuilder;
        if (!Intrinsics.areEqual(step$iv.getArtifactKind(), artifactKind)) {
            boolean bl = false;
            String string = "Step kind: " + step$iv.getArtifactKind() + ", passed kind is " + artifactKind;
            throw new IllegalArgumentException(string.toString());
        }
        HandlersStepBuilder<I> handlersStepBuilder2 = step$iv;
        init.invoke(handlersStepBuilder2);
        return previouslyContainedStep;
    }

    public final <I extends ResultingArtifact<I>> void configureNamedHandlersStep(@NotNull String name2, @NotNull TestArtifactKind<I> artifactKind, @NotNull Function1<? super HandlersStepBuilder<I>, Unit> init) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter(artifactKind, (String)"artifactKind");
        Intrinsics.checkNotNullParameter(init, (String)"init");
        boolean $i$f$configureNamedHandlersStep = false;
        HandlersStepBuilder<I> handlersStepBuilder = this.namedStepOfType(name2);
        if (handlersStepBuilder == null) {
            throw new IllegalStateException(new /* invalid duplicate definition of identical inner class */.toString());
        }
        HandlersStepBuilder<I> step2 = handlersStepBuilder;
        if (!Intrinsics.areEqual(step2.getArtifactKind(), artifactKind)) {
            boolean bl = false;
            String string = "Step kind: " + step2.getArtifactKind() + ", passed kind is " + artifactKind;
            throw new IllegalArgumentException(string.toString());
        }
        HandlersStepBuilder<I> handlersStepBuilder2 = step2;
        init.invoke(handlersStepBuilder2);
    }

    @Nullable
    public final <I extends ResultingArtifact<I>> HandlersStepBuilder<I> namedStepOfType(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return (HandlersStepBuilder)this.namedSteps.get(name2);
    }

    public final void useSourcePreprocessor(@NotNull Function1<? super TestServices, ? extends SourceFilePreprocessor>[] preprocessors, boolean needToPrepend) {
        Intrinsics.checkNotNullParameter(preprocessors, (String)"preprocessors");
        if (needToPrepend) {
            this.sourcePreprocessors.addAll(0, ArraysKt.toList((Object[])preprocessors));
        } else {
            CollectionsKt.addAll((Collection)this.sourcePreprocessors, (Object[])preprocessors);
        }
    }

    public static /* synthetic */ void useSourcePreprocessor$default(TestConfigurationBuilder testConfigurationBuilder, Function1[] function1Array, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        testConfigurationBuilder.useSourcePreprocessor(function1Array, bl);
    }

    public final void useDirectives(DirectivesContainer ... directives2) {
        Intrinsics.checkNotNullParameter((Object)directives2, (String)"directives");
        CollectionsKt.addAll((Collection)this.directives, (Object[])directives2);
    }

    public final void useConfigurators(Function1<? super TestServices, ? extends AbstractEnvironmentConfigurator> ... environmentConfigurators) {
        Intrinsics.checkNotNullParameter(environmentConfigurators, (String)"environmentConfigurators");
        CollectionsKt.addAll((Collection)this.environmentConfigurators, (Object[])environmentConfigurators);
    }

    public final void usePreAnalysisHandlers(Function1<? super TestServices, ? extends PreAnalysisHandler> ... handlers) {
        Intrinsics.checkNotNullParameter(handlers, (String)"handlers");
        CollectionsKt.addAll((Collection)this.preAnalysisHandlers, (Object[])handlers);
    }

    public final void useMetaInfoProcessors(Function1<? super TestServices, ? extends AdditionalMetaInfoProcessor> ... updaters) {
        Intrinsics.checkNotNullParameter(updaters, (String)"updaters");
        CollectionsKt.addAll((Collection)this.additionalMetaInfoProcessors, (Object[])updaters);
    }

    public final void useAdditionalSourceProviders(Function1<? super TestServices, ? extends AdditionalSourceProvider> ... providers) {
        Intrinsics.checkNotNullParameter(providers, (String)"providers");
        CollectionsKt.addAll((Collection)this.additionalSourceProviders, (Object[])providers);
    }

    @TestInfrastructureInternals
    public final void resetModuleStructureTransformers() {
        this.moduleStructureTransformers.clear();
    }

    @TestInfrastructureInternals
    public final void useModuleStructureTransformers(ModuleStructureTransformer ... transformers) {
        Intrinsics.checkNotNullParameter((Object)transformers, (String)"transformers");
        CollectionsKt.addAll((Collection)this.moduleStructureTransformers, (Object[])transformers);
    }

    @TestInfrastructureInternals
    public final void useCustomCompilerConfigurationProvider(@NotNull Function3<? super TestServices, ? super Disposable, ? super List<? extends AbstractEnvironmentConfigurator>, ? extends CompilerConfigurationProvider> provider) {
        Intrinsics.checkNotNullParameter(provider, (String)"provider");
        this.compilerConfigurationProvider = provider;
    }

    public final void useCustomRuntimeClasspathProviders(Function1<? super TestServices, ? extends RuntimeClasspathProvider> ... provider) {
        Intrinsics.checkNotNullParameter(provider, (String)"provider");
        CollectionsKt.addAll((Collection)this.runtimeClasspathProviders, (Object[])provider);
    }

    public final void useMetaTestConfigurators(Function1<? super TestServices, ? extends MetaTestConfigurator> ... configurators) {
        Intrinsics.checkNotNullParameter(configurators, (String)"configurators");
        CollectionsKt.addAll((Collection)this.metaTestConfigurators, (Object[])configurators);
    }

    public final void useAfterAnalysisCheckers(Function1<? super TestServices, ? extends AfterAnalysisChecker> ... checkers) {
        Intrinsics.checkNotNullParameter(checkers, (String)"checkers");
        CollectionsKt.addAll((Collection)this.afterAnalysisCheckers, (Object[])checkers);
    }

    public final void defaultDirectives(@NotNull Function1<? super RegisteredDirectivesBuilder, Unit> init) {
        Intrinsics.checkNotNullParameter(init, (String)"init");
        ((Collection)this.defaultDirectiveConfigurators).add(init);
        RegisteredDirectivesBuilder registeredDirectivesBuilder = this.defaultRegisteredDirectivesBuilder;
        init.invoke((Object)registeredDirectivesBuilder);
    }

    public final void enableMetaInfoHandler() {
        this.metaInfoHandlerEnabled = true;
    }

    @NotNull
    public final TestConfiguration build(@NotNull String testDataPath) {
        Function1 configuration2;
        Regex regex;
        Intrinsics.checkNotNullParameter((Object)testDataPath, (String)"testDataPath");
        Path path = Paths.get(testDataPath, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(path)");
        String string = path.normalize().toUri().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Path(testDataPath).normalize().toUri().toString()");
        String absoluteTestDataPath = string;
        for (Pair<Regex, Function1<TestConfigurationBuilder, Unit>> pair : this.configurationsByPositiveTestDataCondition) {
            regex = (Regex)pair.component1();
            configuration2 = (Function1)pair.component2();
            if (!regex.matches((CharSequence)absoluteTestDataPath)) continue;
            configuration2.invoke((Object)this);
        }
        for (Pair<Regex, Function1<TestConfigurationBuilder, Unit>> pair : this.configurationsByNegativeTestDataCondition) {
            regex = (Regex)pair.component1();
            configuration2 = (Function1)pair.component2();
            if (regex.matches((CharSequence)absoluteTestDataPath)) continue;
            configuration2.invoke((Object)this);
        }
        return new TestConfigurationImpl(this.getTestInfo(), this.defaultsProviderBuilder.build(), this.getAssertions(), this.steps, this.sourcePreprocessors, this.additionalMetaInfoProcessors, this.environmentConfigurators, this.additionalSourceProviders, this.preAnalysisHandlers, this.moduleStructureTransformers, this.metaTestConfigurators, this.afterAnalysisCheckers, this.compilerConfigurationProvider, this.runtimeClasspathProviders, this.metaInfoHandlerEnabled, this.directives, this.defaultRegisteredDirectivesBuilder.build(), this.getStartingArtifactFactory(), this.additionalServices, new ReadOnlyBuilder(this, testDataPath));
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00d4\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R-\u0010\u0007\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tj\b\u0012\u0004\u0012\u00020\u000b`\f0\b8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000eR-\u0010\u0012\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00130\tj\b\u0012\u0004\u0012\u00020\u0013`\f0\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u000eR-\u0010\u0015\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00160\tj\b\u0012\u0004\u0012\u00020\u0016`\f0\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u000eR\u0011\u0010\u0018\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R1\u0010\u001c\u001a\"\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001f0\b\u0012\u0004\u0012\u00020 \u0018\u00010\u001d8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R4\u0010#\u001a%\u0012!\u0012\u001f\u0012\u0004\u0012\u00020%\u0012\u0015\u0012\u0013\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020&0\t\u00a2\u0006\u0002\b'0$0\b8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u000eR4\u0010)\u001a%\u0012!\u0012\u001f\u0012\u0004\u0012\u00020%\u0012\u0015\u0012\u0013\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020&0\t\u00a2\u0006\u0002\b'0$0\b8F\u00a2\u0006\u0006\u001a\u0004\b*\u0010\u000eR(\u0010+\u001a\u0019\u0012\u0015\u0012\u0013\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020&0\t\u00a2\u0006\u0002\b'0\b8F\u00a2\u0006\u0006\u001a\u0004\b-\u0010\u000eR\u0011\u0010.\u001a\u00020/8F\u00a2\u0006\u0006\u001a\u0004\b0\u00101R\u0017\u00102\u001a\b\u0012\u0004\u0012\u0002030\b8F\u00a2\u0006\u0006\u001a\u0004\b4\u0010\u000eR-\u00105\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u001f0\tj\b\u0012\u0004\u0012\u00020\u001f`\f0\b8F\u00a2\u0006\u0006\u001a\u0004\b6\u0010\u000eR(\u00107\u001a\u0019\u0012\u0015\u0012\u0013\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u00020&0\t\u00a2\u0006\u0002\b'0\b8F\u00a2\u0006\u0006\u001a\u0004\b8\u0010\u000eR\u0011\u00109\u001a\u00020:8F\u00a2\u0006\u0006\u001a\u0004\b;\u0010<R-\u0010=\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020>0\tj\b\u0012\u0004\u0012\u00020>`\f0\b8F\u00a2\u0006\u0006\u001a\u0004\b?\u0010\u000eR\u0017\u0010@\u001a\b\u0012\u0004\u0012\u00020A0\b8F\u00a2\u0006\u0006\u001a\u0004\bB\u0010\u000eR-\u0010C\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020D0\tj\b\u0012\u0004\u0012\u00020D`\f0\b8F\u00a2\u0006\u0006\u001a\u0004\bE\u0010\u000eR-\u0010F\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020G0\tj\b\u0012\u0004\u0012\u00020G`\f0\b8F\u00a2\u0006\u0006\u001a\u0004\bH\u0010\u000eR-\u0010I\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020J0\tj\b\u0012\u0004\u0012\u00020J`\f0\b8F\u00a2\u0006\u0006\u001a\u0004\bK\u0010\u000eR!\u0010L\u001a\u0012\u0012\u0004\u0012\u00020M\u0012\b\u0012\u0006\u0012\u0002\b\u00030N0\t8F\u00a2\u0006\u0006\u001a\u0004\bO\u0010PR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bQ\u0010RR\u0011\u0010S\u001a\u00020T8F\u00a2\u0006\u0006\u001a\u0004\bU\u0010V\u00a8\u0006W"}, d2={"Lorg/jetbrains/kotlin/test/builders/TestConfigurationBuilder$ReadOnlyBuilder;", "", "builder", "Lorg/jetbrains/kotlin/test/builders/TestConfigurationBuilder;", "testDataPath", "", "(Lorg/jetbrains/kotlin/test/builders/TestConfigurationBuilder;Ljava/lang/String;)V", "additionalMetaInfoProcessors", "", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/test/services/TestServices;", "Lorg/jetbrains/kotlin/test/services/AdditionalMetaInfoProcessor;", "Lorg/jetbrains/kotlin/test/Constructor;", "getAdditionalMetaInfoProcessors", "()Ljava/util/List;", "additionalServices", "Lorg/jetbrains/kotlin/test/services/ServiceRegistrationData;", "getAdditionalServices", "additionalSourceProviders", "Lorg/jetbrains/kotlin/test/services/AdditionalSourceProvider;", "getAdditionalSourceProviders", "afterAnalysisCheckers", "Lorg/jetbrains/kotlin/test/model/AfterAnalysisChecker;", "getAfterAnalysisCheckers", "assertions", "Lorg/jetbrains/kotlin/test/services/AssertionsService;", "getAssertions", "()Lorg/jetbrains/kotlin/test/services/AssertionsService;", "compilerConfigurationProvider", "Lkotlin/Function3;", "Lcom/intellij/openapi/Disposable;", "Lorg/jetbrains/kotlin/test/services/AbstractEnvironmentConfigurator;", "Lorg/jetbrains/kotlin/test/services/CompilerConfigurationProvider;", "getCompilerConfigurationProvider", "()Lkotlin/jvm/functions/Function3;", "configurationsByNegativeTestDataCondition", "Lkotlin/Pair;", "Lkotlin/text/Regex;", "", "Lkotlin/ExtensionFunctionType;", "getConfigurationsByNegativeTestDataCondition", "configurationsByPositiveTestDataCondition", "getConfigurationsByPositiveTestDataCondition", "defaultDirectiveConfigurators", "Lorg/jetbrains/kotlin/test/builders/RegisteredDirectivesBuilder;", "getDefaultDirectiveConfigurators", "defaultsProviderBuilder", "Lorg/jetbrains/kotlin/test/builders/DefaultsProviderBuilder;", "getDefaultsProviderBuilder", "()Lorg/jetbrains/kotlin/test/builders/DefaultsProviderBuilder;", "directives", "Lorg/jetbrains/kotlin/test/directives/model/DirectivesContainer;", "getDirectives", "environmentConfigurators", "getEnvironmentConfigurators", "globalDefaultsConfigurators", "getGlobalDefaultsConfigurators", "metaInfoHandlerEnabled", "", "getMetaInfoHandlerEnabled", "()Z", "metaTestConfigurators", "Lorg/jetbrains/kotlin/test/services/MetaTestConfigurator;", "getMetaTestConfigurators", "moduleStructureTransformers", "Lorg/jetbrains/kotlin/test/services/ModuleStructureTransformer;", "getModuleStructureTransformers", "preAnalysisHandlers", "Lorg/jetbrains/kotlin/test/services/PreAnalysisHandler;", "getPreAnalysisHandlers", "runtimeClasspathProviders", "Lorg/jetbrains/kotlin/test/services/RuntimeClasspathProvider;", "getRuntimeClasspathProviders", "sourcePreprocessors", "Lorg/jetbrains/kotlin/test/services/SourceFilePreprocessor;", "getSourcePreprocessors", "startingArtifactFactory", "Lorg/jetbrains/kotlin/test/model/TestModule;", "Lorg/jetbrains/kotlin/test/model/ResultingArtifact;", "getStartingArtifactFactory", "()Lkotlin/jvm/functions/Function1;", "getTestDataPath", "()Ljava/lang/String;", "testInfo", "Lorg/jetbrains/kotlin/test/services/KotlinTestInfo;", "getTestInfo", "()Lorg/jetbrains/kotlin/test/services/KotlinTestInfo;", "tests-common-new"})
    public static final class ReadOnlyBuilder {
        @NotNull
        private final TestConfigurationBuilder builder;
        @NotNull
        private final String testDataPath;

        public ReadOnlyBuilder(@NotNull TestConfigurationBuilder builder, @NotNull String testDataPath) {
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            Intrinsics.checkNotNullParameter((Object)testDataPath, (String)"testDataPath");
            this.builder = builder;
            this.testDataPath = testDataPath;
        }

        @NotNull
        public final String getTestDataPath() {
            return this.testDataPath;
        }

        @NotNull
        public final DefaultsProviderBuilder getDefaultsProviderBuilder() {
            return this.builder.getDefaultsProviderBuilder();
        }

        @NotNull
        public final AssertionsService getAssertions() {
            return this.builder.getAssertions();
        }

        @NotNull
        public final List<Function1<TestServices, SourceFilePreprocessor>> getSourcePreprocessors() {
            return this.builder.sourcePreprocessors;
        }

        @NotNull
        public final List<Function1<TestServices, AdditionalMetaInfoProcessor>> getAdditionalMetaInfoProcessors() {
            return this.builder.additionalMetaInfoProcessors;
        }

        @NotNull
        public final List<Function1<TestServices, AbstractEnvironmentConfigurator>> getEnvironmentConfigurators() {
            return this.builder.environmentConfigurators;
        }

        @NotNull
        public final List<Function1<TestServices, PreAnalysisHandler>> getPreAnalysisHandlers() {
            return this.builder.preAnalysisHandlers;
        }

        @NotNull
        public final List<Function1<TestServices, AdditionalSourceProvider>> getAdditionalSourceProviders() {
            return this.builder.additionalSourceProviders;
        }

        @NotNull
        public final List<ModuleStructureTransformer> getModuleStructureTransformers() {
            return this.builder.moduleStructureTransformers;
        }

        @NotNull
        public final List<Function1<TestServices, MetaTestConfigurator>> getMetaTestConfigurators() {
            return this.builder.metaTestConfigurators;
        }

        @NotNull
        public final List<Function1<TestServices, AfterAnalysisChecker>> getAfterAnalysisCheckers() {
            return this.builder.afterAnalysisCheckers;
        }

        public final boolean getMetaInfoHandlerEnabled() {
            return this.builder.metaInfoHandlerEnabled;
        }

        @NotNull
        public final List<DirectivesContainer> getDirectives() {
            return this.builder.directives;
        }

        @NotNull
        public final List<Function1<RegisteredDirectivesBuilder, Unit>> getDefaultDirectiveConfigurators() {
            return this.builder.defaultDirectiveConfigurators;
        }

        @NotNull
        public final List<Function1<DefaultsProviderBuilder, Unit>> getGlobalDefaultsConfigurators() {
            return this.builder.globalDefaultsConfigurators;
        }

        @NotNull
        public final List<Pair<Regex, Function1<TestConfigurationBuilder, Unit>>> getConfigurationsByPositiveTestDataCondition() {
            return this.builder.configurationsByPositiveTestDataCondition;
        }

        @NotNull
        public final List<Pair<Regex, Function1<TestConfigurationBuilder, Unit>>> getConfigurationsByNegativeTestDataCondition() {
            return this.builder.configurationsByNegativeTestDataCondition;
        }

        @NotNull
        public final List<ServiceRegistrationData> getAdditionalServices() {
            return this.builder.additionalServices;
        }

        @Nullable
        public final Function3<TestServices, Disposable, List<? extends AbstractEnvironmentConfigurator>, CompilerConfigurationProvider> getCompilerConfigurationProvider() {
            return this.builder.compilerConfigurationProvider;
        }

        @NotNull
        public final List<Function1<TestServices, RuntimeClasspathProvider>> getRuntimeClasspathProviders() {
            return this.builder.runtimeClasspathProviders;
        }

        @NotNull
        public final KotlinTestInfo getTestInfo() {
            return this.builder.getTestInfo();
        }

        @NotNull
        public final Function1<TestModule, ResultingArtifact<?>> getStartingArtifactFactory() {
            return this.builder.getStartingArtifactFactory();
        }
    }
}

