/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.backend.handlers;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.ClassFileFactory;
import org.jetbrains.kotlin.codegen.ClassFileUtilsKt;
import org.jetbrains.kotlin.codegen.CommonSMAPTestUtil;
import org.jetbrains.kotlin.test.Assertions;
import org.jetbrains.kotlin.test.backend.handlers.JvmBinaryArtifactHandler;
import org.jetbrains.kotlin.test.directives.CodegenTestDirectives;
import org.jetbrains.kotlin.test.directives.model.DirectivesContainer;
import org.jetbrains.kotlin.test.model.BinaryArtifacts;
import org.jetbrains.kotlin.test.model.TestFile;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.TestModuleStructureKt;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.utils.FileUtilsKt;
import org.jetbrains.kotlin.test.utils.MultiModuleInfoDumper;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\rH\u0016J\u0018\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\rH\u0002R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/test/backend/handlers/SMAPDumpHandler;", "Lorg/jetbrains/kotlin/test/backend/handlers/JvmBinaryArtifactHandler;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "directiveContainers", "", "Lorg/jetbrains/kotlin/test/directives/model/DirectivesContainer;", "getDirectiveContainers", "()Ljava/util/List;", "dumper", "Lorg/jetbrains/kotlin/test/utils/MultiModuleInfoDumper;", "isSeparateCompilation", "", "processAfterAllModules", "", "someAssertionWasFailed", "processModule", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "info", "Lorg/jetbrains/kotlin/test/model/BinaryArtifacts$Jvm;", "separateDumpsEnabled", "Companion", "tests-common-new"})
public final class SMAPDumpHandler
extends JvmBinaryArtifactHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MultiModuleInfoDumper dumper;
    @NotNull
    public static final String SMAP_EXT = "smap";
    @NotNull
    public static final String SMAP_SEP_EXT = "smap-separate-compilation";
    @NotNull
    public static final String SMAP_NON_SEP_EXT = "smap-nonseparate-compilation";

    public SMAPDumpHandler(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        super(testServices, false, 2, null);
        this.dumper = new MultiModuleInfoDumper(null);
    }

    @Override
    @NotNull
    public List<DirectivesContainer> getDirectiveContainers() {
        return CollectionsKt.listOf((Object)CodegenTestDirectives.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void processModule(@NotNull TestModule module, @NotNull BinaryArtifacts.Jvm info) {
        StringBuilder stringBuilder;
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        void $this$groupByTo$iv$iv;
        void $this$mapTo$iv$iv2;
        void $this$map$iv2;
        Iterable $this$sortedBy$iv;
        void $this$mapNotNullTo$iv$iv;
        Object object;
        void $this$mapTo$iv$iv3;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        if (!module.getDirectives().contains(CodegenTestDirectives.INSTANCE.getDUMP_SMAP())) {
            return;
        }
        Iterable $this$map$iv3 = module.getFiles();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv3;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            void it;
            TestFile testFile = (TestFile)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(it.getName());
        }
        List originalFileNames = (List)destination$iv$iv;
        Iterable $this$mapNotNull$iv = CommonSMAPTestUtil.INSTANCE.extractSMAPFromClasses(ClassFileUtilsKt.getClassFiles((ClassFileFactory)info.getClassFileFactory()));
        boolean $i$f$mapNotNull = false;
        destination$iv$iv = $this$mapNotNull$iv;
        Iterable destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Pair bl = $this$forEach$iv$iv$iv.iterator();
        while (bl.hasNext()) {
            Pair it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = bl.next();
            boolean bl2 = false;
            CommonSMAPTestUtil.SMAPAndFile it = (CommonSMAPTestUtil.SMAPAndFile)element$iv$iv;
            boolean bl3 = false;
            String name2 = new File(it.getSourceFile()).getName();
            int index = originalFileNames.indexOf(name2);
            TestFile testFile = module.getFiles().get(index);
            if ((testFile.getDirectives().contains(CodegenTestDirectives.INSTANCE.getNO_SMAP_DUMP()) ? null : TuplesKt.to((Object)index, (Object)it)) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl4 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv2;
        boolean $i$f$sortedBy = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Pair it = (Pair)a;
                boolean bl = false;
                Comparable comparable = (Integer)it.getFirst();
                it = (Pair)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Integer)it.getFirst()));
            }
        });
        boolean $i$f$map2 = false;
        $this$mapNotNullTo$iv$iv = $this$map$iv2;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            bl = (Pair)item$iv$iv;
            object = destination$iv$iv2;
            boolean bl5 = false;
            object.add((CommonSMAPTestUtil.SMAPAndFile)it.getSecond());
        }
        List compiledSmaps = (List)destination$iv$iv2;
        CommonSMAPTestUtil.INSTANCE.checkNoConflictMappings(compiledSmaps, this.getAssertions());
        Object $this$groupBy$iv = compiledSmaps;
        boolean $i$f$groupBy = false;
        destination$iv$iv2 = $this$groupBy$iv;
        Object destination$iv$iv3 = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object2;
            CommonSMAPTestUtil.SMAPAndFile it = (CommonSMAPTestUtil.SMAPAndFile)element$iv$iv;
            boolean bl6 = false;
            String key$iv$iv = it.getSourceFile();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv3;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl7 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object2;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv3;
        boolean $i$f$map3 = false;
        $this$groupByTo$iv$iv = $this$map$iv;
        destination$iv$iv3 = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo3 = false;
        Iterator<Object> item$iv$iv = $this$mapTo$iv$iv.entrySet().iterator();
        while (item$iv$iv.hasNext()) {
            void $this$mapNotNullTo$iv$iv2;
            void $this$mapNotNull$iv2;
            void it;
            Map.Entry item$iv$iv2;
            Map.Entry list$iv$iv = item$iv$iv2 = (Map.Entry)item$iv$iv.next();
            object = destination$iv$iv3;
            boolean bl8 = false;
            Iterable $this$sortedByDescending$iv = (Iterable)it.getValue();
            boolean $i$f$sortedByDescending = false;
            $this$sortedByDescending$iv = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    CommonSMAPTestUtil.SMAPAndFile p0 = (CommonSMAPTestUtil.SMAPAndFile)b;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)p0.getOutputFile());
                    p0 = (CommonSMAPTestUtil.SMAPAndFile)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)p0.getOutputFile())));
                }
            });
            boolean $i$f$mapNotNull2 = false;
            void $i$f$getOrPut = $this$mapNotNull$iv2;
            Collection destination$iv$iv4 = new ArrayList();
            boolean $i$f$mapNotNullTo2 = false;
            void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv2;
            boolean $i$f$forEach2 = false;
            Iterator iterator = $this$forEach$iv$iv$iv2.iterator();
            while (iterator.hasNext()) {
                String it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl9 = false;
                CommonSMAPTestUtil.SMAPAndFile p0 = (CommonSMAPTestUtil.SMAPAndFile)element$iv$iv;
                boolean bl10 = false;
                if (p0.getSmap() == null) continue;
                boolean bl11 = false;
                destination$iv$iv4.add(it$iv$iv);
            }
            String smap = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv4), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
            object.add(new CommonSMAPTestUtil.SMAPAndFile(((CharSequence)smap).length() > 0 ? smap : null, (String)it.getKey(), "NOT_SORTED"));
        }
        $this$map$iv = (List)destination$iv$iv3;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        destination$iv$iv3 = $this$associateBy$iv;
        Map destination$iv$iv5 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            CommonSMAPTestUtil.SMAPAndFile bl8 = (CommonSMAPTestUtil.SMAPAndFile)element$iv$iv;
            object = destination$iv$iv5;
            boolean bl12 = false;
            object.put(it.getSourceFile(), element$iv$iv);
        }
        Map compiledData = destination$iv$iv5;
        StringBuilder $this$processModule_u24lambda_u248 = stringBuilder = this.dumper.builderForModule(module);
        boolean bl13 = false;
        for (CommonSMAPTestUtil.SMAPAndFile source : compiledData.values()) {
            StringBuilder stringBuilder2 = $this$processModule_u24lambda_u248.append("// FILE: " + new File(source.getSourceFile()).getName());
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append('\\n')");
            StringBuilder stringBuilder3 = $this$processModule_u24lambda_u248;
            String string = source.getSmap();
            if (string == null) {
                string = "";
            }
            StringBuilder stringBuilder4 = stringBuilder3.append(string);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(value)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append('\\n')");
        }
    }

    @Override
    public void processAfterAllModules(boolean someAssertionWasFailed) {
        if (this.dumper.isEmpty()) {
            return;
        }
        boolean separateDumpEnabled = this.separateDumpsEnabled();
        boolean isSeparateCompilation = this.isSeparateCompilation();
        String extension = !separateDumpEnabled ? SMAP_EXT : (isSeparateCompilation ? SMAP_SEP_EXT : SMAP_NON_SEP_EXT);
        File testDataFile = (File)CollectionsKt.first(TestModuleStructureKt.getModuleStructure(this.getTestServices()).getOriginalTestDataFiles());
        File expectedFile = FileUtilsKt.withExtension(testDataFile, extension);
        Assertions.assertEqualsToFile$default(this.getAssertions(), expectedFile, this.dumper.generateResultingDump(), null, 4, null);
        if (separateDumpEnabled && isSeparateCompilation) {
            String otherExtension = isSeparateCompilation ? SMAP_NON_SEP_EXT : SMAP_SEP_EXT;
            File otherFile = FileUtilsKt.withExtension(expectedFile, otherExtension);
            if (!otherFile.exists()) {
                return;
            }
            String expectedText = FilesKt.readText$default((File)expectedFile, null, (int)1, null);
            if (Intrinsics.areEqual((Object)expectedText, (Object)FilesKt.readText$default((File)otherFile, null, (int)1, null))) {
                File smapFile = FileUtilsKt.withExtension(expectedFile, SMAP_EXT);
                FilesKt.writeText$default((File)smapFile, (String)expectedText, null, (int)2, null);
                expectedFile.delete();
                otherFile.delete();
                this.getAssertions().fail((Function0<String>)((Function0)new Function0<String>(expectedFile, otherFile, smapFile, testDataFile){
                    final /* synthetic */ File $expectedFile;
                    final /* synthetic */ File $otherFile;
                    final /* synthetic */ File $smapFile;
                    final /* synthetic */ File $testDataFile;
                    {
                        this.$expectedFile = $expectedFile;
                        this.$otherFile = $otherFile;
                        this.$smapFile = $smapFile;
                        this.$testDataFile = $testDataFile;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return StringsKt.trimIndent((String)("\n                    Contents of " + this.$expectedFile.getName() + " and " + this.$otherFile.getName() + " are equals, so they are deleted\n                     and joined to " + this.$smapFile.getName() + ". Please remove " + CodegenTestDirectives.INSTANCE.getSEPARATE_SMAP_DUMPS() + " directive from\n                     " + this.$testDataFile.getName() + " and rerun test\n                    "));
                    }
                }));
                throw null;
            }
        }
    }

    private final boolean isSeparateCompilation() {
        return TestModuleStructureKt.getModuleStructure(this.getTestServices()).getModules().size() > 1;
    }

    private final boolean separateDumpsEnabled() {
        return TestModuleStructureKt.getModuleStructure(this.getTestServices()).getAllDirectives().contains(CodegenTestDirectives.INSTANCE.getSEPARATE_SMAP_DUMPS());
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/test/backend/handlers/SMAPDumpHandler$Companion;", "", "()V", "SMAP_EXT", "", "SMAP_NON_SEP_EXT", "SMAP_SEP_EXT", "tests-common-new"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

