/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.backend.handlers;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKt;
import org.jetbrains.kotlin.diagnostics.KtDiagnostic;
import org.jetbrains.kotlin.diagnostics.PsiDiagnosticUtils;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.diagnostics.rendering.RootDiagnosticRendererFactory;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.test.backend.handlers.NoFirCompilationErrorsHandler;
import org.jetbrains.kotlin.test.directives.CodegenTestDirectives;
import org.jetbrains.kotlin.test.directives.model.DirectivesContainer;
import org.jetbrains.kotlin.test.frontend.fir.FirOutputArtifact;
import org.jetbrains.kotlin.test.frontend.fir.handlers.FirAnalysisHandler;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.TestServices;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/test/backend/handlers/NoFirCompilationErrorsHandler;", "Lorg/jetbrains/kotlin/test/frontend/fir/handlers/FirAnalysisHandler;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "directiveContainers", "", "Lorg/jetbrains/kotlin/test/directives/model/DirectivesContainer;", "getDirectiveContainers", "()Ljava/util/List;", "processAfterAllModules", "", "someAssertionWasFailed", "", "processModule", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "info", "Lorg/jetbrains/kotlin/test/frontend/fir/FirOutputArtifact;", "tests-common-new"})
public final class NoFirCompilationErrorsHandler
extends FirAnalysisHandler {
    public NoFirCompilationErrorsHandler(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        super(testServices, true, false, 4, null);
    }

    @Override
    @NotNull
    public List<DirectivesContainer> getDirectiveContainers() {
        return CollectionsKt.listOf((Object)CodegenTestDirectives.INSTANCE);
    }

    @Override
    public void processModule(@NotNull TestModule module, @NotNull FirOutputArtifact info) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        boolean hasError = false;
        boolean ignoreErrors = module.getDirectives().contains(CodegenTestDirectives.INSTANCE.getIGNORE_FIR_DIAGNOSTICS());
        for (Map.Entry<FirFile, List<KtDiagnostic>> entry : info.getFirAnalyzerFacade().runCheckers().entrySet()) {
            FirFile firFile = entry.getKey();
            List<KtDiagnostic> diagnostics = entry.getValue();
            for (KtDiagnostic diagnostic : diagnostics) {
                Object object;
                String diagnosticText;
                block7: {
                    TextRange range;
                    block6: {
                        if (diagnostic.getSeverity() != Severity.ERROR) continue;
                        hasError = true;
                        if (ignoreErrors) continue;
                        diagnosticText = RootDiagnosticRendererFactory.INSTANCE.invoke(diagnostic).render(diagnostic);
                        range = (TextRange)CollectionsKt.first((List)diagnostic.getTextRanges());
                        object = firFile.getSource();
                        if (object == null || (object = KtSourceElementKt.getPsi((AbstractKtSourceElement)((AbstractKtSourceElement)object))) == null || (object = object.getContainingFile()) == null) break block6;
                        KtSourceElement psiFile = object;
                        boolean bl = false;
                        String string = PsiDiagnosticUtils.atLocation((PsiFile)psiFile, (TextRange)range);
                        object = string;
                        if (string != null) break block7;
                    }
                    object = firFile.getName() + ':' + range;
                }
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"firFile.source?.psi?.con\u2026 \"${firFile.name}:$range\"");
                Object locationText = object;
                throw new IllegalStateException(diagnostic.getFactory().getName() + ": " + diagnosticText + " at " + (String)locationText);
            }
        }
        if (!hasError && ignoreErrors) {
            this.getAssertions().fail((Function0<String>)((Function0)processModule.1.INSTANCE));
            throw null;
        }
    }

    @Override
    public void processAfterAllModules(boolean someAssertionWasFailed) {
    }
}

