/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.backend.handlers;

import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.test.WrappedException;
import org.jetbrains.kotlin.test.backend.handlers.FirIrDumpIdenticalChecker;
import org.jetbrains.kotlin.test.directives.FirDiagnosticsDirectives;
import org.jetbrains.kotlin.test.directives.model.DirectivesContainer;
import org.jetbrains.kotlin.test.model.AfterAnalysisChecker;
import org.jetbrains.kotlin.test.services.TestModuleStructureKt;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.utils.FileUtilsKt;
import org.jetbrains.kotlin.test.utils.FirIdenticalCheckerHelper;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0002\u000b\u000e\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u0006H\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0010\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u0010\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000f\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/test/backend/handlers/FirIrDumpIdenticalChecker;", "Lorg/jetbrains/kotlin/test/model/AfterAnalysisChecker;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "directiveContainers", "", "Lorg/jetbrains/kotlin/test/directives/model/DirectivesContainer;", "getDirectiveContainers", "()Ljava/util/List;", "prettyDumpChecker", "org/jetbrains/kotlin/test/backend/handlers/FirIrDumpIdenticalChecker$prettyDumpChecker$1", "Lorg/jetbrains/kotlin/test/backend/handlers/FirIrDumpIdenticalChecker$prettyDumpChecker$1;", "simpleDumpChecker", "org/jetbrains/kotlin/test/backend/handlers/FirIrDumpIdenticalChecker$simpleDumpChecker$1", "Lorg/jetbrains/kotlin/test/backend/handlers/FirIrDumpIdenticalChecker$simpleDumpChecker$1;", "check", "", "failedAssertions", "Lorg/jetbrains/kotlin/test/WrappedException;", "tests-common-new"})
public final class FirIrDumpIdenticalChecker
extends AfterAnalysisChecker {
    @NotNull
    private final simpleDumpChecker.1 simpleDumpChecker;
    @NotNull
    private final prettyDumpChecker.1 prettyDumpChecker;

    public FirIrDumpIdenticalChecker(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        super(testServices);
        this.simpleDumpChecker = new FirIdenticalCheckerHelper(testServices){

            @Nullable
            public File getClassicFileToCompare(@NotNull File testDataFile) {
                File file;
                Intrinsics.checkNotNullParameter((Object)testDataFile, (String)"testDataFile");
                File it = file = FileUtilsKt.withExtension(testDataFile, "ir.txt");
                boolean bl = false;
                return it.exists() ? file : null;
            }

            @Nullable
            public File getFirFileToCompare(@NotNull File testDataFile) {
                File file;
                Intrinsics.checkNotNullParameter((Object)testDataFile, (String)"testDataFile");
                File it = file = FileUtilsKt.withExtension(testDataFile, "fir.ir.txt");
                boolean bl = false;
                return it.exists() ? file : null;
            }
        };
        this.prettyDumpChecker = new FirIdenticalCheckerHelper(testServices){

            @Nullable
            public File getClassicFileToCompare(@NotNull File testDataFile) {
                File file;
                Intrinsics.checkNotNullParameter((Object)testDataFile, (String)"testDataFile");
                File it = file = FileUtilsKt.withExtension(testDataFile, "kt.txt");
                boolean bl = false;
                return it.exists() ? file : null;
            }

            @Nullable
            public File getFirFileToCompare(@NotNull File testDataFile) {
                File file;
                Intrinsics.checkNotNullParameter((Object)testDataFile, (String)"testDataFile");
                File it = file = FileUtilsKt.withExtension(testDataFile, "fir.kt.txt");
                boolean bl = false;
                return it.exists() ? file : null;
            }
        };
    }

    @Override
    @NotNull
    public List<DirectivesContainer> getDirectiveContainers() {
        return CollectionsKt.listOf((Object)FirDiagnosticsDirectives.INSTANCE);
    }

    @Override
    public void check(@NotNull List<? extends WrappedException> failedAssertions) {
        Intrinsics.checkNotNullParameter(failedAssertions, (String)"failedAssertions");
        if (!((Collection)failedAssertions).isEmpty()) {
            return;
        }
        File testDataFile = (File)CollectionsKt.first(TestModuleStructureKt.getModuleStructure(this.getTestServices()).getOriginalTestDataFiles());
        if (TestModuleStructureKt.getModuleStructure(this.getTestServices()).getAllDirectives().contains(FirDiagnosticsDirectives.INSTANCE.getFIR_IDENTICAL())) {
            this.simpleDumpChecker.deleteFirFile(testDataFile);
            this.prettyDumpChecker.deleteFirFile(testDataFile);
            return;
        }
        if (FirIdenticalCheckerHelper.firAndClassicContentsAreEquals$default(this.simpleDumpChecker, testDataFile, false, 2, null) && this.prettyDumpChecker.firAndClassicContentsAreEquals(testDataFile, true)) {
            this.simpleDumpChecker.deleteFirFile(testDataFile);
            this.prettyDumpChecker.deleteFirFile(testDataFile);
            this.simpleDumpChecker.addDirectiveToClassicFileAndAssert(testDataFile);
        }
    }
}

