/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.references.FirControlFlowGraphReference;
import org.jetbrains.kotlin.fir.resolve.dfa.FirControlFlowGraphReferenceImpl;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.CFGNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraph;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.Edge;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.EdgeKind;
import org.jetbrains.kotlin.fir.visitors.FirVisitorVoid;
import org.jetbrains.kotlin.test.Assertions;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\f\u001a\u00020\t2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0002J\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/fir/FirCfgConsistencyChecker;", "Lorg/jetbrains/kotlin/fir/visitors/FirVisitorVoid;", "assertions", "Lorg/jetbrains/kotlin/test/Assertions;", "(Lorg/jetbrains/kotlin/test/Assertions;)V", "cfgKinds", "", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/EdgeKind;", "checkConsistency", "", "graph", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraph;", "checkEdge", "from", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/CFGNode;", "to", "checkOrder", "visitControlFlowGraphReference", "controlFlowGraphReference", "Lorg/jetbrains/kotlin/fir/references/FirControlFlowGraphReference;", "visitElement", "element", "Lorg/jetbrains/kotlin/fir/FirElement;", "tests-compiler-utils"})
public final class FirCfgConsistencyChecker
extends FirVisitorVoid {
    @NotNull
    private final Assertions assertions;
    @NotNull
    private final List<EdgeKind> cfgKinds;

    public FirCfgConsistencyChecker(@NotNull Assertions assertions) {
        Intrinsics.checkNotNullParameter((Object)assertions, (String)"assertions");
        this.assertions = assertions;
        Object[] objectArray = new EdgeKind[]{EdgeKind.DeadForward, EdgeKind.CfgForward, EdgeKind.DeadBackward, EdgeKind.CfgBackward};
        this.cfgKinds = CollectionsKt.listOf((Object[])objectArray);
    }

    public void visitElement(@NotNull FirElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        element.acceptChildren((FirVisitorVoid)this);
    }

    public void visitControlFlowGraphReference(@NotNull FirControlFlowGraphReference controlFlowGraphReference) {
        Intrinsics.checkNotNullParameter((Object)controlFlowGraphReference, (String)"controlFlowGraphReference");
        FirControlFlowGraphReferenceImpl firControlFlowGraphReferenceImpl = controlFlowGraphReference instanceof FirControlFlowGraphReferenceImpl ? (FirControlFlowGraphReferenceImpl)controlFlowGraphReference : null;
        if (firControlFlowGraphReferenceImpl == null || (firControlFlowGraphReferenceImpl = firControlFlowGraphReferenceImpl.getControlFlowGraph()) == null) {
            return;
        }
        FirControlFlowGraphReferenceImpl graph = firControlFlowGraphReferenceImpl;
        Assertions.assertEquals$default(this.assertions, ControlFlowGraph.State.Completed, graph.getState(), null, 4, null);
        this.checkConsistency((ControlFlowGraph)graph);
        this.checkOrder((ControlFlowGraph)graph);
    }

    private final void checkConsistency(ControlFlowGraph graph) {
        for (CFGNode node : graph.getNodes()) {
            for (CFGNode to : node.getFollowingNodes()) {
                this.checkEdge(node, to);
            }
            for (CFGNode from : node.getPreviousNodes()) {
                this.checkEdge(from, node);
            }
            if (node.getFollowingNodes().isEmpty() && node.getPreviousNodes().isEmpty()) {
                throw new AssertionError((Object)("Unconnected CFG node: " + node));
            }
        }
    }

    private final void checkEdge(CFGNode<?> from, CFGNode<?> to) {
        CFGNode[] cFGNodeArray = new CFGNode[]{to};
        this.assertions.assertContainsElements((Collection)from.getFollowingNodes(), cFGNodeArray);
        cFGNodeArray = new CFGNode[]{from};
        this.assertions.assertContainsElements((Collection)to.getPreviousNodes(), cFGNodeArray);
        EdgeKind fromKind = ((Edge)MapsKt.getValue((Map)from.getOutgoingEdges(), to)).getKind();
        EdgeKind toKind = ((Edge)MapsKt.getValue((Map)to.getIncomingEdges(), from)).getKind();
        Assertions.assertEquals$default(this.assertions, fromKind, toKind, null, 4, null);
        if (from.isDead() && to.isDead()) {
            EdgeKind[] edgeKindArray = new EdgeKind[]{toKind};
            this.assertions.assertContainsElements((Collection)this.cfgKinds, edgeKindArray);
        }
    }

    private final void checkOrder(ControlFlowGraph graph) {
        Set visited = new LinkedHashSet();
        for (CFGNode node : graph.getNodes()) {
            for (CFGNode previousNode : node.getPreviousNodes()) {
                if (!Intrinsics.areEqual((Object)previousNode.getOwner(), (Object)graph) || ((Edge)MapsKt.getValue((Map)node.getIncomingEdges(), (Object)previousNode)).getKind().isBack()) continue;
                Assertions.assertTrue$default(this.assertions, visited.contains(previousNode), null, 2, null);
            }
            ((Collection)visited).add(node);
        }
    }
}

