/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.extensions.IrGenerationExtension;
import org.jetbrains.kotlin.backend.jvm.serialization.JvmIdSignatureDescriptor;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporterFactory;
import org.jetbrains.kotlin.diagnostics.KtDiagnostic;
import org.jetbrains.kotlin.diagnostics.impl.PendingDiagnosticsCollectorWithSuppress;
import org.jetbrains.kotlin.fir.AbstractFirAnalyzerFacade;
import org.jetbrains.kotlin.fir.FirModuleData;
import org.jetbrains.kotlin.fir.FirModuleDataKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.collectors.FirDiagnosticsCollector;
import org.jetbrains.kotlin.fir.analysis.collectors.SimpleDiagnosticsCollector;
import org.jetbrains.kotlin.fir.backend.Fir2IrConverter;
import org.jetbrains.kotlin.fir.backend.Fir2IrExtensions;
import org.jetbrains.kotlin.fir.backend.Fir2IrResult;
import org.jetbrains.kotlin.fir.backend.Fir2IrSpecialSymbolProvider;
import org.jetbrains.kotlin.fir.backend.Fir2IrVisibilityConverter;
import org.jetbrains.kotlin.fir.backend.jvm.Fir2IrJvmSpecialAnnotationSymbolProvider;
import org.jetbrains.kotlin.fir.backend.jvm.FirJvmKotlinMangler;
import org.jetbrains.kotlin.fir.backend.jvm.FirJvmVisibilityConverter;
import org.jetbrains.kotlin.fir.builder.PsiHandlingMode;
import org.jetbrains.kotlin.fir.builder.RawFirBuilder;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.lightTree.LightTree2Fir;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.providers.FirProvider;
import org.jetbrains.kotlin.fir.resolve.providers.FirProviderKt;
import org.jetbrains.kotlin.fir.resolve.providers.impl.FirProviderImpl;
import org.jetbrains.kotlin.fir.resolve.transformers.FirTotalResolveProcessor;
import org.jetbrains.kotlin.fir.scopes.FirScopeProvider;
import org.jetbrains.kotlin.fir.signaturer.FirMangler;
import org.jetbrains.kotlin.ir.backend.jvm.serialization.JvmDescriptorMangler;
import org.jetbrains.kotlin.ir.backend.jvm.serialization.JvmIrMangler;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.impl.IrFactoryImpl;
import org.jetbrains.kotlin.ir.util.IdSignatureComposer;
import org.jetbrains.kotlin.ir.util.KotlinMangler;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.sourceFiles.LightTreeFile;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001Ba\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0007\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u000e\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u0011J\b\u0010)\u001a\u00020*H\u0002J\u0010\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0016J\u001a\u0010/\u001a\u0014\u0012\u0004\u0012\u00020\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u00170\u0015H\u0016J\u000e\u00100\u001a\b\u0012\u0004\u0012\u00020\u00160\u0017H\u0016R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u0014\u001a\u0016\u0012\u0004\u0012\u00020\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u0017\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0016\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001aR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u001eR\u0014\u0010#\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u001a\u00a8\u00061"}, d2={"Lorg/jetbrains/kotlin/fir/FirAnalyzerFacade;", "Lorg/jetbrains/kotlin/fir/AbstractFirAnalyzerFacade;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "ktFiles", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "lightTreeFiles", "Lorg/jetbrains/kotlin/sourceFiles/LightTreeFile;", "irGeneratorExtensions", "Lorg/jetbrains/kotlin/backend/common/extensions/IrGenerationExtension;", "useLightTree", "", "enablePluginPhases", "generateSignatures", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Ljava/util/Collection;Ljava/util/Collection;Ljava/util/Collection;ZZZ)V", "_scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "collectedDiagnostics", "", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "", "Lorg/jetbrains/kotlin/diagnostics/KtDiagnostic;", "getEnablePluginPhases", "()Z", "firFiles", "getGenerateSignatures", "getIrGeneratorExtensions", "()Ljava/util/Collection;", "getKtFiles", "getLanguageVersionSettings", "()Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "getLightTreeFiles", "scopeSession", "getScopeSession", "()Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "getUseLightTree", "buildRawFir", "", "convertToIr", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrResult;", "fir2IrExtensions", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrExtensions;", "runCheckers", "runResolution", "tests-compiler-utils"})
public final class FirAnalyzerFacade
extends AbstractFirAnalyzerFacade {
    @NotNull
    private final FirSession session;
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;
    @NotNull
    private final Collection<KtFile> ktFiles;
    @NotNull
    private final Collection<LightTreeFile> lightTreeFiles;
    @NotNull
    private final Collection<IrGenerationExtension> irGeneratorExtensions;
    private final boolean useLightTree;
    private final boolean enablePluginPhases;
    private final boolean generateSignatures;
    @Nullable
    private List<? extends FirFile> firFiles;
    @Nullable
    private ScopeSession _scopeSession;
    @Nullable
    private Map<FirFile, ? extends List<? extends KtDiagnostic>> collectedDiagnostics;

    public FirAnalyzerFacade(@NotNull FirSession session, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull Collection<? extends KtFile> ktFiles, @NotNull Collection<LightTreeFile> lightTreeFiles, @NotNull Collection<? extends IrGenerationExtension> irGeneratorExtensions, boolean useLightTree, boolean enablePluginPhases, boolean generateSignatures) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        Intrinsics.checkNotNullParameter(ktFiles, (String)"ktFiles");
        Intrinsics.checkNotNullParameter(lightTreeFiles, (String)"lightTreeFiles");
        Intrinsics.checkNotNullParameter(irGeneratorExtensions, (String)"irGeneratorExtensions");
        this.session = session;
        this.languageVersionSettings = languageVersionSettings;
        this.ktFiles = ktFiles;
        this.lightTreeFiles = lightTreeFiles;
        this.irGeneratorExtensions = irGeneratorExtensions;
        this.useLightTree = useLightTree;
        this.enablePluginPhases = enablePluginPhases;
        this.generateSignatures = generateSignatures;
    }

    public /* synthetic */ FirAnalyzerFacade(FirSession firSession, LanguageVersionSettings languageVersionSettings, Collection collection, Collection collection2, Collection collection3, boolean bl, boolean bl2, boolean bl3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            collection = CollectionsKt.emptyList();
        }
        if ((n & 8) != 0) {
            collection2 = CollectionsKt.emptyList();
        }
        if ((n & 0x20) != 0) {
            bl = false;
        }
        if ((n & 0x40) != 0) {
            bl2 = false;
        }
        if ((n & 0x80) != 0) {
            bl3 = false;
        }
        this(firSession, languageVersionSettings, collection, collection2, collection3, bl, bl2, bl3);
    }

    @NotNull
    public final FirSession getSession() {
        return this.session;
    }

    @NotNull
    public final LanguageVersionSettings getLanguageVersionSettings() {
        return this.languageVersionSettings;
    }

    @NotNull
    public final Collection<KtFile> getKtFiles() {
        return this.ktFiles;
    }

    @NotNull
    public final Collection<LightTreeFile> getLightTreeFiles() {
        return this.lightTreeFiles;
    }

    @NotNull
    public final Collection<IrGenerationExtension> getIrGeneratorExtensions() {
        return this.irGeneratorExtensions;
    }

    public final boolean getUseLightTree() {
        return this.useLightTree;
    }

    public final boolean getEnablePluginPhases() {
        return this.enablePluginPhases;
    }

    public final boolean getGenerateSignatures() {
        return this.generateSignatures;
    }

    @Override
    @NotNull
    public ScopeSession getScopeSession() {
        ScopeSession scopeSession = this._scopeSession;
        Intrinsics.checkNotNull((Object)scopeSession);
        return scopeSession;
    }

    /*
     * WARNING - void declaration
     */
    private final void buildRawFir() {
        FirAnalyzerFacade firAnalyzerFacade;
        List list;
        if (this.firFiles != null) {
            return;
        }
        FirProvider firProvider = FirProviderKt.getFirProvider((FirSession)this.session);
        Intrinsics.checkNotNull((Object)firProvider, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.resolve.providers.impl.FirProviderImpl");
        FirProviderImpl firProvider2 = (FirProviderImpl)firProvider;
        FirAnalyzerFacade firAnalyzerFacade2 = this;
        if (this.useLightTree) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            LightTree2Fir builder = new LightTree2Fir(this.session, (FirScopeProvider)firProvider2.getKotlinScopeProvider(), null, 4, null);
            Iterable iterable = this.lightTreeFiles;
            FirAnalyzerFacade firAnalyzerFacade3 = firAnalyzerFacade2;
            boolean $i$f$map = false;
            void var5_10 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                FirFile firFile;
                LightTreeFile lightTreeFile = (LightTreeFile)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                FirFile firFile2 = firFile = builder.buildFirFile(it.getLightTree(), it.getSourceFile(), it.getLinesMapping());
                boolean bl2 = false;
                firProvider2.recordFile(firFile2);
                collection.add(firFile);
            }
            list = (List)destination$iv$iv;
            firAnalyzerFacade = firAnalyzerFacade3;
        } else {
            RawFirBuilder builder = new RawFirBuilder(this.session, (FirScopeProvider)firProvider2.getKotlinScopeProvider(), PsiHandlingMode.COMPILER, null, 8, null);
            Iterable $this$map$iv = this.ktFiles;
            FirAnalyzerFacade firAnalyzerFacade4 = firAnalyzerFacade2;
            boolean $i$f$map = false;
            Iterable $this$mapTo$iv$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                FirFile firFile;
                KtFile it = (KtFile)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                FirFile firFile3 = firFile = builder.buildFirFile(it);
                boolean bl3 = false;
                firProvider2.recordFile(firFile3);
                collection.add(firFile);
            }
            list = (List)destination$iv$iv;
            firAnalyzerFacade = firAnalyzerFacade4;
        }
        firAnalyzerFacade.firFiles = list;
    }

    @Override
    @NotNull
    public List<FirFile> runResolution() {
        if (this.firFiles == null) {
            this.buildRawFir();
        }
        if (this._scopeSession != null) {
            List<FirFile> list = this.firFiles;
            Intrinsics.checkNotNull(list);
            return list;
        }
        FirTotalResolveProcessor resolveProcessor = new FirTotalResolveProcessor(this.session);
        List<? extends FirFile> list = this.firFiles;
        Intrinsics.checkNotNull(list);
        resolveProcessor.process(list);
        this._scopeSession = resolveProcessor.getScopeSession();
        List<FirFile> list2 = this.firFiles;
        Intrinsics.checkNotNull(list2);
        return list2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<FirFile, List<KtDiagnostic>> runCheckers() {
        Map map;
        if (this._scopeSession == null) {
            this.runResolution();
        }
        if (this.collectedDiagnostics != null) {
            Map<FirFile, List<KtDiagnostic>> map2 = this.collectedDiagnostics;
            Intrinsics.checkNotNull(map2);
            return map2;
        }
        SimpleDiagnosticsCollector collector = FirDiagnosticsCollector.INSTANCE.create(this.session, this.getScopeSession());
        Map map3 = map = MapsKt.createMapBuilder();
        FirAnalyzerFacade firAnalyzerFacade = this;
        boolean bl = false;
        List<? extends FirFile> list = this.firFiles;
        Intrinsics.checkNotNull(list);
        for (FirFile firFile : list) {
            void $this$runCheckers_u24lambda_u244;
            PendingDiagnosticsCollectorWithSuppress reporter = DiagnosticReporterFactory.INSTANCE.createPendingReporter();
            collector.collectDiagnostics((FirDeclaration)firFile, (DiagnosticReporter)reporter);
            $this$runCheckers_u24lambda_u244.put(firFile, reporter.getDiagnostics());
        }
        firAnalyzerFacade.collectedDiagnostics = MapsKt.build((Map)map);
        Map<FirFile, List<KtDiagnostic>> map4 = this.collectedDiagnostics;
        Intrinsics.checkNotNull(map4);
        return map4;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Fir2IrResult convertToIr(@NotNull Fir2IrExtensions fir2IrExtensions) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        FirSession it;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)fir2IrExtensions, (String)"fir2IrExtensions");
        if (this._scopeSession == null) {
            this.runResolution();
        }
        JvmDescriptorMangler mangler = new JvmDescriptorMangler(null);
        JvmIdSignatureDescriptor signaturer = new JvmIdSignatureDescriptor((KotlinMangler.DescriptorMangler)mangler);
        Iterable iterable = FirModuleDataKt.getModuleData((FirSession)this.session).getDependsOnDependencies();
        boolean $i$f$map = false;
        void var7_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            FirModuleData firModuleData = (FirModuleData)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getSession());
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (FirSession)element$iv$iv;
            boolean bl = false;
            if (!(it.getKind() == FirSession.Kind.Source)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$filterTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (FirSession)element$iv$iv;
            boolean bl = false;
            FirProvider firProvider = FirProviderKt.getFirProvider((FirSession)it);
            Intrinsics.checkNotNull((Object)firProvider, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.resolve.providers.impl.FirProviderImpl");
            Iterable list$iv$iv = ((FirProviderImpl)firProvider).getAllFirFiles();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List commonFirFiles = (List)destination$iv$iv;
        ScopeSession scopeSession = this._scopeSession;
        Intrinsics.checkNotNull((Object)scopeSession);
        List<? extends FirFile> list = this.firFiles;
        Intrinsics.checkNotNull(list);
        return Fir2IrConverter.Companion.createModuleFragmentWithSignaturesIfNeeded(this.session, scopeSession, CollectionsKt.plus((Collection)list, (Iterable)commonFirFiles), this.languageVersionSettings, (IdSignatureComposer)signaturer, fir2IrExtensions, (FirMangler)new FirJvmKotlinMangler(this.session), (KotlinMangler.IrMangler)JvmIrMangler.INSTANCE, (IrFactory)IrFactoryImpl.INSTANCE, (Fir2IrVisibilityConverter)FirJvmVisibilityConverter.INSTANCE, (Fir2IrSpecialSymbolProvider)new Fir2IrJvmSpecialAnnotationSymbolProvider(), this.irGeneratorExtensions, this.generateSignatures);
    }
}

