/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.test.Assertions;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.model.FrontendKind;
import org.jetbrains.kotlin.test.model.FrontendKinds;
import org.jetbrains.kotlin.test.services.JUnit5Assertions;
import org.jetbrains.kotlin.test.utils.SteppingTestLoggedData;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u001a0\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u001a\u001c\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002\u001a&\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u0019\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"CLASSIC_FRONTEND_EXPECTATIONS_MARKER", "", "EXPECTATIONS_MARKER", "FIR_EXPECTATIONS_MARKER", "FORCE_STEP_INTO_MARKER", "JVM_EXPECTATIONS_MARKER", "JVM_IR_EXPECTATIONS_MARKER", "checkSteppingTestResult", "", "frontendKind", "Lorg/jetbrains/kotlin/test/model/FrontendKind;", "targetBackend", "Lorg/jetbrains/kotlin/test/TargetBackend;", "wholeFile", "Ljava/io/File;", "loggedItems", "", "Lorg/jetbrains/kotlin/test/utils/SteppingTestLoggedData;", "compressSequencesWithoutLinenumber", "formatAsSteppingTestExpectation", "sourceName", "lineNumber", "", "functionName", "isSynthetic", "", "tests-common-new"})
public final class SteppingTestUtilsKt {
    @NotNull
    private static final String EXPECTATIONS_MARKER = "// EXPECTATIONS";
    @NotNull
    private static final String FORCE_STEP_INTO_MARKER = "// FORCE_STEP_INTO";
    @NotNull
    private static final String JVM_EXPECTATIONS_MARKER = "// EXPECTATIONS JVM";
    @NotNull
    private static final String JVM_IR_EXPECTATIONS_MARKER = "// EXPECTATIONS JVM_IR";
    @NotNull
    private static final String CLASSIC_FRONTEND_EXPECTATIONS_MARKER = "// EXPECTATIONS CLASSIC_FRONTEND";
    @NotNull
    private static final String FIR_EXPECTATIONS_MARKER = "// EXPECTATIONS FIR";

    /*
     * WARNING - void declaration
     */
    public static final void checkSteppingTestResult(@NotNull FrontendKind<?> frontendKind, @NotNull TargetBackend targetBackend, @NotNull File wholeFile, @NotNull List<SteppingTestLoggedData> loggedItems) {
        Iterator lineIterator;
        Iterator $this$mapTo$iv$iv;
        void $this$map$iv;
        SteppingTestLoggedData it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Object element$iv2;
        boolean bl;
        List lines;
        List actual;
        block48: {
            Intrinsics.checkNotNullParameter(frontendKind, (String)"frontendKind");
            Intrinsics.checkNotNullParameter((Object)((Object)targetBackend), (String)"targetBackend");
            Intrinsics.checkNotNullParameter((Object)wholeFile, (String)"wholeFile");
            Intrinsics.checkNotNullParameter(loggedItems, (String)"loggedItems");
            actual = new ArrayList();
            lines = FilesKt.readLines$default((File)wholeFile, null, (int)1, null);
            Iterable $this$any$iv = lines;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv2 : $this$any$iv) {
                    String it2 = (String)element$iv2;
                    boolean bl2 = false;
                    if (!StringsKt.startsWith$default((String)it2, (String)FORCE_STEP_INTO_MARKER, (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block48;
                }
                bl = false;
            }
        }
        boolean forceStepInto = bl;
        Iterable $i$f$any = SteppingTestUtilsKt.compressSequencesWithoutLinenumber(loggedItems);
        boolean $i$f$filter = false;
        element$iv2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (SteppingTestLoggedData)element$iv$iv;
            boolean bl3 = false;
            if (!(forceStepInto || !it.isSynthetic())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object item$iv$iv = iterator.next();
            it = (SteppingTestLoggedData)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl4 = false;
            collection.add("// " + it.getExpectation());
        }
        List actualLineNumbers = (List)destination$iv$iv;
        Iterator actualLineNumbersIterator = actualLineNumbers.iterator();
        $this$mapTo$iv$iv = lineIterator = lines.iterator();
        while ($this$mapTo$iv$iv.hasNext()) {
            String line = (String)$this$mapTo$iv$iv.next();
            actual.add(line);
            if (!StringsKt.startsWith$default((String)line, (String)EXPECTATIONS_MARKER, (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)line, (String)FORCE_STEP_INTO_MARKER, (boolean)false, (int)2, null)) continue;
        }
        TargetBackend currentBackend = TargetBackend.ANY;
        FrontendKind currentFrontend = frontendKind;
        Iterator $i$f$mapTo22 = lineIterator;
        while ($i$f$mapTo22.hasNext()) {
            String line;
            block49: {
                FrontendKind frontendKind2;
                TargetBackend targetBackend2;
                line = (String)$i$f$mapTo22.next();
                if (((CharSequence)line).length() == 0) {
                    actual.add(line);
                    continue;
                }
                if (!StringsKt.startsWith$default((String)line, (String)EXPECTATIONS_MARKER, (boolean)false, (int)2, null)) break block49;
                actual.add(line);
                switch (line) {
                    case "// EXPECTATIONS": {
                        targetBackend2 = TargetBackend.ANY;
                        break;
                    }
                    case "// EXPECTATIONS JVM": {
                        targetBackend2 = TargetBackend.JVM;
                        break;
                    }
                    case "// EXPECTATIONS JVM_IR": {
                        targetBackend2 = TargetBackend.JVM_IR;
                        break;
                    }
                    case "// EXPECTATIONS CLASSIC_FRONTEND": {
                        targetBackend2 = currentBackend;
                        break;
                    }
                    case "// EXPECTATIONS FIR": {
                        targetBackend2 = currentBackend;
                        break;
                    }
                    default: {
                        throw new IllegalStateException(("Expected JVM backend: " + line).toString());
                    }
                }
                currentBackend = targetBackend2;
                switch (line) {
                    case "// EXPECTATIONS": {
                        frontendKind2 = frontendKind;
                        break;
                    }
                    case "// EXPECTATIONS JVM": {
                        frontendKind2 = currentFrontend;
                        break;
                    }
                    case "// EXPECTATIONS JVM_IR": {
                        frontendKind2 = currentFrontend;
                        break;
                    }
                    case "// EXPECTATIONS CLASSIC_FRONTEND": {
                        frontendKind2 = FrontendKinds.ClassicFrontend.INSTANCE;
                        break;
                    }
                    case "// EXPECTATIONS FIR": {
                        frontendKind2 = FrontendKinds.FIR.INSTANCE;
                        break;
                    }
                    default: {
                        throw new IllegalStateException(("Expected JVM backend: " + line).toString());
                    }
                }
                currentFrontend = frontendKind2;
                continue;
            }
            if ((currentBackend == TargetBackend.ANY || currentBackend == targetBackend) && Intrinsics.areEqual(currentFrontend, frontendKind)) {
                if (!actualLineNumbersIterator.hasNext()) continue;
                actual.add(actualLineNumbersIterator.next());
                continue;
            }
            actual.add(line);
        }
        Iterator $this$forEach$iv = actualLineNumbersIterator;
        boolean $i$f$forEach = false;
        Object object = $this$forEach$iv;
        while (object.hasNext()) {
            Object element$iv3 = object.next();
            String it3 = (String)element$iv3;
            boolean bl5 = false;
            actual.add(it3);
        }
        Assertions.assertEqualsToFile$default((Assertions)JUnit5Assertions.INSTANCE, wholeFile, CollectionsKt.joinToString$default((Iterable)actual, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null), null, 4, null);
    }

    private static final List<SteppingTestLoggedData> compressSequencesWithoutLinenumber(List<SteppingTestLoggedData> loggedItems) {
        if (loggedItems.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Iterator<SteppingTestLoggedData> logIterator = loggedItems.iterator();
        SteppingTestLoggedData currentItem = logIterator.next();
        Object object = new SteppingTestLoggedData[]{currentItem};
        List result = CollectionsKt.mutableListOf((Object[])object);
        object = logIterator;
        while (object.hasNext()) {
            SteppingTestLoggedData logItem = (SteppingTestLoggedData)object.next();
            if (currentItem.getLine() == -1 && Intrinsics.areEqual((Object)currentItem.getExpectation(), (Object)logItem.getExpectation())) continue;
            result.add(logItem);
            currentItem = logItem;
        }
        return result;
    }

    @NotNull
    public static final String formatAsSteppingTestExpectation(@NotNull String sourceName, int lineNumber, @NotNull String functionName, boolean isSynthetic) {
        Intrinsics.checkNotNullParameter((Object)sourceName, (String)"sourceName");
        Intrinsics.checkNotNullParameter((Object)functionName, (String)"functionName");
        String synthetic = isSynthetic ? " (synthetic)" : "";
        return sourceName + ':' + lineNumber + ' ' + functionName + synthetic;
    }
}

