/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.runners;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.test.ExecutionListenerBasedDisposableProvider;
import org.jetbrains.kotlin.test.TestConfiguration;
import org.jetbrains.kotlin.test.TestRunner;
import org.jetbrains.kotlin.test.builders.TestConfigurationBuilder;
import org.jetbrains.kotlin.test.directives.ConfigurationDirectives;
import org.jetbrains.kotlin.test.directives.LanguageSettingsDirectives;
import org.jetbrains.kotlin.test.directives.model.SimpleDirectivesContainer;
import org.jetbrains.kotlin.test.model.TestFile;
import org.jetbrains.kotlin.test.runners.AbstractKotlinCompilerTest;
import org.jetbrains.kotlin.test.services.ApplicationDisposableProvider;
import org.jetbrains.kotlin.test.services.KotlinStandardLibrariesPathProvider;
import org.jetbrains.kotlin.test.services.KotlinTestInfo;
import org.jetbrains.kotlin.test.services.ReversibleSourceFilePreprocessor;
import org.jetbrains.kotlin.test.services.ServiceRegistrationData;
import org.jetbrains.kotlin.test.services.SourceFilePreprocessor;
import org.jetbrains.kotlin.test.services.StandardLibrariesPathProviderForKotlinProject;
import org.jetbrains.kotlin.test.services.TestService;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.utils.ReplacingSourceTransformer;
import org.jetbrains.kotlin.types.AbstractTypeChecker;
import org.jetbrains.kotlin.types.FlexibleTypeImpl;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0005H\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u000e\u0010\u0012\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\u0012\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0013H\u0007J\u0010\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\f\u0010\u0003\u001a\u00020\u0006*\u00020\u0005H&R%\u0010\u0003\u001a\u0013\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\u0002\b\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/test/runners/AbstractKotlinCompilerTest;", "", "()V", "configuration", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/test/builders/TestConfigurationBuilder;", "", "Lkotlin/ExtensionFunctionType;", "getConfiguration", "()Lkotlin/jvm/functions/Function1;", "testInfo", "Lorg/jetbrains/kotlin/test/services/KotlinTestInfo;", "configure", "builder", "createApplicationDisposableProvider", "Lorg/jetbrains/kotlin/test/services/ApplicationDisposableProvider;", "createKotlinStandardLibrariesPathProvider", "Lorg/jetbrains/kotlin/test/services/KotlinStandardLibrariesPathProvider;", "initTestInfo", "Lorg/junit/jupiter/api/TestInfo;", "runTest", "filePath", "", "contentModifier", "Lorg/jetbrains/kotlin/test/utils/ReplacingSourceTransformer;", "Companion", "tests-common-new"})
public abstract class AbstractKotlinCompilerTest {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function1<TestConfigurationBuilder, Unit> configuration = (Function1)new Function1<TestConfigurationBuilder, Unit>(this){
        final /* synthetic */ AbstractKotlinCompilerTest this$0;
        {
            this.this$0 = $receiver;
            super(1);
        }

        public final void invoke(@NotNull TestConfigurationBuilder $this$null) {
            TestConfigurationBuilder this_$iv;
            Intrinsics.checkNotNullParameter((Object)$this$null, (String)"$this$null");
            AbstractKotlinCompilerTest.Companion.getDefaultConfiguration().invoke((Object)$this$null);
            TestConfigurationBuilder testConfigurationBuilder = $this$null;
            Function1 serviceConstructor$iv = (Function1)new Function1<TestServices, ApplicationDisposableProvider>(this.this$0){
                final /* synthetic */ AbstractKotlinCompilerTest this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final ApplicationDisposableProvider invoke(@NotNull TestServices it) {
                    Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
                    return this.this$0.createApplicationDisposableProvider();
                }
            };
            boolean $i$f$useAdditionalService = false;
            ServiceRegistrationData[] serviceRegistrationDataArray = new ServiceRegistrationData[1];
            boolean $i$f$service = false;
            serviceRegistrationDataArray[0] = new ServiceRegistrationData((KClass<? extends TestService>)Reflection.getOrCreateKotlinClass(ApplicationDisposableProvider.class), (Function1<? super TestServices, ? extends TestService>)serviceConstructor$iv);
            this_$iv.useAdditionalServices(serviceRegistrationDataArray);
            this_$iv = $this$null;
            serviceConstructor$iv = (Function1)new Function1<TestServices, KotlinStandardLibrariesPathProvider>(this.this$0){
                final /* synthetic */ AbstractKotlinCompilerTest this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final KotlinStandardLibrariesPathProvider invoke(@NotNull TestServices it) {
                    Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
                    return this.this$0.createKotlinStandardLibrariesPathProvider();
                }
            };
            $i$f$useAdditionalService = false;
            serviceRegistrationDataArray = new ServiceRegistrationData[1];
            $i$f$service = false;
            serviceRegistrationDataArray[0] = new ServiceRegistrationData((KClass<? extends TestService>)Reflection.getOrCreateKotlinClass(KotlinStandardLibrariesPathProvider.class), (Function1<? super TestServices, ? extends TestService>)serviceConstructor$iv);
            this_$iv.useAdditionalServices(serviceRegistrationDataArray);
            this.this$0.configure($this$null);
        }
    };
    private KotlinTestInfo testInfo;
    @NotNull
    private static final List<SimpleDirectivesContainer> defaultDirectiveContainers;
    @NotNull
    private static final List<Function1<TestServices, SourceFilePreprocessor>> defaultPreprocessors;
    @NotNull
    private static final Function1<TestConfigurationBuilder, Unit> defaultConfiguration;

    @NotNull
    protected final Function1<TestConfigurationBuilder, Unit> getConfiguration() {
        return this.configuration;
    }

    public abstract void configuration(@NotNull TestConfigurationBuilder var1);

    @NotNull
    public ApplicationDisposableProvider createApplicationDisposableProvider() {
        return new ExecutionListenerBasedDisposableProvider();
    }

    @NotNull
    public KotlinStandardLibrariesPathProvider createKotlinStandardLibrariesPathProvider() {
        return StandardLibrariesPathProviderForKotlinProject.INSTANCE;
    }

    @BeforeEach
    public final void initTestInfo(@NotNull TestInfo testInfo) {
        Intrinsics.checkNotNullParameter((Object)testInfo, (String)"testInfo");
        Class clazz = (Class)testInfo.getTestClass().orElseGet(null);
        String string = clazz != null ? clazz.getName() : null;
        if (string == null) {
            string = "_undefined_";
        }
        Method method = (Method)testInfo.getTestMethod().orElseGet(null);
        String string2 = method != null ? method.getName() : null;
        if (string2 == null) {
            string2 = "_testUndefined_";
        }
        Set set = testInfo.getTags();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"testInfo.tags");
        this.initTestInfo(new KotlinTestInfo(string, string2, set));
    }

    public final void initTestInfo(@NotNull KotlinTestInfo testInfo) {
        Intrinsics.checkNotNullParameter((Object)testInfo, (String)"testInfo");
        this.testInfo = testInfo;
    }

    public void configure(@NotNull TestConfigurationBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        TestConfigurationBuilder $this$configure_u24lambda_u240 = builder;
        boolean bl = false;
        KotlinTestInfo kotlinTestInfo = this.testInfo;
        if (kotlinTestInfo == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"testInfo");
            kotlinTestInfo = null;
        }
        $this$configure_u24lambda_u240.setTestInfo(kotlinTestInfo);
        this.configuration(builder);
    }

    public void runTest(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Function1<TestConfigurationBuilder, Unit> init$iv = this.configuration;
        boolean $i$f$testRunner = false;
        boolean $i$f$testConfiguration = false;
        TestConfigurationBuilder testConfigurationBuilder = new TestConfigurationBuilder();
        init$iv.invoke((Object)testConfigurationBuilder);
        TestRunner.runTest$default(new TestRunner(testConfigurationBuilder.build(filePath)), filePath, null, 2, null);
    }

    public void runTest(@NotNull String filePath, @NotNull ReplacingSourceTransformer contentModifier) {
        TestConfigurationBuilder testConfigurationBuilder;
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)contentModifier, (String)"contentModifier");
        boolean $i$f$testRunner = false;
        boolean $i$f$testConfiguration = false;
        TestConfigurationBuilder $this$runTest_u24lambda_u241 = testConfigurationBuilder = new TestConfigurationBuilder();
        boolean bl = false;
        this.getConfiguration().invoke((Object)$this$runTest_u24lambda_u241);
        Function1[] function1Array = new Function1[]{(Function1)new Function1<TestServices, runTest.SourceTransformer>(contentModifier){
            final /* synthetic */ ReplacingSourceTransformer $contentModifier;
            {
                this.$contentModifier = $contentModifier;
                super(1);
            }

            @NotNull
            public final runTest.SourceTransformer invoke(@NotNull TestServices p0) {
                Intrinsics.checkNotNullParameter((Object)((Object)p0), (String)"p0");
                @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006H\u0016J\u0018\u0010\n\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u0006H\u0016\u00a8\u0006\f"}, d2={"org/jetbrains/kotlin/test/runners/AbstractKotlinCompilerTest$runTest$SourceTransformer", "Lorg/jetbrains/kotlin/test/services/ReversibleSourceFilePreprocessor;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "(Lorg/jetbrains/kotlin/test/utils/ReplacingSourceTransformer;Lorg/jetbrains/kotlin/test/services/TestServices;)V", "process", "", "file", "Lorg/jetbrains/kotlin/test/model/TestFile;", "content", "revert", "actualContent", "tests-common-new"})
                public final class SourceTransformer
                extends ReversibleSourceFilePreprocessor {
                    final /* synthetic */ ReplacingSourceTransformer $contentModifier;

                    public SourceTransformer(@NotNull ReplacingSourceTransformer $contentModifier, @NotNull TestServices testServices) {
                        Intrinsics.checkNotNullParameter((Object)$contentModifier, (String)"$contentModifier");
                        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
                        this.$contentModifier = $contentModifier;
                        super(testServices);
                    }

                    @NotNull
                    public String process(@NotNull TestFile file, @NotNull String content) {
                        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
                        return this.$contentModifier.invokeForTestFile(content);
                    }

                    @NotNull
                    public String revert(@NotNull TestFile file, @NotNull String actualContent) {
                        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                        Intrinsics.checkNotNullParameter((Object)actualContent, (String)"actualContent");
                        return this.$contentModifier.revertForFile(actualContent);
                    }
                }
                return new SourceTransformer(this.$contentModifier, p0);
            }

            @NotNull
            public final String getSignature() {
                return "<init>(Lorg/jetbrains/kotlin/test/utils/ReplacingSourceTransformer;Lorg/jetbrains/kotlin/test/services/TestServices;)V";
            }

            @NotNull
            public final String getName() {
                return "<init>";
            }

            @NotNull
            public final KDeclarationContainer getOwner() {
                return (KDeclarationContainer)Reflection.getOrCreateKotlinClass(SourceTransformer.class);
            }
        }};
        TestConfigurationBuilder.useSourcePreprocessor$default($this$runTest_u24lambda_u241, function1Array, false, 2, null);
        TestConfiguration testConfiguration = testConfigurationBuilder.build(filePath);
        TestRunner.runTest$default(new TestRunner(testConfiguration), filePath, null, 2, null);
    }

    static {
        Object[] objectArray = new SimpleDirectivesContainer[]{ConfigurationDirectives.INSTANCE, LanguageSettingsDirectives.INSTANCE};
        defaultDirectiveContainers = CollectionsKt.listOf((Object[])objectArray);
        defaultPreprocessors = CollectionsKt.listOf((Object)((Object)Companion.defaultPreprocessors.1.INSTANCE));
        defaultConfiguration = Companion.defaultConfiguration.1.INSTANCE;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0014\u001a\u00020\u0006H\u0002R\"\u0010\u0003\u001a\u0013\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\u0002\b\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR-\u0010\u000f\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u0004j\b\u0012\u0004\u0012\u00020\u0011`\u00120\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000e\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/test/runners/AbstractKotlinCompilerTest$Companion;", "", "()V", "defaultConfiguration", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/test/builders/TestConfigurationBuilder;", "", "Lkotlin/ExtensionFunctionType;", "getDefaultConfiguration", "()Lkotlin/jvm/functions/Function1;", "defaultDirectiveContainers", "", "Lorg/jetbrains/kotlin/test/directives/model/SimpleDirectivesContainer;", "getDefaultDirectiveContainers", "()Ljava/util/List;", "defaultPreprocessors", "Lorg/jetbrains/kotlin/test/services/TestServices;", "Lorg/jetbrains/kotlin/test/services/SourceFilePreprocessor;", "Lorg/jetbrains/kotlin/test/Constructor;", "getDefaultPreprocessors", "configureDebugFlags", "tests-common-new"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<SimpleDirectivesContainer> getDefaultDirectiveContainers() {
            return defaultDirectiveContainers;
        }

        @NotNull
        public final List<Function1<TestServices, SourceFilePreprocessor>> getDefaultPreprocessors() {
            return defaultPreprocessors;
        }

        private final void configureDebugFlags() {
            AbstractTypeChecker.RUN_SLOW_ASSERTIONS = true;
            FlexibleTypeImpl.RUN_SLOW_ASSERTIONS = true;
        }

        @NotNull
        public final Function1<TestConfigurationBuilder, Unit> getDefaultConfiguration() {
            return defaultConfiguration;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        public static final /* synthetic */ void access$configureDebugFlags(Companion $this) {
            $this.configureDebugFlags();
        }
    }
}

