/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.model;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.test.Assertions;
import org.jetbrains.kotlin.test.directives.model.DirectivesContainer;
import org.jetbrains.kotlin.test.model.ResultingArtifact;
import org.jetbrains.kotlin.test.model.ServicesAndDirectivesContainer;
import org.jetbrains.kotlin.test.model.TestArtifactKind;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.AssertionsKt;
import org.jetbrains.kotlin.test.services.ServiceRegistrationData;
import org.jetbrains.kotlin.test.services.TestServices;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\u00020\u0003B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0007H&J\u001d\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u001eR\u0018\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/test/model/AnalysisHandler;", "A", "Lorg/jetbrains/kotlin/test/model/ResultingArtifact;", "Lorg/jetbrains/kotlin/test/model/ServicesAndDirectivesContainer;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "failureDisablesNextSteps", "", "doNotRunIfThereWerePreviousFailures", "(Lorg/jetbrains/kotlin/test/services/TestServices;ZZ)V", "artifactKind", "Lorg/jetbrains/kotlin/test/model/TestArtifactKind;", "getArtifactKind", "()Lorg/jetbrains/kotlin/test/model/TestArtifactKind;", "assertions", "Lorg/jetbrains/kotlin/test/Assertions;", "getAssertions", "()Lorg/jetbrains/kotlin/test/Assertions;", "getDoNotRunIfThereWerePreviousFailures", "()Z", "getFailureDisablesNextSteps", "getTestServices", "()Lorg/jetbrains/kotlin/test/services/TestServices;", "processAfterAllModules", "", "someAssertionWasFailed", "processModule", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "info", "(Lorg/jetbrains/kotlin/test/model/TestModule;Lorg/jetbrains/kotlin/test/model/ResultingArtifact;)V", "test-infrastructure"})
public abstract class AnalysisHandler<A extends ResultingArtifact<A>>
implements ServicesAndDirectivesContainer {
    @NotNull
    private final TestServices testServices;
    private final boolean failureDisablesNextSteps;
    private final boolean doNotRunIfThereWerePreviousFailures;

    public AnalysisHandler(@NotNull TestServices testServices, boolean failureDisablesNextSteps, boolean doNotRunIfThereWerePreviousFailures) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        this.testServices = testServices;
        this.failureDisablesNextSteps = failureDisablesNextSteps;
        this.doNotRunIfThereWerePreviousFailures = doNotRunIfThereWerePreviousFailures;
    }

    @NotNull
    public final TestServices getTestServices() {
        return this.testServices;
    }

    public final boolean getFailureDisablesNextSteps() {
        return this.failureDisablesNextSteps;
    }

    public final boolean getDoNotRunIfThereWerePreviousFailures() {
        return this.doNotRunIfThereWerePreviousFailures;
    }

    @NotNull
    protected final Assertions getAssertions() {
        return AssertionsKt.getAssertions(this.testServices);
    }

    @NotNull
    public abstract TestArtifactKind<A> getArtifactKind();

    public abstract void processModule(@NotNull TestModule var1, @NotNull A var2);

    public abstract void processAfterAllModules(boolean var1);

    @Override
    @NotNull
    public List<ServiceRegistrationData> getAdditionalServices() {
        return ServicesAndDirectivesContainer.DefaultImpls.getAdditionalServices(this);
    }

    @Override
    @NotNull
    public List<DirectivesContainer> getDirectiveContainers() {
        return ServicesAndDirectivesContainer.DefaultImpls.getDirectiveContainers(this);
    }
}

