/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.frontend.fir.handlers;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.expressions.FirLoop;
import org.jetbrains.kotlin.fir.expressions.FirLoopJump;
import org.jetbrains.kotlin.fir.types.FirErrorTypeRef;
import org.jetbrains.kotlin.fir.types.FirImplicitTypeRef;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.visitors.FirDefaultVisitor;
import org.jetbrains.kotlin.fir.visitors.FirVisitor;
import org.jetbrains.kotlin.test.frontend.fir.FirOutputArtifact;
import org.jetbrains.kotlin.test.frontend.fir.handlers.FirAnalysisHandler;
import org.jetbrains.kotlin.test.frontend.fir.handlers.FirNoImplicitTypesHandler;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.TestServices;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/test/frontend/fir/handlers/FirNoImplicitTypesHandler;", "Lorg/jetbrains/kotlin/test/frontend/fir/handlers/FirAnalysisHandler;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "processAfterAllModules", "", "someAssertionWasFailed", "", "processModule", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "info", "Lorg/jetbrains/kotlin/test/frontend/fir/FirOutputArtifact;", "Visitor", "tests-common-new"})
public final class FirNoImplicitTypesHandler
extends FirAnalysisHandler {
    public FirNoImplicitTypesHandler(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        super(testServices, true, false, 4, null);
    }

    @Override
    public void processModule(@NotNull TestModule module, @NotNull FirOutputArtifact info) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Visitor visitor = new Visitor();
        for (FirFile firFile : info.getFirFiles().values()) {
            firFile.acceptChildren((FirVisitor)visitor, (Object)firFile);
        }
        if (!((Collection)visitor.getDetectedImplicitTypesParents()).isEmpty()) {
            this.getAssertions().fail((Function0<String>)((Function0)new Function0<String>(visitor){
                final /* synthetic */ Visitor $visitor;
                {
                    this.$visitor = $visitor;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    StringBuilder stringBuilder;
                    Visitor visitor = this.$visitor;
                    StringBuilder $this$invoke_u24lambda_u240 = stringBuilder = new StringBuilder();
                    boolean bl = false;
                    int count = visitor.getDetectedImplicitTypesParents().size();
                    if (count == 1) {
                        StringBuilder stringBuilder2 = $this$invoke_u24lambda_u240.append("One implicit type was found:");
                        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
                        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append('\\n')");
                    } else {
                        StringBuilder stringBuilder3 = $this$invoke_u24lambda_u240.append(count + " implicit types were found:");
                        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
                        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append('\\n')");
                    }
                    String types2 = CollectionsKt.joinToString$default((Iterable)visitor.getDetectedImplicitTypesParents(), (CharSequence)"\n", null, null, (int)0, null, (Function1)processModule.1.types.1.INSTANCE, (int)30, null);
                    $this$invoke_u24lambda_u240.append(types2);
                    String string = stringBuilder.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
                    return string;
                }
            }));
            throw null;
        }
    }

    @Override
    public void processAfterAllModules(boolean someAssertionWasFailed) {
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0003H\u0016J\u0018\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u0003H\u0016J\u0018\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u0003H\u0016J\u0018\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u0003H\u0016J\u0018\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000e\u001a\u00020\u0003H\u0016R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\b\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/test/frontend/fir/handlers/FirNoImplicitTypesHandler$Visitor;", "Lorg/jetbrains/kotlin/fir/visitors/FirDefaultVisitor;", "", "Lorg/jetbrains/kotlin/fir/FirElement;", "(Lorg/jetbrains/kotlin/test/frontend/fir/handlers/FirNoImplicitTypesHandler;)V", "detectedImplicitTypesParents", "", "getDetectedImplicitTypesParents", "()Ljava/util/Set;", "visitedLoopTargets", "Lorg/jetbrains/kotlin/fir/expressions/FirLoop;", "getVisitedLoopTargets", "visitElement", "element", "data", "visitErrorTypeRef", "errorTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirErrorTypeRef;", "visitImplicitTypeRef", "implicitTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirImplicitTypeRef;", "visitLoopJump", "loopJump", "Lorg/jetbrains/kotlin/fir/expressions/FirLoopJump;", "visitResolvedTypeRef", "resolvedTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirResolvedTypeRef;", "tests-common-new"})
    private final class Visitor
    extends FirDefaultVisitor<Unit, FirElement> {
        @NotNull
        private final Set<FirElement> detectedImplicitTypesParents = new LinkedHashSet();
        @NotNull
        private final Set<FirLoop> visitedLoopTargets = new LinkedHashSet();

        @NotNull
        public final Set<FirElement> getDetectedImplicitTypesParents() {
            return this.detectedImplicitTypesParents;
        }

        @NotNull
        public final Set<FirLoop> getVisitedLoopTargets() {
            return this.visitedLoopTargets;
        }

        public void visitElement(@NotNull FirElement element, @NotNull FirElement data) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            element.acceptChildren((FirVisitor)this, (Object)element);
        }

        public void visitResolvedTypeRef(@NotNull FirResolvedTypeRef resolvedTypeRef, @NotNull FirElement data) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)resolvedTypeRef, (String)"resolvedTypeRef");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                super.visitResolvedTypeRef(resolvedTypeRef, (Object)data);
                FirTypeRef firTypeRef = resolvedTypeRef.getDelegatedTypeRef();
                if (firTypeRef == null) break block0;
                FirTypeRef it = firTypeRef;
                boolean bl = false;
                this.visitElement((FirElement)it, data);
            }
        }

        public void visitErrorTypeRef(@NotNull FirErrorTypeRef errorTypeRef, @NotNull FirElement data) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)errorTypeRef, (String)"errorTypeRef");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                super.visitErrorTypeRef(errorTypeRef, (Object)data);
                FirTypeRef firTypeRef = errorTypeRef.getDelegatedTypeRef();
                if (firTypeRef == null) break block0;
                FirTypeRef it = firTypeRef;
                boolean bl = false;
                this.visitElement((FirElement)it, data);
            }
        }

        public void visitLoopJump(@NotNull FirLoopJump loopJump, @NotNull FirElement data) {
            Intrinsics.checkNotNullParameter((Object)loopJump, (String)"loopJump");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            super.visitLoopJump(loopJump, (Object)data);
            if (this.visitedLoopTargets.add((FirLoop)loopJump.getTarget().getLabeledElement())) {
                this.visitElement((FirElement)loopJump.getTarget().getLabeledElement(), data);
            }
        }

        public void visitImplicitTypeRef(@NotNull FirImplicitTypeRef implicitTypeRef, @NotNull FirElement data) {
            Intrinsics.checkNotNullParameter((Object)implicitTypeRef, (String)"implicitTypeRef");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            ((Collection)this.detectedImplicitTypesParents).add(data);
        }
    }
}

