/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.clientserver;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0003\u001a\u0014\u0010\u0000\u001a\u0004\u0018\u00010\u00012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u001a\u001a\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\u0010\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\u0001\u001a;\u0010\u000b\u001a\u0004\u0018\u00010\u0001*\u0006\u0012\u0002\b\u00030\u00032\u0006\u0010\f\u001a\u00020\b2\u001a\u0010\r\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00030\u000e\"\u0006\u0012\u0002\b\u00030\u0003H\u0002\u00a2\u0006\u0002\u0010\u000f\u001a\u001a\u0010\u0010\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0003*\u00020\u00062\u0006\u0010\f\u001a\u00020\bH\u0002\u00a8\u0006\u0011"}, d2={"getBoxMethodOrNull", "Ljava/lang/reflect/Method;", "aClass", "Ljava/lang/Class;", "getGeneratedClass", "classLoader", "Ljava/lang/ClassLoader;", "className", "", "runBoxMethod", "method", "getMethodOrNull", "name", "parameterTypes", "", "(Ljava/lang/Class;Ljava/lang/String;[Ljava/lang/Class;)Ljava/lang/reflect/Method;", "loadClassOrNull", "tests-common-jvm6"})
public final class TestProcessServerKt {
    private static final Class<?> loadClassOrNull(ClassLoader $this$loadClassOrNull, String name2) {
        Class<?> clazz;
        try {
            clazz = $this$loadClassOrNull.loadClass(name2);
        }
        catch (ClassNotFoundException e) {
            clazz = null;
        }
        return clazz;
    }

    private static final Method getMethodOrNull(Class<?> $this$getMethodOrNull, String name2, Class<?> ... parameterTypes) {
        Method method;
        try {
            method = $this$getMethodOrNull.getMethod(name2, Arrays.copyOf(parameterTypes, parameterTypes.length));
        }
        catch (NoSuchMethodException e) {
            method = null;
        }
        return method;
    }

    @NotNull
    public static final Class<?> getGeneratedClass(@NotNull ClassLoader classLoader, @NotNull String className) {
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Class<?> clazz = TestProcessServerKt.loadClassOrNull(classLoader, className);
        if (clazz == null) {
            throw new IllegalStateException(("No class file was generated for: " + className).toString());
        }
        return clazz;
    }

    @Nullable
    public static final Method getBoxMethodOrNull(@NotNull Class<?> aClass) {
        Intrinsics.checkNotNullParameter(aClass, (String)"aClass");
        Method method = TestProcessServerKt.getMethodOrNull(aClass, "box", new Class[0]);
        if (method == null) {
            Method method2;
            Class[] classArray;
            Class<?> it;
            ClassLoader classLoader = aClass.getClassLoader();
            Intrinsics.checkNotNullExpressionValue((Object)classLoader, (String)"aClass.classLoader");
            Class<?> clazz = TestProcessServerKt.loadClassOrNull(classLoader, "kotlin.coroutines.Continuation");
            if (clazz != null) {
                it = clazz;
                boolean bl = false;
                classArray = new Class[]{it};
                method2 = TestProcessServerKt.getMethodOrNull(aClass, "box", classArray);
            } else {
                method2 = method = null;
            }
            if (method2 == null) {
                ClassLoader classLoader2 = aClass.getClassLoader();
                Intrinsics.checkNotNullExpressionValue((Object)classLoader2, (String)"aClass.classLoader");
                Class<?> clazz2 = TestProcessServerKt.loadClassOrNull(classLoader2, "kotlin.coroutines.experimental.Continuation");
                if (clazz2 != null) {
                    it = clazz2;
                    boolean bl = false;
                    classArray = new Class[]{it};
                    method = TestProcessServerKt.getMethodOrNull(aClass, "box", classArray);
                } else {
                    method = null;
                }
            }
        }
        return method;
    }

    @Nullable
    public static final String runBoxMethod(@NotNull Method method) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Class<?>[] classArray = method.getParameterTypes();
        Intrinsics.checkNotNullExpressionValue(classArray, (String)"method.parameterTypes");
        if (((Object[])classArray).length == 0) {
            Object object2 = method.invoke(null, new Object[0]);
            return object2 instanceof String ? (String)object2 : null;
        }
        Class<?> emptyContinuationClass = method.getDeclaringClass().getClassLoader().loadClass("helpers.ResultContinuation");
        Constructor<?>[] constructorArray = emptyContinuationClass.getDeclaredConstructors();
        Intrinsics.checkNotNullExpressionValue(constructorArray, (String)"emptyContinuationClass.declaredConstructors");
        Object emptyContinuation = ((Constructor)ArraysKt.single((Object[])constructorArray)).newInstance(new Object[0]);
        Object[] objectArray = new Object[]{emptyContinuation};
        Object result = method.invoke(null, objectArray);
        Object resultAfterSuspend = emptyContinuationClass.getField("result").get(emptyContinuation);
        Object object3 = resultAfterSuspend;
        if (object3 == null) {
            object3 = result;
        }
        return (object = object3) instanceof String ? (String)object : null;
    }
}

