/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.backend.handlers;

import com.sun.jdi.Location;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.LocatableEvent;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.test.backend.handlers.DebugRunner;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.utils.SteppingTestLoggedData;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\u0005\u001a\u00020\u00062\u0016\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\t0\bj\b\u0012\u0004\u0012\u00020\t`\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/test/backend/handlers/SteppingDebugRunner;", "Lorg/jetbrains/kotlin/test/backend/handlers/DebugRunner;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "storeStep", "", "loggedItems", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/test/utils/SteppingTestLoggedData;", "Lkotlin/collections/ArrayList;", "event", "Lcom/sun/jdi/event/Event;", "tests-common-new"})
public final class SteppingDebugRunner
extends DebugRunner {
    public SteppingDebugRunner(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        super(testServices);
    }

    @Override
    public void storeStep(@NotNull ArrayList<SteppingTestLoggedData> loggedItems, @NotNull Event event) {
        Intrinsics.checkNotNullParameter(loggedItems, (String)"loggedItems");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        boolean bl = event instanceof LocatableEvent;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        Location location = ((LocatableEvent)event).location();
        int n = location.lineNumber();
        boolean bl2 = location.method().isSynthetic();
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"location");
        loggedItems.add(new SteppingTestLoggedData(n, bl2, this.formatAsExpectation(location)));
    }
}

