/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner;

import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class FormPreviewFrame {
    private JComponent myComponent;
    private static final ResourceBundle ourBundle = ResourceBundle.getBundle("RuntimeBundle");

    public static void main(String[] args) {
        UIManager.LookAndFeelInfo[] lafs;
        FormPreviewFrame f = new FormPreviewFrame();
        JFrame frame = new JFrame(ourBundle.getString("form.preview.title"));
        frame.setContentPane(f.myComponent);
        frame.setDefaultCloseOperation(3);
        JMenuBar menuBar = new JMenuBar();
        frame.setJMenuBar(menuBar);
        JMenu menuFile = new JMenu(ourBundle.getString("form.menu.preview"));
        menuFile.setMnemonic(ourBundle.getString("form.menu.preview.mnemonic").charAt(0));
        menuFile.add(new JMenuItem(new MyPackAction(frame)));
        menuFile.add(new JMenuItem(new MyExitAction()));
        menuBar.add(menuFile);
        JMenu viewMenu = new JMenu(ourBundle.getString("form.menu.laf"));
        viewMenu.setMnemonic(ourBundle.getString("form.menu.laf.mnemonic").charAt(0));
        menuBar.add(viewMenu);
        for (UIManager.LookAndFeelInfo laf : lafs = UIManager.getInstalledLookAndFeels()) {
            viewMenu.add(new MySetLafAction(frame, laf));
        }
        frame.pack();
        Rectangle screenBounds = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getBounds();
        frame.setLocation(screenBounds.x + (screenBounds.width - frame.getWidth()) / 2, screenBounds.y + (screenBounds.height - frame.getHeight()) / 2);
        frame.setVisible(true);
    }

    private static final class MySetLafAction
    extends AbstractAction {
        private final JFrame myFrame;
        private final UIManager.LookAndFeelInfo myInfo;

        MySetLafAction(JFrame frame, UIManager.LookAndFeelInfo info) {
            this(frame, info, info.getName());
        }

        MySetLafAction(JFrame frame, UIManager.LookAndFeelInfo info, String name2) {
            super(name2);
            this.myFrame = frame;
            this.myInfo = info;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                UIManager.setLookAndFeel(this.myInfo.getClassName());
                SwingUtilities.updateComponentTreeUI(this.myFrame);
                Dimension prefSize = this.myFrame.getPreferredSize();
                if (prefSize.width > this.myFrame.getWidth() || prefSize.height > this.myFrame.getHeight()) {
                    this.myFrame.pack();
                }
            }
            catch (Exception exc) {
                JOptionPane.showMessageDialog(this.myFrame, MessageFormat.format(ourBundle.getString("error.cannot.change.look.feel"), exc.getMessage()), ourBundle.getString("error.title"), 0);
            }
        }
    }

    private static final class MyPackAction
    extends AbstractAction {
        private final JFrame myFrame;

        MyPackAction(JFrame frame) {
            super(ourBundle.getString("form.menu.view.pack"));
            this.myFrame = frame;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.myFrame.pack();
        }
    }

    private static final class MyExitAction
    extends AbstractAction {
        MyExitAction() {
            super(ourBundle.getString("form.menu.file.exit"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            System.exit(0);
        }
    }
}

