/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.frontend.fir;

import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.test.WrappedException;
import org.jetbrains.kotlin.test.frontend.fir.FirFrontendFacade;
import org.jetbrains.kotlin.test.model.AfterAnalysisChecker;
import org.jetbrains.kotlin.test.model.FrontendKinds;
import org.jetbrains.kotlin.test.services.TestModuleStructureKt;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.utils.FileUtilsKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \t2\u00020\u0001:\u0001\tB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/test/frontend/fir/FirFailingTestSuppressor;", "Lorg/jetbrains/kotlin/test/model/AfterAnalysisChecker;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "suppressIfNeeded", "", "Lorg/jetbrains/kotlin/test/WrappedException;", "failedAssertions", "Companion", "tests-common-new"})
public final class FirFailingTestSuppressor
extends AfterAnalysisChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String INCONSISTENT_DIAGNOSTICS = "INCONSISTENT_DIAGNOSTICS";

    public FirFailingTestSuppressor(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        super(testServices);
    }

    @Override
    @NotNull
    public List<WrappedException> suppressIfNeeded(@NotNull List<? extends WrappedException> failedAssertions) {
        boolean hasFail;
        String failReason;
        File failFile;
        block5: {
            boolean bl;
            File file;
            Intrinsics.checkNotNullParameter(failedAssertions, (String)"failedAssertions");
            File testFile = FileUtilsKt.getFirTestDataFile((File)CollectionsKt.first(TestModuleStructureKt.getModuleStructure(this.getTestServices()).getOriginalTestDataFiles()));
            File file2 = testFile.getParentFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"testFile.parentFile");
            File it = file = FilesKt.resolve((File)file2, (String)(FilesKt.getNameWithoutExtension((File)testFile) + ".fail"));
            boolean bl2 = false;
            File file3 = it.exists() ? file : null;
            if (file3 == null) {
                return failedAssertions;
            }
            failFile = file3;
            failReason = ((Object)StringsKt.trim((CharSequence)FilesKt.readText$default((File)failFile, null, (int)1, null))).toString();
            Iterable $this$any$iv = failedAssertions;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    WrappedException it2 = (WrappedException)element$iv;
                    boolean bl3 = false;
                    WrappedException wrappedException = it2;
                    boolean bl4 = wrappedException instanceof WrappedException.FromFacade ? ((WrappedException.FromFacade)it2).getFacade() instanceof FirFrontendFacade : (wrappedException instanceof WrappedException.FromHandler ? Intrinsics.areEqual(((WrappedException.FromHandler)it2).getHandler().getArtifactKind(), (Object)FrontendKinds.FIR.INSTANCE) : false);
                    if (!bl4) continue;
                    bl = true;
                    break block5;
                }
                bl = hasFail = false;
            }
        }
        if (hasFail || Intrinsics.areEqual((Object)failReason, (Object)INCONSISTENT_DIAGNOSTICS)) {
            return CollectionsKt.emptyList();
        }
        return CollectionsKt.plus((Collection)failedAssertions, (Object)this.wrap((Throwable)((Object)new AssertionError((Object)("Fail file exists but no exception was thrown. Please remove " + failFile.getName())))));
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/test/frontend/fir/FirFailingTestSuppressor$Companion;", "", "()V", "INCONSISTENT_DIAGNOSTICS", "", "tests-common-new"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

