/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.clientserver;

import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.test.clientserver.ServerTest;
import org.jetbrains.kotlin.test.clientserver.TestProcessServer;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\u0017H\u0007\u00a2\u0006\u0002\u0010\u0018J\u0010\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u0004H\u0002J\b\u0010\u001b\u001a\u00020\u0015H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u0006\u0012\u0002\b\u00030\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/test/clientserver/TestProcessServer;", "", "()V", "DEBUG_TEST", "", "allocatePort", "", "executor", "Ljava/util/concurrent/ExecutorService;", "handler", "Ljava/util/concurrent/ScheduledFuture;", "isProcessingTask", "lastTime", "", "scheduler", "Ljava/util/concurrent/ScheduledExecutorService;", "kotlin.jvm.PlatformType", "serverSocket", "Ljava/net/ServerSocket;", "suppressOutput", "main", "", "args", "", "([Ljava/lang/String;)V", "printlnTest", "text", "scheduleShutdownProcess", "tests-common-jvm6"})
public final class TestProcessServer {
    @NotNull
    public static final TestProcessServer INSTANCE = new TestProcessServer();
    @NotNull
    public static final String DEBUG_TEST = "--debugTest";
    @NotNull
    private static final ExecutorService executor;
    private static volatile boolean isProcessingTask;
    private static volatile long lastTime;
    private static final ScheduledExecutorService scheduler;
    private static ScheduledFuture<?> handler;
    private static ServerSocket serverSocket;
    private static boolean suppressOutput;
    private static boolean allocatePort;

    private TestProcessServer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    public static final void main(@NotNull String[] args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        if (Intrinsics.areEqual((Object)args[0], (Object)DEBUG_TEST)) {
            suppressOutput = true;
            allocatePort = true;
        }
        int portNumber = allocatePort ? 0 : Integer.parseInt(args[0]);
        System.out.println((Object)("Starting server on port " + portNumber + "..."));
        ServerSocket serverSocket = new ServerSocket(portNumber);
        System.out.println((Object)("...server started on port " + serverSocket.getLocalPort()));
        INSTANCE.scheduleShutdownProcess();
        try {
            while (true) {
                lastTime = System.currentTimeMillis();
                isProcessingTask = false;
                Socket clientSocket = serverSocket.accept();
                isProcessingTask = true;
                System.out.println((Object)"Socket established...");
                Intrinsics.checkNotNullExpressionValue((Object)clientSocket, (String)"clientSocket");
                executor.execute(new ServerTest(clientSocket, suppressOutput));
            }
        }
        catch (Throwable throwable) {
            ScheduledFuture<?> scheduledFuture = handler;
            if (scheduledFuture == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"handler");
                scheduledFuture = null;
            }
            scheduledFuture.cancel(false);
            scheduler.shutdown();
            serverSocket.close();
            System.out.println((Object)"Server stopped!");
            throw throwable;
        }
    }

    private final void scheduleShutdownProcess() {
        ScheduledFuture<?> scheduledFuture = scheduler.scheduleAtFixedRate(scheduleShutdownProcess.1.INSTANCE, 60L, 60L, TimeUnit.SECONDS);
        Intrinsics.checkNotNullExpressionValue(scheduledFuture, (String)"scheduler.scheduleAtFixe\u202660, 60, TimeUnit.SECONDS)");
        handler = scheduledFuture;
    }

    private final void printlnTest(String text) {
        if (!suppressOutput) {
            System.out.println((Object)text);
        }
    }

    public static final /* synthetic */ boolean access$isProcessingTask$p() {
        return isProcessingTask;
    }

    public static final /* synthetic */ long access$getLastTime$p() {
        return lastTime;
    }

    public static final /* synthetic */ ServerSocket access$getServerSocket$p() {
        return serverSocket;
    }

    static {
        ExecutorService executorService = Executors.newFixedThreadPool(1);
        Intrinsics.checkNotNull((Object)executorService);
        executor = executorService;
        isProcessingTask = true;
        lastTime = System.currentTimeMillis();
        scheduler = Executors.newScheduledThreadPool(1);
    }
}

