/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.backend.handlers;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.checkers.utils.DiagnosticsRenderingConfiguration;
import org.jetbrains.kotlin.cli.common.messages.AnalyzerWithCompilerReport;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtils;
import org.jetbrains.kotlin.diagnostics.KtDiagnostic;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticRenderer;
import org.jetbrains.kotlin.diagnostics.PsiDiagnosticUtils;
import org.jetbrains.kotlin.diagnostics.impl.BaseDiagnosticsCollector;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.KtDefaultJvmErrorMessages;
import org.jetbrains.kotlin.test.Assertions;
import org.jetbrains.kotlin.test.backend.handlers.JvmBinaryArtifactHandler;
import org.jetbrains.kotlin.test.directives.DiagnosticsDirectives;
import org.jetbrains.kotlin.test.frontend.classic.ClassicFrontendOutputArtifact;
import org.jetbrains.kotlin.test.frontend.classic.handlers.ClassicDiagnosticReporter;
import org.jetbrains.kotlin.test.frontend.classic.handlers.ClassicDiagnosticReporterKt;
import org.jetbrains.kotlin.test.frontend.fir.FirOutputArtifact;
import org.jetbrains.kotlin.test.frontend.fir.handlers.FirDiagnosticsHandlerKt;
import org.jetbrains.kotlin.test.model.BinaryArtifacts;
import org.jetbrains.kotlin.test.model.FrontendKind;
import org.jetbrains.kotlin.test.model.FrontendKinds;
import org.jetbrains.kotlin.test.model.TestFile;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.AssertionsKt;
import org.jetbrains.kotlin.test.services.DependencyProviderKt;
import org.jetbrains.kotlin.test.services.GlobalMetadataInfoHandler;
import org.jetbrains.kotlin.test.services.GlobalMetadataInfoHandlerKt;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.util.capitalizeDecapitalize.CapitalizeDecapitalizeKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001c\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\u0019\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u001a\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/test/backend/handlers/JvmBackendDiagnosticsHandler;", "Lorg/jetbrains/kotlin/test/backend/handlers/JvmBinaryArtifactHandler;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "reporter", "Lorg/jetbrains/kotlin/test/frontend/classic/handlers/ClassicDiagnosticReporter;", "checkFullDiagnosticRender", "", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "info", "Lorg/jetbrains/kotlin/test/model/BinaryArtifacts$Jvm;", "getKtFiles", "", "Lorg/jetbrains/kotlin/test/model/TestFile;", "Lorg/jetbrains/kotlin/psi/KtFile;", "getLineAndColumnRange", "Lorg/jetbrains/kotlin/diagnostics/PsiDiagnosticUtils$LineAndColumnRange;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/KtDiagnostic;", "processAfterAllModules", "someAssertionWasFailed", "", "processModule", "reportDiagnostics", "reportKtDiagnostics", "tests-common-new"})
public final class JvmBackendDiagnosticsHandler
extends JvmBinaryArtifactHandler {
    @NotNull
    private final ClassicDiagnosticReporter reporter;

    public JvmBackendDiagnosticsHandler(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        super(testServices, false, 2, null);
        this.reporter = new ClassicDiagnosticReporter(testServices);
    }

    @Override
    public void processModule(@NotNull TestModule module, @NotNull BinaryArtifacts.Jvm info) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        this.reportDiagnostics(module, info);
        this.reportKtDiagnostics(module, info);
        this.checkFullDiagnosticRender(module, info);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<TestFile, KtFile> getKtFiles(TestModule module) {
        Map map;
        FrontendKind<?> frontendKind = module.getFrontendKind();
        if (Intrinsics.areEqual(frontendKind, (Object)FrontendKinds.ClassicFrontend.INSTANCE)) {
            map = ((ClassicFrontendOutputArtifact)DependencyProviderKt.getDependencyProvider(this.getTestServices()).getArtifact(module, FrontendKinds.ClassicFrontend.INSTANCE)).getKtFiles();
        } else if (Intrinsics.areEqual(frontendKind, (Object)FrontendKinds.FIR.INSTANCE)) {
            void $this$associateTo$iv$iv;
            Iterable $this$associate$iv = ((FirOutputArtifact)DependencyProviderKt.getDependencyProvider(this.getTestServices()).getArtifact(module, FrontendKinds.FIR.INSTANCE)).getFirFiles().entrySet();
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            Iterable iterable = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map2 = destination$iv$iv;
                Map.Entry it = (Map.Entry)element$iv$iv;
                boolean bl = false;
                Object k = it.getKey();
                PsiElement psiElement = UtilsKt.getPsi((FirElement)((FirElement)it.getValue()));
                Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
                Pair pair = TuplesKt.to(k, (Object)((KtFile)psiElement));
                map2.put(pair.getFirst(), pair.getSecond());
            }
            map = destination$iv$iv;
        } else {
            AssertionsKt.getAssertions(this.getTestServices()).fail((Function0<String>)((Function0)new Function0<String>(module){
                final /* synthetic */ TestModule $module;
                {
                    this.$module = $module;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Unknown frontend kind " + this.$module.getFrontendKind();
                }
            }));
            throw null;
        }
        return map;
    }

    @Override
    public void processAfterAllModules(boolean someAssertionWasFailed) {
    }

    private final PsiDiagnosticUtils.LineAndColumnRange getLineAndColumnRange(KtDiagnostic diagnostic) {
        PsiFile file = diagnostic.getPsiElement().getContainingFile();
        List textRanges = diagnostic.getTextRanges();
        PsiDiagnosticUtils.LineAndColumnRange lineAndColumnRange = DiagnosticUtils.getLineAndColumnRange((PsiFile)file, (List)textRanges);
        Intrinsics.checkNotNullExpressionValue((Object)lineAndColumnRange, (String)"getLineAndColumnRange(file, textRanges)");
        return lineAndColumnRange;
    }

    /*
     * WARNING - void declaration
     */
    private final void reportDiagnostics(TestModule module, BinaryArtifacts.Jvm info) {
        Map map;
        void $this$associateTo$iv$iv;
        Map<TestFile, KtFile> testFileToKtFileMap = this.getKtFiles(module);
        Iterable $this$associate$iv = testFileToKtFileMap.entrySet();
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            map = destination$iv$iv;
            Map.Entry it = (Map.Entry)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to(it.getValue(), it.getKey());
            map.put(pair.getFirst(), pair.getSecond());
        }
        Map ktFileToTestFileMap = destination$iv$iv;
        GenerationState generationState = info.getClassFileFactory().getGenerationState();
        DiagnosticsRenderingConfiguration configuration2 = this.reporter.createConfiguration(module);
        boolean withNewInferenceModeEnabled = ClassicDiagnosticReporterKt.withNewInferenceModeEnabled(this.getTestServices());
        Collection diagnostics = generationState.getCollectedExtraJvmDiagnostics().all();
        for (Diagnostic diagnostic : diagnostics) {
            TestFile testFile;
            KtFile ktFile;
            map = diagnostic.getPsiFile();
            KtFile ktFile2 = map instanceof KtFile ? (KtFile)map : null;
            if (ktFile2 == null || (TestFile)ktFileToTestFileMap.get(ktFile = ktFile2) == null) continue;
            this.reporter.reportDiagnostic(diagnostic, module, testFile, configuration2, withNewInferenceModeEnabled);
        }
    }

    private final void reportKtDiagnostics(TestModule module, BinaryArtifacts.Jvm info) {
        Map<TestFile, KtFile> testFileToKtFileMap = this.getKtFiles(module);
        GenerationState generationState = info.getClassFileFactory().getGenerationState();
        DiagnosticReporter diagnosticReporter = generationState.getDiagnosticReporter();
        Intrinsics.checkNotNull((Object)diagnosticReporter, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.diagnostics.impl.BaseDiagnosticsCollector");
        BaseDiagnosticsCollector ktDiagnosticReporter = (BaseDiagnosticsCollector)diagnosticReporter;
        GlobalMetadataInfoHandler globalMetadataInfoHandler = GlobalMetadataInfoHandlerKt.getGlobalMetadataInfoHandler(this.getTestServices());
        for (Map.Entry<TestFile, KtFile> entry : testFileToKtFileMap.entrySet()) {
            List ktDiagnostics;
            TestFile testFile = entry.getKey();
            KtFile ktFile = entry.getValue();
            if ((List)ktDiagnosticReporter.getDiagnosticsByFilePath().get(ktFile.getVirtualFilePath()) == null) continue;
            Iterable $this$forEach$iv = ktDiagnostics;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KtDiagnostic it = (KtDiagnostic)element$iv;
                boolean bl = false;
                List metaInfos = FirDiagnosticsHandlerKt.toMetaInfos$default(it, testFile, globalMetadataInfoHandler, false, false, false, 16, null);
                globalMetadataInfoHandler.addMetadataInfosForFile(testFile, metaInfos);
            }
        }
    }

    private final void checkFullDiagnosticRender(TestModule module, BinaryArtifacts.Jvm info) {
        if (!module.getDirectives().contains(DiagnosticsDirectives.INSTANCE.getRENDER_DIAGNOSTICS_FULL_TEXT())) {
            return;
        }
        Map<TestFile, KtFile> testFileToKtFileMap = this.getKtFiles(module);
        GenerationState generationState = info.getClassFileFactory().getGenerationState();
        DiagnosticReporter diagnosticReporter = generationState.getDiagnosticReporter();
        Intrinsics.checkNotNull((Object)diagnosticReporter, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.diagnostics.impl.BaseDiagnosticsCollector");
        BaseDiagnosticsCollector ktDiagnosticReporter = (BaseDiagnosticsCollector)diagnosticReporter;
        List reportedDiagnostics = new ArrayList();
        for (KtFile ktFile : testFileToKtFileMap.values()) {
            List ktDiagnostics;
            if ((List)ktDiagnosticReporter.getDiagnosticsByFilePath().get(ktFile.getVirtualFilePath()) == null) continue;
            Iterable $this$forEach$iv = ktDiagnostics;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KtDiagnostic it = (KtDiagnostic)element$iv;
                boolean bl = false;
                String severity = CapitalizeDecapitalizeKt.toLowerCaseAsciiOnly((String)AnalyzerWithCompilerReport.Companion.convertSeverity(it.getSeverity()).toString());
                KtDiagnosticRenderer ktDiagnosticRenderer = KtDefaultJvmErrorMessages.INSTANCE.getMAP().get(it.getFactory());
                String message = ktDiagnosticRenderer != null ? ktDiagnosticRenderer.render(it) : null;
                PsiDiagnosticUtils.LineAndColumn position = this.getLineAndColumnRange(it).getStart();
                ((Collection)reportedDiagnostics).add('/' + ktFile.getName() + ':' + position.getLine() + ':' + position.getColumn() + ": " + severity + ": " + message);
            }
        }
        if (!((Collection)reportedDiagnostics).isEmpty()) {
            Assertions.assertEqualsToFile$default((Assertions)AssertionsKt.getAssertions(this.getTestServices()), new File(FileUtil.getNameWithoutExtension((String)((TestFile)CollectionsKt.first((Iterable)testFileToKtFileMap.keySet())).getOriginalFile().getAbsolutePath()) + ".diag.txt"), CollectionsKt.joinToString$default((Iterable)reportedDiagnostics, (CharSequence)"\n\n", null, null, (int)0, null, null, (int)62, null), null, 4, null);
        }
    }
}

