/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.services.configuration;

import com.intellij.openapi.project.Project;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.config.AnalysisFlag;
import org.jetbrains.kotlin.config.AnalysisFlags;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.impl.ModuleDescriptorImpl;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.TranslationMode;
import org.jetbrains.kotlin.js.config.EcmaVersion;
import org.jetbrains.kotlin.js.config.ErrorTolerancePolicy;
import org.jetbrains.kotlin.js.config.JSConfigurationKeys;
import org.jetbrains.kotlin.js.config.JsConfig;
import org.jetbrains.kotlin.js.config.SourceMapSourceEmbedding;
import org.jetbrains.kotlin.js.facade.MainCallParameters;
import org.jetbrains.kotlin.library.KotlinLibrary;
import org.jetbrains.kotlin.resolve.CompilerEnvironment;
import org.jetbrains.kotlin.resolve.TargetEnvironment;
import org.jetbrains.kotlin.serialization.js.JsModuleDescriptor;
import org.jetbrains.kotlin.serialization.js.KotlinJavaScriptLibraryParts;
import org.jetbrains.kotlin.serialization.js.KotlinJavascriptSerializationUtil;
import org.jetbrains.kotlin.serialization.js.ModuleKind;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.directives.ConfigurationDirectives;
import org.jetbrains.kotlin.test.directives.JsEnvironmentConfigurationDirectives;
import org.jetbrains.kotlin.test.directives.model.DirectivesContainer;
import org.jetbrains.kotlin.test.directives.model.RegisteredDirectives;
import org.jetbrains.kotlin.test.directives.model.SimpleDirective;
import org.jetbrains.kotlin.test.frontend.classic.ModuleDescriptorProviderKt;
import org.jetbrains.kotlin.test.model.ArtifactKinds;
import org.jetbrains.kotlin.test.model.BinaryArtifacts;
import org.jetbrains.kotlin.test.model.DependencyDescription;
import org.jetbrains.kotlin.test.model.DependencyRelation;
import org.jetbrains.kotlin.test.model.TestFile;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.DependencyProviderKt;
import org.jetbrains.kotlin.test.services.EnvironmentConfigurator;
import org.jetbrains.kotlin.test.services.JsLibraryProvider;
import org.jetbrains.kotlin.test.services.JsLibraryProviderKt;
import org.jetbrains.kotlin.test.services.KotlinTestInfoKt;
import org.jetbrains.kotlin.test.services.RuntimeClasspathProvider;
import org.jetbrains.kotlin.test.services.RuntimeClasspathProviderKt;
import org.jetbrains.kotlin.test.services.TemporaryDirectoryManager;
import org.jetbrains.kotlin.test.services.TemporaryDirectoryManagerKt;
import org.jetbrains.kotlin.test.services.TestModuleStructureKt;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.util.StringUtilsKt;
import org.jetbrains.kotlin.util.capitalizeDecapitalize.CapitalizeDecapitalizeKt;
import org.jetbrains.kotlin.utils.JsMetadataVersion;
import org.jetbrains.kotlin.utils.KotlinJavascriptMetadata;
import org.jetbrains.kotlin.utils.KotlinJavascriptMetadataUtils;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J*\u0010\u0010\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u00112\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0012\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019*\u00020\u000fH\u0002R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/test/services/configuration/JsEnvironmentConfigurator;", "Lorg/jetbrains/kotlin/test/services/EnvironmentConfigurator;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "directiveContainers", "", "Lorg/jetbrains/kotlin/test/directives/model/DirectivesContainer;", "getDirectiveContainers", "()Ljava/util/List;", "configureCompilerConfiguration", "", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "provideAdditionalAnalysisFlags", "", "Lorg/jetbrains/kotlin/config/AnalysisFlag;", "", "directives", "Lorg/jetbrains/kotlin/test/directives/model/RegisteredDirectives;", "languageVersion", "Lorg/jetbrains/kotlin/config/LanguageVersion;", "allTransitiveDependencies", "", "Lorg/jetbrains/kotlin/test/model/DependencyDescription;", "Companion", "tests-common-new"})
public final class JsEnvironmentConfigurator
extends EnvironmentConfigurator {
    @NotNull
    public static final Companion Companion;
    @NotNull
    public static final String TEST_DATA_DIR_PATH = "js/js.translator/testData";
    @NotNull
    public static final String OLD_MODULE_SUFFIX = "_old";
    @NotNull
    private static final Map<TranslationMode, String> outputDirByMode;
    @NotNull
    private static final String OUTPUT_KLIB_DIR_NAME = "outputKlibDir";
    @NotNull
    private static final String MINIFICATION_OUTPUT_DIR_NAME = "minOutputDir";
    @NotNull
    private static final List<JsModuleDescriptor<KotlinJavaScriptLibraryParts>> METADATA_CACHE;

    public JsEnvironmentConfigurator(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        super(testServices);
    }

    @Override
    @NotNull
    public List<DirectivesContainer> getDirectiveContainers() {
        return CollectionsKt.listOf((Object)JsEnvironmentConfigurationDirectives.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    private final Set<DependencyDescription> allTransitiveDependencies(TestModule $this$allTransitiveDependencies) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        List<TestModule> modules = TestModuleStructureKt.getModuleStructure(this.getTestServices()).getModules();
        Iterable iterable = $this$allTransitiveDependencies.getRegularDependencies();
        Set set = CollectionsKt.toSet((Iterable)$this$allTransitiveDependencies.getRegularDependencies());
        boolean $i$f$flatMap = false;
        void var5_6 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$single$iv;
            DependencyDescription it = (DependencyDescription)element$iv$iv;
            boolean bl = false;
            Iterable iterable2 = modules;
            JsEnvironmentConfigurator jsEnvironmentConfigurator = this;
            boolean $i$f$single = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$single$iv) {
                TestModule module = (TestModule)element$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)module.getName(), (Object)it.getModuleName())) continue;
                if (found$iv) {
                    throw new IllegalArgumentException("Collection contains more than one matching element.");
                }
                single$iv = element$iv;
                found$iv = true;
            }
            if (!found$iv) {
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            Iterable list$iv$iv = jsEnvironmentConfigurator.allTransitiveDependencies(single$iv);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return SetsKt.plus((Set)set, (Iterable)((List)destination$iv$iv));
    }

    @Override
    @NotNull
    public Map<AnalysisFlag<?>, Object> provideAdditionalAnalysisFlags(@NotNull RegisteredDirectives directives2, @NotNull LanguageVersion languageVersion) {
        Map map;
        Intrinsics.checkNotNullParameter((Object)directives2, (String)"directives");
        Intrinsics.checkNotNullParameter((Object)languageVersion, (String)"languageVersion");
        Map it = map = MapsKt.toMutableMap(super.provideAdditionalAnalysisFlags(directives2, languageVersion));
        boolean bl = false;
        it.put(AnalysisFlags.getAllowFullyQualifiedNameInKClass(), false);
        return map;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void configureCompilerConfiguration(@NotNull CompilerConfiguration configuration2, @NotNull TestModule module) {
        void $this$mapTo$iv$iv;
        List list;
        void $this$mapTo$iv$iv2;
        void $this$mapTo$iv$iv3;
        Collection collection;
        void $this$mapTo$iv$iv4;
        ModuleKind moduleKind;
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        RegisteredDirectives registeredDirectives = module.getDirectives();
        List<ModuleKind> moduleKinds = registeredDirectives.get(JsEnvironmentConfigurationDirectives.INSTANCE.getMODULE_KIND());
        switch (moduleKinds.size()) {
            case 0: {
                moduleKind = (ModuleKind)CollectionsKt.singleOrNull(TestModuleStructureKt.getModuleStructure(this.getTestServices()).getAllDirectives().get(JsEnvironmentConfigurationDirectives.INSTANCE.getMODULE_KIND()));
                if (moduleKind != null) break;
                if (registeredDirectives.contains(JsEnvironmentConfigurationDirectives.INSTANCE.getES_MODULES())) {
                    moduleKind = ModuleKind.ES;
                    break;
                }
                moduleKind = ModuleKind.PLAIN;
                break;
            }
            case 1: {
                moduleKind = (ModuleKind)CollectionsKt.single(moduleKinds);
                break;
            }
            default: {
                throw new IllegalStateException(("Too many module kinds passed " + StringUtilsKt.joinToArrayString((Iterable)moduleKinds)).toString());
            }
        }
        ModuleKind moduleKind2 = moduleKind;
        configuration2.put(JSConfigurationKeys.MODULE_KIND, (Object)moduleKind2);
        boolean noInline = registeredDirectives.contains(JsEnvironmentConfigurationDirectives.INSTANCE.getNO_INLINE());
        configuration2.put(CommonConfigurationKeys.DISABLE_INLINE, (Object)noInline);
        Iterable $this$map$iv = module.getRegularDependencies();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv4) {
            void it;
            DependencyDescription dependencyDescription = (DependencyDescription)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(org.jetbrains.kotlin.test.services.configuration.JsEnvironmentConfigurator$Companion.getJsModuleArtifactPath$default(Companion, this.getTestServices(), it.getModuleName(), null, 4, null) + ".meta.js");
        }
        List dependencies = (List)destination$iv$iv;
        Iterable $this$map$iv2 = this.allTransitiveDependencies(module);
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            void it;
            DependencyDescription bl = (DependencyDescription)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(org.jetbrains.kotlin.test.services.configuration.JsEnvironmentConfigurator$Companion.getJsModuleArtifactPath$default(Companion, this.getTestServices(), it.getModuleName(), null, 4, null) + ".meta.js");
        }
        List allDependencies = (List)destination$iv$iv2;
        Iterable $this$map$iv3 = module.getFriendDependencies();
        boolean $i$f$map3 = false;
        destination$iv$iv2 = $this$map$iv3;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            DependencyDescription bl2 = (DependencyDescription)item$iv$iv;
            collection = destination$iv$iv3;
            boolean bl = false;
            collection.add(org.jetbrains.kotlin.test.services.configuration.JsEnvironmentConfigurator$Companion.getJsModuleArtifactPath$default(Companion, this.getTestServices(), it.getModuleName(), null, 4, null) + ".meta.js");
        }
        List friends = (List)destination$iv$iv3;
        TargetBackend targetBackend = module.getTargetBackend();
        switch (targetBackend == null ? -1 : WhenMappings.$EnumSwitchMapping$0[targetBackend.ordinal()]) {
            case -1: {
                List list2 = JsConfig.JS_STDLIB;
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"JS_STDLIB");
                Collection collection2 = list2;
                List list3 = JsConfig.JS_KOTLIN_TEST;
                Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"JS_KOTLIN_TEST");
                list = CollectionsKt.plus((Collection)collection2, (Iterable)list3);
                break;
            }
            case 1: {
                list = dependencies;
                break;
            }
            case 2: {
                List list4 = JsConfig.JS_STDLIB;
                Intrinsics.checkNotNullExpressionValue((Object)list4, (String)"JS_STDLIB");
                Collection collection3 = list4;
                List list5 = JsConfig.JS_KOTLIN_TEST;
                Intrinsics.checkNotNullExpressionValue((Object)list5, (String)"JS_KOTLIN_TEST");
                list = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)collection3, (Iterable)list5), (Iterable)dependencies);
                break;
            }
            default: {
                throw new IllegalStateException(("Unsupported target backend: " + (Object)((Object)module.getTargetBackend())).toString());
            }
        }
        List libraries = list;
        configuration2.put(JSConfigurationKeys.LIBRARIES, (Object)libraries);
        configuration2.put(JSConfigurationKeys.TRANSITIVE_LIBRARIES, (Object)allDependencies);
        configuration2.put(JSConfigurationKeys.FRIEND_PATHS, (Object)friends);
        configuration2.put(CommonConfigurationKeys.MODULE_NAME, (Object)StringsKt.removeSuffix((String)module.getName(), (CharSequence)OLD_MODULE_SUFFIX));
        configuration2.put(JSConfigurationKeys.TARGET, (Object)EcmaVersion.v5);
        ErrorTolerancePolicy errorTolerancePolicy = (ErrorTolerancePolicy)CollectionsKt.singleOrNull(registeredDirectives.get(JsEnvironmentConfigurationDirectives.INSTANCE.getERROR_POLICY()));
        if (errorTolerancePolicy == null) {
            errorTolerancePolicy = ErrorTolerancePolicy.Companion.getDEFAULT();
        }
        ErrorTolerancePolicy errorIgnorancePolicy = errorTolerancePolicy;
        configuration2.put(JSConfigurationKeys.ERROR_TOLERANCE_POLICY, (Object)errorIgnorancePolicy);
        if (errorIgnorancePolicy.getAllowErrors()) {
            configuration2.put(JSConfigurationKeys.DEVELOPER_MODE, (Object)true);
        }
        if (errorIgnorancePolicy != ErrorTolerancePolicy.Companion.getDEFAULT()) {
            configuration2.put(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY, (Object)MessageCollector.Companion.getNONE());
        }
        boolean multiModule = TestModuleStructureKt.getModuleStructure(this.getTestServices()).getModules().size() > 1;
        configuration2.put(JSConfigurationKeys.META_INFO, (Object)multiModule);
        Iterable $this$map$iv4 = module.getFiles();
        boolean $i$f$map4 = false;
        Iterable item$iv$iv = $this$map$iv4;
        Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv4, (int)10));
        boolean $i$f$mapTo4 = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
            void it;
            TestFile testFile = (TestFile)item$iv$iv2;
            collection = destination$iv$iv4;
            boolean bl = false;
            collection.add(it.getOriginalFile().getParent());
        }
        List sourceDirs = CollectionsKt.distinct((Iterable)((List)destination$iv$iv4));
        configuration2.put(JSConfigurationKeys.SOURCE_MAP_SOURCE_ROOTS, (Object)sourceDirs);
        configuration2.put(JSConfigurationKeys.SOURCE_MAP, (Object)true);
        SourceMapSourceEmbedding sourceMapSourceEmbedding = (SourceMapSourceEmbedding)CollectionsKt.singleOrNull(registeredDirectives.get(JsEnvironmentConfigurationDirectives.INSTANCE.getSOURCE_MAP_EMBED_SOURCES()));
        if (sourceMapSourceEmbedding == null) {
            sourceMapSourceEmbedding = SourceMapSourceEmbedding.NEVER;
        }
        SourceMapSourceEmbedding sourceMapSourceEmbedding2 = sourceMapSourceEmbedding;
        configuration2.put(JSConfigurationKeys.SOURCE_MAP_EMBED_SOURCES, (Object)sourceMapSourceEmbedding2);
        configuration2.put(JSConfigurationKeys.TYPED_ARRAYS_ENABLED, (Object)registeredDirectives.contains(JsEnvironmentConfigurationDirectives.INSTANCE.getTYPED_ARRAYS()));
        configuration2.put(JSConfigurationKeys.GENERATE_REGION_COMMENTS, (Object)true);
        String string = new File(".").getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"File(\".\").absolutePath");
        configuration2.put(JSConfigurationKeys.FILE_PATHS_PREFIX_MAP, (Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)StringsKt.removeSuffix((String)string, (CharSequence)"."), (Object)"")));
        configuration2.put(CommonConfigurationKeys.EXPECT_ACTUAL_LINKER, (Object)registeredDirectives.contains(JsEnvironmentConfigurationDirectives.INSTANCE.getEXPECT_ACTUAL_LINKER()));
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $this$flatMapTo$iv$iv;
        Companion = new Companion(null);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)TranslationMode.FULL, (Object)"out"), TuplesKt.to((Object)TranslationMode.FULL_DCE_MINIMIZED_NAMES, (Object)"outMin"), TuplesKt.to((Object)TranslationMode.PER_MODULE, (Object)"outPm"), TuplesKt.to((Object)TranslationMode.PER_MODULE_DCE_MINIMIZED_NAMES, (Object)"outPmMin")};
        outputDirByMode = MapsKt.mapOf((Pair[])pairArray);
        List list = JsConfig.JS_STDLIB;
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"JS_STDLIB");
        Collection collection = list;
        List list2 = JsConfig.JS_KOTLIN_TEST;
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"JS_KOTLIN_TEST");
        Iterable $this$flatMap$iv = CollectionsKt.plus((Collection)collection, (Iterable)list2);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            String path = (String)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"path");
            Iterable $this$map$iv = KotlinJavascriptMetadataUtils.loadMetadata((String)path);
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void metadata;
                KotlinJavascriptMetadata kotlinJavascriptMetadata = (KotlinJavascriptMetadata)item$iv$iv;
                Collection collection2 = destination$iv$iv2;
                boolean bl2 = false;
                KotlinJavaScriptLibraryParts parts = KotlinJavascriptSerializationUtil.readModuleAsProto((byte[])metadata.getBody(), (JsMetadataVersion)metadata.getVersion());
                collection2.add(new JsModuleDescriptor(metadata.getModuleName(), parts.getKind(), parts.getImportedModules(), (Object)parts));
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        METADATA_CACHE = (List)var3_3;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001<B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u0016J\u001c\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\"\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u00190\r2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ$\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00190\u00042\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\"J\u0016\u0010#\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020\bJ\u0018\u0010%\u001a\u00020&2\u0006\u0010\u001c\u001a\u00020\u001d2\b\b\u0002\u0010'\u001a\u00020\u000eJ\u0018\u0010(\u001a\u00020&2\u0006\u0010\u001c\u001a\u00020\u001d2\b\b\u0002\u0010'\u001a\u00020\u000eJ\u0016\u0010)\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020\bJ\u000e\u0010*\u001a\u00020&2\u0006\u0010\u001c\u001a\u00020\u001dJ \u0010+\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020\b2\b\b\u0002\u0010'\u001a\u00020\u000eJ$\u0010,\u001a\b\u0012\u0004\u0012\u00020&0\u00042\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\"J\u000e\u0010-\u001a\u00020.2\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010/\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u00100\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u00101\u001a\u00020&2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0010\u00102\u001a\u0004\u0018\u00010&2\u0006\u0010\u001a\u001a\u00020\u001bJ\u0010\u00103\u001a\u0004\u0018\u00010&2\u0006\u0010\u001a\u001a\u00020\u001bJ\u001a\u00104\u001a\u0004\u0018\u00010&2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u00105\u001a\u000206H\u0002J \u00107\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020\b2\b\b\u0002\u0010'\u001a\u00020\u000eJ\u001c\u00108\u001a\b\u0012\u0004\u0012\u00020\b0\u00042\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u00109\u001a\u0002062\u0006\u0010\u001c\u001a\u00020\u001dJ\u0016\u0010:\u001a\u0002062\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\n\u0010;\u001a\u000206*\u00020\u001bR\u001a\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\b0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lorg/jetbrains/kotlin/test/services/configuration/JsEnvironmentConfigurator$Companion;", "", "()V", "METADATA_CACHE", "", "Lorg/jetbrains/kotlin/serialization/js/JsModuleDescriptor;", "Lorg/jetbrains/kotlin/serialization/js/KotlinJavaScriptLibraryParts;", "MINIFICATION_OUTPUT_DIR_NAME", "", "OLD_MODULE_SUFFIX", "OUTPUT_KLIB_DIR_NAME", "TEST_DATA_DIR_PATH", "outputDirByMode", "", "Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/TranslationMode;", "createJsConfig", "Lorg/jetbrains/kotlin/js/config/JsConfig;", "project", "Lcom/intellij/openapi/project/Project;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "compilerEnvironment", "Lorg/jetbrains/kotlin/resolve/TargetEnvironment;", "getAllRecursiveDependenciesFor", "", "Lorg/jetbrains/kotlin/descriptors/impl/ModuleDescriptorImpl;", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "getAllRecursiveLibrariesFor", "Lorg/jetbrains/kotlin/library/KotlinLibrary;", "getDependencies", "kind", "Lorg/jetbrains/kotlin/test/model/DependencyRelation;", "getJsArtifactSimpleName", "moduleName", "getJsArtifactsOutputDir", "Ljava/io/File;", "translationMode", "getJsArtifactsRecompiledOutputDir", "getJsKlibArtifactPath", "getJsKlibOutputDir", "getJsModuleArtifactPath", "getKlibDependencies", "getMainCallParametersForModule", "Lorg/jetbrains/kotlin/js/facade/MainCallParameters;", "getMainModule", "getMainModuleName", "getMinificationJsArtifactsOutputDir", "getPostfixFile", "getPrefixFile", "getPrefixPostfixFile", "prefix", "", "getRecompiledJsModuleArtifactPath", "getRuntimePathsForModule", "incrementalEnabled", "isMainModule", "hasFilesToRecompile", "ExceptionThrowingReporter", "tests-common-new"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getJsArtifactSimpleName(@NotNull TestServices testServices, @NotNull String moduleName) {
            Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
            Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
            String testName = CapitalizeDecapitalizeKt.decapitalizeAsciiOnly((String)StringsKt.removePrefix((String)KotlinTestInfoKt.getTestInfo(testServices).getMethodName(), (CharSequence)"test"));
            String outputFileSuffix = Intrinsics.areEqual((Object)moduleName, (Object)"main") ? "" : '-' + moduleName;
            return testName + outputFileSuffix;
        }

        @NotNull
        public final String getJsModuleArtifactPath(@NotNull TestServices testServices, @NotNull String moduleName, @NotNull TranslationMode translationMode) {
            Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
            Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
            Intrinsics.checkNotNullParameter((Object)translationMode, (String)"translationMode");
            return this.getJsArtifactsOutputDir(testServices, translationMode).getAbsolutePath() + File.separator + this.getJsArtifactSimpleName(testServices, moduleName) + "_v5";
        }

        public static /* synthetic */ String getJsModuleArtifactPath$default(Companion companion, TestServices testServices, String string, TranslationMode translationMode, int n, Object object) {
            if ((n & 4) != 0) {
                translationMode = TranslationMode.FULL;
            }
            return companion.getJsModuleArtifactPath(testServices, string, translationMode);
        }

        @NotNull
        public final String getRecompiledJsModuleArtifactPath(@NotNull TestServices testServices, @NotNull String moduleName, @NotNull TranslationMode translationMode) {
            Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
            Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
            Intrinsics.checkNotNullParameter((Object)translationMode, (String)"translationMode");
            return this.getJsArtifactsRecompiledOutputDir(testServices, translationMode).getAbsolutePath() + File.separator + this.getJsArtifactSimpleName(testServices, moduleName) + "_v5";
        }

        public static /* synthetic */ String getRecompiledJsModuleArtifactPath$default(Companion companion, TestServices testServices, String string, TranslationMode translationMode, int n, Object object) {
            if ((n & 4) != 0) {
                translationMode = TranslationMode.FULL;
            }
            return companion.getRecompiledJsModuleArtifactPath(testServices, string, translationMode);
        }

        @NotNull
        public final String getJsKlibArtifactPath(@NotNull TestServices testServices, @NotNull String moduleName) {
            Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
            Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
            return this.getJsKlibOutputDir(testServices).getAbsolutePath() + File.separator + this.getJsArtifactSimpleName(testServices, moduleName);
        }

        @NotNull
        public final File getJsArtifactsOutputDir(@NotNull TestServices testServices, @NotNull TranslationMode translationMode) {
            Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
            Intrinsics.checkNotNullParameter((Object)translationMode, (String)"translationMode");
            TemporaryDirectoryManager temporaryDirectoryManager = TemporaryDirectoryManagerKt.getTemporaryDirectoryManager(testServices);
            Object v = outputDirByMode.get(translationMode);
            Intrinsics.checkNotNull(v);
            return temporaryDirectoryManager.getOrCreateTempDirectory((String)v);
        }

        public static /* synthetic */ File getJsArtifactsOutputDir$default(Companion companion, TestServices testServices, TranslationMode translationMode, int n, Object object) {
            if ((n & 2) != 0) {
                translationMode = TranslationMode.FULL;
            }
            return companion.getJsArtifactsOutputDir(testServices, translationMode);
        }

        @NotNull
        public final File getJsArtifactsRecompiledOutputDir(@NotNull TestServices testServices, @NotNull TranslationMode translationMode) {
            Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
            Intrinsics.checkNotNullParameter((Object)translationMode, (String)"translationMode");
            TemporaryDirectoryManager temporaryDirectoryManager = TemporaryDirectoryManagerKt.getTemporaryDirectoryManager(testServices);
            StringBuilder stringBuilder = new StringBuilder();
            Object v = outputDirByMode.get(translationMode);
            Intrinsics.checkNotNull(v);
            return temporaryDirectoryManager.getOrCreateTempDirectory(stringBuilder.append((String)v).append("-recompiled").toString());
        }

        public static /* synthetic */ File getJsArtifactsRecompiledOutputDir$default(Companion companion, TestServices testServices, TranslationMode translationMode, int n, Object object) {
            if ((n & 2) != 0) {
                translationMode = TranslationMode.FULL;
            }
            return companion.getJsArtifactsRecompiledOutputDir(testServices, translationMode);
        }

        @NotNull
        public final File getJsKlibOutputDir(@NotNull TestServices testServices) {
            Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
            return TemporaryDirectoryManagerKt.getTemporaryDirectoryManager(testServices).getOrCreateTempDirectory(JsEnvironmentConfigurator.OUTPUT_KLIB_DIR_NAME);
        }

        @NotNull
        public final File getMinificationJsArtifactsOutputDir(@NotNull TestServices testServices) {
            Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
            return TemporaryDirectoryManagerKt.getTemporaryDirectoryManager(testServices).getOrCreateTempDirectory(JsEnvironmentConfigurator.MINIFICATION_OUTPUT_DIR_NAME);
        }

        private final File getPrefixPostfixFile(TestModule module, boolean prefix) {
            File file;
            String suffix = prefix ? ".prefix" : ".postfix";
            File originalFile = ((TestFile)CollectionsKt.first(module.getFiles())).getOriginalFile();
            File file2 = originalFile.getParentFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"originalFile.parentFile");
            File it = file = FilesKt.resolve((File)file2, (String)(originalFile.getName() + suffix));
            boolean bl = false;
            return it.exists() ? file : null;
        }

        @Nullable
        public final File getPrefixFile(@NotNull TestModule module) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            return this.getPrefixPostfixFile(module, true);
        }

        @Nullable
        public final File getPostfixFile(@NotNull TestModule module) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            return this.getPrefixPostfixFile(module, false);
        }

        @NotNull
        public final JsConfig createJsConfig(@NotNull Project project, @NotNull CompilerConfiguration configuration2, @NotNull TargetEnvironment compilerEnvironment) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
            Intrinsics.checkNotNullParameter((Object)compilerEnvironment, (String)"compilerEnvironment");
            List list = METADATA_CACHE;
            List list2 = JsConfig.JS_STDLIB;
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"JS_STDLIB");
            Collection collection = list2;
            List list3 = JsConfig.JS_KOTLIN_TEST;
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"JS_KOTLIN_TEST");
            return new JsConfig(project, configuration2, compilerEnvironment, list, CollectionsKt.toSet((Iterable)CollectionsKt.plus((Collection)collection, (Iterable)list3)));
        }

        public static /* synthetic */ JsConfig createJsConfig$default(Companion companion, Project project, CompilerConfiguration compilerConfiguration, TargetEnvironment targetEnvironment, int n, Object object) {
            if ((n & 4) != 0) {
                targetEnvironment = (TargetEnvironment)CompilerEnvironment.INSTANCE;
            }
            return companion.createJsConfig(project, compilerConfiguration, targetEnvironment);
        }

        @NotNull
        public final TestModule getMainModule(@NotNull TestServices testServices) {
            TestModule testModule;
            Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
            List<TestModule> modules = TestModuleStructureKt.getModuleStructure(testServices).getModules();
            boolean inferMainModule = TestModuleStructureKt.getModuleStructure(testServices).getAllDirectives().contains(JsEnvironmentConfigurationDirectives.INSTANCE.getINFER_MAIN_MODULE());
            if (inferMainModule) {
                testModule = (TestModule)CollectionsKt.last(modules);
            } else {
                Object v1;
                block5: {
                    Iterable $this$singleOrNull$iv = modules;
                    boolean $i$f$singleOrNull = false;
                    Object single$iv = null;
                    boolean found$iv = false;
                    for (Object element$iv : $this$singleOrNull$iv) {
                        TestModule it = (TestModule)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)"main")) continue;
                        if (found$iv) {
                            v1 = null;
                            break block5;
                        }
                        single$iv = element$iv;
                        found$iv = true;
                    }
                    v1 = !found$iv ? null : single$iv;
                }
                if ((testModule = (TestModule)v1) == null) {
                    testModule = (TestModule)CollectionsKt.single(modules);
                }
            }
            return testModule;
        }

        public final boolean isMainModule(@NotNull TestModule module, @NotNull TestServices testServices) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
            return Intrinsics.areEqual((Object)module, (Object)this.getMainModule(testServices));
        }

        @NotNull
        public final String getMainModuleName(@NotNull TestServices testServices) {
            Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
            return this.getMainModule(testServices).getName();
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<String> getRuntimePathsForModule(@NotNull TestModule module, @NotNull TestServices testServices) {
            void $this$flatMapTo$iv$iv;
            Object it;
            List list;
            boolean needsFullIrRuntime;
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
            List result = new ArrayList();
            boolean bl = needsFullIrRuntime = module.getDirectives().contains(JsEnvironmentConfigurationDirectives.INSTANCE.getKJS_WITH_FULL_RUNTIME()) || module.getDirectives().contains(ConfigurationDirectives.INSTANCE.getWITH_STDLIB());
            if (needsFullIrRuntime) {
                Object[] objectArray = new String[]{"full.stdlib", "kotlin.test"};
                list = CollectionsKt.listOf((Object[])objectArray);
            } else {
                list = CollectionsKt.listOf((Object)"reduced.stdlib");
            }
            List names = list;
            Iterable $this$mapNotNullTo$iv = names;
            boolean $i$f$mapNotNullTo = false;
            Iterable $this$forEach$iv$iv = $this$mapNotNullTo$iv;
            boolean $i$f$forEach22 = false;
            for (Object element$iv$iv : $this$forEach$iv$iv) {
                String it$iv;
                Object element$iv = element$iv$iv;
                boolean bl2 = false;
                it = (String)element$iv;
                boolean bl3 = false;
                if (System.getProperty("kotlin.js." + (String)it + ".path") == null) continue;
                boolean bl4 = false;
                ((Collection)result).add(it$iv);
            }
            Iterable $this$flatMap$iv = RuntimeClasspathProviderKt.getRuntimeClasspathProviders(testServices);
            boolean $i$f$flatMap = false;
            Iterable $i$f$forEach22 = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo2 = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                it = (RuntimeClasspathProvider)element$iv$iv;
                boolean bl5 = false;
                Iterable list$iv$iv = ((RuntimeClasspathProvider)it).runtimeClassPaths(module);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List runtimeClasspaths = (List)destination$iv$iv;
            Iterable $this$mapTo$iv = runtimeClasspaths;
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void it2;
                File $i$f$flatMapTo2 = (File)item$iv;
                Collection collection = result;
                boolean bl6 = false;
                collection.add(it2.getAbsolutePath());
            }
            return result;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<File> getKlibDependencies(@NotNull TestModule module, @NotNull TestServices testServices, @NotNull DependencyRelation kind) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
            Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
            Set visited = new LinkedHashSet();
            org.jetbrains.kotlin.test.services.configuration.JsEnvironmentConfigurator$Companion.getKlibDependencies$getRecursive(testServices, visited, module, kind);
            Iterable $this$map$iv = visited;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                TestModule testModule = (TestModule)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(((BinaryArtifacts.KLib)DependencyProviderKt.getDependencyProvider(testServices).getArtifact((TestModule)it, ArtifactKinds.KLib.INSTANCE)).getOutputFile());
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<ModuleDescriptorImpl> getDependencies(@NotNull TestModule module, @NotNull TestServices testServices, @NotNull DependencyRelation kind) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
            Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
            Iterable iterable = this.getKlibDependencies(module, testServices, kind);
            boolean $i$f$map = false;
            void var6_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                File file = (File)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                JsLibraryProvider jsLibraryProvider = JsLibraryProviderKt.getJsLibraryProvider(testServices);
                String string = it.getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.absolutePath");
                collection.add(jsLibraryProvider.getDescriptorByPath(string));
            }
            return (List)destination$iv$iv;
        }

        @NotNull
        public final MainCallParameters getMainCallParametersForModule(@NotNull TestModule module) {
            MainCallParameters mainCallParameters;
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            SimpleDirective simpleDirective = JsEnvironmentConfigurationDirectives.INSTANCE.getCALL_MAIN();
            if (module.getDirectives().contains(simpleDirective)) {
                MainCallParameters mainCallParameters2 = MainCallParameters.mainWithArguments((List)CollectionsKt.emptyList());
                mainCallParameters = mainCallParameters2;
                Intrinsics.checkNotNullExpressionValue((Object)mainCallParameters2, (String)"mainWithArguments(listOf())");
            } else {
                MainCallParameters mainCallParameters3 = MainCallParameters.noCall();
                mainCallParameters = mainCallParameters3;
                Intrinsics.checkNotNullExpressionValue((Object)mainCallParameters3, (String)"noCall()");
            }
            return mainCallParameters;
        }

        @NotNull
        public final Set<ModuleDescriptorImpl> getAllRecursiveDependenciesFor(@NotNull TestModule module, @NotNull TestServices testServices) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
            Set visited = new LinkedHashSet();
            org.jetbrains.kotlin.test.services.configuration.JsEnvironmentConfigurator$Companion.getAllRecursiveDependenciesFor$getRecursive$10(visited, ModuleDescriptorProviderKt.getModuleDescriptorProvider(testServices).getModuleDescriptor(module));
            return visited;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Map<KotlinLibrary, ModuleDescriptorImpl> getAllRecursiveLibrariesFor(@NotNull TestModule module, @NotNull TestServices testServices) {
            void $this$associateByTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
            Set<ModuleDescriptorImpl> dependencies = this.getAllRecursiveDependenciesFor(module, testServices);
            Iterable $this$associateBy$iv = dependencies;
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            Iterable iterable = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                void it;
                ModuleDescriptorImpl moduleDescriptorImpl = (ModuleDescriptorImpl)element$iv$iv;
                Map map = destination$iv$iv;
                boolean bl = false;
                map.put(JsLibraryProviderKt.getJsLibraryProvider(testServices).getCompiledLibraryByDescriptor((ModuleDescriptor)it), element$iv$iv);
            }
            return destination$iv$iv;
        }

        public final boolean hasFilesToRecompile(@NotNull TestModule $this$hasFilesToRecompile) {
            boolean bl;
            block3: {
                Intrinsics.checkNotNullParameter((Object)$this$hasFilesToRecompile, (String)"<this>");
                Iterable $this$any$iv = $this$hasFilesToRecompile.getFiles();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        TestFile it = (TestFile)element$iv;
                        boolean bl2 = false;
                        if (!it.getDirectives().contains(JsEnvironmentConfigurationDirectives.INSTANCE.getRECOMPILE())) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean incrementalEnabled(@NotNull TestServices testServices) {
            TestModule it;
            Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
            if (TestModuleStructureKt.getModuleStructure(testServices).getAllDirectives().contains(JsEnvironmentConfigurationDirectives.INSTANCE.getSKIP_IR_INCREMENTAL_CHECKS())) return false;
            Iterable $this$any$iv = TestModuleStructureKt.getModuleStructure(testServices).getModules();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator = $this$any$iv.iterator();
            do {
                if (!iterator.hasNext()) return false;
                Object element$iv = iterator.next();
                it = (TestModule)element$iv;
                boolean bl = false;
            } while (!Companion.hasFilesToRecompile(it));
            return true;
        }

        /*
         * WARNING - void declaration
         */
        private static final void getKlibDependencies$getRecursive(TestServices $testServices, Set<TestModule> visited, TestModule module, DependencyRelation kind) {
            void $this$forEach$iv;
            void $this$mapTo$iv$iv;
            List<DependencyDescription> dependencies = kind == DependencyRelation.FriendDependency ? module.getFriendDependencies() : module.getRegularDependencies();
            Iterable $this$map$iv = dependencies;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                DependencyDescription dependencyDescription = (DependencyDescription)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(DependencyProviderKt.getDependencyProvider($testServices).getTestModule(it.getModuleName()));
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TestModule it = (TestModule)element$iv;
                boolean bl = false;
                if (visited.contains(it)) continue;
                ((Collection)visited).add(it);
                org.jetbrains.kotlin.test.services.configuration.JsEnvironmentConfigurator$Companion.getKlibDependencies$getRecursive($testServices, visited, it, kind);
            }
        }

        private static final void getAllRecursiveDependenciesFor$getRecursive$10(Set<ModuleDescriptorImpl> visited, ModuleDescriptorImpl descriptor) {
            Iterable $this$forEach$iv = descriptor.getAllDependencyModules();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ModuleDescriptor it = (ModuleDescriptor)element$iv;
                boolean bl = false;
                if (!(it instanceof ModuleDescriptorImpl) || visited.contains(it)) continue;
                ((Collection)visited).add(it);
                org.jetbrains.kotlin.test.services.configuration.JsEnvironmentConfigurator$Companion.getAllRecursiveDependenciesFor$getRecursive$10(visited, (ModuleDescriptorImpl)it);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/test/services/configuration/JsEnvironmentConfigurator$Companion$ExceptionThrowingReporter;", "Lorg/jetbrains/kotlin/js/config/JsConfig$Reporter;", "()V", "error", "", "message", "", "tests-common-new"})
        public static final class ExceptionThrowingReporter
        extends JsConfig.Reporter {
            @NotNull
            public static final ExceptionThrowingReporter INSTANCE = new ExceptionThrowingReporter();

            private ExceptionThrowingReporter() {
            }

            public void error(@NotNull String message) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                throw new AssertionError((Object)("Error message reported: " + message));
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TargetBackend.values().length];
            try {
                nArray[TargetBackend.JS_IR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TargetBackend.JS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

