/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.services;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.impl.ModuleDescriptorImpl;
import org.jetbrains.kotlin.library.KotlinLibrary;
import org.jetbrains.kotlin.test.services.AssertionsKt;
import org.jetbrains.kotlin.test.services.TestService;
import org.jetbrains.kotlin.test.services.TestServices;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u0007J\u000e\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\bJ\u000e\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\nJ.\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\n2\u001e\u0010\u0013\u001a\u001a\u0012\u0004\u0012\u00020\n\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\b0\u00150\u0014J\u000e\u0010\u0016\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u0007J\u001e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\bR\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/test/services/JsLibraryProvider;", "Lorg/jetbrains/kotlin/test/services/TestService;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "descriptorToLibrary", "", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "Lorg/jetbrains/kotlin/library/KotlinLibrary;", "stdlibPathToDescriptor", "", "Lorg/jetbrains/kotlin/descriptors/impl/ModuleDescriptorImpl;", "getCompiledLibraryByDescriptor", "descriptor", "getDescriptorByCompiledLibrary", "library", "getDescriptorByPath", "path", "getOrCreateStdlibByPath", "create", "Lkotlin/Function1;", "Lkotlin/Pair;", "getPathByDescriptor", "setDescriptorAndLibraryByName", "", "name", "test-infrastructure"})
public final class JsLibraryProvider
implements TestService {
    @NotNull
    private final TestServices testServices;
    @NotNull
    private final Map<ModuleDescriptor, KotlinLibrary> descriptorToLibrary;
    @NotNull
    private final Map<String, ModuleDescriptorImpl> stdlibPathToDescriptor;

    public JsLibraryProvider(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        this.testServices = testServices;
        this.descriptorToLibrary = new LinkedHashMap();
        this.stdlibPathToDescriptor = new LinkedHashMap();
    }

    @NotNull
    public final ModuleDescriptorImpl getDescriptorByPath(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        ModuleDescriptorImpl moduleDescriptorImpl = this.stdlibPathToDescriptor.get(path);
        if (moduleDescriptorImpl == null) {
            AssertionsKt.getAssertions(this.testServices).fail((Function0<String>)((Function0)new Function0<String>(path){
                final /* synthetic */ String $path;
                {
                    this.$path = $path;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "There is no library with path " + this.$path;
                }
            }));
            throw null;
        }
        return moduleDescriptorImpl;
    }

    public final void setDescriptorAndLibraryByName(@NotNull String name2, @NotNull ModuleDescriptorImpl descriptor, @NotNull KotlinLibrary library) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        this.stdlibPathToDescriptor.put(name2, descriptor);
        this.descriptorToLibrary.put((ModuleDescriptor)descriptor, library);
    }

    @NotNull
    public final KotlinLibrary getCompiledLibraryByDescriptor(@NotNull ModuleDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        KotlinLibrary kotlinLibrary = this.descriptorToLibrary.get(descriptor);
        if (kotlinLibrary == null) {
            AssertionsKt.getAssertions(this.testServices).fail((Function0<String>)((Function0)new Function0<String>(descriptor){
                final /* synthetic */ ModuleDescriptor $descriptor;
                {
                    this.$descriptor = $descriptor;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "There is no library for descriptor " + this.$descriptor.getName();
                }
            }));
            throw null;
        }
        return kotlinLibrary;
    }

    @NotNull
    public final String getPathByDescriptor(@NotNull ModuleDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Iterable $this$single$iv = this.stdlibPathToDescriptor.entrySet();
        boolean $i$f$single = false;
        Object single$iv = null;
        boolean found$iv = false;
        for (Object element$iv : $this$single$iv) {
            Map.Entry it = (Map.Entry)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual(it.getValue(), (Object)descriptor)) continue;
            if (found$iv) {
                throw new IllegalArgumentException("Collection contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        return (String)((Map.Entry)single$iv).getKey();
    }

    @NotNull
    public final ModuleDescriptor getDescriptorByCompiledLibrary(@NotNull KotlinLibrary library) {
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        Map<ModuleDescriptor, KotlinLibrary> $this$filterValues$iv = this.descriptorToLibrary;
        boolean $i$f$filterValues = false;
        LinkedHashMap<ModuleDescriptor, KotlinLibrary> result$iv = new LinkedHashMap<ModuleDescriptor, KotlinLibrary>();
        for (Map.Entry<ModuleDescriptor, KotlinLibrary> entry$iv : $this$filterValues$iv.entrySet()) {
            KotlinLibrary it = entry$iv.getValue();
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it, (Object)library)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        ModuleDescriptor moduleDescriptor = (ModuleDescriptor)CollectionsKt.singleOrNull((Iterable)((Map)result$iv).keySet());
        if (moduleDescriptor == null) {
            AssertionsKt.getAssertions(this.testServices).fail((Function0<String>)((Function0)new Function0<String>(library){
                final /* synthetic */ KotlinLibrary $library;
                {
                    this.$library = $library;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "There is no descriptor for library " + this.$library.getLibraryName();
                }
            }));
            throw null;
        }
        return moduleDescriptor;
    }

    @NotNull
    public final ModuleDescriptorImpl getOrCreateStdlibByPath(@NotNull String path, @NotNull Function1<? super String, ? extends Pair<ModuleDescriptorImpl, ? extends KotlinLibrary>> create) {
        ModuleDescriptorImpl moduleDescriptorImpl;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(create, (String)"create");
        Map<String, ModuleDescriptorImpl> $this$getOrPut$iv = this.stdlibPathToDescriptor;
        boolean $i$f$getOrPut = false;
        ModuleDescriptorImpl value$iv = $this$getOrPut$iv.get(path);
        if (value$iv == null) {
            boolean bl = false;
            Pair it = (Pair)create.invoke((Object)path);
            boolean bl2 = false;
            this.descriptorToLibrary.put((ModuleDescriptor)it.getFirst(), (KotlinLibrary)it.getSecond());
            ModuleDescriptorImpl answer$iv = (ModuleDescriptorImpl)it.getFirst();
            $this$getOrPut$iv.put(path, answer$iv);
            moduleDescriptorImpl = answer$iv;
        } else {
            moduleDescriptorImpl = value$iv;
        }
        return moduleDescriptorImpl;
    }
}

