/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.runners;

import com.intellij.testFramework.TestDataPath;
import java.io.File;
import java.util.regex.Pattern;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.jetbrains.kotlin.test.runners.AbstractDiagnosticsTestWithOldJvmBackend;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

@TestMetadata(value="compiler/testData/diagnostics/testsWithJvmBackend")
@TestDataPath(value="$PROJECT_ROOT")
public class DiagnosticsTestWithOldJvmBackendGenerated
extends AbstractDiagnosticsTestWithOldJvmBackend {
    @Test
    public void testAllFilesPresentInTestsWithJvmBackend() throws Exception {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/testsWithJvmBackend"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_OLD, true, new String[0]);
    }

    @Test
    @TestMetadata(value="indirectInlineCycle.kt")
    public void testIndirectInlineCycle() throws Exception {
        this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/indirectInlineCycle.kt");
    }

    @Test
    @TestMetadata(value="inlineCycle.kt")
    public void testInlineCycle() throws Exception {
        this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/inlineCycle.kt");
    }

    @Test
    @TestMetadata(value="multipleBigArityFunsImplemented.kt")
    public void testMultipleBigArityFunsImplemented() throws Exception {
        this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/multipleBigArityFunsImplemented.kt");
    }

    @Test
    @TestMetadata(value="noWarningInLV1_5.kt")
    public void testNoWarningInLV1_5() throws Exception {
        this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/noWarningInLV1_5.kt");
    }

    @Test
    @TestMetadata(value="propertyInlineCycle.kt")
    public void testPropertyInlineCycle() throws Exception {
        this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/propertyInlineCycle.kt");
    }

    @Test
    @TestMetadata(value="suspendInlineCycle.kt")
    public void testSuspendInlineCycle() throws Exception {
        this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/suspendInlineCycle.kt");
    }

    @Nested
    @TestMetadata(value="compiler/testData/diagnostics/testsWithJvmBackend/valueClasses")
    @TestDataPath(value="$PROJECT_ROOT")
    public class ValueClasses {
        @Test
        public void testAllFilesPresentInValueClasses() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/testsWithJvmBackend/valueClasses"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_OLD, true, new String[0]);
        }

        @Test
        @TestMetadata(value="cloneable.kt")
        public void testCloneable() throws Exception {
            DiagnosticsTestWithOldJvmBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/valueClasses/cloneable.kt");
        }

        @Test
        @TestMetadata(value="cloneable.fir.kt")
        public void testCloneable_fir() throws Exception {
            DiagnosticsTestWithOldJvmBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/valueClasses/cloneable.fir.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/diagnostics/testsWithJvmBackend/typeOf")
    @TestDataPath(value="$PROJECT_ROOT")
    public class TypeOf {
        @Test
        public void testAllFilesPresentInTypeOf() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/testsWithJvmBackend/typeOf"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_OLD, true, new String[0]);
        }

        @Test
        @TestMetadata(value="nonReifiedTypeParameterWithRecursiveBound.kt")
        public void testNonReifiedTypeParameterWithRecursiveBound() throws Exception {
            DiagnosticsTestWithOldJvmBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/typeOf/nonReifiedTypeParameterWithRecursiveBound.kt");
        }

        @Test
        @TestMetadata(value="suspendType.kt")
        public void testSuspendType() throws Exception {
            DiagnosticsTestWithOldJvmBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/typeOf/suspendType.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/diagnostics/testsWithJvmBackend/scripts")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Scripts {
        @Test
        public void testAllFilesPresentInScripts() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/testsWithJvmBackend/scripts"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_OLD, true, new String[0]);
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/diagnostics/testsWithJvmBackend/multifileClasses")
    @TestDataPath(value="$PROJECT_ROOT")
    public class MultifileClasses {
        @Test
        public void testAllFilesPresentInMultifileClasses() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/testsWithJvmBackend/multifileClasses"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_OLD, true, new String[0]);
        }

        @Test
        @TestMetadata(value="jvmSynthetic.kt")
        public void testJvmSynthetic() throws Exception {
            DiagnosticsTestWithOldJvmBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/multifileClasses/jvmSynthetic.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature")
    @TestDataPath(value="$PROJECT_ROOT")
    public class DuplicateJvmSignature {
        @Test
        public void testAllFilesPresentInDuplicateJvmSignature() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_OLD, true, new String[0]);
        }

        @Test
        @TestMetadata(value="caseInProperties.kt")
        public void testCaseInProperties() throws Exception {
            DiagnosticsTestWithOldJvmBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/caseInProperties.kt");
        }

        @Test
        @TestMetadata(value="changingNullabilityOfOrdinaryClassIsBinaryCompatibleChange.kt")
        public void testChangingNullabilityOfOrdinaryClassIsBinaryCompatibleChange() throws Exception {
            DiagnosticsTestWithOldJvmBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/changingNullabilityOfOrdinaryClassIsBinaryCompatibleChange.kt");
        }

        @Test
        @TestMetadata(value="vararg.kt")
        public void testVararg() throws Exception {
            DiagnosticsTestWithOldJvmBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/vararg.kt");
        }

        @Nested
        @TestMetadata(value="compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/traitImpl")
        @TestDataPath(value="$PROJECT_ROOT")
        public class TraitImpl {
            @Test
            public void testAllFilesPresentInTraitImpl() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/traitImpl"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_OLD, true, new String[0]);
            }

            @Test
            @TestMetadata(value="defaultVsNonDefault_old.kt")
            public void testDefaultVsNonDefault_old() throws Exception {
                DiagnosticsTestWithOldJvmBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/traitImpl/defaultVsNonDefault_old.kt");
            }

            @Test
            @TestMetadata(value="kt43611.kt")
            public void testKt43611() throws Exception {
                DiagnosticsTestWithOldJvmBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/traitImpl/kt43611.kt");
            }

            @Test
            @TestMetadata(value="oneTrait_old.kt")
            public void testOneTrait_old() throws Exception {
                DiagnosticsTestWithOldJvmBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/traitImpl/oneTrait_old.kt");
            }

            @Test
            @TestMetadata(value="traitFunctionOverriddenByPropertyInTrait_old.kt")
            public void testTraitFunctionOverriddenByPropertyInTrait_old() throws Exception {
                DiagnosticsTestWithOldJvmBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/traitImpl/traitFunctionOverriddenByPropertyInTrait_old.kt");
            }

            @Test
            @TestMetadata(value="traitPropertyOverriddenByFunctionInTrait_old.kt")
            public void testTraitPropertyOverriddenByFunctionInTrait_old() throws Exception {
                DiagnosticsTestWithOldJvmBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/traitImpl/traitPropertyOverriddenByFunctionInTrait_old.kt");
            }

            @Test
            @TestMetadata(value="twoTraits_old.kt")
            public void testTwoTraits_old() throws Exception {
                DiagnosticsTestWithOldJvmBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/traitImpl/twoTraits_old.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/synthesized")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Synthesized {
            @Test
            public void testAllFilesPresentInSynthesized() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/synthesized"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_OLD, true, new String[0]);
            }

            @Test
            @TestMetadata(value="enumValuesValueOf.kt")
            public void testEnumValuesValueOf() throws Exception {
                DiagnosticsTestWithOldJvmBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/synthesized/enumValuesValueOf.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/statics")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Statics {
            @Test
            public void testAllFilesPresentInStatics() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/statics"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_OLD, true, new String[0]);
            }

            @Test
            @TestMetadata(value="jkjk.kt")
            public void testJkjk() throws Exception {
                DiagnosticsTestWithOldJvmBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/statics/jkjk.kt");
            }

            @Test
            @TestMetadata(value="kotlinClassExtendsJavaClass.kt")
            public void testKotlinClassExtendsJavaClass() throws Exception {
                DiagnosticsTestWithOldJvmBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/statics/kotlinClassExtendsJavaClass.kt");
            }

            @Test
            @TestMetadata(value="kotlinClassExtendsJavaClassExtendsJavaClass.kt")
            public void testKotlinClassExtendsJavaClassExtendsJavaClass() throws Exception {
                DiagnosticsTestWithOldJvmBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/statics/kotlinClassExtendsJavaClassExtendsJavaClass.kt");
            }

            @Test
            @TestMetadata(value="kotlinClassImplementsJavaInterface.kt")
            public void testKotlinClassImplementsJavaInterface() throws Exception {
                DiagnosticsTestWithOldJvmBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/statics/kotlinClassImplementsJavaInterface.kt");
            }

            @Test
            @TestMetadata(value="kotlinClassImplementsJavaInterfaceExtendsJavaInteface.kt")
            public void testKotlinClassImplementsJavaInterfaceExtendsJavaInteface() throws Exception {
                DiagnosticsTestWithOldJvmBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/statics/kotlinClassImplementsJavaInterfaceExtendsJavaInteface.kt");
            }

            @Test
            @TestMetadata(value="kotlinMembersVsJavaNonVisibleStatics.kt")
            public void testKotlinMembersVsJavaNonVisibleStatics() throws Exception {
                DiagnosticsTestWithOldJvmBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/statics/kotlinMembersVsJavaNonVisibleStatics.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/specialNames")
        @TestDataPath(value="$PROJECT_ROOT")
        public class SpecialNames {
            @Test
            public void testAllFilesPresentInSpecialNames() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/specialNames"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_OLD, true, new String[0]);
            }

            @Test
            @TestMetadata(value="classObjectCopiedField.kt")
            public void testClassObjectCopiedField() throws Exception {
                DiagnosticsTestWithOldJvmBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/specialNames/classObjectCopiedField.kt");
            }

            @Test
            @TestMetadata(value="classObjectCopiedFieldObject_old.kt")
            public void testClassObjectCopiedFieldObject_old() throws Exception {
                DiagnosticsTestWithOldJvmBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/specialNames/classObjectCopiedFieldObject_old.kt");
            }

            @Test
            @TestMetadata(value="classObject_old.kt")
            public void testClassObject_old() throws Exception {
                DiagnosticsTestWithOldJvmBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/specialNames/classObject_old.kt");
            }

            @Test
            @TestMetadata(value="dataClassCopy.kt")
            public void testDataClassCopy() throws Exception {
                DiagnosticsTestWithOldJvmBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/specialNames/dataClassCopy.kt");
            }

            @Test
            @TestMetadata(value="defaults_old.kt")
            public void testDefaults_old() throws Exception {
                DiagnosticsTestWithOldJvmBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/specialNames/defaults_old.kt");
            }

            @Test
            @TestMetadata(value="delegationBy_old.kt")
            public void testDelegationBy_old() throws Exception {
                DiagnosticsTestWithOldJvmBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/specialNames/delegationBy_old.kt");
            }

            @Test
            @TestMetadata(value="enum.kt")
            public void testEnum() throws Exception {
                DiagnosticsTestWithOldJvmBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/specialNames/enum.kt");
            }

            @Test
            @TestMetadata(value="innerClassField_old.kt")
            public void testInnerClassField_old() throws Exception {
                DiagnosticsTestWithOldJvmBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/specialNames/innerClassField_old.kt");
            }

            @Test
            @TestMetadata(value="instance_old.kt")
            public void testInstance_old() throws Exception {
                DiagnosticsTestWithOldJvmBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/specialNames/instance_old.kt");
            }

            @Test
            @TestMetadata(value="propertyMetadataCache_old.kt")
            public void testPropertyMetadataCache_old() throws Exception {
                DiagnosticsTestWithOldJvmBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/specialNames/propertyMetadataCache_old.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/functionAndProperty")
        @TestDataPath(value="$PROJECT_ROOT")
        public class FunctionAndProperty {
            @Test
            public void testAllFilesPresentInFunctionAndProperty() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/functionAndProperty"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_OLD, true, new String[0]);
            }

            @Test
            @TestMetadata(value="class.kt")
            public void testClass() throws Exception {
                DiagnosticsTestWithOldJvmBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/functionAndProperty/class.kt");
            }

            @Test
            @TestMetadata(value="classObject.kt")
            public void testClassObject() throws Exception {
                DiagnosticsTestWithOldJvmBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/functionAndProperty/classObject.kt");
            }

            @Test
            @TestMetadata(value="classPropertyInConstructor.kt")
            public void testClassPropertyInConstructor() throws Exception {
                DiagnosticsTestWithOldJvmBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/functionAndProperty/classPropertyInConstructor.kt");
            }

            @Test
            @TestMetadata(value="extensionFunctionAndNormalFunction.kt")
            public void testExtensionFunctionAndNormalFunction() throws Exception {
                DiagnosticsTestWithOldJvmBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/functionAndProperty/extensionFunctionAndNormalFunction.kt");
            }

            @Test
            @TestMetadata(value="extensionPropertyAndFunction.kt")
            public void testExtensionPropertyAndFunction() throws Exception {
                DiagnosticsTestWithOldJvmBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/functionAndProperty/extensionPropertyAndFunction.kt");
            }

            @Test
            @TestMetadata(value="functionAndSetter.kt")
            public void testFunctionAndSetter() throws Exception {
                DiagnosticsTestWithOldJvmBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/functionAndProperty/functionAndSetter.kt");
            }

            @Test
            @TestMetadata(value="functionAndVar.kt")
            public void testFunctionAndVar() throws Exception {
                DiagnosticsTestWithOldJvmBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/functionAndProperty/functionAndVar.kt");
            }

            @Test
            @TestMetadata(value="localClass.kt")
            public void testLocalClass() throws Exception {
                DiagnosticsTestWithOldJvmBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/functionAndProperty/localClass.kt");
            }

            @Test
            @TestMetadata(value="localClassInClass.kt")
            public void testLocalClassInClass() throws Exception {
                DiagnosticsTestWithOldJvmBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/functionAndProperty/localClassInClass.kt");
            }

            @Test
            @TestMetadata(value="nestedClass.kt")
            public void testNestedClass() throws Exception {
                DiagnosticsTestWithOldJvmBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/functionAndProperty/nestedClass.kt");
            }

            @Test
            @TestMetadata(value="object.kt")
            public void testObject() throws Exception {
                DiagnosticsTestWithOldJvmBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/functionAndProperty/object.kt");
            }

            @Test
            @TestMetadata(value="objectExpression.kt")
            public void testObjectExpression() throws Exception {
                DiagnosticsTestWithOldJvmBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/functionAndProperty/objectExpression.kt");
            }

            @Test
            @TestMetadata(value="objectExpressionInConstructor.kt")
            public void testObjectExpressionInConstructor() throws Exception {
                DiagnosticsTestWithOldJvmBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/functionAndProperty/objectExpressionInConstructor.kt");
            }

            @Test
            @TestMetadata(value="privateClassPropertyNoClash.kt")
            public void testPrivateClassPropertyNoClash() throws Exception {
                DiagnosticsTestWithOldJvmBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/functionAndProperty/privateClassPropertyNoClash.kt");
            }

            @Test
            @TestMetadata(value="topLevel.kt")
            public void testTopLevel() throws Exception {
                DiagnosticsTestWithOldJvmBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/functionAndProperty/topLevel.kt");
            }

            @Test
            @TestMetadata(value="topLevelDifferentFiles.kt")
            public void testTopLevelDifferentFiles() throws Exception {
                DiagnosticsTestWithOldJvmBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/functionAndProperty/topLevelDifferentFiles.kt");
            }

            @Test
            @TestMetadata(value="topLevelGetter.kt")
            public void testTopLevelGetter() throws Exception {
                DiagnosticsTestWithOldJvmBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/functionAndProperty/topLevelGetter.kt");
            }

            @Test
            @TestMetadata(value="trait_old.kt")
            public void testTrait_old() throws Exception {
                DiagnosticsTestWithOldJvmBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/functionAndProperty/trait_old.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/finalMembersFromBuiltIns")
        @TestDataPath(value="$PROJECT_ROOT")
        public class FinalMembersFromBuiltIns {
            @Test
            public void testAllFilesPresentInFinalMembersFromBuiltIns() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/finalMembersFromBuiltIns"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_OLD, true, new String[0]);
            }

            @Test
            @TestMetadata(value="enumMembers.kt")
            public void testEnumMembers() throws Exception {
                DiagnosticsTestWithOldJvmBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/finalMembersFromBuiltIns/enumMembers.kt");
            }

            @Test
            @TestMetadata(value="waitNotifyGetClass_old.kt")
            public void testWaitNotifyGetClass_old() throws Exception {
                DiagnosticsTestWithOldJvmBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/finalMembersFromBuiltIns/waitNotifyGetClass_old.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/erasure")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Erasure {
            @Test
            public void testAllFilesPresentInErasure() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/erasure"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_OLD, true, new String[0]);
            }

            @Test
            @TestMetadata(value="clashFromInterfaceAndSuperClass_old.kt")
            public void testClashFromInterfaceAndSuperClass_old() throws Exception {
                DiagnosticsTestWithOldJvmBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/erasure/clashFromInterfaceAndSuperClass_old.kt");
            }

            @Test
            @TestMetadata(value="collections.kt")
            public void testCollections() throws Exception {
                DiagnosticsTestWithOldJvmBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/erasure/collections.kt");
            }

            @Test
            @TestMetadata(value="delegateToTwoTraits.kt")
            public void testDelegateToTwoTraits() throws Exception {
                DiagnosticsTestWithOldJvmBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/erasure/delegateToTwoTraits.kt");
            }

            @Test
            @TestMetadata(value="delegationAndOwnMethod.kt")
            public void testDelegationAndOwnMethod() throws Exception {
                DiagnosticsTestWithOldJvmBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/erasure/delegationAndOwnMethod.kt");
            }

            @Test
            @TestMetadata(value="delegationToTraitImplAndOwnMethod.kt")
            public void testDelegationToTraitImplAndOwnMethod() throws Exception {
                DiagnosticsTestWithOldJvmBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/erasure/delegationToTraitImplAndOwnMethod.kt");
            }

            @Test
            @TestMetadata(value="extensionProperties.kt")
            public void testExtensionProperties() throws Exception {
                DiagnosticsTestWithOldJvmBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/erasure/extensionProperties.kt");
            }

            @Test
            @TestMetadata(value="genericType.kt")
            public void testGenericType() throws Exception {
                DiagnosticsTestWithOldJvmBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/erasure/genericType.kt");
            }

            @Test
            @TestMetadata(value="inheritFromTwoTraits_old.kt")
            public void testInheritFromTwoTraits_old() throws Exception {
                DiagnosticsTestWithOldJvmBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/erasure/inheritFromTwoTraits_old.kt");
            }

            @Test
            @TestMetadata(value="kotlinAndJavaCollections.kt")
            public void testKotlinAndJavaCollections() throws Exception {
                DiagnosticsTestWithOldJvmBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/erasure/kotlinAndJavaCollections.kt");
            }

            @Test
            @TestMetadata(value="nullableType.kt")
            public void testNullableType() throws Exception {
                DiagnosticsTestWithOldJvmBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/erasure/nullableType.kt");
            }

            @Test
            @TestMetadata(value="superTraitAndDelegationToTraitImpl_old.kt")
            public void testSuperTraitAndDelegationToTraitImpl_old() throws Exception {
                DiagnosticsTestWithOldJvmBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/erasure/superTraitAndDelegationToTraitImpl_old.kt");
            }

            @Test
            @TestMetadata(value="twoTraitsAndOwnFunction_old.kt")
            public void testTwoTraitsAndOwnFunction_old() throws Exception {
                DiagnosticsTestWithOldJvmBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/erasure/twoTraitsAndOwnFunction_old.kt");
            }

            @Test
            @TestMetadata(value="typeMappedToJava.kt")
            public void testTypeMappedToJava() throws Exception {
                DiagnosticsTestWithOldJvmBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/erasure/typeMappedToJava.kt");
            }

            @Test
            @TestMetadata(value="typeParameter.kt")
            public void testTypeParameter() throws Exception {
                DiagnosticsTestWithOldJvmBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/erasure/typeParameter.kt");
            }

            @Test
            @TestMetadata(value="typeParameterWithBound.kt")
            public void testTypeParameterWithBound() throws Exception {
                DiagnosticsTestWithOldJvmBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/erasure/typeParameterWithBound.kt");
            }

            @Test
            @TestMetadata(value="typeParameterWithTwoBounds.kt")
            public void testTypeParameterWithTwoBounds() throws Exception {
                DiagnosticsTestWithOldJvmBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/erasure/typeParameterWithTwoBounds.kt");
            }

            @Test
            @TestMetadata(value="typeParameterWithTwoBoundsInWhere.kt")
            public void testTypeParameterWithTwoBoundsInWhere() throws Exception {
                DiagnosticsTestWithOldJvmBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/erasure/typeParameterWithTwoBoundsInWhere.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/bridges")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Bridges {
            @Test
            public void testAllFilesPresentInBridges() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/bridges"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_OLD, true, new String[0]);
            }

            @Test
            @TestMetadata(value="class_old.kt")
            public void testClass_old() throws Exception {
                DiagnosticsTestWithOldJvmBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/bridges/class_old.kt");
            }

            @Test
            @TestMetadata(value="fakeOverrideTrait_old.kt")
            public void testFakeOverrideTrait_old() throws Exception {
                DiagnosticsTestWithOldJvmBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/bridges/fakeOverrideTrait_old.kt");
            }

            @Test
            @TestMetadata(value="trait_old.kt")
            public void testTrait_old() throws Exception {
                DiagnosticsTestWithOldJvmBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/bridges/trait_old.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/accidentalOverrides")
        @TestDataPath(value="$PROJECT_ROOT")
        public class AccidentalOverrides {
            @Test
            @TestMetadata(value="accidentalOverrideFromGrandparent.kt")
            public void testAccidentalOverrideFromGrandparent() throws Exception {
                DiagnosticsTestWithOldJvmBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/accidentalOverrides/accidentalOverrideFromGrandparent.kt");
            }

            @Test
            public void testAllFilesPresentInAccidentalOverrides() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/accidentalOverrides"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_OLD, true, new String[0]);
            }

            @Test
            @TestMetadata(value="classFunctionOverriddenByProperty.kt")
            public void testClassFunctionOverriddenByProperty() throws Exception {
                DiagnosticsTestWithOldJvmBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/accidentalOverrides/classFunctionOverriddenByProperty.kt");
            }

            @Test
            @TestMetadata(value="classFunctionOverriddenByPropertyInConstructor.kt")
            public void testClassFunctionOverriddenByPropertyInConstructor() throws Exception {
                DiagnosticsTestWithOldJvmBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/accidentalOverrides/classFunctionOverriddenByPropertyInConstructor.kt");
            }

            @Test
            @TestMetadata(value="classFunctionOverriddenByPropertyNoGetter.kt")
            public void testClassFunctionOverriddenByPropertyNoGetter() throws Exception {
                DiagnosticsTestWithOldJvmBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/accidentalOverrides/classFunctionOverriddenByPropertyNoGetter.kt");
            }

            @Test
            @TestMetadata(value="classPropertyOverriddenByFunction.kt")
            public void testClassPropertyOverriddenByFunction() throws Exception {
                DiagnosticsTestWithOldJvmBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/accidentalOverrides/classPropertyOverriddenByFunction.kt");
            }

            @Test
            @TestMetadata(value="defaultFunction_old.kt")
            public void testDefaultFunction_old() throws Exception {
                DiagnosticsTestWithOldJvmBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/accidentalOverrides/defaultFunction_old.kt");
            }

            @Test
            @TestMetadata(value="delegatedFunctionOverriddenByProperty_old.kt")
            public void testDelegatedFunctionOverriddenByProperty_old() throws Exception {
                DiagnosticsTestWithOldJvmBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/accidentalOverrides/delegatedFunctionOverriddenByProperty_old.kt");
            }

            @Test
            @TestMetadata(value="genericClassFunction.kt")
            public void testGenericClassFunction() throws Exception {
                DiagnosticsTestWithOldJvmBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/accidentalOverrides/genericClassFunction.kt");
            }

            @Test
            @TestMetadata(value="privateClassFunctionOverriddenByProperty.kt")
            public void testPrivateClassFunctionOverriddenByProperty() throws Exception {
                DiagnosticsTestWithOldJvmBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/accidentalOverrides/privateClassFunctionOverriddenByProperty.kt");
            }

            @Test
            @TestMetadata(value="traitFunctionOverriddenByPropertyNoImpl.kt")
            public void testTraitFunctionOverriddenByPropertyNoImpl() throws Exception {
                DiagnosticsTestWithOldJvmBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/accidentalOverrides/traitFunctionOverriddenByPropertyNoImpl.kt");
            }

            @Test
            @TestMetadata(value="traitFunctionOverriddenByProperty_old.kt")
            public void testTraitFunctionOverriddenByProperty_old() throws Exception {
                DiagnosticsTestWithOldJvmBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/accidentalOverrides/traitFunctionOverriddenByProperty_old.kt");
            }

            @Test
            @TestMetadata(value="traitPropertyOverriddenByFunctionNoImpl.kt")
            public void testTraitPropertyOverriddenByFunctionNoImpl() throws Exception {
                DiagnosticsTestWithOldJvmBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/accidentalOverrides/traitPropertyOverriddenByFunctionNoImpl.kt");
            }

            @Test
            @TestMetadata(value="traitPropertyOverriddenByFunction_old.kt")
            public void testTraitPropertyOverriddenByFunction_old() throws Exception {
                DiagnosticsTestWithOldJvmBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/accidentalOverrides/traitPropertyOverriddenByFunction_old.kt");
            }
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/diagnostics/testsWithJvmBackend/dataObjects")
    @TestDataPath(value="$PROJECT_ROOT")
    public class DataObjects {
        @Test
        public void testAllFilesPresentInDataObjects() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/testsWithJvmBackend/dataObjects"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_OLD, true, new String[0]);
        }
    }
}

