/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.frontend.fir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirModuleData;
import org.jetbrains.kotlin.fir.java.FirProjectSessionProvider;
import org.jetbrains.kotlin.test.model.DependencyDescription;
import org.jetbrains.kotlin.test.model.DependencyKind;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.DependencyProviderKt;
import org.jetbrains.kotlin.test.services.TestService;
import org.jetbrains.kotlin.test.services.TestServices;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u0007J\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u00102\u0006\u0010\u000e\u001a\u00020\u0007J\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u00102\u0006\u0010\u000e\u001a\u00020\u0007J\u001c\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u00102\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0010H\u0002J\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\b0\u00102\u0006\u0010\u000e\u001a\u00020\u0007J\u0016\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\bR\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/test/frontend/fir/FirModuleInfoProvider;", "Lorg/jetbrains/kotlin/test/services/TestService;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "firModuleDataByModule", "", "Lorg/jetbrains/kotlin/test/model/TestModule;", "Lorg/jetbrains/kotlin/fir/FirModuleData;", "firSessionProvider", "Lorg/jetbrains/kotlin/fir/java/FirProjectSessionProvider;", "getFirSessionProvider", "()Lorg/jetbrains/kotlin/fir/java/FirProjectSessionProvider;", "getCorrespondingModuleData", "module", "getDependentDependsOnSourceModules", "", "getDependentFriendSourceModules", "getDependentModulesImpl", "dependencies", "Lorg/jetbrains/kotlin/test/model/DependencyDescription;", "getRegularDependentSourceModules", "registerModuleData", "", "moduleData", "tests-common-new"})
public final class FirModuleInfoProvider
implements TestService {
    @NotNull
    private final TestServices testServices;
    @NotNull
    private final FirProjectSessionProvider firSessionProvider;
    @NotNull
    private final Map<TestModule, FirModuleData> firModuleDataByModule;

    public FirModuleInfoProvider(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        this.testServices = testServices;
        this.firSessionProvider = new FirProjectSessionProvider();
        this.firModuleDataByModule = new LinkedHashMap();
    }

    @NotNull
    public final FirProjectSessionProvider getFirSessionProvider() {
        return this.firSessionProvider;
    }

    public final void registerModuleData(@NotNull TestModule module, @NotNull FirModuleData moduleData) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)moduleData, (String)"moduleData");
        if (this.firModuleDataByModule.containsKey(module)) {
            throw new IllegalStateException(("module data for module " + module + " already registered").toString());
        }
        this.firModuleDataByModule.put(module, moduleData);
    }

    @NotNull
    public final FirModuleData getCorrespondingModuleData(@NotNull TestModule module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        FirModuleData firModuleData = this.firModuleDataByModule.get(module);
        if (firModuleData == null) {
            throw new IllegalStateException(("module data for module " + module + " is not registered").toString());
        }
        return firModuleData;
    }

    @NotNull
    public final List<FirModuleData> getRegularDependentSourceModules(@NotNull TestModule module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return this.getDependentModulesImpl(module.getRegularDependencies());
    }

    @NotNull
    public final List<FirModuleData> getDependentFriendSourceModules(@NotNull TestModule module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return this.getDependentModulesImpl(module.getFriendDependencies());
    }

    @NotNull
    public final List<FirModuleData> getDependentDependsOnSourceModules(@NotNull TestModule module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return this.getDependentModulesImpl(module.getDependsOnDependencies());
    }

    /*
     * WARNING - void declaration
     */
    private final List<FirModuleData> getDependentModulesImpl(List<DependencyDescription> dependencies) {
        void $this$mapTo$iv$iv;
        DependencyDescription it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = dependencies;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (DependencyDescription)element$iv$iv;
            boolean bl = false;
            if (!(it.getKind() == DependencyKind.Source)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (DependencyDescription)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.getCorrespondingModuleData(DependencyProviderKt.getDependencyProvider(this.testServices).getTestModule(it.getModuleName())));
        }
        return (List)destination$iv$iv;
    }
}

