/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.frontend.classic.handlers;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.test.Assertions;
import org.jetbrains.kotlin.test.directives.AdditionalFilesDirectives;
import org.jetbrains.kotlin.test.directives.DiagnosticsDirectives;
import org.jetbrains.kotlin.test.directives.JvmEnvironmentConfigurationDirectives;
import org.jetbrains.kotlin.test.directives.model.DirectivesContainer;
import org.jetbrains.kotlin.test.frontend.classic.ClassicFrontendOutputArtifact;
import org.jetbrains.kotlin.test.frontend.classic.handlers.ClassicFrontendAnalysisHandler;
import org.jetbrains.kotlin.test.frontend.classic.handlers.DeclarationsDumpHandler;
import org.jetbrains.kotlin.test.model.TestFile;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.SourceFileProviderKt;
import org.jetbrains.kotlin.test.services.TestModuleStructureKt;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.util.DescriptorValidator;
import org.jetbrains.kotlin.test.util.RecursiveDescriptorComparator;
import org.jetbrains.kotlin.test.utils.MultiModuleInfoDumper;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \"2\u00020\u0001:\u0001\"B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J:\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00062\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000fH\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0016H\u0016J\u0018\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/test/frontend/classic/handlers/DeclarationsDumpHandler;", "Lorg/jetbrains/kotlin/test/frontend/classic/handlers/ClassicFrontendAnalysisHandler;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "directiveContainers", "", "Lorg/jetbrains/kotlin/test/directives/model/DirectivesContainer;", "getDirectiveContainers", "()Ljava/util/List;", "dumper", "Lorg/jetbrains/kotlin/test/utils/MultiModuleInfoDumper;", "createdAffectedPackagesConfiguration", "Lorg/jetbrains/kotlin/test/util/RecursiveDescriptorComparator$Configuration;", "testFiles", "Lorg/jetbrains/kotlin/test/model/TestFile;", "ktFiles", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "checkTypeEnabled", "", "getJavaFilePackage", "Lorg/jetbrains/kotlin/name/Name;", "testFile", "processAfterAllModules", "", "someAssertionWasFailed", "processModule", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "info", "Lorg/jetbrains/kotlin/test/frontend/classic/ClassicFrontendOutputArtifact;", "Companion", "tests-common-new"})
public final class DeclarationsDumpHandler
extends ClassicFrontendAnalysisHandler {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final MultiModuleInfoDumper dumper;
    @NotNull
    private static final List<Name> NAMES_OF_CHECK_TYPE_HELPER;
    private static final Pattern JAVA_PACKAGE_PATTERN;

    public DeclarationsDumpHandler(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        super(testServices, false, false, 6, null);
        this.dumper = new MultiModuleInfoDumper("// -- Module: <%s> --");
    }

    @Override
    @NotNull
    public List<DirectivesContainer> getDirectiveContainers() {
        return kotlin.collections.CollectionsKt.listOf((Object)DiagnosticsDirectives.INSTANCE);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void processAfterAllModules(boolean someAssertionWasFailed) {
        block6: {
            if (this.dumper.isEmpty()) {
                return;
            }
            resultDump = this.dumper.generateResultingDump();
            testDataFile = (File)kotlin.collections.CollectionsKt.first(TestModuleStructureKt.getModuleStructure(this.getTestServices()).getOriginalTestDataFiles());
            allDirectives = TestModuleStructureKt.getModuleStructure(this.getTestServices()).getAllDirectives();
            if (!allDirectives.contains(DiagnosticsDirectives.INSTANCE.getNI_EXPECTED_FILE())) ** GOTO lbl-1000
            $this$any$iv = TestModuleStructureKt.getModuleStructure(this.getTestServices()).getModules();
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                v0 = false;
            } else {
                for (T element$iv : $this$any$iv) {
                    it = (TestModule)element$iv;
                    $i$a$-any-DeclarationsDumpHandler$processAfterAllModules$prefix$1 = false;
                    if (!it.getLanguageVersionSettings().supportsFeature(LanguageFeature.NewInference)) continue;
                    v0 = true;
                    break block6;
                }
                v0 = false;
            }
        }
        if (v0) {
            v1 = ".ni";
        } else lbl-1000:
        // 2 sources

        {
            v1 = allDirectives.contains(JvmEnvironmentConfigurationDirectives.INSTANCE.getUSE_JAVAC()) != false && allDirectives.contains(DiagnosticsDirectives.INSTANCE.getJAVAC_EXPECTED_FILE()) != false ? ".javac" : "";
        }
        prefix = v1;
        expectedFileName = FilesKt.getNameWithoutExtension((File)testDataFile) + prefix + ".txt";
        v2 = testDataFile.getParentFile();
        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"testDataFile.parentFile");
        expectedFile = FilesKt.resolve((File)v2, (String)expectedFileName);
        Assertions.assertEqualsToFile$default(this.getAssertions(), expectedFile, resultDump, null, 4, null);
    }

    @Override
    public void processModule(@NotNull TestModule module, @NotNull ClassicFrontendOutputArtifact info) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        if (module.getDirectives().contains(DiagnosticsDirectives.INSTANCE.getSKIP_TXT())) {
            return;
        }
        ModuleDescriptor moduleDescriptor = info.getAnalysisResult().getModuleDescriptor();
        boolean checkTypeEnabled = module.getDirectives().contains(AdditionalFilesDirectives.INSTANCE.getCHECK_TYPE());
        RecursiveDescriptorComparator comparator = new RecursiveDescriptorComparator(this.createdAffectedPackagesConfiguration(module.getFiles(), info.getKtFiles(), moduleDescriptor, checkTypeEnabled));
        List list = kotlin.collections.CollectionsKt.createListBuilder();
        List $this$processModule_u24lambda_u242 = list;
        boolean bl = false;
        Iterable $this$forEach$iv = module.getDirectives().get(DiagnosticsDirectives.INSTANCE.getRENDER_PACKAGE());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl2 = false;
            $this$processModule_u24lambda_u242.add(new FqName(it));
        }
        $this$processModule_u24lambda_u242.add(FqName.ROOT);
        List packages = kotlin.collections.CollectionsKt.build((List)list);
        Map textByPackage2 = CollectionsKt.keysToMap((Iterable)packages, (Function1)processModule.textByPackage.1.INSTANCE);
        for (Map.Entry entry : textByPackage2.entrySet()) {
            FqName packageName = (FqName)entry.getKey();
            StringBuilder packageText = (StringBuilder)entry.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)packageName, (String)"packageName");
            PackageViewDescriptor aPackage = moduleDescriptor.getPackage(packageName);
            Assertions.assertFalse$default(this.getAssertions(), aPackage.isEmpty(), null, 2, null);
            String actualSerialized = comparator.serializeRecursively((DeclarationDescriptor)aPackage);
            packageText.append(actualSerialized);
        }
        String allPackagesText = kotlin.collections.CollectionsKt.joinToString$default((Iterable)textByPackage2.values(), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        StringBuilder stringBuilder = this.dumper.builderForModule(module).append(allPackagesText);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append('\\n')");
    }

    /*
     * WARNING - void declaration
     */
    private final RecursiveDescriptorComparator.Configuration createdAffectedPackagesConfiguration(List<TestFile> testFiles, Map<TestFile, ? extends KtFile> ktFiles, ModuleDescriptor moduleDescriptor, boolean checkTypeEnabled) {
        void destination$iv;
        void $this$mapNotNullTo$iv;
        Iterable iterable = testFiles;
        Collection collection = new LinkedHashSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv.iterator();
        while (iterator.hasNext()) {
            Name name2;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator.next();
            boolean bl = false;
            TestFile it = (TestFile)element$iv;
            boolean bl2 = false;
            KtFile ktFile = ktFiles.get(it);
            KtFile ktFile2 = ktFile;
            if (ktFile2 != null) {
                List list = ktFile2.getPackageFqName().pathSegments();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"ktFile.packageFqName.pathSegments()");
                name2 = (Name)kotlin.collections.CollectionsKt.firstOrNull((List)list);
                if (name2 == null) {
                    name2 = SpecialNames.ROOT_PACKAGE;
                }
            } else {
                name2 = SourceFileProviderKt.isJavaFile(it) ? this.getJavaFilePackage(it) : null;
            }
            if (name2 == null) continue;
            Name it$iv = name2;
            boolean bl3 = false;
            destination$iv.add(it$iv);
        }
        Set packagesNames = (Set)destination$iv;
        Predicate<DeclarationDescriptor> stepIntoFilter = arg_0 -> DeclarationsDumpHandler.createdAffectedPackagesConfiguration$lambda$4(moduleDescriptor, packagesNames, checkTypeEnabled, arg_0);
        RecursiveDescriptorComparator.Configuration configuration2 = RecursiveDescriptorComparator.RECURSIVE.filterRecursion(stepIntoFilter).withValidationStrategy(DescriptorValidator.ValidationVisitor.errorTypesAllowed()).checkFunctionContracts(true);
        Intrinsics.checkNotNullExpressionValue((Object)configuration2, (String)"RECURSIVE.filterRecursio\u2026ckFunctionContracts(true)");
        return configuration2;
    }

    /*
     * WARNING - void declaration
     */
    private final Name getJavaFilePackage(TestFile testFile) {
        Matcher matcher = JAVA_PACKAGE_PATTERN.matcher(testFile.getOriginalContent());
        if (matcher.find()) {
            void $this$filterTo$iv$iv;
            String string = testFile.getOriginalContent().substring(matcher.start(), matcher.end());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            String[] stringArray = new String[]{" "};
            String $this$filter$iv = (String)kotlin.collections.CollectionsKt.last((List)StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
            boolean $i$f$filter = false;
            CharSequence charSequence = $this$filter$iv;
            Appendable destination$iv$iv = new StringBuilder();
            boolean $i$f$filterTo = false;
            int n = $this$filterTo$iv$iv.length();
            for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                char element$iv$iv;
                char it = element$iv$iv = $this$filterTo$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                if (!(!CharsKt.isWhitespace((char)it))) continue;
                destination$iv$iv.append(element$iv$iv);
            }
            String string2 = ((StringBuilder)destination$iv$iv).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"filterTo(StringBuilder(), predicate).toString()");
            String it = string2;
            boolean bl = false;
            String[] stringArray2 = new String[]{"."};
            Name name2 = Name.identifier((String)((String)kotlin.collections.CollectionsKt.first((List)StringsKt.split$default((CharSequence)it, (String[])stringArray2, (boolean)false, (int)0, (int)6, null))));
            Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"testFile.originalContent\u2026(it.split(\".\").first()) }");
            return name2;
        }
        return SpecialNames.ROOT_PACKAGE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean createdAffectedPackagesConfiguration$lambda$4(ModuleDescriptor $moduleDescriptor, Set $packagesNames, boolean $checkTypeEnabled, DeclarationDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)$moduleDescriptor, (String)"$moduleDescriptor");
        Intrinsics.checkNotNullParameter((Object)$packagesNames, (String)"$packagesNames");
        ModuleDescriptor module = DescriptorUtils.getContainingModuleOrNull((DeclarationDescriptor)descriptor);
        if (!Intrinsics.areEqual((Object)module, (Object)$moduleDescriptor)) {
            return false;
        }
        if (descriptor instanceof PackageViewDescriptor) {
            FqName fqName = ((PackageViewDescriptor)descriptor).getFqName();
            if (fqName.isRoot()) return true;
            List list = fqName.pathSegments();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"fqName.pathSegments()");
            if (!$packagesNames.contains(kotlin.collections.CollectionsKt.first((List)list))) return false;
            return true;
        }
        if (!$checkTypeEnabled) return true;
        if (!NAMES_OF_CHECK_TYPE_HELPER.contains(descriptor.getName())) return true;
        return false;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $this$mapTo$iv$iv;
        Companion = new Companion(null);
        Object[] objectArray = new String[]{"checkSubtype", "CheckTypeInv", "_", "checkType"};
        Iterable $this$map$iv = kotlin.collections.CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Name.identifier((String)it));
        }
        NAMES_OF_CHECK_TYPE_HELPER = (List)var3_3;
        JAVA_PACKAGE_PATTERN = Pattern.compile("^\\s*package [.\\w\\d]*", 8);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/test/frontend/classic/handlers/DeclarationsDumpHandler$Companion;", "", "()V", "JAVA_PACKAGE_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "NAMES_OF_CHECK_TYPE_HELPER", "", "Lorg/jetbrains/kotlin/name/Name;", "tests-common-new"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

