/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.backend.ir;

import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtPsiSourceFile;
import org.jetbrains.kotlin.KtSourceFile;
import org.jetbrains.kotlin.backend.common.BackendException;
import org.jetbrains.kotlin.backend.jvm.MultifileFacadeFileEntry;
import org.jetbrains.kotlin.backend.jvm.lower.FileClassLoweringKt;
import org.jetbrains.kotlin.codegen.ClassFileFactory;
import org.jetbrains.kotlin.codegen.CodegenFactory;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.ir.IrFileEntry;
import org.jetbrains.kotlin.ir.PsiIrFileEntry;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.util.NaiveSourceBasedFileEntryImpl;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.test.backend.classic.JavaCompilerFacade;
import org.jetbrains.kotlin.test.backend.ir.IrBackendFacade;
import org.jetbrains.kotlin.test.backend.ir.IrBackendInput;
import org.jetbrains.kotlin.test.directives.CodegenTestDirectives;
import org.jetbrains.kotlin.test.model.ArtifactKinds;
import org.jetbrains.kotlin.test.model.BinaryArtifacts;
import org.jetbrains.kotlin.test.model.SourceFileInfo;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.CompilerConfigurationProviderKt;
import org.jetbrains.kotlin.test.services.TestServices;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001a\u0010\b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/test/backend/ir/JvmIrBackendFacade;", "Lorg/jetbrains/kotlin/test/backend/ir/IrBackendFacade;", "Lorg/jetbrains/kotlin/test/model/BinaryArtifacts$Jvm;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "javaCompilerFacade", "Lorg/jetbrains/kotlin/test/backend/classic/JavaCompilerFacade;", "transform", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "inputArtifact", "Lorg/jetbrains/kotlin/test/backend/ir/IrBackendInput;", "tests-common-new"})
public final class JvmIrBackendFacade
extends IrBackendFacade<BinaryArtifacts.Jvm> {
    @NotNull
    private final JavaCompilerFacade javaCompilerFacade;

    public JvmIrBackendFacade(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        super(testServices, ArtifactKinds.Jvm.INSTANCE);
        this.javaCompilerFacade = new JavaCompilerFacade(testServices);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public BinaryArtifacts.Jvm transform(@NotNull TestModule module, @NotNull IrBackendInput inputArtifact) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)inputArtifact, (String)"inputArtifact");
        if (!(inputArtifact instanceof IrBackendInput.JvmIrBackendInput)) {
            boolean $i$a$-require-JvmIrBackendFacade$transform$22 = false;
            String $i$a$-require-JvmIrBackendFacade$transform$22 = "JvmIrBackendFacade expects IrBackendInput.JvmIrBackendInput as input";
            throw new IllegalArgumentException($i$a$-require-JvmIrBackendFacade$transform$22.toString());
        }
        GenerationState state = ((IrBackendInput.JvmIrBackendInput)inputArtifact).getState();
        try {
            ((IrBackendInput.JvmIrBackendInput)inputArtifact).getCodegenFactory().generateModule(state, (CodegenFactory.BackendInput)((IrBackendInput.JvmIrBackendInput)inputArtifact).getBackendInput());
        }
        catch (BackendException e) {
            if (module.getDirectives().contains(CodegenTestDirectives.INSTANCE.getIGNORE_ERRORS())) {
                return null;
            }
            throw e;
        }
        state.getFactory().done();
        CompilerConfiguration configuration2 = CompilerConfigurationProviderKt.getCompilerConfigurationProvider(this.getTestServices()).getCompilerConfiguration(module);
        this.javaCompilerFacade.compileJavaFiles(module, configuration2, state.getFactory());
        Iterable iterable = ((IrBackendInput.JvmIrBackendInput)inputArtifact).getBackendInput().getIrModuleFragment().getFiles();
        ClassFileFactory classFileFactory = state.getFactory();
        boolean $i$f$flatMap = false;
        void var7_11 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            IrFile it = (IrFile)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = JvmIrBackendFacade.transform$sourceFileInfos(inputArtifact, it, true);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Collection collection = (List)destination$iv$iv;
        ClassFileFactory classFileFactory2 = classFileFactory;
        return new BinaryArtifacts.Jvm(classFileFactory2, collection);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<SourceFileInfo> transform$sourceFileInfos(IrBackendInput $inputArtifact, IrFile irFile, boolean allowNestedMultifileFacades) {
        List list;
        IrFileEntry fileEntry = irFile.getFileEntry();
        if (fileEntry instanceof PsiIrFileEntry) {
            KtSourceFile ktSourceFile = (KtSourceFile)new KtPsiSourceFile(((PsiIrFileEntry)fileEntry).getPsiFile());
            PsiFile psiFile = ((PsiIrFileEntry)fileEntry).getPsiFile();
            Intrinsics.checkNotNull((Object)psiFile, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
            list = CollectionsKt.listOf((Object)new SourceFileInfo(ktSourceFile, JvmFileClassUtil.getFileClassInfoNoResolve((KtFile)((KtFile)psiFile))));
        } else if (fileEntry instanceof NaiveSourceBasedFileEntryImpl) {
            Object v3;
            block9: {
                Iterable iterable = ((IrBackendInput.JvmIrBackendInput)$inputArtifact).getSourceFiles();
                for (Object t : iterable) {
                    KtSourceFile it = (KtSourceFile)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getPath(), (Object)fileEntry.getName())) continue;
                    v3 = t;
                    break block9;
                }
                v3 = null;
            }
            KtSourceFile sourceFile = v3;
            list = sourceFile == null ? CollectionsKt.emptyList() : CollectionsKt.listOf((Object)new SourceFileInfo(sourceFile, FileClassLoweringKt.getFileClassInfoFromIrFile((IrFile)irFile, (String)sourceFile.getName())));
        } else if (fileEntry instanceof MultifileFacadeFileEntry) {
            void $this$flatMapTo$iv$iv;
            if (!allowNestedMultifileFacades) {
                throw new IllegalStateException("nested multi-file facades are not allowed".toString());
            }
            Iterable $this$flatMap$iv = ((MultifileFacadeFileEntry)fileEntry).getPartFiles();
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                IrFile it = (IrFile)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = JvmIrBackendFacade.transform$sourceFileInfos($inputArtifact, it, false);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            throw new IllegalStateException(("unknown kind of file entry: " + fileEntry).toString());
        }
        return list;
    }
}

