/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.backend.handlers;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.CodegenUtil;
import org.jetbrains.kotlin.codegen.ClassFileFactory;
import org.jetbrains.kotlin.codegen.CodegenTestUtil;
import org.jetbrains.kotlin.codegen.GeneratedClassLoader;
import org.jetbrains.kotlin.codegen.TestUtilsKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.fileClasses.JvmFileClassInfo;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.test.Assertions;
import org.jetbrains.kotlin.test.ConfigurationKind;
import org.jetbrains.kotlin.test.TestJdkKind;
import org.jetbrains.kotlin.test.backend.BlackBoxCodegenSuppressorKt;
import org.jetbrains.kotlin.test.backend.handlers.JvmBinaryArtifactHandler;
import org.jetbrains.kotlin.test.backend.handlers.JvmBoxRunner;
import org.jetbrains.kotlin.test.clientserver.TestProxy;
import org.jetbrains.kotlin.test.directives.CodegenTestDirectives;
import org.jetbrains.kotlin.test.directives.JvmEnvironmentConfigurationDirectives;
import org.jetbrains.kotlin.test.directives.LanguageSettingsDirectives;
import org.jetbrains.kotlin.test.directives.model.DirectiveKt;
import org.jetbrains.kotlin.test.model.BinaryArtifacts;
import org.jetbrains.kotlin.test.model.DependencyDescription;
import org.jetbrains.kotlin.test.model.DependencyKind;
import org.jetbrains.kotlin.test.model.ModulesKt;
import org.jetbrains.kotlin.test.model.SourceFileInfo;
import org.jetbrains.kotlin.test.model.TestFile;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.CompilerConfigurationProviderKt;
import org.jetbrains.kotlin.test.services.DependencyProviderKt;
import org.jetbrains.kotlin.test.services.KotlinStandardLibrariesPathProviderKt;
import org.jetbrains.kotlin.test.services.RuntimeClasspathProvider;
import org.jetbrains.kotlin.test.services.RuntimeClasspathProviderKt;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.services.configuration.JvmEnvironmentConfigurator;
import org.jetbrains.kotlin.test.services.jvm.CompiledClassesManager;
import org.jetbrains.kotlin.test.services.jvm.CompiledClassesManagerKt;
import org.jetbrains.kotlin.test.services.jvm.JvmBoxMainClassProvider;
import org.jetbrains.kotlin.test.services.jvm.JvmBoxMainClassProviderKt;
import org.jetbrains.kotlin.test.services.sourceProviders.MainFunctionForBlackBoxTestsSourceProvider;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 <2\u00020\u0001:\u0001<B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J0\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0006H\u0002J8\u0010\u0017\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0006H\u0002J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\t0\u001a2\u0006\u0010\u001b\u001a\u00020\u0011H\u0002J \u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0006H\u0002J\u0018\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J&\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\b0\u001a2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J0\u0010 \u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\"\u0012\u0004\u0012\u00020#0!2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J,\u0010$\u001a\u00020%2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\n\u0010&\u001a\u0006\u0012\u0002\b\u00030\"H\u0002J4\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\b0\u001a2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020%0\u001aH\u0014J\u0010\u0010,\u001a\u00020\r2\u0006\u0010-\u001a\u00020\u0006H\u0016J\u0018\u0010.\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010/\u001a\u000200H\u0016J\u0018\u00101\u001a\u00020%2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u00102\u001a\u00020#H\u0002J(\u00103\u001a\u00020%2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u00104\u001a\u0002052\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0012\u00106\u001a\u0004\u0018\u00010#*\u0006\u0012\u0002\b\u00030\"H\u0002J\u000e\u00107\u001a\u0004\u0018\u00010%*\u000208H\u0002J\u0018\u00109\u001a\u0006\u0012\u0002\b\u00030\"*\u00020:2\u0006\u0010;\u001a\u00020%H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0007\u001a\u00020\b*\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006="}, d2={"Lorg/jetbrains/kotlin/test/backend/handlers/JvmBoxRunner;", "Lorg/jetbrains/kotlin/test/backend/handlers/JvmBinaryArtifactHandler;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "boxMethodFound", "", "url", "Ljava/net/URL;", "Ljava/io/File;", "getUrl", "(Ljava/io/File;)Ljava/net/URL;", "callBoxMethodAndCheckResult", "", "fileInfo", "Lorg/jetbrains/kotlin/fileClasses/JvmFileClassInfo;", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "classFileFactory", "Lorg/jetbrains/kotlin/codegen/ClassFileFactory;", "classLoader", "Ljava/net/URLClassLoader;", "unexpectedBehaviour", "callBoxMethodAndCheckResultWithCleanup", "reportProblems", "computeRuntimeClasspath", "", "rootModule", "createAndVerifyClassLoader", "Lorg/jetbrains/kotlin/codegen/GeneratedClassLoader;", "createClassLoader", "extractClassPath", "findClassAndMethodToExecute", "Lkotlin/Pair;", "Ljava/lang/Class;", "Ljava/lang/reflect/Method;", "invokeBoxInSeparateProcess", "", "clazz", "launchSeparateJvmProcess", "Ljava/lang/Process;", "javaExe", "classPath", "mainClassAndArguments", "processAfterAllModules", "someAssertionWasFailed", "processModule", "info", "Lorg/jetbrains/kotlin/test/model/BinaryArtifacts$Jvm;", "runBoxInCurrentProcess", "method", "runSeparateJvmInstance", "jdkKind", "Lorg/jetbrains/kotlin/test/TestJdkKind;", "getBoxMethodOrNull", "getFacadeFqName", "Lorg/jetbrains/kotlin/psi/KtFile;", "getGeneratedClass", "Ljava/lang/ClassLoader;", "className", "Companion", "tests-common-new"})
public class JvmBoxRunner
extends JvmBinaryArtifactHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean boxMethodFound;
    private static final String BOX_IN_SEPARATE_PROCESS_PORT = System.getProperty("kotlin.test.box.in.separate.process.port");

    public JvmBoxRunner(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        super(testServices, false, 2, null);
    }

    @Override
    public void processAfterAllModules(boolean someAssertionWasFailed) {
        if (!this.boxMethodFound) {
            this.getAssertions().fail((Function0<String>)((Function0)processAfterAllModules.1.INSTANCE));
            throw null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processModule(@NotNull TestModule module, @NotNull BinaryArtifacts.Jvm info) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Collection<SourceFileInfo> collection = info.getFileInfos();
        if (collection.isEmpty()) {
            boolean bl = false;
            return;
        }
        Collection<SourceFileInfo> fileInfos = collection;
        boolean reportProblems = !BlackBoxCodegenSuppressorKt.getCodegenSuppressionChecker(this.getTestServices()).failuresInModuleAreIgnored(module);
        GeneratedClassLoader classLoader = this.createAndVerifyClassLoader(module, info.getClassFileFactory(), reportProblems);
        try {
            for (SourceFileInfo fileInfo : fileInfos) {
                if (!MainFunctionForBlackBoxTestsSourceProvider.Companion.fileContainsBoxMethod(fileInfo.getSourceFile())) continue;
                this.boxMethodFound = true;
                this.callBoxMethodAndCheckResultWithCleanup(fileInfo.getInfo(), module, info.getClassFileFactory(), (URLClassLoader)classLoader, false, reportProblems);
                return;
            }
        }
        finally {
            classLoader.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void callBoxMethodAndCheckResultWithCleanup(JvmFileClassInfo fileInfo, TestModule module, ClassFileFactory classFileFactory, URLClassLoader classLoader, boolean unexpectedBehaviour, boolean reportProblems) {
        try {
            this.callBoxMethodAndCheckResult(fileInfo, module, classFileFactory, classLoader, unexpectedBehaviour);
        }
        catch (Throwable e) {
            if (reportProblems) {
                try {
                    String string = classFileFactory.createText();
                    System.out.println((Object)string);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            throw e;
        }
        finally {
            TestUtilsKt.clearReflectionCache(classLoader);
        }
    }

    private final Pair<Class<?>, Method> findClassAndMethodToExecute(JvmFileClassInfo fileInfo, URLClassLoader classLoader, ClassFileFactory classFileFactory) {
        Class<?> clazz;
        String string = fileInfo.getFacadeClassFqName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"fileInfo.facadeClassFqName.asString()");
        String className = string;
        try {
            clazz = this.getGeneratedClass(classLoader, className);
        }
        catch (LinkageError e) {
            throw new AssertionError("Failed to load class '" + className + "':\n" + classFileFactory.createText(), e);
        }
        Class<?> clazz2 = clazz;
        Method method = this.getBoxMethodOrNull(clazz2);
        if (method == null) {
            throw new IllegalStateException("box method not found".toString());
        }
        Method method2 = method;
        return TuplesKt.to(clazz2, (Object)method2);
    }

    private final void callBoxMethodAndCheckResult(JvmFileClassInfo fileInfo, TestModule module, ClassFileFactory classFileFactory, URLClassLoader classLoader, boolean unexpectedBehaviour) {
        String result;
        String string;
        if (BOX_IN_SEPARATE_PROCESS_PORT != null) {
            string = this.invokeBoxInSeparateProcess(module, classFileFactory, classLoader, (Class)this.findClassAndMethodToExecute(fileInfo, classLoader, classFileFactory).getFirst());
        } else {
            TestJdkKind jdkKind;
            TestJdkKind testJdkKind = jdkKind = DirectiveKt.singleOrZeroValue(module.getDirectives(), JvmEnvironmentConfigurationDirectives.INSTANCE.getJDK_KIND());
            boolean bl = testJdkKind != null ? testJdkKind.getRequiresSeparateProcess() : false;
            if (bl || module.getDirectives().contains(CodegenTestDirectives.INSTANCE.getREQUIRES_SEPARATE_PROCESS())) {
                TestJdkKind testJdkKind2 = jdkKind;
                if (testJdkKind2 == null) {
                    testJdkKind2 = TestJdkKind.FULL_JDK;
                }
                string = this.runSeparateJvmInstance(module, testJdkKind2, classLoader, classFileFactory);
            } else {
                string = result = this.runBoxInCurrentProcess(classLoader, (Method)this.findClassAndMethodToExecute(fileInfo, classLoader, classFileFactory).getSecond());
            }
        }
        if (unexpectedBehaviour) {
            TestCase.assertNotSame((Object)"OK", (Object)result);
        } else {
            Assertions.assertEquals$default(this.getAssertions(), "OK", result, null, 4, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String runBoxInCurrentProcess(URLClassLoader classLoader, Method method) {
        String string;
        ClassLoader savedClassLoader = Thread.currentThread().getContextClassLoader();
        if (savedClassLoader != classLoader) {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
        try {
            Object object = method.invoke(null, new Object[0]);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
            string = (String)object;
        }
        finally {
            if (savedClassLoader != classLoader) {
                Thread.currentThread().setContextClassLoader(savedClassLoader);
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String runSeparateJvmInstance(TestModule module, TestJdkKind jdkKind, URLClassLoader classLoader, ClassFileFactory classFileFactory) {
        String string;
        Object[] $this$firstOrNull$iv;
        File file;
        File file2;
        switch (WhenMappings.$EnumSwitchMapping$0[jdkKind.ordinal()]) {
            case 1: {
                file2 = KtTestUtil.getJdk8Home();
                break;
            }
            case 2: {
                file2 = KtTestUtil.getJdk11Home();
                break;
            }
            case 3: {
                file2 = KtTestUtil.getJdk17Home();
                break;
            }
            default: {
                throw new IllegalStateException(("Unsupported JDK kind: " + (Object)((Object)jdkKind)).toString());
            }
        }
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"when (jdkKind) {\n       \u2026ind: $jdkKind\")\n        }");
        File jdkHome = file2;
        File p0 = file = new File(jdkHome, "bin/java.exe");
        boolean bl = false;
        File file3 = p0.exists() ? file : null;
        if (file3 == null) {
            File p02 = p0 = new File(jdkHome, "bin/java");
            boolean bl2 = false;
            file3 = p02.exists() ? p0 : null;
            if (file3 == null) {
                throw new IllegalStateException(("Can't find 'java' executable in " + jdkHome).toString());
            }
        }
        File javaExe = file3;
        List<URL> classPath = this.extractClassPath(module, classLoader, classFileFactory);
        Object object = JvmBoxMainClassProviderKt.getJvmBoxMainClassProvider(this.getTestServices());
        if (object == null || (object = ((JvmBoxMainClassProvider)object).getMainClassNameAndAdditionalArguments()) == null) {
            Object v3;
            block17: {
                JvmBoxRunner $this$runSeparateJvmInstance_u24lambda_u243 = this;
                boolean bl3 = false;
                $this$firstOrNull$iv = (String[])module.getFiles();
                boolean $i$f$firstOrNull = false;
                for (Object charset : $this$firstOrNull$iv) {
                    TestFile it = (TestFile)charset;
                    boolean bl4 = false;
                    if (!(Intrinsics.areEqual((Object)it.getName(), (Object)"Generated_Box_Main.kt") && it.isAdditional())) continue;
                    v3 = charset;
                    break block17;
                }
                v3 = null;
            }
            TestFile testFile = v3;
            if (testFile == null) {
                throw new IllegalStateException("No file with main function was generated. Please check TODO source provider".toString());
            }
            TestFile mainFile = testFile;
            $this$firstOrNull$iv = new String[]{MainFunctionForBlackBoxTestsSourceProvider.Companion.detectPackage(mainFile), ModulesKt.getNameWithoutExtension(mainFile) + "Kt"};
            String mainFqName = kotlin.collections.CollectionsKt.joinToString$default((Iterable)kotlin.collections.CollectionsKt.listOfNotNull((Object[])$this$firstOrNull$iv), (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
            object = kotlin.collections.CollectionsKt.listOf((Object)mainFqName);
        }
        Object mainClassAndArguments = object;
        Process process = this.launchSeparateJvmProcess(javaExe, module, classPath, (List<String>)mainClassAndArguments);
        process.waitFor(3L, TimeUnit.MINUTES);
        try {
            String string2;
            if (process.exitValue() == 0) {
                string2 = "OK";
            } else {
                StringBuilder stringBuilder;
                StringBuilder $this$runSeparateJvmInstance_u24lambda_u245 = stringBuilder = new StringBuilder();
                boolean bl5 = false;
                $this$firstOrNull$iv = new InputStream[]{process.getInputStream(), process.getErrorStream()};
                for (InputStream stream : kotlin.collections.CollectionsKt.listOfNotNull((Object[])$this$firstOrNull$iv)) {
                    InputStream inputStream = stream;
                    Charset charset = Charsets.UTF_8;
                    Reader reader = new InputStreamReader(inputStream, charset);
                    int n = 8192;
                    (reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n)).lines().forEach(arg_0 -> JvmBoxRunner.runSeparateJvmInstance$lambda$5$lambda$4($this$runSeparateJvmInstance_u24lambda_u245, arg_0));
                }
                if (((CharSequence)$this$runSeparateJvmInstance_u24lambda_u245).length() == 0) {
                    StringBuilder stringBuilder2 = $this$runSeparateJvmInstance_u24lambda_u245.append("External process completed with error. Check the build log");
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append('\\n')");
                }
                String string3 = stringBuilder.toString();
                string2 = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"StringBuilder().apply(builderAction).toString()");
            }
            string = string2;
        }
        finally {
            process.getOutputStream().flush();
        }
        return string;
    }

    @NotNull
    protected Process launchSeparateJvmProcess(@NotNull File javaExe, @NotNull TestModule module, @NotNull List<URL> classPath, @NotNull List<String> mainClassAndArguments) {
        String string;
        String string2;
        String string3;
        Object[] objectArray;
        int n;
        Intrinsics.checkNotNullParameter((Object)javaExe, (String)"javaExe");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter(classPath, (String)"classPath");
        Intrinsics.checkNotNullParameter(mainClassAndArguments, (String)"mainClassAndArguments");
        Object[] objectArray2 = new String[6];
        objectArray2[0] = javaExe.getAbsolutePath();
        Object[] objectArray3 = objectArray2;
        int n2 = 1;
        boolean condition$iv = module.getDirectives().contains(CodegenTestDirectives.INSTANCE.getATTACH_DEBUGGER());
        boolean $i$f$runIf = false;
        if (condition$iv) {
            n = n2;
            objectArray = objectArray3;
            boolean bl = false;
            string3 = "-agentlib:jdwp=transport=dt_socket,server=y,suspend=y,address=5005";
            objectArray3 = objectArray;
            n2 = n;
            string2 = string3;
        } else {
            string2 = null;
        }
        objectArray3[n2] = string2;
        objectArray2[2] = "-ea";
        Object[] objectArray4 = objectArray2;
        int n3 = 3;
        condition$iv = module.getDirectives().contains(LanguageSettingsDirectives.INSTANCE.getENABLE_JVM_PREVIEW());
        $i$f$runIf = false;
        if (condition$iv) {
            n = n3;
            objectArray = objectArray4;
            boolean bl = false;
            string3 = "--enable-preview";
            objectArray4 = objectArray;
            n3 = n;
            string = string3;
        } else {
            string = null;
        }
        objectArray4[n3] = string;
        objectArray2[4] = "-classpath";
        Iterable iterable = classPath;
        String string4 = File.pathSeparator;
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"pathSeparator");
        objectArray2[5] = kotlin.collections.CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string4, null, null, (int)0, null, (Function1)launchSeparateJvmProcess.command.3.INSTANCE, (int)30, null);
        List command2 = kotlin.collections.CollectionsKt.plus((Collection)kotlin.collections.CollectionsKt.listOfNotNull((Object[])objectArray2), (Iterable)mainClassAndArguments);
        Process process = new ProcessBuilder(command2).start();
        Intrinsics.checkNotNullExpressionValue((Object)process, (String)"ProcessBuilder(command).start()");
        return process;
    }

    private final String invokeBoxInSeparateProcess(TestModule module, ClassFileFactory classFileFactory, URLClassLoader classLoader, Class<?> clazz) {
        List<URL> classPath = this.extractClassPath(module, classLoader, classFileFactory);
        Integer n = Integer.valueOf(BOX_IN_SEPARATE_PROCESS_PORT);
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"valueOf(BOX_IN_SEPARATE_PROCESS_PORT)");
        int n2 = ((Number)n).intValue();
        String string = clazz.getCanonicalName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"clazz.canonicalName");
        TestProxy proxy = new TestProxy(n2, string, classPath);
        return proxy.runTest();
    }

    private final List<URL> extractClassPath(TestModule module, URLClassLoader classLoader, ClassFileFactory classFileFactory) {
        List list;
        List $this$extractClassPath_u24lambda_u248 = list = kotlin.collections.CollectionsKt.createListBuilder();
        boolean bl = false;
        $this$extractClassPath_u24lambda_u248.addAll((Collection)TestUtilsKt.extractUrls(classLoader));
        if (classLoader instanceof GeneratedClassLoader) {
            URL javaPath;
            File file = CompiledClassesManagerKt.getCompiledClassesManager(this.getTestServices()).getCompiledJavaDirForModule(module);
            URL uRL = javaPath = file != null ? this.getUrl(file) : null;
            if (javaPath != null) {
                $this$extractClassPath_u24lambda_u248.add(0, javaPath);
            }
            $this$extractClassPath_u24lambda_u248.add(0, this.getUrl(CompiledClassesManagerKt.getCompiledClassesManager(this.getTestServices()).getCompiledKotlinDirForModule(module, classFileFactory)));
        }
        return kotlin.collections.CollectionsKt.build((List)list);
    }

    private final URL getUrl(File $this$url) {
        URL uRL = $this$url.toURI().toURL();
        Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"toURI().toURL()");
        return uRL;
    }

    private final GeneratedClassLoader createAndVerifyClassLoader(TestModule module, ClassFileFactory classFileFactory, boolean reportProblems) {
        GeneratedClassLoader classLoader = this.createClassLoader(module, classFileFactory);
        if (!module.getDirectives().contains(CodegenTestDirectives.INSTANCE.getREQUIRES_SEPARATE_PROCESS())) {
            boolean verificationSucceeded;
            TestJdkKind testJdkKind = DirectiveKt.singleOrZeroValue(module.getDirectives(), JvmEnvironmentConfigurationDirectives.INSTANCE.getJDK_KIND());
            if (!(testJdkKind != null ? testJdkKind.getRequiresSeparateProcess() : false) && !(verificationSucceeded = CodegenTestUtil.verifyAllFilesWithAsm(classFileFactory, (ClassLoader)classLoader, reportProblems))) {
                this.getAssertions().fail((Function0<String>)((Function0)createAndVerifyClassLoader.1.INSTANCE));
                throw null;
            }
        }
        return classLoader;
    }

    /*
     * WARNING - void declaration
     */
    private final GeneratedClassLoader createClassLoader(TestModule module, ClassFileFactory classFileFactory) {
        void $this$toTypedArray$iv;
        Collection<URL> collection;
        void $this$mapTo$iv$iv;
        Collection $this$map$iv;
        CompilerConfiguration configuration2 = CompilerConfigurationProviderKt.getCompilerConfigurationProvider(this.getTestServices()).getCompilerConfiguration(module);
        ConfigurationKind configurationKind = (ConfigurationKind)((Object)configuration2.get(JvmEnvironmentConfigurator.Companion.getTEST_CONFIGURATION_KIND_KEY()));
        ClassLoader parentClassLoader = (configurationKind != null ? configurationKind.getWithReflection() : false) ? KotlinStandardLibrariesPathProviderKt.getStandardLibrariesPathProvider(this.getTestServices()).getRuntimeAndReflectJarClassLoader() : KotlinStandardLibrariesPathProviderKt.getStandardLibrariesPathProvider(this.getTestServices()).getRuntimeJarClassLoader();
        List<File> classpath = this.computeRuntimeClasspath(module);
        Iterable iterable = classpath;
        ClassLoader classLoader = parentClassLoader;
        ClassFileFactory classFileFactory2 = classFileFactory;
        boolean $i$f$map = false;
        void var9_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            File file = (File)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.toURI().toURL());
        }
        collection = (List)destination$iv$iv;
        $this$map$iv = collection;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        URL[] uRLArray = thisCollection$iv.toArray(new URL[0]);
        Intrinsics.checkNotNull((Object)uRLArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        URL[] uRLArray2 = uRLArray;
        URL[] uRLArray3 = Arrays.copyOf(uRLArray2, uRLArray2.length);
        ClassLoader classLoader2 = classLoader;
        ClassFileFactory classFileFactory3 = classFileFactory2;
        return new GeneratedClassLoader(classFileFactory3, classLoader2, uRLArray3);
    }

    private final List<File> computeRuntimeClasspath(TestModule rootModule) {
        Set visited = new LinkedHashSet();
        List result = new ArrayList();
        JvmBoxRunner.computeRuntimeClasspath$computeClasspath(visited, result, this, rootModule, true);
        Iterable $this$flatMapTo$iv = RuntimeClasspathProviderKt.getRuntimeClasspathProviders(this.getTestServices());
        boolean $i$f$flatMapTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            RuntimeClasspathProvider it = (RuntimeClasspathProvider)element$iv;
            boolean bl = false;
            Iterable list$iv = it.runtimeClassPaths(rootModule);
            kotlin.collections.CollectionsKt.addAll((Collection)result, (Iterable)list$iv);
        }
        return result;
    }

    private final String getFacadeFqName(KtFile $this$getFacadeFqName) {
        String string;
        boolean condition$iv = !((Collection)CodegenUtil.getMemberDeclarationsToGenerate((KtFile)$this$getFacadeFqName)).isEmpty();
        boolean $i$f$runIf = false;
        if (condition$iv) {
            boolean bl = false;
            string = JvmFileClassUtil.getFileClassInfoNoResolve((KtFile)$this$getFacadeFqName).getFacadeClassFqName().asString();
        } else {
            string = null;
        }
        return string;
    }

    private final Class<?> getGeneratedClass(ClassLoader $this$getGeneratedClass, String className) {
        try {
            Class<?> clazz = $this$getGeneratedClass.loadClass(className);
            Intrinsics.checkNotNullExpressionValue(clazz, (String)"loadClass(className)");
            return clazz;
        }
        catch (ClassNotFoundException e) {
            this.getAssertions().fail((Function0<String>)((Function0)new Function0<String>(className){
                final /* synthetic */ String $className;
                {
                    this.$className = $className;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "No class file was generated for: " + this.$className;
                }
            }));
            throw null;
        }
    }

    private final Method getBoxMethodOrNull(Class<?> $this$getBoxMethodOrNull) {
        Method method;
        try {
            method = $this$getBoxMethodOrNull.getMethod("box", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        return method;
    }

    private static final void runSeparateJvmInstance$lambda$5$lambda$4(StringBuilder $this_buildString, String it) {
        Intrinsics.checkNotNullParameter((Object)$this_buildString, (String)"$this_buildString");
        StringBuilder stringBuilder = $this_buildString.append(it);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append('\\n')");
    }

    private static final void computeRuntimeClasspath$computeClasspath(Set<TestModule> visited, List<File> result, JvmBoxRunner this$0, TestModule module, boolean isRoot) {
        if (!visited.add(module)) {
            return;
        }
        if (!isRoot) {
            result.add(CompiledClassesManager.getCompiledKotlinDirForModule$default(CompiledClassesManagerKt.getCompiledClassesManager(this$0.getTestServices()), module, null, 2, null));
        }
        CollectionsKt.addIfNotNull((Collection)result, (Object)CompiledClassesManagerKt.getCompiledClassesManager(this$0.getTestServices()).getCompiledJavaDirForModule(module));
        for (DependencyDescription dependency : module.getAllDependencies()) {
            if (dependency.getKind() != DependencyKind.Binary) continue;
            JvmBoxRunner.computeRuntimeClasspath$computeClasspath(visited, result, this$0, DependencyProviderKt.getDependencyProvider(this$0.getTestServices()).getTestModule(dependency.getModuleName()), false);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/test/backend/handlers/JvmBoxRunner$Companion;", "", "()V", "BOX_IN_SEPARATE_PROCESS_PORT", "", "kotlin.jvm.PlatformType", "tests-common-new"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TestJdkKind.values().length];
            try {
                nArray[TestJdkKind.FULL_JDK.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TestJdkKind.FULL_JDK_11.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TestJdkKind.FULL_JDK_17.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

