/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.generators.model;

import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.generators.model.AnnotationModel;
import org.jetbrains.kotlin.generators.model.MethodModel;
import org.jetbrains.kotlin.generators.model.RunTestMethodModel;
import org.jetbrains.kotlin.generators.model.SingleClassTestModel;
import org.jetbrains.kotlin.generators.model.TestClassModel;
import org.jetbrains.kotlin.generators.model.TransformingTestMethodModel;
import org.jetbrains.kotlin.generators.util.MethodModelLocatorKt;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.util.KtTestUtil;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b!\u0018\u00002\u00020\u0001:\u000267B\u0089\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\b\u0012\u0006\u0010\u000f\u001a\u00020\n\u0012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\u0011\u0012\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u0011\u0012\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\n0\u0011\u0012\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016\u00a2\u0006\u0002\u0010\u0018J\u0016\u00104\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u00105\u001a\u00020\u0003H\u0002R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0012\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001eR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\"R\u001a\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00010\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u0014\u0010'\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R!\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00170\u00168VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b+\u0010,\u001a\u0004\b*\u0010&R\u0014\u0010-\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010\u001eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u000e\u0010\u000e\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\n0\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010\u001aR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lorg/jetbrains/kotlin/generators/model/SingleClassTestModel;", "Lorg/jetbrains/kotlin/generators/model/TestClassModel;", "rootFile", "Ljava/io/File;", "filenamePattern", "Ljava/util/regex/Pattern;", "excludePattern", "checkFilenameStartsLowerCase", "", "doTestMethodName", "", "testClassName", "targetBackend", "Lorg/jetbrains/kotlin/test/TargetBackend;", "skipIgnored", "testRunnerMethodName", "additionalRunnerArguments", "", "annotations", "Lorg/jetbrains/kotlin/generators/model/AnnotationModel;", "tags", "additionalMethods", "", "Lorg/jetbrains/kotlin/generators/model/MethodModel;", "(Ljava/io/File;Ljava/util/regex/Pattern;Ljava/util/regex/Pattern;Ljava/lang/Boolean;Ljava/lang/String;Ljava/lang/String;Lorg/jetbrains/kotlin/test/TargetBackend;ZLjava/lang/String;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/Collection;)V", "getAnnotations", "()Ljava/util/List;", "Ljava/lang/Boolean;", "dataPathRoot", "getDataPathRoot", "()Ljava/lang/String;", "dataString", "getDataString", "getExcludePattern", "()Ljava/util/regex/Pattern;", "getFilenamePattern", "innerTestClasses", "getInnerTestClasses", "()Ljava/util/Collection;", "isEmpty", "()Z", "methods", "getMethods", "methods$delegate", "Lkotlin/Lazy;", "name", "getName", "getRootFile", "()Ljava/io/File;", "getTags", "getTargetBackend", "()Lorg/jetbrains/kotlin/test/TargetBackend;", "getTestMethodsFromFile", "file", "AllFilesPresentedMethodKind", "TestAllFilesPresentMethodModel", "test-generator"})
public final class SingleClassTestModel
extends TestClassModel {
    @NotNull
    private final File rootFile;
    @NotNull
    private final Pattern filenamePattern;
    @Nullable
    private final Pattern excludePattern;
    @Nullable
    private final Boolean checkFilenameStartsLowerCase;
    @NotNull
    private final String doTestMethodName;
    @NotNull
    private final String testClassName;
    @NotNull
    private final TargetBackend targetBackend;
    private final boolean skipIgnored;
    @NotNull
    private final String testRunnerMethodName;
    @NotNull
    private final List<String> additionalRunnerArguments;
    @NotNull
    private final List<AnnotationModel> annotations;
    @NotNull
    private final List<String> tags;
    @NotNull
    private final Collection<MethodModel> additionalMethods;
    @NotNull
    private final Lazy methods$delegate;
    @NotNull
    private final String dataString;
    @NotNull
    private final String dataPathRoot;

    public SingleClassTestModel(@NotNull File rootFile, @NotNull Pattern filenamePattern, @Nullable Pattern excludePattern, @Nullable Boolean checkFilenameStartsLowerCase, @NotNull String doTestMethodName, @NotNull String testClassName, @NotNull TargetBackend targetBackend, boolean skipIgnored, @NotNull String testRunnerMethodName, @NotNull List<String> additionalRunnerArguments, @NotNull List<AnnotationModel> annotations, @NotNull List<String> tags, @NotNull Collection<? extends MethodModel> additionalMethods) {
        Intrinsics.checkNotNullParameter((Object)rootFile, (String)"rootFile");
        Intrinsics.checkNotNullParameter((Object)filenamePattern, (String)"filenamePattern");
        Intrinsics.checkNotNullParameter((Object)doTestMethodName, (String)"doTestMethodName");
        Intrinsics.checkNotNullParameter((Object)testClassName, (String)"testClassName");
        Intrinsics.checkNotNullParameter((Object)((Object)targetBackend), (String)"targetBackend");
        Intrinsics.checkNotNullParameter((Object)testRunnerMethodName, (String)"testRunnerMethodName");
        Intrinsics.checkNotNullParameter(additionalRunnerArguments, (String)"additionalRunnerArguments");
        Intrinsics.checkNotNullParameter(annotations, (String)"annotations");
        Intrinsics.checkNotNullParameter(tags, (String)"tags");
        Intrinsics.checkNotNullParameter(additionalMethods, (String)"additionalMethods");
        this.rootFile = rootFile;
        this.filenamePattern = filenamePattern;
        this.excludePattern = excludePattern;
        this.checkFilenameStartsLowerCase = checkFilenameStartsLowerCase;
        this.doTestMethodName = doTestMethodName;
        this.testClassName = testClassName;
        this.targetBackend = targetBackend;
        this.skipIgnored = skipIgnored;
        this.testRunnerMethodName = testRunnerMethodName;
        this.additionalRunnerArguments = additionalRunnerArguments;
        this.annotations = annotations;
        this.tags = tags;
        this.additionalMethods = additionalMethods;
        this.methods$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<? extends MethodModel>>(this){
            final /* synthetic */ SingleClassTestModel this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final List<MethodModel> invoke() {
                boolean bl;
                List result;
                block4: {
                    result = new ArrayList<E>();
                    result.add(new RunTestMethodModel(this.this$0.getTargetBackend(), SingleClassTestModel.access$getDoTestMethodName$p(this.this$0), SingleClassTestModel.access$getTestRunnerMethodName$p(this.this$0), SingleClassTestModel.access$getAdditionalRunnerArguments$p(this.this$0), false, 16, null));
                    result.add(this.this$0.new TestAllFilesPresentMethodModel());
                    result.addAll(SingleClassTestModel.access$getAdditionalMethods$p(this.this$0));
                    FileUtil.processFilesRecursively((File)this.this$0.getRootFile(), arg_0 -> methods.2.invoke$lambda$0(this.this$0, result, arg_0));
                    Iterable $this$any$iv = result;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            MethodModel it = (MethodModel)element$iv;
                            boolean bl2 = false;
                            if (!(it instanceof TransformingTestMethodModel && it.shouldBeGenerated())) continue;
                            bl = true;
                            break block4;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    RunTestMethodModel additionalRunner = new RunTestMethodModel(this.this$0.getTargetBackend(), SingleClassTestModel.access$getDoTestMethodName$p(this.this$0), SingleClassTestModel.access$getTestRunnerMethodName$p(this.this$0), SingleClassTestModel.access$getAdditionalRunnerArguments$p(this.this$0), true);
                    result.add(additionalRunner);
                }
                return CollectionsKt.sortedWith((Iterable)result, methods.2::invoke$lambda$2);
            }

            private static final boolean invoke$lambda$0(SingleClassTestModel this$0, List $result, File file) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$result, (String)"$result");
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                if (!file.isDirectory() && this$0.getFilenamePattern().matcher(file.getName()).matches()) {
                    $result.addAll(SingleClassTestModel.access$getTestMethodsFromFile(this$0, file));
                }
                return true;
            }

            private static final int invoke$lambda$2(MethodModel o1, MethodModel o2) {
                Intrinsics.checkNotNullParameter((Object)o1, (String)"o1");
                Intrinsics.checkNotNullParameter((Object)o2, (String)"o2");
                return StringsKt.compareTo((String)o1.getName(), (String)o2.getName(), (boolean)true);
            }
        }));
        String string = KtTestUtil.getFilePath(this.rootFile);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFilePath(rootFile)");
        this.dataString = string;
        this.dataPathRoot = "$PROJECT_ROOT";
    }

    @NotNull
    public final File getRootFile() {
        return this.rootFile;
    }

    @NotNull
    public final Pattern getFilenamePattern() {
        return this.filenamePattern;
    }

    @Nullable
    public final Pattern getExcludePattern() {
        return this.excludePattern;
    }

    @NotNull
    public final TargetBackend getTargetBackend() {
        return this.targetBackend;
    }

    @NotNull
    public List<AnnotationModel> getAnnotations() {
        return this.annotations;
    }

    @Override
    @NotNull
    public List<String> getTags() {
        return this.tags;
    }

    @Override
    @NotNull
    public String getName() {
        return this.testClassName;
    }

    @Override
    @NotNull
    public Collection<MethodModel> getMethods() {
        Lazy lazy = this.methods$delegate;
        return (Collection)lazy.getValue();
    }

    @Override
    @NotNull
    public Collection<TestClassModel> getInnerTestClasses() {
        return CollectionsKt.emptyList();
    }

    private final Collection<MethodModel> getTestMethodsFromFile(File file) {
        return MethodModelLocatorKt.methodModelLocator(this.rootFile, file, this.filenamePattern, this.checkFilenameStartsLowerCase, this.targetBackend, this.skipIgnored, CollectionsKt.emptyList());
    }

    @Override
    public boolean isEmpty() {
        return this.getMethods().size() <= 1;
    }

    @Override
    @NotNull
    public String getDataString() {
        return this.dataString;
    }

    @Override
    @NotNull
    public String getDataPathRoot() {
        return this.dataPathRoot;
    }

    public static final /* synthetic */ String access$getDoTestMethodName$p(SingleClassTestModel $this) {
        return $this.doTestMethodName;
    }

    public static final /* synthetic */ String access$getTestRunnerMethodName$p(SingleClassTestModel $this) {
        return $this.testRunnerMethodName;
    }

    public static final /* synthetic */ List access$getAdditionalRunnerArguments$p(SingleClassTestModel $this) {
        return $this.additionalRunnerArguments;
    }

    public static final /* synthetic */ Collection access$getAdditionalMethods$p(SingleClassTestModel $this) {
        return $this.additionalMethods;
    }

    public static final /* synthetic */ Collection access$getTestMethodsFromFile(SingleClassTestModel $this, File file) {
        return $this.getTestMethodsFromFile(file);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/generators/model/SingleClassTestModel$AllFilesPresentedMethodKind;", "Lorg/jetbrains/kotlin/generators/model/MethodModel$Kind;", "()V", "test-generator"})
    public static final class AllFilesPresentedMethodKind
    extends MethodModel.Kind {
        @NotNull
        public static final AllFilesPresentedMethodKind INSTANCE = new AllFilesPresentedMethodKind();

        private AllFilesPresentedMethodKind() {
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\nR\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/generators/model/SingleClassTestModel$TestAllFilesPresentMethodModel;", "Lorg/jetbrains/kotlin/generators/model/MethodModel;", "(Lorg/jetbrains/kotlin/generators/model/SingleClassTestModel;)V", "classModel", "Lorg/jetbrains/kotlin/generators/model/SingleClassTestModel;", "getClassModel", "()Lorg/jetbrains/kotlin/generators/model/SingleClassTestModel;", "dataString", "", "getDataString", "()Ljava/lang/String;", "kind", "Lorg/jetbrains/kotlin/generators/model/MethodModel$Kind;", "getKind", "()Lorg/jetbrains/kotlin/generators/model/MethodModel$Kind;", "name", "getName", "tags", "", "getTags", "()Ljava/util/List;", "shouldBeGenerated", "", "test-generator"})
    public final class TestAllFilesPresentMethodModel
    implements MethodModel {
        @NotNull
        private final String name;

        public TestAllFilesPresentMethodModel() {
            this.name = "testAllFilesPresentIn" + SingleClassTestModel.this.testClassName;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        @Nullable
        public String getDataString() {
            return null;
        }

        @NotNull
        public final SingleClassTestModel getClassModel() {
            return SingleClassTestModel.this;
        }

        @Override
        @NotNull
        public MethodModel.Kind getKind() {
            return AllFilesPresentedMethodKind.INSTANCE;
        }

        @Override
        public boolean shouldBeGenerated() {
            return true;
        }

        @Override
        @NotNull
        public List<String> getTags() {
            return CollectionsKt.emptyList();
        }

        @Override
        public boolean isTestMethod() {
            return MethodModel.DefaultImpls.isTestMethod(this);
        }

        @Override
        public boolean shouldBeGeneratedForInnerTestClass() {
            return MethodModel.DefaultImpls.shouldBeGeneratedForInnerTestClass(this);
        }

        @Override
        @NotNull
        public Collection<Class<?>> imports() {
            return MethodModel.DefaultImpls.imports(this);
        }
    }
}

