/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codeMetaInfo;

import com.intellij.util.containers.Stack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codeMetaInfo.model.CodeMetaInfo;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\n2\u0006\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u00060\u000ej\u0002`\u000fH\u0002J\u001c\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u0013H\u0002JD\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\f2\u0018\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00110\u00172\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\n2\n\u0010\u0018\u001a\u00060\u000ej\u0002`\u000fH\u0002J \u0010\u0019\u001a\u00060\u000ej\u0002`\u000f2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00050\u00112\u0006\u0010\u001b\u001a\u00020\u001cJ(\u0010\u0019\u001a\u00020\b2\n\u0010\u0018\u001a\u00060\u000ej\u0002`\u000f2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00050\u00112\u0006\u0010\u001b\u001a\u00020\u001cR\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/codeMetaInfo/CodeMetaInfoRenderer;", "", "()V", "metaInfoComparator", "Ljava/util/Comparator;", "Lorg/jetbrains/kotlin/codeMetaInfo/model/CodeMetaInfo;", "Lkotlin/Comparator;", "checkOpenedAndCloseStringIfNeeded", "", "opened", "Lcom/intellij/util/containers/Stack;", "end", "", "result", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "getSortedCodeMetaInfos", "", "metaInfos", "", "processMetaInfosStartedAtOffset", "offset", "sortedMetaInfos", "", "builder", "renderTagsToText", "codeMetaInfos", "originalText", "", "test-infrastructure-utils"})
public final class CodeMetaInfoRenderer {
    @NotNull
    public static final CodeMetaInfoRenderer INSTANCE = new CodeMetaInfoRenderer();
    @NotNull
    private static final Comparator<CodeMetaInfo> metaInfoComparator = ComparisonsKt.then((Comparator)ComparisonsKt.then((Comparator)new Comparator(){

        public final int compare(T a, T b) {
            CodeMetaInfo it = (CodeMetaInfo)a;
            boolean bl = false;
            Comparable comparable = Integer.valueOf(it.getStart());
            it = (CodeMetaInfo)b;
            Comparable comparable2 = comparable;
            bl = false;
            return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getStart()));
        }
    }, (Comparator)new Comparator(){

        public final int compare(T a, T b) {
            CodeMetaInfo it = (CodeMetaInfo)b;
            boolean bl = false;
            Comparable comparable = Integer.valueOf(it.getEnd());
            it = (CodeMetaInfo)a;
            Comparable comparable2 = comparable;
            bl = false;
            return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getEnd()));
        }
    }), (Comparator)new Comparator(){

        public final int compare(T a, T b) {
            CodeMetaInfo it = (CodeMetaInfo)a;
            boolean bl = false;
            Comparable comparable = (Comparable)((Object)it.getTag());
            it = (CodeMetaInfo)b;
            Comparable comparable2 = comparable;
            bl = false;
            return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getTag())));
        }
    });

    private CodeMetaInfoRenderer() {
    }

    @NotNull
    public final StringBuilder renderTagsToText(@NotNull List<? extends CodeMetaInfo> codeMetaInfos, @NotNull String originalText) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(codeMetaInfos, (String)"codeMetaInfos");
        Intrinsics.checkNotNullParameter((Object)originalText, (String)"originalText");
        StringBuilder $this$renderTagsToText_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        INSTANCE.renderTagsToText($this$renderTagsToText_u24lambda_u240, codeMetaInfos, originalText);
        return stringBuilder;
    }

    /*
     * WARNING - void declaration
     */
    public final void renderTagsToText(@NotNull StringBuilder builder, @NotNull List<? extends CodeMetaInfo> codeMetaInfos, @NotNull String originalText) {
        boolean lastSymbolIsNewLine;
        void $this$groupByTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter(codeMetaInfos, (String)"codeMetaInfos");
        Intrinsics.checkNotNullParameter((Object)originalText, (String)"originalText");
        if (codeMetaInfos.isEmpty()) {
            builder.append(originalText);
            return;
        }
        Iterable $this$groupBy$iv = this.getSortedCodeMetaInfos((Collection<? extends CodeMetaInfo>)codeMetaInfos);
        int $i$f$groupBy = 0;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            CodeMetaInfo it = (CodeMetaInfo)element$iv$iv;
            boolean bl = false;
            Integer key$iv$iv = it.getStart();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map sortedMetaInfos = destination$iv$iv;
        Stack opened = new Stack();
        int n = originalText.length();
        for ($i$f$groupBy = 0; $i$f$groupBy < n; ++$i$f$groupBy) {
            int i = $i$f$groupBy;
            char c = originalText.charAt($i$f$groupBy);
            this.processMetaInfosStartedAtOffset(i, sortedMetaInfos, (Stack<CodeMetaInfo>)opened, builder);
            builder.append(c);
        }
        boolean bl = lastSymbolIsNewLine = StringsKt.last((CharSequence)builder) == '\n';
        if (lastSymbolIsNewLine) {
            builder.deleteCharAt(builder.length() - 1);
        }
        this.processMetaInfosStartedAtOffset(originalText.length(), sortedMetaInfos, (Stack<CodeMetaInfo>)opened, builder);
        if (lastSymbolIsNewLine) {
            Intrinsics.checkNotNullExpressionValue((Object)builder.append('\n'), (String)"append('\\n')");
        }
    }

    private final void processMetaInfosStartedAtOffset(int offset, Map<Integer, ? extends List<? extends CodeMetaInfo>> sortedMetaInfos, Stack<CodeMetaInfo> opened, StringBuilder builder) {
        List matchedCodeMetaInfos;
        this.checkOpenedAndCloseStringIfNeeded(opened, offset, builder);
        List list = sortedMetaInfos.get(offset);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        if (!((Collection)(matchedCodeMetaInfos = list)).isEmpty()) {
            ListIterator iterator = matchedCodeMetaInfos.listIterator();
            CodeMetaInfo current = (CodeMetaInfo)iterator.next();
            if (current != null) {
                builder.append(current.getTagPrefix());
            }
            while (current != null) {
                CodeMetaInfo next = iterator.hasNext() ? (CodeMetaInfo)iterator.next() : null;
                opened.push((Object)current);
                builder.append(current.asString());
                if (next == null) {
                    builder.append(current.getTagPostfix());
                } else if (next.getEnd() == current.getEnd()) {
                    builder.append(", ");
                } else {
                    builder.append(current.getTagPostfix());
                    builder.append(next.getTagPrefix());
                }
                current = next;
            }
        }
        this.checkOpenedAndCloseStringIfNeeded(opened, offset, builder);
    }

    private final List<CodeMetaInfo> getSortedCodeMetaInfos(Collection<? extends CodeMetaInfo> metaInfos) {
        return CollectionsKt.sortedWith((Iterable)metaInfos, metaInfoComparator);
    }

    private final void checkOpenedAndCloseStringIfNeeded(Stack<CodeMetaInfo> opened, int end, StringBuilder result) {
        CodeMetaInfo prev = null;
        while (!opened.isEmpty() && end == ((CodeMetaInfo)opened.peek()).getEnd()) {
            if (prev == null || prev.getStart() != ((CodeMetaInfo)opened.peek()).getStart()) {
                result.append(((CodeMetaInfo)opened.peek()).getClosingTag());
            }
            prev = (CodeMetaInfo)opened.pop();
        }
    }
}

