/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.dce;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.wasm.WasmBackendContext;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.DeclarationGeneratorKt;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.TypeTransformerKt;
import org.jetbrains.kotlin.backend.wasm.utils.AnnotationsKt;
import org.jetbrains.kotlin.backend.wasm.utils.WasmArrayInfo;
import org.jetbrains.kotlin.ir.backend.js.dce.UsefulDeclarationProcessor;
import org.jetbrains.kotlin.ir.backend.js.utils.AnnotationUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.IrResolveUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.MiscKt;
import org.jetbrains.kotlin.ir.backend.js.utils.TypeTranformerKt;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstKind;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.InlineClassesKt;
import org.jetbrains.kotlin.ir.util.IrFakeOverrideUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.wasm.ir.WasmImmediateKind;
import org.jetbrains.kotlin.wasm.ir.WasmOp;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J\u0010\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J\u0010\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u000eH\u0014J\f\u0010 \u001a\u00020\u0013*\u00020\u0011H\u0002J\u001c\u0010!\u001a\u00020\u0013*\u00020\"2\u0006\u0010#\u001a\u00020\u00112\u0006\u0010$\u001a\u00020%H\u0002J\u001c\u0010&\u001a\u00020\u0013*\u00020\"2\u0006\u0010#\u001a\u00020\u00112\u0006\u0010$\u001a\u00020%H\u0002J\u0014\u0010'\u001a\u00020\u0013*\u00020(2\u0006\u0010#\u001a\u00020\u0011H\u0002J\u000e\u0010)\u001a\u0004\u0018\u00010\"*\u00020\"H\u0002R\u0018\u0010\u0007\u001a\u00060\bR\u00020\u0001X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/dce/WasmUsefulDeclarationProcessor;", "Lorg/jetbrains/kotlin/ir/backend/js/dce/UsefulDeclarationProcessor;", "context", "Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "printReachabilityInfo", "", "(Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;Z)V", "bodyVisitor", "Lorg/jetbrains/kotlin/ir/backend/js/dce/UsefulDeclarationProcessor$BodyVisitorBase;", "getBodyVisitor", "()Lorg/jetbrains/kotlin/ir/backend/js/dce/UsefulDeclarationProcessor$BodyVisitorBase;", "getContext", "()Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "unitGetInstance", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "isExported", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "processClass", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "processConstructor", "irConstructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "processField", "irField", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "processIrFunction", "irFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "processSimpleFunction", "enqueueParentClass", "enqueueRuntimeClassOrAny", "Lorg/jetbrains/kotlin/ir/types/IrType;", "from", "info", "", "enqueueType", "enqueueValueParameterType", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "getInlinedValueTypeIfAny", "backend.wasm"})
public final class WasmUsefulDeclarationProcessor
extends UsefulDeclarationProcessor {
    @NotNull
    private final WasmBackendContext context;
    @NotNull
    private final IrSimpleFunction unitGetInstance;
    @NotNull
    private final UsefulDeclarationProcessor.BodyVisitorBase bodyVisitor;

    public WasmUsefulDeclarationProcessor(@NotNull WasmBackendContext context, boolean printReachabilityInfo) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(printReachabilityInfo, false);
        this.context = context;
        this.unitGetInstance = MiscKt.findUnitGetInstanceFunction(this.getContext());
        this.bodyVisitor = new UsefulDeclarationProcessor.BodyVisitorBase(this){
            final /* synthetic */ WasmUsefulDeclarationProcessor this$0;
            {
                this.this$0 = $receiver;
            }

            public void visitConst(@NotNull IrConst<?> expression2, @NotNull IrDeclaration data) {
                block1: {
                    IrConstKind<?> irConstKind;
                    block0: {
                        Intrinsics.checkNotNullParameter(expression2, (String)"expression");
                        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                        irConstKind = expression2.getKind();
                        if (!(irConstKind instanceof IrConstKind.Null)) break block0;
                        WasmUsefulDeclarationProcessor.access$enqueueType(this.this$0, expression2.getType(), data, "expression type");
                        break block1;
                    }
                    if (!(irConstKind instanceof IrConstKind.String)) break block1;
                    UsefulDeclarationProcessor.enqueue$default(this.this$0, this.this$0.getContext().getWasmSymbols().getStringGetLiteral().getOwner(), data, "String literal intrinsic getter stringGetLiteral", false, 4, null);
                }
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private final boolean tryToProcessIntrinsicCall(IrDeclaration from2, IrCall call2) {
                IrSimpleFunctionSymbol irSimpleFunctionSymbol = call2.getSymbol();
                if (Intrinsics.areEqual((Object)irSimpleFunctionSymbol, (Object)this.this$0.getContext().getWasmSymbols().getUnboxIntrinsic())) {
                    IrType fromType = call2.getTypeArgument(0);
                    if (fromType == null) return true;
                    if (IrTypePredicatesKt.isNothing(fromType)) return true;
                    if (IrTypePredicatesKt.isNullableNothing(fromType)) return true;
                    IrType irType = call2.getTypeArgument(1);
                    if (irType == null) return true;
                    IrType irType2 = irType;
                    WasmUsefulDeclarationProcessor wasmUsefulDeclarationProcessor = this.this$0;
                    IrType it = irType2;
                    boolean bl = false;
                    IrClass irClass2 = wasmUsefulDeclarationProcessor.getContext().getInlineClassesUtils().getInlinedClass(it);
                    if (irClass2 == null) return true;
                    IrClass it2 = irClass2;
                    boolean bl2 = false;
                    IrField irField = InlineClassesKt.getInlineClassBackingField(it2);
                    IrField backingField2 = irField;
                    if (backingField2 == null) return true;
                    UsefulDeclarationProcessor.enqueue$default(this.this$0, backingField2, from2, "backing inline class field for unboxIntrinsic", false, 4, null);
                    return true;
                }
                if (!((Intrinsics.areEqual((Object)irSimpleFunctionSymbol, (Object)this.this$0.getContext().getWasmSymbols().getWasmClassId()) ? true : Intrinsics.areEqual((Object)irSimpleFunctionSymbol, (Object)this.this$0.getContext().getWasmSymbols().getWasmInterfaceId())) ? true : Intrinsics.areEqual((Object)irSimpleFunctionSymbol, (Object)this.this$0.getContext().getWasmSymbols().getWasmRefCast()))) return false;
                IrType irType = call2.getTypeArgument(0);
                if (irType == null) return true;
                IrClass irClass3 = IrTypesKt.getClass(irType);
                if (irClass3 == null) return true;
                UsefulDeclarationProcessor.enqueue$default(this.this$0, irClass3, from2, "generic intrinsic " + ((IrSimpleFunction)call2.getSymbol().getOwner()).getName(), false, 4, null);
                return true;
            }

            private final boolean tryToProcessWasmOpIntrinsicCall(IrDeclaration from2, IrCall call2, IrFunction function2) {
                if (AnnotationsKt.hasWasmNoOpCastAnnotation(function2)) {
                    return true;
                }
                String opString = AnnotationsKt.getWasmOpAnnotation(function2);
                if (opString != null) {
                    WasmOp op = WasmOp.valueOf(opString);
                    switch (op.getImmediates().size()) {
                        case 0: {
                            IrType irType;
                            if (op != WasmOp.REF_TEST || (irType = call2.getTypeArgument(0)) == null) break;
                            WasmUsefulDeclarationProcessor.access$enqueueRuntimeClassOrAny(this.this$0, irType, from2, "REF_TEST");
                            break;
                        }
                        case 1: {
                            IrClass irClass2;
                            IrClassSymbol irClassSymbol;
                            IrType irType;
                            IrValueParameter irValueParameter;
                            if (CollectionsKt.firstOrNull(op.getImmediates()) != WasmImmediateKind.STRUCT_TYPE_IDX || (irValueParameter = function2.getDispatchReceiverParameter()) == null || (irType = irValueParameter.getType()) == null || (irClassSymbol = IrTypesKt.getClassOrNull(irType)) == null || (irClass2 = (IrClass)irClassSymbol.getOwner()) == null) break;
                            UsefulDeclarationProcessor.enqueue$default(this.this$0, irClass2, from2, "STRUCT_TYPE_IDX", false, 4, null);
                        }
                    }
                    return true;
                }
                return false;
            }

            public void visitCall(@NotNull IrCall expression2, @NotNull IrDeclaration data) {
                boolean isSuperCall;
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                super.visitCall(expression2, data);
                if (Intrinsics.areEqual((Object)expression2.getSymbol(), (Object)this.this$0.getContext().getWasmSymbols().getBoxIntrinsic())) {
                    IrType irType = expression2.getTypeArgument(0);
                    if (irType != null) {
                        WasmUsefulDeclarationProcessor.access$enqueueRuntimeClassOrAny(this.this$0, irType, data, "boxIntrinsic");
                    }
                    return;
                }
                IrFunction function2 = IrResolveUtilsKt.getRealOverrideTarget((IrSimpleFunction)expression2.getSymbol().getOwner());
                if (Intrinsics.areEqual((Object)function2.getReturnType(), (Object)this.this$0.getContext().getIrBuiltIns().getUnitType())) {
                    UsefulDeclarationProcessor.enqueue$default(this.this$0, WasmUsefulDeclarationProcessor.access$getUnitGetInstance$p(this.this$0), data, "function Unit return type", false, 4, null);
                }
                if (this.tryToProcessIntrinsicCall(data, expression2)) {
                    return;
                }
                if (this.tryToProcessWasmOpIntrinsicCall(data, expression2, function2)) {
                    return;
                }
                boolean bl = isSuperCall = expression2.getSuperQualifierSymbol() != null;
                if (function2 instanceof IrSimpleFunction && org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.isOverridable((IrSimpleFunction)function2) && !isSuperCall) {
                    IrClass klass = IrUtilsKt.getParentAsClass(function2);
                    if (!IrUtilsKt.isInterface(klass)) {
                        UsefulDeclarationProcessor.enqueue$default(this.this$0, this.this$0.getContext().getWasmSymbols().getGetVirtualMethodId().getOwner(), data, "call on class receiver", false, 4, null);
                    } else {
                        UsefulDeclarationProcessor.enqueue$default(this.this$0, klass, data, "receiver class", false, 4, null);
                        UsefulDeclarationProcessor.enqueue$default(this.this$0, this.this$0.getContext().getWasmSymbols().getGetInterfaceImplId().getOwner(), data, "call on interface receiver", false, 4, null);
                    }
                    UsefulDeclarationProcessor.enqueue$default(this.this$0, function2, data, "method call", false, 4, null);
                }
            }
        };
    }

    @Override
    @NotNull
    public WasmBackendContext getContext() {
        return this.context;
    }

    @Override
    @NotNull
    protected UsefulDeclarationProcessor.BodyVisitorBase getBodyVisitor() {
        return this.bodyVisitor;
    }

    private final IrType getInlinedValueTypeIfAny(IrType $this$getInlinedValueTypeIfAny) {
        IrType irType;
        IrType irType2 = $this$getInlinedValueTypeIfAny;
        if (((((((((((((Intrinsics.areEqual((Object)irType2, (Object)this.getContext().getIrBuiltIns().getBooleanType()) ? true : Intrinsics.areEqual((Object)irType2, (Object)this.getContext().getIrBuiltIns().getByteType())) ? true : Intrinsics.areEqual((Object)irType2, (Object)this.getContext().getIrBuiltIns().getShortType())) ? true : Intrinsics.areEqual((Object)irType2, (Object)this.getContext().getIrBuiltIns().getCharType())) ? true : Intrinsics.areEqual((Object)irType2, (Object)this.getContext().getIrBuiltIns().getBooleanType())) ? true : Intrinsics.areEqual((Object)irType2, (Object)this.getContext().getIrBuiltIns().getByteType())) ? true : Intrinsics.areEqual((Object)irType2, (Object)this.getContext().getIrBuiltIns().getShortType())) ? true : Intrinsics.areEqual((Object)irType2, (Object)this.getContext().getIrBuiltIns().getIntType())) ? true : Intrinsics.areEqual((Object)irType2, (Object)this.getContext().getIrBuiltIns().getCharType())) ? true : Intrinsics.areEqual((Object)irType2, (Object)this.getContext().getIrBuiltIns().getLongType())) ? true : Intrinsics.areEqual((Object)irType2, (Object)this.getContext().getIrBuiltIns().getFloatType())) ? true : Intrinsics.areEqual((Object)irType2, (Object)this.getContext().getIrBuiltIns().getDoubleType())) ? true : Intrinsics.areEqual((Object)irType2, (Object)this.getContext().getIrBuiltIns().getNothingType())) ? true : Intrinsics.areEqual((Object)irType2, (Object)this.getContext().getWasmSymbols().getVoidType())) {
            irType = null;
        } else if (TypeTransformerKt.isBuiltInWasmRefType($this$getInlinedValueTypeIfAny)) {
            irType = null;
        } else {
            IrClass ic;
            IrClass irClass2 = TypeTranformerKt.getErasedUpperBound($this$getInlinedValueTypeIfAny);
            irType = (irClass2 != null ? irClass2.isExternal() : false) ? null : ((ic = this.getContext().getInlineClassesUtils().getInlinedClass($this$getInlinedValueTypeIfAny)) == null ? $this$getInlinedValueTypeIfAny : this.getInlinedValueTypeIfAny(this.getContext().getInlineClassesUtils().getInlineClassUnderlyingType(ic)));
        }
        return irType;
    }

    private final void enqueueRuntimeClassOrAny(IrType $this$enqueueRuntimeClassOrAny, IrDeclaration from2, String info) {
        IrClass irClass2 = TypeTransformerKt.getGetRuntimeClass($this$enqueueRuntimeClassOrAny);
        if (irClass2 == null) {
            irClass2 = (IrClass)this.getContext().getWasmSymbols().getAny().getOwner();
        }
        this.enqueue(irClass2, from2, info, false);
    }

    private final void enqueueType(IrType $this$enqueueType, IrDeclaration from2, String info) {
        IrType irType = this.getInlinedValueTypeIfAny($this$enqueueType);
        if (irType != null) {
            this.enqueueRuntimeClassOrAny(irType, from2, info);
        }
    }

    private final void enqueueParentClass(IrDeclaration $this$enqueueParentClass) {
        block0: {
            IrClass irClass2 = IrUtilsKt.getParentClassOrNull($this$enqueueParentClass);
            if (irClass2 == null) break block0;
            this.enqueue(irClass2, $this$enqueueParentClass, "parent class", false);
        }
    }

    @Override
    protected void processField(@NotNull IrField irField) {
        Intrinsics.checkNotNullParameter((Object)irField, (String)"irField");
        super.processField(irField);
        this.enqueueParentClass(irField);
        this.enqueueType(irField.getType(), irField, "field types");
    }

    @Override
    protected void processClass(@NotNull IrClass irClass2) {
        block5: {
            Object v0;
            Object object;
            Object object2;
            block4: {
                Intrinsics.checkNotNullParameter((Object)irClass2, (String)"irClass");
                super.processClass(irClass2);
                object2 = AnnotationsKt.getWasmArrayAnnotation(irClass2);
                if (object2 != null && (object = ((WasmArrayInfo)object2).getType()) != null) {
                    this.enqueueType((IrType)object, irClass2, "array type for wasm array annotated");
                }
                if (!this.getContext().getInlineClassesUtils().isClassInlineLike(irClass2)) break block5;
                Iterable $this$firstIsInstanceOrNull$iv = irClass2.getDeclarations();
                boolean $i$f$firstIsInstanceOrNull = false;
                for (Object element$iv : $this$firstIsInstanceOrNull$iv) {
                    if (!(element$iv instanceof IrConstructor)) continue;
                    v0 = element$iv;
                    break block4;
                }
                v0 = null;
            }
            object2 = v0;
            if (object2 != null) {
                Object object3;
                Object it = object3 = object2;
                boolean bl = false;
                Object object4 = object = ((IrConstructor)it).isPrimary() ? object3 : null;
                if (object != null) {
                    UsefulDeclarationProcessor.enqueue$default(this, (IrDeclaration)object, irClass2, "inline class primary ctor", false, 4, null);
                }
            }
        }
    }

    private final void enqueueValueParameterType(IrValueParameter $this$enqueueValueParameterType, IrDeclaration from2) {
        if (this.getContext().getInlineClassesUtils().shouldValueParameterBeBoxed($this$enqueueValueParameterType)) {
            this.enqueueRuntimeClassOrAny($this$enqueueValueParameterType.getType(), from2, "function ValueParameterType");
        } else {
            this.enqueueType($this$enqueueValueParameterType.getType(), from2, "function ValueParameterType");
        }
    }

    private final void processIrFunction(IrFunction irFunction2) {
        boolean isIntrinsic;
        if (IrFakeOverrideUtilsKt.isFakeOverride(irFunction2)) {
            return;
        }
        boolean bl = isIntrinsic = AnnotationsKt.hasWasmNoOpCastAnnotation(irFunction2) || AnnotationsKt.getWasmOpAnnotation(irFunction2) != null;
        if (isIntrinsic) {
            return;
        }
        Iterable $this$forEach$iv = DeclarationGeneratorKt.getEffectiveValueParameters(irFunction2);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrValueParameter it = (IrValueParameter)element$iv;
            boolean bl2 = false;
            this.enqueueValueParameterType(it, irFunction2);
        }
        this.enqueueType(irFunction2.getReturnType(), irFunction2, "function return type");
    }

    @Override
    protected void processSimpleFunction(@NotNull IrSimpleFunction irFunction2) {
        Intrinsics.checkNotNullParameter((Object)irFunction2, (String)"irFunction");
        super.processSimpleFunction(irFunction2);
        this.enqueueParentClass(irFunction2);
        if (irFunction2.isFakeOverride()) {
            Iterable $this$forEach$iv = irFunction2.getOverriddenSymbols();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IrSimpleFunctionSymbol overridden = (IrSimpleFunctionSymbol)element$iv;
                boolean bl = false;
                UsefulDeclarationProcessor.enqueue$default(this, overridden.getOwner(), irFunction2, "original for fake-override", false, 4, null);
            }
        }
        this.processIrFunction(irFunction2);
    }

    @Override
    protected void processConstructor(@NotNull IrConstructor irConstructor2) {
        Intrinsics.checkNotNullParameter((Object)irConstructor2, (String)"irConstructor");
        super.processConstructor(irConstructor2);
        if (!this.getContext().getInlineClassesUtils().isClassInlineLike(IrUtilsKt.getParentAsClass(irConstructor2))) {
            this.processIrFunction(irConstructor2);
        }
    }

    @Override
    protected boolean isExported(@NotNull IrDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        return AnnotationUtilsKt.isJsExport(declaration);
    }

    public static final /* synthetic */ void access$enqueueType(WasmUsefulDeclarationProcessor $this, IrType $receiver, IrDeclaration from2, String info) {
        $this.enqueueType($receiver, from2, info);
    }

    public static final /* synthetic */ void access$enqueueRuntimeClassOrAny(WasmUsefulDeclarationProcessor $this, IrType $receiver, IrDeclaration from2, String info) {
        $this.enqueueRuntimeClassOrAny($receiver, from2, info);
    }

    public static final /* synthetic */ IrSimpleFunction access$getUnitGetInstance$p(WasmUsefulDeclarationProcessor $this) {
        return $this.unitGetInstance;
    }
}

