/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.model;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.test.model.AbstractTestFacade;
import org.jetbrains.kotlin.test.model.BackendKind;
import org.jetbrains.kotlin.test.model.FrontendKind;
import org.jetbrains.kotlin.test.model.ResultingArtifact;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.TestServices;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u0002*\u000e\b\u0001\u0010\u0003*\b\u0012\u0004\u0012\u0002H\u00030\u00042\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0005B)\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/test/model/Frontend2BackendConverter;", "R", "Lorg/jetbrains/kotlin/test/model/ResultingArtifact$FrontendOutput;", "I", "Lorg/jetbrains/kotlin/test/model/ResultingArtifact$BackendInput;", "Lorg/jetbrains/kotlin/test/model/AbstractTestFacade;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "inputKind", "Lorg/jetbrains/kotlin/test/model/FrontendKind;", "outputKind", "Lorg/jetbrains/kotlin/test/model/BackendKind;", "(Lorg/jetbrains/kotlin/test/services/TestServices;Lorg/jetbrains/kotlin/test/model/FrontendKind;Lorg/jetbrains/kotlin/test/model/BackendKind;)V", "getInputKind", "()Lorg/jetbrains/kotlin/test/model/FrontendKind;", "getOutputKind", "()Lorg/jetbrains/kotlin/test/model/BackendKind;", "getTestServices", "()Lorg/jetbrains/kotlin/test/services/TestServices;", "shouldRunAnalysis", "", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "test-infrastructure"})
public abstract class Frontend2BackendConverter<R extends ResultingArtifact.FrontendOutput<R>, I extends ResultingArtifact.BackendInput<I>>
extends AbstractTestFacade<R, I> {
    @NotNull
    private final TestServices testServices;
    @NotNull
    private final FrontendKind<R> inputKind;
    @NotNull
    private final BackendKind<I> outputKind;

    public Frontend2BackendConverter(@NotNull TestServices testServices, @NotNull FrontendKind<R> inputKind, @NotNull BackendKind<I> outputKind) {
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        Intrinsics.checkNotNullParameter(inputKind, (String)"inputKind");
        Intrinsics.checkNotNullParameter(outputKind, (String)"outputKind");
        this.testServices = testServices;
        this.inputKind = inputKind;
        this.outputKind = outputKind;
    }

    @NotNull
    public final TestServices getTestServices() {
        return this.testServices;
    }

    @Override
    @NotNull
    public final FrontendKind<R> getInputKind() {
        return this.inputKind;
    }

    @Override
    @NotNull
    public final BackendKind<I> getOutputKind() {
        return this.outputKind;
    }

    @Override
    public boolean shouldRunAnalysis(@NotNull TestModule module2) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        return Intrinsics.areEqual(module2.getBackendKind(), this.outputKind);
    }
}

