/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.frontend.classic;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.impl.ModuleDescriptorImpl;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.AssertionsKt;
import org.jetbrains.kotlin.test.services.TestService;
import org.jetbrains.kotlin.test.services.TestServices;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u0007J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eR\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/test/frontend/classic/ModuleDescriptorProvider;", "Lorg/jetbrains/kotlin/test/services/TestService;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "moduleDescriptorByModule", "", "Lorg/jetbrains/kotlin/test/model/TestModule;", "Lorg/jetbrains/kotlin/descriptors/impl/ModuleDescriptorImpl;", "getModuleDescriptor", "testModule", "replaceModuleDescriptorForModule", "", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "tests-common-new"})
public final class ModuleDescriptorProvider
implements TestService {
    @NotNull
    private final TestServices testServices;
    @NotNull
    private final Map<TestModule, ModuleDescriptorImpl> moduleDescriptorByModule;

    public ModuleDescriptorProvider(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        this.testServices = testServices;
        this.moduleDescriptorByModule = new LinkedHashMap();
    }

    @NotNull
    public final ModuleDescriptorImpl getModuleDescriptor(@NotNull TestModule testModule) {
        Intrinsics.checkNotNullParameter((Object)testModule, (String)"testModule");
        ModuleDescriptorImpl moduleDescriptorImpl = this.moduleDescriptorByModule.get(testModule);
        if (moduleDescriptorImpl == null) {
            AssertionsKt.getAssertions(this.testServices).fail((Function0<String>)((Function0)new Function0<String>(testModule){
                final /* synthetic */ TestModule $testModule;
                {
                    this.$testModule = $testModule;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Module descriptor for module " + this.$testModule.getName() + " not found";
                }
            }));
            throw null;
        }
        return moduleDescriptorImpl;
    }

    public final void replaceModuleDescriptorForModule(@NotNull TestModule testModule, @NotNull ModuleDescriptor moduleDescriptor) {
        Intrinsics.checkNotNullParameter((Object)testModule, (String)"testModule");
        Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"moduleDescriptor");
        if (!(moduleDescriptor instanceof ModuleDescriptorImpl)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        this.moduleDescriptorByModule.put(testModule, (ModuleDescriptorImpl)moduleDescriptor);
    }
}

