/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.backend.handlers;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StackFrame;
import com.sun.jdi.Value;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.LocatableEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.test.backend.handlers.DebugRunner;
import org.jetbrains.kotlin.test.backend.handlers.LoggedData;
import org.jetbrains.kotlin.test.services.TestServices;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0005\u0017\u0018\u0019\u001a\u001bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\u0005\u001a\u00020\u00062\u0016\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\t0\bj\b\u0012\u0004\u0012\u00020\t`\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0016\u0010\u0013\u001a\u00020\u00062\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/test/backend/handlers/LocalVariableDebugRunner;", "Lorg/jetbrains/kotlin/test/backend/handlers/DebugRunner;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "storeStep", "", "loggedItems", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/test/backend/handlers/LoggedData;", "Lkotlin/collections/ArrayList;", "event", "Lcom/sun/jdi/event/Event;", "toRecord", "Lorg/jetbrains/kotlin/test/backend/handlers/LocalVariableDebugRunner$LocalVariableRecord;", "frame", "Lcom/sun/jdi/StackFrame;", "variable", "Lcom/sun/jdi/LocalVariable;", "waitUntil", "condition", "Lkotlin/Function0;", "", "LocalNullValue", "LocalPrimitive", "LocalReference", "LocalValue", "LocalVariableRecord", "tests-common-new"})
public final class LocalVariableDebugRunner
extends DebugRunner {
    public LocalVariableDebugRunner(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        super(testServices);
    }

    private final LocalVariableRecord toRecord(StackFrame frame, LocalVariable variable2) {
        LocalValue localValue;
        Value value2 = frame.getValue(variable2);
        if (value2 == null) {
            localValue = new LocalNullValue();
        } else if (value2 instanceof ObjectReference && !Intrinsics.areEqual((Object)((ObjectReference)value2).referenceType().name(), (Object)"java.lang.String")) {
            String string2 = String.valueOf(((ObjectReference)value2).uniqueID());
            String string3 = ((ObjectReference)value2).referenceType().name();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"value.referenceType().name()");
            localValue = new LocalReference(string2, string3);
        } else {
            String string4 = value2.toString();
            String string5 = value2.type().name();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"value.type().name()");
            localValue = new LocalPrimitive(string4, string5);
        }
        LocalValue valueRecord = localValue;
        String string6 = variable2.name();
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"variable.name()");
        String string7 = variable2.typeName();
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"variable.typeName()");
        return new LocalVariableRecord(string6, string7, valueRecord);
    }

    private final void waitUntil(Function0<Boolean> condition) {
        while (!((Boolean)condition.invoke()).booleanValue()) {
            Thread.sleep(10L);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void storeStep(@NotNull ArrayList<LoggedData> loggedItems, @NotNull Event event) {
        List list2;
        Intrinsics.checkNotNullParameter(loggedItems, (String)"loggedItems");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        LocatableEvent locatableEvent = (LocatableEvent)event;
        this.waitUntil((Function0<Boolean>)((Function0)new Function0<Boolean>(locatableEvent){
            final /* synthetic */ LocatableEvent $locatableEvent;
            {
                this.$locatableEvent = $locatableEvent;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                return this.$locatableEvent.thread().isSuspended();
            }
        }));
        Location location = locatableEvent.location();
        if (location.method().isSynthetic()) {
            return;
        }
        StackFrame frame = locatableEvent.thread().frame(0);
        try {
            void $this$mapTo$iv$iv;
            List<LocalVariable> list3 = frame.visibleVariables();
            Intrinsics.checkNotNullExpressionValue(list3, (String)"frame.visibleVariables()");
            Iterable $this$map$iv = list3;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void variable2;
                LocalVariable localVariable = (LocalVariable)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)frame, (String)"frame");
                Intrinsics.checkNotNullExpressionValue((Object)variable2, (String)"variable");
                collection.add(this.toRecord(frame, (LocalVariable)variable2));
            }
            list2 = (List)destination$iv$iv;
        }
        catch (AbsentInformationException e) {
            list2 = CollectionsKt.emptyList();
        }
        List visibleVars = list2;
        int n = location.lineNumber();
        StringBuilder stringBuilder2 = new StringBuilder();
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"location");
        loggedItems.add(new LoggedData(n, false, ((Object)StringsKt.trim((CharSequence)stringBuilder2.append(this.formatAsExpectation(location)).append(": ").append(CollectionsKt.joinToString$default((Iterable)visibleVars, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null)).toString())).toString()));
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\bf\u0018\u00002\u00020\u0001\u00a8\u0006\u0002"}, d2={"Lorg/jetbrains/kotlin/test/backend/handlers/LocalVariableDebugRunner$LocalValue;", "", "tests-common-new"})
    public static interface LocalValue {
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\t\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/test/backend/handlers/LocalVariableDebugRunner$LocalPrimitive;", "Lorg/jetbrains/kotlin/test/backend/handlers/LocalVariableDebugRunner$LocalValue;", "value", "", "valueType", "(Ljava/lang/String;Ljava/lang/String;)V", "getValue", "()Ljava/lang/String;", "getValueType", "toString", "tests-common-new"})
    public static final class LocalPrimitive
    implements LocalValue {
        @NotNull
        private final String value;
        @NotNull
        private final String valueType;

        public LocalPrimitive(@NotNull String value2, @NotNull String valueType) {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            Intrinsics.checkNotNullParameter((Object)valueType, (String)"valueType");
            this.value = value2;
            this.valueType = valueType;
        }

        @NotNull
        public final String getValue() {
            return this.value;
        }

        @NotNull
        public final String getValueType() {
            return this.valueType;
        }

        @NotNull
        public String toString() {
            return this.value + ':' + this.valueType;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\t\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/test/backend/handlers/LocalVariableDebugRunner$LocalReference;", "Lorg/jetbrains/kotlin/test/backend/handlers/LocalVariableDebugRunner$LocalValue;", "id", "", "referenceType", "(Ljava/lang/String;Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "getReferenceType", "toString", "tests-common-new"})
    public static final class LocalReference
    implements LocalValue {
        @NotNull
        private final String id;
        @NotNull
        private final String referenceType;

        public LocalReference(@NotNull String id, @NotNull String referenceType) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)referenceType, (String)"referenceType");
            this.id = id;
            this.referenceType = referenceType;
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        @NotNull
        public final String getReferenceType() {
            return this.referenceType;
        }

        @NotNull
        public String toString() {
            return this.referenceType;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/test/backend/handlers/LocalVariableDebugRunner$LocalNullValue;", "Lorg/jetbrains/kotlin/test/backend/handlers/LocalVariableDebugRunner$LocalValue;", "()V", "toString", "", "tests-common-new"})
    public static final class LocalNullValue
    implements LocalValue {
        @NotNull
        public String toString() {
            return "null";
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\r\u001a\u00020\u0003H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/test/backend/handlers/LocalVariableDebugRunner$LocalVariableRecord;", "", "variable", "", "variableType", "value", "Lorg/jetbrains/kotlin/test/backend/handlers/LocalVariableDebugRunner$LocalValue;", "(Ljava/lang/String;Ljava/lang/String;Lorg/jetbrains/kotlin/test/backend/handlers/LocalVariableDebugRunner$LocalValue;)V", "getValue", "()Lorg/jetbrains/kotlin/test/backend/handlers/LocalVariableDebugRunner$LocalValue;", "getVariable", "()Ljava/lang/String;", "getVariableType", "toString", "tests-common-new"})
    public static final class LocalVariableRecord {
        @NotNull
        private final String variable;
        @NotNull
        private final String variableType;
        @NotNull
        private final LocalValue value;

        public LocalVariableRecord(@NotNull String variable2, @NotNull String variableType, @NotNull LocalValue value2) {
            Intrinsics.checkNotNullParameter((Object)variable2, (String)"variable");
            Intrinsics.checkNotNullParameter((Object)variableType, (String)"variableType");
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            this.variable = variable2;
            this.variableType = variableType;
            this.value = value2;
        }

        @NotNull
        public final String getVariable() {
            return this.variable;
        }

        @NotNull
        public final String getVariableType() {
            return this.variableType;
        }

        @NotNull
        public final LocalValue getValue() {
            return this.value;
        }

        @NotNull
        public String toString() {
            return this.variable + ':' + this.variableType + '=' + this.value;
        }
    }
}

