/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.utils.serialization;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.JsIrIcClassModel;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.JsIrProgramFragment;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsImportedModule;
import org.jetbrains.kotlin.js.backend.ast.JsLocation;
import org.jetbrains.kotlin.js.backend.ast.JsLocationWithSource;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.serialization.js.ast.JsAstProtoBuf;
import org.jetbrains.kotlin.serialization.js.ast.JsAstSerializerBase;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u0007\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rJ\u0018\u0010\u0007\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/utils/serialization/JsIrAstSerializer;", "Lorg/jetbrains/kotlin/serialization/js/ast/JsAstSerializerBase;", "()V", "extractLocation", "Lorg/jetbrains/kotlin/js/backend/ast/JsLocation;", "node", "Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "serialize", "Lorg/jetbrains/kotlin/serialization/js/ast/JsAstProtoBuf$Chunk;", "fragment", "Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/JsIrProgramFragment;", "", "output", "Ljava/io/OutputStream;", "Lorg/jetbrains/kotlin/serialization/js/ast/JsAstProtoBuf$IrClassModel;", "name", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "classModel", "Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/JsIrIcClassModel;", "serializeFragment", "Lorg/jetbrains/kotlin/serialization/js/ast/JsAstProtoBuf$Fragment;", "backend.js"})
public final class JsIrAstSerializer
extends JsAstSerializerBase {
    /*
     * WARNING - void declaration
     */
    public final void serialize(@NotNull JsIrProgramFragment fragment, @NotNull OutputStream output) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        this.getImportedNames().clear();
        Collection collection = this.getImportedNames();
        Map<String, JsExpression> $this$map$iv = fragment.getImports();
        boolean $i$f$map = false;
        Map<String, JsExpression> map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator2.next();
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            JsName jsName = fragment.getNameBindings().get(it.getKey());
            Intrinsics.checkNotNull((Object)jsName);
            collection2.add(jsName);
        }
        Iterable iterable = (List)destination$iv$iv;
        CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
        this.serialize(fragment).writeTo(output);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final JsAstProtoBuf.Chunk serialize(@NotNull JsIrProgramFragment fragment) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        try {
            JsAstProtoBuf.Chunk.Builder chunkBuilder = JsAstProtoBuf.Chunk.newBuilder();
            chunkBuilder.setFragment(this.serializeFragment(fragment));
            chunkBuilder.setNameTable(this.getNameTableBuilder().build());
            chunkBuilder.setStringTable(this.getStringTableBuilder().build());
            JsAstProtoBuf.Chunk chunk = chunkBuilder.build();
            Intrinsics.checkNotNullExpressionValue((Object)chunk, (String)"chunkBuilder.build()");
            JsAstProtoBuf.Chunk chunk2 = chunk;
            return chunk2;
        }
        finally {
            this.getNameTableBuilder().clear();
            this.getStringTableBuilder().clear();
            this.getNameMap().clear();
            this.getStringMap().clear();
        }
    }

    private final JsAstProtoBuf.Fragment serializeFragment(JsIrProgramFragment fragment) {
        Object it;
        Object nameBindingBuilder;
        JsAstProtoBuf.Fragment.Builder fragmentBuilder = JsAstProtoBuf.Fragment.newBuilder();
        fragmentBuilder.setPackageFqn(fragment.getPackageFqn());
        for (JsImportedModule jsImportedModule : fragment.getImportedModules()) {
            JsAstProtoBuf.ImportedModule.Builder importedModuleBuilder = JsAstProtoBuf.ImportedModule.newBuilder();
            importedModuleBuilder.setExternalNameId(this.serialize(jsImportedModule.getExternalName()));
            importedModuleBuilder.setInternalNameId(this.serialize(jsImportedModule.getInternalName()));
            if (jsImportedModule.getPlainReference() != null) {
                JsExpression it2;
                boolean bl = false;
                importedModuleBuilder.setPlainReference(this.serialize(it2));
            }
            fragmentBuilder.addImportedModule(importedModuleBuilder);
        }
        for (Map.Entry entry : fragment.getImports().entrySet()) {
            String signature2 = (String)entry.getKey();
            JsExpression expression2 = (JsExpression)entry.getValue();
            JsAstProtoBuf.Import.Builder importBuilder = JsAstProtoBuf.Import.newBuilder();
            importBuilder.setSignatureId(this.serialize(signature2));
            importBuilder.setExpression(this.serialize(expression2));
            fragmentBuilder.addImportEntry(importBuilder);
        }
        fragmentBuilder.setDeclarationBlock(this.serializeBlock(fragment.getDeclarations()));
        fragmentBuilder.setInitializerBlock(this.serializeBlock(fragment.getInitializers()));
        fragmentBuilder.setExportBlock(this.serializeBlock(fragment.getExports()));
        fragmentBuilder.setPolyfills(this.serializeBlock(fragment.getPolyfills()));
        for (Map.Entry entry : fragment.getNameBindings().entrySet()) {
            String key = (String)entry.getKey();
            JsName name2 = (JsName)entry.getValue();
            nameBindingBuilder = JsAstProtoBuf.NameBinding.newBuilder();
            ((JsAstProtoBuf.NameBinding.Builder)nameBindingBuilder).setSignatureId(this.serialize(key));
            ((JsAstProtoBuf.NameBinding.Builder)nameBindingBuilder).setNameId(this.serialize(name2));
            fragmentBuilder.addNameBinding((JsAstProtoBuf.NameBinding.Builder)nameBindingBuilder);
        }
        Iterable $this$forEach$iv = fragment.getClasses().entrySet();
        boolean bl = false;
        for (Object element$iv : $this$forEach$iv) {
            nameBindingBuilder = (Map.Entry)element$iv;
            boolean bl2 = false;
            JsName name3 = (JsName)nameBindingBuilder.getKey();
            JsIrIcClassModel model = (JsIrIcClassModel)nameBindingBuilder.getValue();
            fragmentBuilder.addIrClassModel(this.serialize(name3, model));
        }
        JsStatement jsStatement = fragment.getTestFunInvocation();
        if (jsStatement != null) {
            it = jsStatement;
            boolean bl3 = false;
            fragmentBuilder.setTestsInvocation(this.serialize((JsStatement)it));
        }
        JsStatement jsStatement2 = fragment.getMainFunction();
        if (jsStatement2 != null) {
            it = jsStatement2;
            boolean bl4 = false;
            fragmentBuilder.setMainInvocation(this.serialize((JsStatement)it));
        }
        String string2 = fragment.getDts();
        if (string2 != null) {
            it = string2;
            boolean bl5 = false;
            fragmentBuilder.setDts((String)it);
        }
        JsName jsName = fragment.getSuiteFn();
        if (jsName != null) {
            it = jsName;
            boolean bl6 = false;
            fragmentBuilder.setSuiteFunction(this.serialize((JsName)it));
        }
        $this$forEach$iv = fragment.getDefinitions();
        boolean bl7 = false;
        for (Object element$iv : $this$forEach$iv) {
            String it3 = (String)element$iv;
            boolean bl8 = false;
            fragmentBuilder.addDefinitions(this.serialize(it3));
        }
        JsAstProtoBuf.Fragment fragment2 = fragmentBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)fragment2, (String)"fragmentBuilder.build()");
        return fragment2;
    }

    private final JsAstProtoBuf.IrClassModel serialize(JsName name2, JsIrIcClassModel classModel) {
        JsAstProtoBuf.IrClassModel.Builder builder2 = JsAstProtoBuf.IrClassModel.newBuilder();
        builder2.setNameId(this.serialize(name2));
        Iterable $this$forEach$iv = classModel.getSuperClasses();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JsName it = (JsName)element$iv;
            boolean bl = false;
            builder2.addSuperClasses(this.serialize(it));
        }
        List<JsStatement> list2 = classModel.getPreDeclarationBlock().getStatements();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"classModel.preDeclarationBlock.statements");
        if (!((Collection)list2).isEmpty()) {
            builder2.setPreDeclarationBlock(this.serializeBlock(classModel.getPreDeclarationBlock()));
        }
        List<JsStatement> list3 = classModel.getPostDeclarationBlock().getStatements();
        Intrinsics.checkNotNullExpressionValue(list3, (String)"classModel.postDeclarationBlock.statements");
        if (!((Collection)list3).isEmpty()) {
            builder2.setPostDeclarationBlock(this.serializeBlock(classModel.getPostDeclarationBlock()));
        }
        JsAstProtoBuf.IrClassModel irClassModel = builder2.build();
        Intrinsics.checkNotNullExpressionValue((Object)irClassModel, (String)"builder.build()");
        return irClassModel;
    }

    @Override
    @Nullable
    public JsLocation extractLocation(@NotNull JsNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Object $this$safeAs$iv = node.getSource();
        boolean $i$f$safeAs = false;
        Object object = $this$safeAs$iv;
        if (!(object instanceof JsLocationWithSource)) {
            object = null;
        }
        JsLocationWithSource jsLocationWithSource = (JsLocationWithSource)object;
        return jsLocationWithSource != null ? jsLocationWithSource.asSimpleLocation() : null;
    }
}

