/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import com.google.common.collect.Lists;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.util.ArrayUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.checkers.DiagnosedRange;
import org.jetbrains.kotlin.checkers.utils.CheckerTestUtil;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.AnalyzingUtils;
import org.jetbrains.kotlin.test.util.KtTestUtil;

public class CodegenTestFiles {
    @NotNull
    private final List<KtFile> psiFiles;
    @NotNull
    private final List<Pair<String, String>> expectedValues;
    @NotNull
    private final List<Object> scriptParameterValues;

    private CodegenTestFiles(@NotNull List<KtFile> psiFiles, @NotNull List<Pair<String, String>> expectedValues, @NotNull List<Object> scriptParameterValues) {
        if (psiFiles == null) {
            CodegenTestFiles.$$$reportNull$$$0(0);
        }
        if (expectedValues == null) {
            CodegenTestFiles.$$$reportNull$$$0(1);
        }
        if (scriptParameterValues == null) {
            CodegenTestFiles.$$$reportNull$$$0(2);
        }
        this.psiFiles = psiFiles;
        this.expectedValues = expectedValues;
        this.scriptParameterValues = scriptParameterValues;
    }

    @NotNull
    public KtFile getPsiFile() {
        assert (this.psiFiles.size() == 1);
        KtFile ktFile = this.psiFiles.get(0);
        if (ktFile == null) {
            CodegenTestFiles.$$$reportNull$$$0(3);
        }
        return ktFile;
    }

    @NotNull
    public List<Pair<String, String>> getExpectedValues() {
        List<Pair<String, String>> list2 = this.expectedValues;
        if (list2 == null) {
            CodegenTestFiles.$$$reportNull$$$0(4);
        }
        return list2;
    }

    @NotNull
    public List<Object> getScriptParameterValues() {
        List<Object> list2 = this.scriptParameterValues;
        if (list2 == null) {
            CodegenTestFiles.$$$reportNull$$$0(5);
        }
        return list2;
    }

    @NotNull
    public List<KtFile> getPsiFiles() {
        List<KtFile> list2 = this.psiFiles;
        if (list2 == null) {
            CodegenTestFiles.$$$reportNull$$$0(6);
        }
        return list2;
    }

    @NotNull
    public static CodegenTestFiles create(@NotNull List<KtFile> ktFiles) {
        if (ktFiles == null) {
            CodegenTestFiles.$$$reportNull$$$0(7);
        }
        assert (!ktFiles.isEmpty()) : "List should have at least one file";
        return new CodegenTestFiles(ktFiles, Collections.emptyList(), Collections.emptyList());
    }

    public static CodegenTestFiles create(Project project, String[] names2) {
        return CodegenTestFiles.create(project, names2, KtTestUtil.getTestDataPathBase());
    }

    public static CodegenTestFiles create(Project project, String[] names2, String testDataPath) {
        ArrayList<KtFile> files2 = new ArrayList<KtFile>(names2.length);
        for (String name2 : names2) {
            try {
                String content2 = KtTestUtil.doLoadFile(testDataPath + "/codegen/", name2);
                KtFile file2 = KtTestUtil.createFile(name2, content2, project);
                files2.add(file2);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return CodegenTestFiles.create(files2);
    }

    @NotNull
    public static CodegenTestFiles create(@NotNull String fileName, @NotNull String contentWithDiagnosticMarkup, @NotNull Project project) {
        if (fileName == null) {
            CodegenTestFiles.$$$reportNull$$$0(8);
        }
        if (contentWithDiagnosticMarkup == null) {
            CodegenTestFiles.$$$reportNull$$$0(9);
        }
        if (project == null) {
            CodegenTestFiles.$$$reportNull$$$0(10);
        }
        String content2 = CheckerTestUtil.INSTANCE.parseDiagnosedRanges(contentWithDiagnosticMarkup, new ArrayList<DiagnosedRange>(), null);
        KtFile file2 = KtTestUtil.createFile(fileName, content2, project);
        List<PsiErrorElement> ranges2 = AnalyzingUtils.getSyntaxErrorRanges((PsiElement)file2);
        assert (ranges2.isEmpty()) : "Syntax errors found in " + file2 + ": " + ranges2;
        ArrayList expectedValues = Lists.newArrayList();
        Matcher matcher2 = Pattern.compile("// expected: (\\S+): (.*)").matcher(content2);
        while (matcher2.find()) {
            String fieldName = matcher2.group(1);
            String expectedValue = matcher2.group(2);
            expectedValues.add(Pair.create((Object)fieldName, (Object)expectedValue));
        }
        ArrayList scriptParameterValues = Lists.newArrayList();
        if (file2.isScript()) {
            Pattern scriptParametersPattern = Pattern.compile("param: (\\S.*)");
            Matcher scriptParametersMatcher = scriptParametersPattern.matcher(file2.getText());
            if (scriptParametersMatcher.find()) {
                String valueString = scriptParametersMatcher.group(1);
                String[] values2 = valueString.split(" ");
                scriptParameterValues.add(values2);
            } else {
                scriptParameterValues.add(ArrayUtil.EMPTY_STRING_ARRAY);
            }
        }
        return new CodegenTestFiles(Collections.singletonList(file2), expectedValues, scriptParameterValues);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFiles";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedValues";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptParameterValues";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/codegen/CodegenTestFiles";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ktFiles";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentWithDiagnosticMarkup";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/codegen/CodegenTestFiles";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiFile";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpectedValues";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getScriptParameterValues";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

