/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.test.TestInfrastructureInternals;
import org.jetbrains.kotlin.test.model.DependencyDescription;
import org.jetbrains.kotlin.test.model.DependencyKind;
import org.jetbrains.kotlin.test.model.DependencyRelation;
import org.jetbrains.kotlin.test.model.TestFile;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.ModuleStructureTransformer;
import org.jetbrains.kotlin.test.services.TestModuleStructure;
import org.jetbrains.kotlin.test.services.impl.TestModuleStructureImpl;

@TestInfrastructureInternals
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/test/services/SplittingModuleTransformerForBoxTests;", "Lorg/jetbrains/kotlin/test/services/ModuleStructureTransformer;", "()V", "transformModuleStructure", "Lorg/jetbrains/kotlin/test/services/TestModuleStructure;", "moduleStructure", "tests-common-new"})
public final class SplittingModuleTransformerForBoxTests
extends ModuleStructureTransformer {
    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public TestModuleStructure transformModuleStructure(@NotNull TestModuleStructure moduleStructure) {
        void $this$filterTo$iv$iv;
        void $this$filterNotTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)moduleStructure, (String)"moduleStructure");
        TestModule testModule = (TestModule)CollectionsKt.singleOrNull(moduleStructure.getModules());
        if (testModule == null) {
            throw new IllegalStateException("Test should contain only one module".toString());
        }
        TestModule module2 = testModule;
        Iterable $this$filterNot$iv = module2.getFiles();
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            TestFile it = (TestFile)element$iv$iv;
            boolean bl = false;
            if (it.isAdditional()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List realFiles = (List)destination$iv$iv;
        if (realFiles.size() < 2) {
            throw new IllegalStateException("Test should contain at least two files".toString());
        }
        Iterable $this$filter$iv = module2.getFiles();
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            TestFile it = (TestFile)element$iv$iv;
            boolean bl = false;
            if (!it.isAdditional()) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List additionalFiles = (List)destination$iv$iv2;
        List firstModuleFiles = CollectionsKt.dropLast((List)realFiles, (int)1);
        TestFile secondModuleFile = (TestFile)CollectionsKt.last((List)realFiles);
        TestModule firstModule = new TestModule("lib", module2.getTargetPlatform(), module2.getTargetBackend(), module2.getFrontendKind(), module2.getBackendKind(), module2.getBinaryKind(), CollectionsKt.plus((Collection)firstModuleFiles, (Iterable)additionalFiles), CollectionsKt.emptyList(), module2.getDirectives(), module2.getLanguageVersionSettings());
        TestModule secondModule = new TestModule("main", module2.getTargetPlatform(), module2.getTargetBackend(), module2.getFrontendKind(), module2.getBackendKind(), module2.getBinaryKind(), CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)secondModuleFile), (Iterable)additionalFiles), CollectionsKt.listOf((Object)new DependencyDescription("lib", DependencyKind.Binary, DependencyRelation.FriendDependency)), module2.getDirectives(), module2.getLanguageVersionSettings());
        Object[] objectArray = new TestModule[]{firstModule, secondModule};
        return new TestModuleStructureImpl(CollectionsKt.listOf((Object[])objectArray), moduleStructure.getOriginalTestDataFiles());
    }
}

