/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.backend.classic;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.jvm.config.JvmContentRootsKt;
import org.jetbrains.kotlin.codegen.ClassFileFactory;
import org.jetbrains.kotlin.codegen.CodegenTestUtil;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.test.JvmCompilationUtils;
import org.jetbrains.kotlin.test.directives.CodegenTestDirectives;
import org.jetbrains.kotlin.test.model.TestFile;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.AssertionsKt;
import org.jetbrains.kotlin.test.services.CompilerConfigurationProviderKt;
import org.jetbrains.kotlin.test.services.SourceFileProviderKt;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.services.jvm.CompiledClassesManagerKt;
import org.jetbrains.kotlin.test.util.KtTestUtil;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ<\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J(\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00130\u00102\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0018\u001a\u00020\u0015H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/test/backend/classic/JavaCompilerFacade;", "", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "compileJavaFiles", "", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "classFileFactory", "Lorg/jetbrains/kotlin/codegen/ClassFileFactory;", "jvmTarget", "Lorg/jetbrains/kotlin/config/JvmTarget;", "files", "", "Ljava/io/File;", "javacOptions", "", "ignoreErrors", "", "extractJavacOptions", "kotlinTarget", "isJvmPreviewEnabled", "tests-common-new"})
public final class JavaCompilerFacade {
    @NotNull
    private final TestServices testServices;

    public JavaCompilerFacade(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        this.testServices = testServices;
    }

    /*
     * WARNING - void declaration
     */
    public final void compileJavaFiles(@NotNull TestModule module2, @NotNull CompilerConfiguration configuration2, @NotNull ClassFileFactory classFileFactory) {
        void $this$mapTo$iv$iv;
        Object item$iv$iv2;
        void $this$mapTo$iv$iv2;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)classFileFactory, (String)"classFileFactory");
        if (CompilerConfigurationProviderKt.getJavaFiles(module2).isEmpty()) {
            return;
        }
        Iterable iterable = JvmContentRootsKt.getJvmClasspathRoots(configuration2);
        Collection collection = CollectionsKt.listOf((Object)CompiledClassesManagerKt.getCompiledClassesManager(this.testServices).getCompiledKotlinDirForModule(module2, classFileFactory).getPath());
        boolean $i$f$map = false;
        void var7_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
            void it;
            File file2 = (File)item$iv$iv2;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.getAbsolutePath());
        }
        List javaClasspath = CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
        File javaClassesOutputDirectory = CompiledClassesManagerKt.getCompiledClassesManager(this.testServices).getOrCreateCompiledJavaDirForModule(module2);
        List<String> javacOptions = this.extractJavacOptions(module2, configuration2.get(JVMConfigurationKeys.JVM_TARGET), configuration2.getBoolean(JVMConfigurationKeys.ENABLE_JVM_PREVIEW));
        List<String> list2 = CodegenTestUtil.prepareJavacOptions(javaClasspath, javacOptions, javaClassesOutputDirectory);
        Intrinsics.checkNotNullExpressionValue(list2, (String)"prepareJavacOptions(\n   \u2026OutputDirectory\n        )");
        List<String> finalJavacOptions = list2;
        Iterable $this$map$iv2 = CompilerConfigurationProviderKt.getJavaFiles(module2);
        boolean $i$f$map2 = false;
        item$iv$iv2 = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv3 : $this$mapTo$iv$iv) {
            void it;
            TestFile testFile = (TestFile)item$iv$iv3;
            collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(SourceFileProviderKt.getSourceFileProvider(this.testServices).getRealFileForSourceFile((TestFile)it));
        }
        List javaFiles2 = (List)destination$iv$iv2;
        boolean ignoreErrors = module2.getDirectives().contains(CodegenTestDirectives.INSTANCE.getIGNORE_JAVA_ERRORS());
        JvmTarget jvmTarget = configuration2.get(JVMConfigurationKeys.JVM_TARGET);
        if (jvmTarget == null) {
            jvmTarget = JvmTarget.DEFAULT;
        }
        Intrinsics.checkNotNullExpressionValue((Object)jvmTarget, (String)"configuration[JVMConfigu\u2026GET] ?: JvmTarget.DEFAULT");
        this.compileJavaFiles(module2, jvmTarget, javaFiles2, finalJavacOptions, ignoreErrors);
    }

    private final List<String> extractJavacOptions(TestModule module2, JvmTarget kotlinTarget, boolean isJvmPreviewEnabled) {
        List list2;
        block1: {
            List $this$extractJavacOptions_u24lambda_u2d3;
            block0: {
                $this$extractJavacOptions_u24lambda_u2d3 = list2 = CollectionsKt.createListBuilder();
                boolean bl = false;
                $this$extractJavacOptions_u24lambda_u2d3.addAll((Collection)module2.getDirectives().get(CodegenTestDirectives.INSTANCE.getJAVAC_OPTIONS()));
                if (kotlinTarget == null || !isJvmPreviewEnabled) break block0;
                $this$extractJavacOptions_u24lambda_u2d3.add("--release");
                $this$extractJavacOptions_u24lambda_u2d3.add(kotlinTarget.getDescription());
                $this$extractJavacOptions_u24lambda_u2d3.add("--enable-preview");
                break block1;
            }
            String string2 = CodegenTestUtil.computeJavaTarget($this$extractJavacOptions_u24lambda_u2d3, kotlinTarget);
            if (string2 == null) break block1;
            String javaTarget = string2;
            boolean bl = false;
            $this$extractJavacOptions_u24lambda_u2d3.add("-source");
            Intrinsics.checkNotNullExpressionValue((Object)javaTarget, (String)"javaTarget");
            $this$extractJavacOptions_u24lambda_u2d3.add(javaTarget);
            $this$extractJavacOptions_u24lambda_u2d3.add("-target");
            $this$extractJavacOptions_u24lambda_u2d3.add(javaTarget);
        }
        return CollectionsKt.build((List)list2);
    }

    private final void compileJavaFiles(TestModule module2, JvmTarget jvmTarget, List<? extends File> files2, List<String> javacOptions, boolean ignoreErrors) {
        File file2;
        boolean targetIsJava8OrLower;
        String string2 = System.getProperty("java.version");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getProperty(\"java.version\")");
        boolean bl = targetIsJava8OrLower = StringsKt.startsWith$default((String)string2, (String)"1.", (boolean)false, (int)2, null) && jvmTarget.compareTo((Enum)JvmTarget.JVM_1_6) <= 0;
        if (!module2.getDirectives().contains(CodegenTestDirectives.INSTANCE.getUSE_JAVAC_BASED_ON_JVM_TARGET()) || targetIsJava8OrLower) {
            JvmCompilationUtils.compileJavaFiles$default(files2, javacOptions, null, AssertionsKt.getAssertions(this.testServices), ignoreErrors, 4, null);
            return;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[jvmTarget.ordinal()]) {
            case 1: {
                file2 = KtTestUtil.getJdk6Home();
                break;
            }
            case 2: {
                file2 = KtTestUtil.getJdk8Home();
                break;
            }
            case 3: 
            case 4: {
                file2 = KtTestUtil.getJdk11Home();
                break;
            }
            case 5: 
            case 6: {
                file2 = KtTestUtil.getJdk17Home();
                break;
            }
            default: {
                file2 = null;
            }
        }
        if (file2 == null) {
            throw new IllegalStateException(("JDK for " + jvmTarget + " is not found").toString());
        }
        File jdkHome = file2;
        JvmCompilationUtils.compileJavaFilesExternally((Collection<? extends File>)files2, javacOptions, jdkHome);
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[JvmTarget.values().length];
            nArray[JvmTarget.JVM_1_6.ordinal()] = 1;
            nArray[JvmTarget.JVM_1_8.ordinal()] = 2;
            nArray[JvmTarget.JVM_9.ordinal()] = 3;
            nArray[JvmTarget.JVM_11.ordinal()] = 4;
            nArray[JvmTarget.JVM_15.ordinal()] = 5;
            nArray[JvmTarget.JVM_17.ordinal()] = 6;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

