/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0001\n\u0000\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0010H\u0004J\u001c\u0010\u0016\u001a\u00020\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u001a0\u0019H\u0004J\u0015\u0010\u001b\u001a\u00028\u00002\u0006\u0010\u001c\u001a\u00020\u0010H&\u00a2\u0006\u0002\u0010\u001dJ\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0015\u001a\u00020\u0010H\u0004R\u0014\u0010\u0003\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/codegen/InfoParser;", "Info", "", "infoFile", "Ljava/io/File;", "(Ljava/io/File;)V", "getInfoFile", "()Ljava/io/File;", "lineCounter", "", "getLineCounter", "()I", "setLineCounter", "(I)V", "lines", "", "", "getLines", "()Ljava/util/List;", "diagnosticMessage", "message", "line", "loop", "", "lambda", "Lkotlin/Function1;", "", "parse", "entryName", "(Ljava/lang/String;)Ljava/lang/Object;", "throwSyntaxError", "", "tests-compiler-utils"})
public abstract class InfoParser<Info> {
    @NotNull
    private final File infoFile;
    private int lineCounter;
    @NotNull
    private final List<String> lines;

    public InfoParser(@NotNull File infoFile) {
        Intrinsics.checkNotNullParameter((Object)infoFile, (String)"infoFile");
        this.infoFile = infoFile;
        this.lines = FilesKt.readLines$default((File)this.infoFile, null, (int)1, null);
    }

    @NotNull
    protected final File getInfoFile() {
        return this.infoFile;
    }

    protected final int getLineCounter() {
        return this.lineCounter;
    }

    protected final void setLineCounter(int n) {
        this.lineCounter = n;
    }

    @NotNull
    protected final List<String> getLines() {
        return this.lines;
    }

    public abstract Info parse(@NotNull String var1);

    protected final void loop(@NotNull Function1<? super String, Boolean> lambda2) {
        Intrinsics.checkNotNullParameter(lambda2, (String)"lambda");
        while (this.lineCounter < this.lines.size()) {
            String line = this.lines.get(this.lineCounter);
            if (StringsKt.isBlank((CharSequence)line)) {
                ++this.lineCounter;
                continue;
            }
            if (!((Boolean)lambda2.invoke((Object)((Object)StringsKt.trim((CharSequence)line)).toString())).booleanValue()) continue;
            break;
        }
    }

    @NotNull
    protected final String diagnosticMessage(@NotNull String message, @NotNull String line) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        return message + " in '" + line + "' at " + this.infoFile.getPath() + ':' + (this.lineCounter - 1);
    }

    @NotNull
    protected final Void throwSyntaxError(@NotNull String line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        throw new AssertionError((Object)this.diagnosticMessage("Syntax error", line));
    }
}

