/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.services.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.test.Assertions;
import org.jetbrains.kotlin.test.directives.model.Directive;
import org.jetbrains.kotlin.test.directives.model.DirectivesContainer;
import org.jetbrains.kotlin.test.directives.model.RegisteredDirectives;
import org.jetbrains.kotlin.test.directives.model.RegisteredDirectivesImpl;
import org.jetbrains.kotlin.test.directives.model.SimpleDirective;
import org.jetbrains.kotlin.test.directives.model.StringDirective;
import org.jetbrains.kotlin.test.directives.model.ValueDirective;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\u0018\u0000  2\u00020\u0001:\u0003 !\"B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\rJ+\u0010\u001c\u001a\u0004\u0018\u0001H\u001d\"\b\b\u0000\u0010\u001d*\u00020\u0001*\b\u0012\u0004\u0012\u0002H\u001d0\u000f2\u0006\u0010\u001e\u001a\u00020\rH\u0002\u00a2\u0006\u0002\u0010\u001fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u000e\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/test/services/impl/RegisteredDirectivesParser;", "", "container", "Lorg/jetbrains/kotlin/test/directives/model/DirectivesContainer;", "assertions", "Lorg/jetbrains/kotlin/test/Assertions;", "(Lorg/jetbrains/kotlin/test/directives/model/DirectivesContainer;Lorg/jetbrains/kotlin/test/Assertions;)V", "simpleDirectives", "", "Lorg/jetbrains/kotlin/test/directives/model/SimpleDirective;", "stringValueDirectives", "", "Lorg/jetbrains/kotlin/test/directives/model/StringDirective;", "", "valueDirectives", "Lorg/jetbrains/kotlin/test/directives/model/ValueDirective;", "addParsedDirective", "", "parsedDirective", "Lorg/jetbrains/kotlin/test/services/impl/RegisteredDirectivesParser$ParsedDirective;", "build", "Lorg/jetbrains/kotlin/test/directives/model/RegisteredDirectives;", "convertToRegisteredDirective", "rawDirective", "Lorg/jetbrains/kotlin/test/services/impl/RegisteredDirectivesParser$RawDirective;", "parse", "", "line", "extractValue", "T", "name", "(Lorg/jetbrains/kotlin/test/directives/model/ValueDirective;Ljava/lang/String;)Ljava/lang/Object;", "Companion", "ParsedDirective", "RawDirective", "test-infrastructure"})
public final class RegisteredDirectivesParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DirectivesContainer container;
    @NotNull
    private final Assertions assertions;
    @NotNull
    private final List<SimpleDirective> simpleDirectives;
    @NotNull
    private final Map<StringDirective, List<String>> stringValueDirectives;
    @NotNull
    private final Map<ValueDirective<?>, List<Object>> valueDirectives;
    @NotNull
    private static final Regex DIRECTIVE_PATTERN = new Regex("^//\\s*[!]?([A-Z0-9_]+)(:[ \\t]*(.*))? *$");
    @NotNull
    private static final Regex SPACES_PATTERN = new Regex("[,]?[ \\t]+");
    private static final int NAME_GROUP = 1;
    private static final int VALUES_GROUP = 3;

    public RegisteredDirectivesParser(@NotNull DirectivesContainer container2, @NotNull Assertions assertions) {
        Intrinsics.checkNotNullParameter((Object)container2, (String)"container");
        Intrinsics.checkNotNullParameter((Object)assertions, (String)"assertions");
        this.container = container2;
        this.assertions = assertions;
        this.simpleDirectives = new ArrayList();
        this.stringValueDirectives = new LinkedHashMap();
        this.valueDirectives = new LinkedHashMap();
    }

    public final boolean parse(@NotNull String line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        RawDirective rawDirective = Companion.parseDirective(line);
        if (rawDirective == null) {
            return false;
        }
        RawDirective rawDirective2 = rawDirective;
        ParsedDirective parsedDirective = this.convertToRegisteredDirective(rawDirective2);
        if (parsedDirective == null) {
            return false;
        }
        ParsedDirective parsedDirective2 = parsedDirective;
        this.addParsedDirective(parsedDirective2);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final void addParsedDirective(@NotNull ParsedDirective parsedDirective) {
        Intrinsics.checkNotNullParameter((Object)parsedDirective, (String)"parsedDirective");
        Directive directive2 = parsedDirective.component1();
        List<?> values2 = parsedDirective.component2();
        Directive directive3 = directive2;
        if (directive3 instanceof SimpleDirective) {
            ((Collection)this.simpleDirectives).add(directive2);
        } else if (directive3 instanceof StringDirective) {
            Object object;
            void $this$getOrPut$iv;
            Map<StringDirective, List<String>> map = this.stringValueDirectives;
            Directive key$iv = directive2;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                List answer$iv = new ArrayList();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            List list2 = (List)object;
            Collection collection = list2;
            Intrinsics.checkNotNull(values2, (String)"null cannot be cast to non-null type kotlin.collections.List<kotlin.String>");
            CollectionsKt.addAll((Collection)collection, (Iterable)values2);
        } else if (directive3 instanceof ValueDirective) {
            List list3;
            Map<ValueDirective<?>, List<Object>> $this$getOrPut$iv = this.valueDirectives;
            Directive key$iv = directive2;
            boolean $i$f$getOrPut = false;
            List value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                List answer$iv = new ArrayList();
                $this$getOrPut$iv.put((ValueDirective<?>)key$iv, answer$iv);
                list3 = answer$iv;
            } else {
                list3 = value$iv;
            }
            List list4 = list3;
            Intrinsics.checkNotNull(values2, (String)"null cannot be cast to non-null type kotlin.collections.List<kotlin.Any>");
            list4.addAll((Collection<Object>)values2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final ParsedDirective convertToRegisteredDirective(@NotNull RawDirective rawDirective) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)rawDirective, (String)"rawDirective");
        String name2 = rawDirective.component1();
        List rawValues = rawDirective.component2();
        Directive directive2 = this.container.get(name2);
        if (directive2 == null) {
            return null;
        }
        Directive directive3 = directive2;
        Directive directive4 = directive3;
        if (directive4 instanceof SimpleDirective) {
            if (rawValues != null) {
                this.assertions.fail((Function0<String>)((Function0)new Function0<String>(directive3, (List<String>)rawValues){
                    final /* synthetic */ Directive $directive;
                    final /* synthetic */ List<String> $rawValues;
                    {
                        this.$directive = $directive;
                        this.$rawValues = $rawValues;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Directive " + this.$directive + " should have no arguments, but " + CollectionsKt.joinToString$default((Iterable)this.$rawValues, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + " are passed";
                    }
                }));
                throw null;
            }
            list2 = CollectionsKt.emptyList();
        } else if (directive4 instanceof StringDirective) {
            list2 = rawValues;
            if (list2 == null) {
                list2 = CollectionsKt.emptyList();
            }
        } else if (directive4 instanceof ValueDirective) {
            void $this$mapTo$iv$iv;
            if (rawValues == null) {
                this.assertions.fail((Function0<String>)((Function0)new Function0<String>(directive3){
                    final /* synthetic */ Directive $directive;
                    {
                        this.$directive = $directive;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Directive " + this.$directive + " must have at least one value";
                    }
                }));
                throw null;
            }
            Iterable $this$map$iv = rawValues;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string2 = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Object t = this.extractValue((ValueDirective)directive3, (String)it);
                if (t == null) {
                    this.assertions.fail((Function0<String>)((Function0)new Function0<String>((String)it, directive3){
                        final /* synthetic */ String $it;
                        final /* synthetic */ Directive $directive;
                        {
                            this.$it = $it;
                            this.$directive = $directive;
                            super(0);
                        }

                        @NotNull
                        public final String invoke() {
                            return this.$it + " is not valid value for " + this.$directive;
                        }
                    }));
                    throw null;
                }
                collection.add(t);
            }
            list2 = (List)destination$iv$iv;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        List values2 = list2;
        return new ParsedDirective(directive3, values2);
    }

    private final <T> T extractValue(ValueDirective<T> $this$extractValue, String name2) {
        return (T)$this$extractValue.getParser().invoke((Object)name2);
    }

    @NotNull
    public final RegisteredDirectives build() {
        return new RegisteredDirectivesImpl(this.simpleDirectives, this.stringValueDirectives, this.valueDirectives);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/test/services/impl/RegisteredDirectivesParser$Companion;", "", "()V", "DIRECTIVE_PATTERN", "Lkotlin/text/Regex;", "NAME_GROUP", "", "SPACES_PATTERN", "VALUES_GROUP", "parseDirective", "Lorg/jetbrains/kotlin/test/services/impl/RegisteredDirectivesParser$RawDirective;", "line", "", "test-infrastructure"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        @Nullable
        public final RawDirective parseDirective(@NotNull String line) {
            List list2;
            String name2;
            block5: {
                List list3;
                Iterator iterator2;
                Collection destination$iv$iv;
                block4: {
                    block3: {
                        void $this$filterTo$iv$iv;
                        int n;
                        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
                        Object object = DIRECTIVE_PATTERN.matchEntire((CharSequence)line);
                        if (object == null || (object = object.getGroupValues()) == null) {
                            return null;
                        }
                        Object object2 = object;
                        String string2 = (String)CollectionsKt.getOrNull((List)object2, (int)1);
                        if (string2 == null) {
                            return null;
                        }
                        name2 = string2;
                        Object object3 = (String)CollectionsKt.getOrNull((List)object2, (int)3);
                        if (object3 == null) break block3;
                        CharSequence charSequence2 = (CharSequence)object3;
                        Regex regex = SPACES_PATTERN;
                        object3 = regex.split(charSequence2, n = 0);
                        if (object3 == null) break block3;
                        Iterable iterable = (Iterable)object3;
                        boolean bl = false;
                        Iterable iterable2 = iterable;
                        destination$iv$iv = new ArrayList();
                        boolean $i$f$filterTo = false;
                        iterator2 = $this$filterTo$iv$iv.iterator();
                        break block4;
                    }
                    list2 = null;
                    break block5;
                }
                while (iterator2.hasNext()) {
                    Object element$iv$iv = iterator2.next();
                    String it = (String)element$iv$iv;
                    boolean bl = false;
                    boolean bl2 = !StringsKt.isBlank((CharSequence)it);
                    if (!bl2) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List list4 = list3 = (List)destination$iv$iv;
                boolean bl = false;
                list2 = !((Collection)list4).isEmpty() ? list3 : null;
            }
            List values2 = list2;
            return new RawDirective(name2, values2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u0011\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0005H\u00c6\u0003J%\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0010\b\u0002\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0019\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/test/services/impl/RegisteredDirectivesParser$RawDirective;", "", "name", "", "values", "", "(Ljava/lang/String;Ljava/util/List;)V", "getName", "()Ljava/lang/String;", "getValues", "()Ljava/util/List;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "test-infrastructure"})
    public static final class RawDirective {
        @NotNull
        private final String name;
        @Nullable
        private final List<String> values;

        public RawDirective(@NotNull String name2, @Nullable List<String> values2) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            this.name = name2;
            this.values = values2;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @Nullable
        public final List<String> getValues() {
            return this.values;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @Nullable
        public final List<String> component2() {
            return this.values;
        }

        @NotNull
        public final RawDirective copy(@NotNull String name2, @Nullable List<String> values2) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            return new RawDirective(name2, values2);
        }

        public static /* synthetic */ RawDirective copy$default(RawDirective rawDirective, String string2, List list2, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = rawDirective.name;
            }
            if ((n & 2) != 0) {
                list2 = rawDirective.values;
            }
            return rawDirective.copy(string2, list2);
        }

        @NotNull
        public String toString() {
            return "RawDirective(name=" + this.name + ", values=" + this.values + ')';
        }

        public int hashCode() {
            int result2 = this.name.hashCode();
            result2 = result2 * 31 + (this.values == null ? 0 : ((Object)this.values).hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RawDirective)) {
                return false;
            }
            RawDirective rawDirective = (RawDirective)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)rawDirective.name)) {
                return false;
            }
            return Intrinsics.areEqual(this.values, rawDirective.values);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\r\u0010\f\u001a\u0006\u0012\u0002\b\u00030\u0005H\u00c6\u0003J!\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\f\b\u0002\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0015\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/test/services/impl/RegisteredDirectivesParser$ParsedDirective;", "", "directive", "Lorg/jetbrains/kotlin/test/directives/model/Directive;", "values", "", "(Lorg/jetbrains/kotlin/test/directives/model/Directive;Ljava/util/List;)V", "getDirective", "()Lorg/jetbrains/kotlin/test/directives/model/Directive;", "getValues", "()Ljava/util/List;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "test-infrastructure"})
    public static final class ParsedDirective {
        @NotNull
        private final Directive directive;
        @NotNull
        private final List<?> values;

        public ParsedDirective(@NotNull Directive directive2, @NotNull List<?> values2) {
            Intrinsics.checkNotNullParameter((Object)directive2, (String)"directive");
            Intrinsics.checkNotNullParameter(values2, (String)"values");
            this.directive = directive2;
            this.values = values2;
        }

        @NotNull
        public final Directive getDirective() {
            return this.directive;
        }

        @NotNull
        public final List<?> getValues() {
            return this.values;
        }

        @NotNull
        public final Directive component1() {
            return this.directive;
        }

        @NotNull
        public final List<?> component2() {
            return this.values;
        }

        @NotNull
        public final ParsedDirective copy(@NotNull Directive directive2, @NotNull List<?> values2) {
            Intrinsics.checkNotNullParameter((Object)directive2, (String)"directive");
            Intrinsics.checkNotNullParameter(values2, (String)"values");
            return new ParsedDirective(directive2, values2);
        }

        public static /* synthetic */ ParsedDirective copy$default(ParsedDirective parsedDirective, Directive directive2, List list2, int n, Object object) {
            if ((n & 1) != 0) {
                directive2 = parsedDirective.directive;
            }
            if ((n & 2) != 0) {
                list2 = parsedDirective.values;
            }
            return parsedDirective.copy(directive2, list2);
        }

        @NotNull
        public String toString() {
            return "ParsedDirective(directive=" + this.directive + ", values=" + this.values + ')';
        }

        public int hashCode() {
            int result2 = this.directive.hashCode();
            result2 = result2 * 31 + ((Object)this.values).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ParsedDirective)) {
                return false;
            }
            ParsedDirective parsedDirective = (ParsedDirective)other;
            if (!Intrinsics.areEqual((Object)this.directive, (Object)parsedDirective.directive)) {
                return false;
            }
            return Intrinsics.areEqual(this.values, parsedDirective.values);
        }
    }
}

