/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.backend.handlers;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.serialization.DescriptorByIdSignatureFinderImpl;
import org.jetbrains.kotlin.backend.common.serialization.signature.IdSignatureDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.FindClassInModuleKt;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.ir.backend.js.lower.serialization.ir.JsManglerDesc;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.impl.IrFactoryImpl;
import org.jetbrains.kotlin.ir.util.DeclarationStubGenerator;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import org.jetbrains.kotlin.ir.util.SymbolTable;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi2ir.generators.DeclarationStubGeneratorImpl;
import org.jetbrains.kotlin.test.Assertions;
import org.jetbrains.kotlin.test.backend.handlers.AbstractIrHandler;
import org.jetbrains.kotlin.test.backend.ir.IrBackendInput;
import org.jetbrains.kotlin.test.directives.CodegenTestDirectives;
import org.jetbrains.kotlin.test.directives.FirDiagnosticsDirectives;
import org.jetbrains.kotlin.test.directives.model.DirectivesContainer;
import org.jetbrains.kotlin.test.directives.model.RegisteredDirectives;
import org.jetbrains.kotlin.test.directives.model.SimpleDirectivesContainer;
import org.jetbrains.kotlin.test.model.FrontendKinds;
import org.jetbrains.kotlin.test.model.TestFile;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.TestModuleStructure;
import org.jetbrains.kotlin.test.services.TestModuleStructureKt;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.utils.FileUtilsKt;
import org.jetbrains.kotlin.test.utils.MultiModuleInfoDumper;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 (2\u00020\u0001:\u0001(B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u0012H\u0002J\u0018\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0018\u0010!\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u001c\u0010\"\u001a\u00020#*\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0012H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\t\u0012\b\u0012\u00060\nj\u0002`\u000b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0018\u0010\u0011\u001a\u00020\u0012*\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/test/backend/handlers/IrTextDumpHandler;", "Lorg/jetbrains/kotlin/test/backend/handlers/AbstractIrHandler;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "baseDumper", "Lorg/jetbrains/kotlin/test/utils/MultiModuleInfoDumper;", "buildersForSeparateFileDumps", "", "Ljava/io/File;", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "directiveContainers", "", "Lorg/jetbrains/kotlin/test/directives/model/DirectivesContainer;", "getDirectiveContainers", "()Ljava/util/List;", "dumpExtension", "", "Lorg/jetbrains/kotlin/test/model/TestModule;", "getDumpExtension", "(Lorg/jetbrains/kotlin/test/model/TestModule;)Ljava/lang/String;", "checkOneExpectedFile", "", "expectedFile", "actualDump", "compareDumpsOfExternalClasses", "module", "info", "Lorg/jetbrains/kotlin/test/backend/ir/IrBackendInput;", "processAfterAllModules", "someAssertionWasFailed", "", "processModule", "generateExternalClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "Lorg/jetbrains/kotlin/ir/util/DeclarationStubGenerator;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "externalClassFqn", "Companion", "tests-common-new"})
public final class IrTextDumpHandler
extends AbstractIrHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MultiModuleInfoDumper baseDumper;
    @NotNull
    private final Map<File, StringBuilder> buildersForSeparateFileDumps;
    @NotNull
    public static final String DUMP_EXTENSION = "ir.txt";

    public IrTextDumpHandler(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        super(testServices, false, false, 6, null);
        this.baseDumper = new MultiModuleInfoDumper(null, 1, null);
        this.buildersForSeparateFileDumps = new LinkedHashMap();
    }

    @Override
    @NotNull
    public List<DirectivesContainer> getDirectiveContainers() {
        Object[] objectArray = new SimpleDirectivesContainer[]{CodegenTestDirectives.INSTANCE, FirDiagnosticsDirectives.INSTANCE};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    public void processModule(@NotNull TestModule module2, @NotNull IrBackendInput info) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        if (!module2.getDirectives().contains(CodegenTestDirectives.INSTANCE.getDUMP_IR())) {
            return;
        }
        List<IrFile> irFiles2 = info.getIrModuleFragment().getFiles();
        List<Pair<TestFile, IrFile>> testFileToIrFile = Companion.groupWithTestFiles(irFiles2, module2);
        StringBuilder builder2 = this.baseDumper.builderForModule(module2);
        for (Pair<TestFile, IrFile> pair : testFileToIrFile) {
            TestFile testFile = (TestFile)pair.component1();
            IrFile irFile = (IrFile)pair.component2();
            Object object = testFile;
            if (object != null && (object = ((TestFile)object).getDirectives()) != null ? ((RegisteredDirectives)object).contains(CodegenTestDirectives.INSTANCE.getEXTERNAL_FILE()) : false) continue;
            String actualDump = DumpIrTreeKt.dumpTreesFromLineNumber(irFile, 0, true);
            if (((CharSequence)actualDump).length() == 0) {
                actualDump = DumpIrTreeKt.dumpTreesFromLineNumber(irFile, -1, true);
            }
            builder2.append(actualDump);
        }
        this.compareDumpsOfExternalClasses(module2, info);
    }

    private final void compareDumpsOfExternalClasses(TestModule module2, IrBackendInput info) {
        if (Intrinsics.areEqual(module2.getFrontendKind(), (Object)FrontendKinds.FIR.INSTANCE)) {
            return;
        }
        List<String> externalClassFqns = module2.getDirectives().get(CodegenTestDirectives.INSTANCE.getDUMP_EXTERNAL_CLASS());
        if (externalClassFqns.isEmpty()) {
            return;
        }
        JsManglerDesc mangler = JsManglerDesc.INSTANCE;
        IdSignatureDescriptor signaturer = new IdSignatureDescriptor(mangler);
        IrModuleFragment irModule = info.getIrModuleFragment();
        DeclarationStubGeneratorImpl stubGenerator = new DeclarationStubGeneratorImpl(irModule.getDescriptor(), new SymbolTable(signaturer, IrFactoryImpl.INSTANCE, null, 4, null), irModule.getIrBuiltins(), new DescriptorByIdSignatureFinderImpl(irModule.getDescriptor(), mangler, null, 4, null), null, 16, null);
        File baseFile = (File)CollectionsKt.first(TestModuleStructureKt.getModuleStructure(this.getTestServices()).getOriginalTestDataFiles());
        for (String externalClassFqn : externalClassFqns) {
            String classDump = DumpIrTreeKt.dump$default(this.generateExternalClass(stubGenerator, irModule.getDescriptor(), externalClassFqn), false, false, 3, null);
            File expectedFile = FileUtilsKt.withSuffixAndExtension(baseFile, "__" + externalClassFqn, this.getDumpExtension(module2));
            Assertions.assertEqualsToFile$default(this.getAssertions(), expectedFile, classDump, null, 4, null);
        }
    }

    private final IrClass generateExternalClass(DeclarationStubGenerator $this$generateExternalClass, ModuleDescriptor descriptor2, String externalClassFqn) {
        ClassId classId = ClassId.topLevel(new FqName(externalClassFqn));
        Intrinsics.checkNotNullExpressionValue((Object)classId, (String)"topLevel(FqName(externalClassFqn))");
        ClassDescriptor classDescriptor = FindClassInModuleKt.findClassAcrossModuleDependencies(descriptor2, classId);
        if (classDescriptor == null) {
            throw new AssertionError((Object)("Can't find a class in external dependencies: " + externalClassFqn));
        }
        ClassDescriptor classDescriptor2 = classDescriptor;
        IrDeclaration irDeclaration2 = $this$generateExternalClass.generateMemberStub(classDescriptor2);
        Intrinsics.checkNotNull((Object)irDeclaration2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
        return (IrClass)irDeclaration2;
    }

    @Override
    public void processAfterAllModules(boolean someAssertionWasFailed) {
        TestModuleStructure moduleStructure = TestModuleStructureKt.getModuleStructure(this.getTestServices());
        File defaultExpectedFile = FileUtilsKt.withExtension((File)CollectionsKt.first(moduleStructure.getOriginalTestDataFiles()), this.getDumpExtension((TestModule)CollectionsKt.first(moduleStructure.getModules())));
        this.checkOneExpectedFile(defaultExpectedFile, this.baseDumper.generateResultingDump());
        Iterable $this$forEach$iv = this.buildersForSeparateFileDumps.entrySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry entry = (Map.Entry)element$iv;
            boolean bl = false;
            File expectedFile = (File)entry.getKey();
            StringBuilder dump2 = (StringBuilder)entry.getValue();
            String string2 = dump2.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"dump.toString()");
            this.checkOneExpectedFile(expectedFile, string2);
        }
    }

    private final void checkOneExpectedFile(File expectedFile, String actualDump) {
        if (((CharSequence)actualDump).length() > 0) {
            Assertions.assertEqualsToFile$default(this.getAssertions(), expectedFile, actualDump, null, 4, null);
        }
    }

    private final String getDumpExtension(TestModule $this$dumpExtension) {
        return Companion.computeDumpExtension($this$dumpExtension, DUMP_EXTENSION);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0004J,\u0010\t\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0006\u0012\u0004\u0018\u00010\f\u0012\u0004\u0012\u00020\r0\u000b0\n*\b\u0012\u0004\u0012\u00020\r0\n2\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/test/backend/handlers/IrTextDumpHandler$Companion;", "", "()V", "DUMP_EXTENSION", "", "computeDumpExtension", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "defaultExtension", "groupWithTestFiles", "", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/test/model/TestFile;", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "tests-common-new"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String computeDumpExtension(@NotNull TestModule module2, @NotNull String defaultExtension) {
            Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
            Intrinsics.checkNotNullParameter((Object)defaultExtension, (String)"defaultExtension");
            return Intrinsics.areEqual(module2.getFrontendKind(), (Object)FrontendKinds.ClassicFrontend.INSTANCE) || module2.getDirectives().contains(FirDiagnosticsDirectives.INSTANCE.getFIR_IDENTICAL()) ? defaultExtension : "fir." + defaultExtension;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<Pair<TestFile, IrFile>> groupWithTestFiles(@NotNull List<? extends IrFile> $this$groupWithTestFiles, @NotNull TestModule module2) {
            void $this$mapNotNullTo$iv$iv;
            Intrinsics.checkNotNullParameter($this$groupWithTestFiles, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
            Iterable $this$mapNotNull$iv = $this$groupWithTestFiles;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Pair it$iv$iv;
                Object v0;
                IrFile irFile;
                block2: {
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl = false;
                    irFile = (IrFile)element$iv$iv;
                    boolean bl2 = false;
                    String name2 = new File(irFile.getFileEntry().getName()).getName();
                    Iterable $this$firstOrNull$iv = module2.getFiles();
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        TestFile it = (TestFile)element$iv;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)name2)) continue;
                        v0 = element$iv;
                        break block2;
                    }
                    v0 = null;
                }
                TestFile testFile = v0;
                if (TuplesKt.to((Object)testFile, (Object)irFile) == null) continue;
                boolean bl = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

