/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.test.TestRunner;
import org.jetbrains.kotlin.test.WrappedException;
import org.jetbrains.kotlin.test.model.AbstractTestFacade;
import org.jetbrains.kotlin.test.model.AnalysisHandler;
import org.jetbrains.kotlin.test.model.ResultingArtifact;
import org.jetbrains.kotlin.test.model.TestArtifactKind;
import org.jetbrains.kotlin.test.model.TestModule;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u0002*\u000e\b\u0001\u0010\u0003*\b\u0012\u0004\u0012\u0002H\u00030\u00022\u00020\u0004:\u0003\u0013\u0014\u0015B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0005J-\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00028\u00002\u0006\u0010\u000f\u001a\u00020\u0010H&\u00a2\u0006\u0002\u0010\u0011J\u001c\u0010\u0012\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\r2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0016R\u0018\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u0082\u0001\u0002\u0016\u0017\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/test/TestStep;", "I", "Lorg/jetbrains/kotlin/test/model/ResultingArtifact;", "O", "", "()V", "inputArtifactKind", "Lorg/jetbrains/kotlin/test/model/TestArtifactKind;", "getInputArtifactKind", "()Lorg/jetbrains/kotlin/test/model/TestArtifactKind;", "processModule", "Lorg/jetbrains/kotlin/test/TestStep$StepResult;", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "inputArtifact", "thereWereExceptionsOnPreviousSteps", "", "(Lorg/jetbrains/kotlin/test/model/TestModule;Lorg/jetbrains/kotlin/test/model/ResultingArtifact;Z)Lorg/jetbrains/kotlin/test/TestStep$StepResult;", "shouldProcessModule", "FacadeStep", "HandlersStep", "StepResult", "Lorg/jetbrains/kotlin/test/TestStep$FacadeStep;", "Lorg/jetbrains/kotlin/test/TestStep$HandlersStep;", "test-infrastructure"})
public abstract class TestStep<I extends ResultingArtifact<I>, O extends ResultingArtifact<O>> {
    private TestStep() {
    }

    @NotNull
    public abstract TestArtifactKind<I> getInputArtifactKind();

    public boolean shouldProcessModule(@NotNull TestModule module2, @NotNull ResultingArtifact<?> inputArtifact) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter(inputArtifact, (String)"inputArtifact");
        return Intrinsics.areEqual(inputArtifact.getKind(), this.getInputArtifactKind());
    }

    @NotNull
    public abstract StepResult<? extends O> processModule(@NotNull TestModule var1, @NotNull I var2, boolean var3);

    public /* synthetic */ TestStep(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000*\u000e\b\u0002\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u0002*\u000e\b\u0003\u0010\u0003*\b\u0012\u0004\u0012\u0002H\u00030\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0004B\u0019\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u0006\u00a2\u0006\u0002\u0010\u0007J-\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00030\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00028\u00022\u0006\u0010\u0015\u001a\u00020\u0016H\u0016\u00a2\u0006\u0002\u0010\u0017J\u001c\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00132\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0016R\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00030\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\r\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/test/TestStep$FacadeStep;", "I", "Lorg/jetbrains/kotlin/test/model/ResultingArtifact;", "O", "Lorg/jetbrains/kotlin/test/TestStep;", "facade", "Lorg/jetbrains/kotlin/test/model/AbstractTestFacade;", "(Lorg/jetbrains/kotlin/test/model/AbstractTestFacade;)V", "getFacade", "()Lorg/jetbrains/kotlin/test/model/AbstractTestFacade;", "inputArtifactKind", "Lorg/jetbrains/kotlin/test/model/TestArtifactKind;", "getInputArtifactKind", "()Lorg/jetbrains/kotlin/test/model/TestArtifactKind;", "outputArtifactKind", "getOutputArtifactKind", "processModule", "Lorg/jetbrains/kotlin/test/TestStep$StepResult;", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "inputArtifact", "thereWereExceptionsOnPreviousSteps", "", "(Lorg/jetbrains/kotlin/test/model/TestModule;Lorg/jetbrains/kotlin/test/model/ResultingArtifact;Z)Lorg/jetbrains/kotlin/test/TestStep$StepResult;", "shouldProcessModule", "test-infrastructure"})
    public static final class FacadeStep<I extends ResultingArtifact<I>, O extends ResultingArtifact<O>>
    extends TestStep<I, O> {
        @NotNull
        private final AbstractTestFacade<I, O> facade;

        public FacadeStep(@NotNull AbstractTestFacade<I, O> facade) {
            Intrinsics.checkNotNullParameter(facade, (String)"facade");
            super(null);
            this.facade = facade;
        }

        @NotNull
        public final AbstractTestFacade<I, O> getFacade() {
            return this.facade;
        }

        @Override
        @NotNull
        public TestArtifactKind<I> getInputArtifactKind() {
            return this.facade.getInputKind();
        }

        @NotNull
        public final TestArtifactKind<O> getOutputArtifactKind() {
            return this.facade.getOutputKind();
        }

        @Override
        public boolean shouldProcessModule(@NotNull TestModule module2, @NotNull ResultingArtifact<?> inputArtifact) {
            Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
            Intrinsics.checkNotNullParameter(inputArtifact, (String)"inputArtifact");
            return super.shouldProcessModule(module2, inputArtifact) && this.facade.shouldRunAnalysis(module2);
        }

        @Override
        @NotNull
        public StepResult<? extends O> processModule(@NotNull TestModule module2, @NotNull I inputArtifact, boolean thereWereExceptionsOnPreviousSteps) {
            O o;
            Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
            Intrinsics.checkNotNullParameter(inputArtifact, (String)"inputArtifact");
            try {
                O o2 = this.facade.transform(module2, inputArtifact);
                if (o2 == null) {
                    return StepResult.NoArtifactFromFacade.INSTANCE;
                }
                o = o2;
            }
            catch (Throwable e) {
                return new StepResult.ErrorFromFacade(new WrappedException.FromFacade(e, this.facade));
            }
            O outputArtifact = o;
            return new StepResult.Artifact<O>(outputArtifact);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000*\u000e\b\u0002\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u00020\u00040\u0003B'\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00020\u0006\u0012\u0012\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00020\t0\b\u00a2\u0006\u0002\u0010\nJ%\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00028\u00022\u0006\u0010\u0014\u001a\u00020\u0015H\u0016\u00a2\u0006\u0002\u0010\u0016R\u001d\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/test/TestStep$HandlersStep;", "I", "Lorg/jetbrains/kotlin/test/model/ResultingArtifact;", "Lorg/jetbrains/kotlin/test/TestStep;", "", "inputArtifactKind", "Lorg/jetbrains/kotlin/test/model/TestArtifactKind;", "handlers", "", "Lorg/jetbrains/kotlin/test/model/AnalysisHandler;", "(Lorg/jetbrains/kotlin/test/model/TestArtifactKind;Ljava/util/List;)V", "getHandlers", "()Ljava/util/List;", "getInputArtifactKind", "()Lorg/jetbrains/kotlin/test/model/TestArtifactKind;", "processModule", "Lorg/jetbrains/kotlin/test/TestStep$StepResult$HandlersResult;", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "inputArtifact", "thereWereExceptionsOnPreviousSteps", "", "(Lorg/jetbrains/kotlin/test/model/TestModule;Lorg/jetbrains/kotlin/test/model/ResultingArtifact;Z)Lorg/jetbrains/kotlin/test/TestStep$StepResult$HandlersResult;", "test-infrastructure"})
    public static final class HandlersStep<I extends ResultingArtifact<I>>
    extends TestStep {
        @NotNull
        private final TestArtifactKind<I> inputArtifactKind;
        @NotNull
        private final List<AnalysisHandler<I>> handlers;

        public HandlersStep(@NotNull TestArtifactKind<I> inputArtifactKind, @NotNull List<? extends AnalysisHandler<I>> handlers2) {
            boolean bl;
            block4: {
                Intrinsics.checkNotNullParameter(inputArtifactKind, (String)"inputArtifactKind");
                Intrinsics.checkNotNullParameter(handlers2, (String)"handlers");
                super(null);
                this.inputArtifactKind = inputArtifactKind;
                this.handlers = handlers2;
                Iterable $this$all$iv = this.handlers;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        AnalysisHandler it = (AnalysisHandler)element$iv;
                        boolean bl2 = false;
                        if (Intrinsics.areEqual(it.getArtifactKind(), this.getInputArtifactKind())) continue;
                        bl = false;
                        break block4;
                    }
                    bl = true;
                }
            }
            if (!bl) {
                String string2 = "Failed requirement.";
                throw new IllegalArgumentException(string2.toString());
            }
        }

        @Override
        @NotNull
        public TestArtifactKind<I> getInputArtifactKind() {
            return this.inputArtifactKind;
        }

        @NotNull
        public final List<AnalysisHandler<I>> getHandlers() {
            return this.handlers;
        }

        @NotNull
        public StepResult.HandlersResult processModule(@NotNull TestModule module2, @NotNull I inputArtifact, boolean thereWereExceptionsOnPreviousSteps) {
            Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
            Intrinsics.checkNotNullParameter(inputArtifact, (String)"inputArtifact");
            List exceptions = new ArrayList();
            for (AnalysisHandler<I> outputHandler : this.handlers) {
                if (!TestRunner.Companion.shouldRun(outputHandler, thereWereExceptionsOnPreviousSteps || !((Collection)exceptions).isEmpty())) continue;
                try {
                    outputHandler.processModule(module2, inputArtifact);
                }
                catch (Throwable e) {
                    ((Collection)exceptions).add(new WrappedException.FromHandler(e, outputHandler));
                    if (!outputHandler.getFailureDisablesNextSteps()) continue;
                    return new StepResult.HandlersResult(exceptions, false);
                }
            }
            return new StepResult.HandlersResult(exceptions, true);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000*\u000e\b\u0002\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\u00020\u0003:\u0004\u0005\u0006\u0007\bB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0004\u0082\u0001\u0004\t\n\u000b\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/test/TestStep$StepResult;", "O", "Lorg/jetbrains/kotlin/test/model/ResultingArtifact;", "", "()V", "Artifact", "ErrorFromFacade", "HandlersResult", "NoArtifactFromFacade", "Lorg/jetbrains/kotlin/test/TestStep$StepResult$Artifact;", "Lorg/jetbrains/kotlin/test/TestStep$StepResult$ErrorFromFacade;", "Lorg/jetbrains/kotlin/test/TestStep$StepResult$HandlersResult;", "Lorg/jetbrains/kotlin/test/TestStep$StepResult$NoArtifactFromFacade;", "test-infrastructure"})
    public static abstract class StepResult<O extends ResultingArtifact<O>> {
        private StepResult() {
        }

        public /* synthetic */ StepResult(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000*\u000e\b\u0003\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00028\u0003\u00a2\u0006\u0002\u0010\u0005R\u0013\u0010\u0004\u001a\u00028\u0003\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/test/TestStep$StepResult$Artifact;", "O", "Lorg/jetbrains/kotlin/test/model/ResultingArtifact;", "Lorg/jetbrains/kotlin/test/TestStep$StepResult;", "outputArtifact", "(Lorg/jetbrains/kotlin/test/model/ResultingArtifact;)V", "getOutputArtifact", "()Lorg/jetbrains/kotlin/test/model/ResultingArtifact;", "Lorg/jetbrains/kotlin/test/model/ResultingArtifact;", "test-infrastructure"})
        public static final class Artifact<O extends ResultingArtifact<O>>
        extends StepResult<O> {
            @NotNull
            private final O outputArtifact;

            public Artifact(@NotNull O outputArtifact) {
                Intrinsics.checkNotNullParameter(outputArtifact, (String)"outputArtifact");
                super(null);
                this.outputArtifact = outputArtifact;
            }

            @NotNull
            public final O getOutputArtifact() {
                return this.outputArtifact;
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000*\u000e\b\u0003\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/test/TestStep$StepResult$ErrorFromFacade;", "O", "Lorg/jetbrains/kotlin/test/model/ResultingArtifact;", "Lorg/jetbrains/kotlin/test/TestStep$StepResult;", "exception", "Lorg/jetbrains/kotlin/test/WrappedException;", "(Lorg/jetbrains/kotlin/test/WrappedException;)V", "getException", "()Lorg/jetbrains/kotlin/test/WrappedException;", "test-infrastructure"})
        public static final class ErrorFromFacade<O extends ResultingArtifact<O>>
        extends StepResult<O> {
            @NotNull
            private final WrappedException exception;

            public ErrorFromFacade(@NotNull WrappedException exception) {
                Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
                super(null);
                this.exception = exception;
            }

            @NotNull
            public final WrappedException getException() {
                return this.exception;
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001b\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0007H\u00c6\u0003J#\u0010\u000f\u001a\u00020\u00002\u000e\b\u0002\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00072\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/test/TestStep$StepResult$HandlersResult;", "Lorg/jetbrains/kotlin/test/TestStep$StepResult;", "", "exceptionsFromHandlers", "", "Lorg/jetbrains/kotlin/test/WrappedException;", "shouldRunNextSteps", "", "(Ljava/util/Collection;Z)V", "getExceptionsFromHandlers", "()Ljava/util/Collection;", "getShouldRunNextSteps", "()Z", "component1", "component2", "copy", "equals", "other", "", "hashCode", "", "toString", "", "test-infrastructure"})
        public static final class HandlersResult
        extends StepResult {
            @NotNull
            private final Collection<WrappedException> exceptionsFromHandlers;
            private final boolean shouldRunNextSteps;

            public HandlersResult(@NotNull Collection<? extends WrappedException> exceptionsFromHandlers, boolean shouldRunNextSteps) {
                Intrinsics.checkNotNullParameter(exceptionsFromHandlers, (String)"exceptionsFromHandlers");
                super(null);
                this.exceptionsFromHandlers = exceptionsFromHandlers;
                this.shouldRunNextSteps = shouldRunNextSteps;
            }

            @NotNull
            public final Collection<WrappedException> getExceptionsFromHandlers() {
                return this.exceptionsFromHandlers;
            }

            public final boolean getShouldRunNextSteps() {
                return this.shouldRunNextSteps;
            }

            @NotNull
            public final Collection<WrappedException> component1() {
                return this.exceptionsFromHandlers;
            }

            public final boolean component2() {
                return this.shouldRunNextSteps;
            }

            @NotNull
            public final HandlersResult copy(@NotNull Collection<? extends WrappedException> exceptionsFromHandlers, boolean shouldRunNextSteps) {
                Intrinsics.checkNotNullParameter(exceptionsFromHandlers, (String)"exceptionsFromHandlers");
                return new HandlersResult(exceptionsFromHandlers, shouldRunNextSteps);
            }

            public static /* synthetic */ HandlersResult copy$default(HandlersResult handlersResult, Collection collection, boolean bl, int n, Object object) {
                if ((n & 1) != 0) {
                    collection = handlersResult.exceptionsFromHandlers;
                }
                if ((n & 2) != 0) {
                    bl = handlersResult.shouldRunNextSteps;
                }
                return handlersResult.copy(collection, bl);
            }

            @NotNull
            public String toString() {
                return "HandlersResult(exceptionsFromHandlers=" + this.exceptionsFromHandlers + ", shouldRunNextSteps=" + this.shouldRunNextSteps + ')';
            }

            public int hashCode() {
                int result2 = ((Object)this.exceptionsFromHandlers).hashCode();
                int n = this.shouldRunNextSteps ? 1 : 0;
                if (n != 0) {
                    n = 1;
                }
                result2 = result2 * 31 + n;
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof HandlersResult)) {
                    return false;
                }
                HandlersResult handlersResult = (HandlersResult)other;
                if (!Intrinsics.areEqual(this.exceptionsFromHandlers, handlersResult.exceptionsFromHandlers)) {
                    return false;
                }
                return this.shouldRunNextSteps == handlersResult.shouldRunNextSteps;
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/jetbrains/kotlin/test/TestStep$StepResult$NoArtifactFromFacade;", "Lorg/jetbrains/kotlin/test/TestStep$StepResult;", "", "()V", "test-infrastructure"})
        public static final class NoArtifactFromFacade
        extends StepResult {
            @NotNull
            public static final NoArtifactFromFacade INSTANCE = new NoArtifactFromFacade();

            private NoArtifactFromFacade() {
                super(null);
            }
        }
    }
}

